/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Busyable;
import fr.dbe.graphique.Fond;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.JExportCsv;
import fr.dbe.graphique.JProprietesGraphique;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionAxeV;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.ScaleFunction;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.SharedFrame;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.TextUI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JPanneauGraphique
extends JPanel
implements IXmlElement,
Busyable {
    private static final String PREFS_KEY_SAVE_IMAGE_DIR = "fr.dbe.graphique.SAVE_IMAGE_DIR";
    private static final String DOM_OUTILS_VISIBLE = "outils-visible";
    private static final String DOM_FICHIER_SAUVEGARDE = "save-file";
    private static final String DOM_VERSION = "version";
    private static final String VERSION = "00.00.00";
    protected final JToolBar fControle = new JToolBar(0);
    final JButton fBtFenetre = new JButton();
    final JScrollBar fHorizontalScrollBar;
    final JScrollBar fVerticalScrollBar;
    final JButton btZoomPlus = new JButton();
    final JButton btZoomMoins = new JButton();
    final JButton btAjuster = new JButton();
    private final JDessinGraphique fDessin;
    private final JCheckBoxMenuItem miOutils;
    private final Action fActionConfigurer;
    private final JLabel fLibInfo;
    private final PopupFactory popupFactory = PopupFactory.getSharedInstance();
    private final JToolTip toolTip = this.createToolTip();
    private final List<ChangeListener> fDetachListeners = new ArrayList<ChangeListener>();
    private final JButton btConfigurer;
    private String fFicSave;
    private String fNom;
    private JButton fBtRattacher;
    private boolean fControleEnabled = true;
    private AdjustmentListener fAdjustementListener;
    private Popup popup;
    private JLabel fBusyLabel;

    public JPanneauGraphique(String pNom) {
        this(pNom, null, true);
    }

    public JPanneauGraphique(String pNom, boolean pIsCursorXOR) {
        this(pNom, null, pIsCursorXOR);
    }

    public JPanneauGraphique(String pNom, String pLibInfo) {
        this(pNom, pLibInfo, true);
    }

    public JPanneauGraphique(String pNom, final String pLibInfo, boolean pIsCursorXOR) {
        JTextPane libVal = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container parent = this.getParent();
                TextUI ui = this.getUI();
                return parent == null || ui.getPreferredSize((JComponent)this).width <= parent.getSize().width;
            }
        };
        libVal.setContentType("text/html");
        libVal.setFont(Utilitaire.FONT_DEFAUT);
        libVal.setEditable(false);
        libVal.setMinimumSize(new Dimension(0, 0));
        libVal.setToolTipText(Messages.getString("JPanneauGraphique.5"));
        libVal.setOpaque(false);
        libVal.setBorder(null);
        this.fDessin = new JDessinGraphique(libVal, pIsCursorXOR);
        this.setLayout(new GridBagLayout());
        this.setNom(pNom);
        this.btConfigurer = new JButton();
        JButton btEnregistrerImg = new JButton();
        JButton btEnregistrerVal = new JButton();
        JButton btImprimer = new JButton();
        this.fDessin.setZoom(1.0, 1.0);
        this.btZoomPlus.setIcon(Utils.chargeIcone((String)"zoomP.gif", JPanneauGraphique.class));
        this.btZoomPlus.setMargin(new Insets(1, 1, 1, 1));
        this.btZoomPlus.setToolTipText(Messages.getString("JPanneauGraphique.9"));
        this.btZoomPlus.addActionListener(e -> {
            boolean maj;
            boolean ctrl = (e.getModifiers() & 2) == 2;
            boolean bl = maj = (e.getModifiers() & 1) == 1;
            if (!ctrl && !maj) {
                this.fDessin.zoomXPlus();
            } else if (ctrl && !maj) {
                this.fDessin.zoomYPlus();
            } else if (!ctrl && maj) {
                this.fDessin.setZoom(1.0, this.fDessin.getZoomY());
            } else {
                this.fDessin.setZoom(this.fDessin.getZoomX(), 1.0);
            }
        });
        this.btZoomMoins.setIcon(Utils.chargeIcone((String)"zoomM.gif", JPanneauGraphique.class));
        this.btZoomMoins.setMargin(new Insets(1, 1, 1, 1));
        this.btZoomMoins.setToolTipText(Messages.getString("JPanneauGraphique.11"));
        this.btZoomMoins.addActionListener(e -> {
            boolean maj;
            boolean ctrl = (e.getModifiers() & 2) == 2;
            boolean bl = maj = (e.getModifiers() & 1) == 1;
            if (!ctrl) {
                if (!maj) {
                    this.fDessin.zoomXMoins();
                } else {
                    this.fDessin.setZoom(1.0, this.fDessin.getZoomY());
                }
            } else if (!maj) {
                this.fDessin.zoomYMoins();
            } else {
                this.fDessin.setZoom(this.fDessin.getZoomX(), 1.0);
            }
        });
        this.btAjuster.setIcon(Utils.chargeIcone((String)"ajuster.gif", JPanneauGraphique.class));
        this.btAjuster.setMargin(new Insets(1, 1, 1, 1));
        this.btAjuster.setToolTipText(Messages.getString("JPanneauGraphique.13"));
        this.btAjuster.addActionListener(e -> {
            if ((e.getModifiers() & 2) == 2) {
                this.ajusterPlageCourante();
            } else {
                this.ajuster();
            }
            this.repaint();
        });
        this.fActionConfigurer = new AbstractAction(Messages.getString("JPanneauGraphique.14"), Utils.chargeIcone((String)"configure.gif", JPanneauGraphique.class)){

            @Override
            public void actionPerformed(ActionEvent e) {
                SharedFrame f = new SharedFrame();
                SwingUtilities.invokeLater(() -> this.lambda$actionPerformed$0((JFrame)f));
            }

            private /* synthetic */ void lambda$actionPerformed$0(JFrame f) {
                JProprietesGraphique d = new JProprietesGraphique(f, JPanneauGraphique.this.fDessin);
                d.setLocationRelativeTo(JPanneauGraphique.this);
                d.setVisible(true);
                f.dispose();
                JPanneauGraphique.this.repaint();
            }
        };
        this.btConfigurer.setAction(this.fActionConfigurer);
        this.btConfigurer.setText("");
        this.btConfigurer.setMargin(new Insets(1, 1, 1, 1));
        this.btConfigurer.setToolTipText(Messages.getString("JPanneauGraphique.17"));
        btImprimer.setIcon(Utils.chargeIcone((String)"impr.gif", JPanneauGraphique.class));
        btImprimer.setMargin(new Insets(1, 1, 1, 1));
        btImprimer.setToolTipText(Messages.getString("JPanneauGraphique.19"));
        btImprimer.addActionListener(e -> {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPrintable(this.fDessin);
            if (pj.printDialog()) {
                try {
                    pj.print();
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        });
        btEnregistrerImg.setIcon(Utils.chargeIcone((String)"enr.gif", JPanneauGraphique.class));
        btEnregistrerImg.setMargin(new Insets(1, 1, 1, 1));
        btEnregistrerImg.setToolTipText(Messages.getString("JPanneauGraphique.21"));
        btEnregistrerImg.addActionListener(e -> {
            final String extension = Arrays.asList(ImageIO.getWriterMIMETypes()).contains("image/gif") ? "gif" : "jpeg";
            File f = null;
            try {
                JFileChooser jfc = new JFileChooser();
                jfc.setAcceptAllFileFilterUsed(false);
                jfc.setMultiSelectionEnabled(false);
                jfc.setCurrentDirectory(new File(Preferences.userRoot().get(PREFS_KEY_SAVE_IMAGE_DIR, "")));
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File pFile) {
                        return pFile.getAbsolutePath().toLowerCase().endsWith("." + extension) || pFile.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Messages.getString("JPanneauGraphique.27") + extension.toUpperCase();
                    }
                });
                if (this.fFicSave != null) {
                    jfc.setSelectedFile(new File(this.fFicSave));
                }
                boolean continuer = true;
                while (continuer) {
                    if (jfc.showSaveDialog(this) == 1) {
                        return;
                    }
                    f = jfc.getSelectedFile();
                    if (!f.getAbsolutePath().toLowerCase().endsWith("." + extension.toLowerCase())) {
                        f = new File(f.getAbsolutePath() + "." + extension);
                    }
                    if (f.exists()) {
                        switch (JOptionPane.showConfirmDialog(this, Messages.getString("JPanneauGraphique.30"), Messages.getString("JPanneauGraphique.31"), 1)) {
                            case 0: {
                                continuer = false;
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                        continue;
                    }
                    continuer = false;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, Messages.getString("JPanneauGraphique.32"));
                return;
            }
            try {
                Preferences.userRoot().put(PREFS_KEY_SAVE_IMAGE_DIR, f.getParentFile().getAbsolutePath());
                Utilitaire.saveImage((String)extension, (Component)this.fDessin, (File)f);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, Messages.getString("JPanneauGraphique.33"));
            }
        });
        btEnregistrerVal.setIcon(Utils.chargeIcone((String)"enrVal.gif", JPanneauGraphique.class));
        btEnregistrerVal.setMargin(new Insets(1, 1, 1, 1));
        btEnregistrerVal.setToolTipText(Messages.getString("JPanneauGraphique.35"));
        btEnregistrerVal.addActionListener(e -> this.save());
        this.fBtFenetre.setIcon(Utils.chargeIcone((String)"fen.gif", JPanneauGraphique.class));
        this.fBtFenetre.setMargin(new Insets(1, 1, 1, 1));
        this.fBtFenetre.setToolTipText(Messages.getString("JPanneauGraphique.47"));
        this.fBtFenetre.addActionListener(e -> {
            final JPanneauGraphique that = this;
            String btLabel = this.fNom.startsWith("<html>") ? "<html>" + Messages.getString("JPanneauGraphique.48") + this.fNom.substring(6) + "'" : Messages.getString("JPanneauGraphique.48") + " '" + this.fNom + "'";
            this.fBtRattacher = new JButton(btLabel);
            that.add(this.fBtRattacher);
            this.removeContent(that);
            this.fBtFenetre.setVisible(false);
            JFrame f = new JFrame();
            f.setDefaultCloseOperation(2);
            this.fBtRattacher.addActionListener(pArg0 -> {
                that.remove(this.fBtRattacher);
                this.addContent(that);
                this.fBtFenetre.setVisible(true);
                that.validate();
                that.repaint();
                that.setVisible(that.isVisible());
                f.dispose();
            });
            f.setLayout(new BorderLayout());
            JPanel center = new JPanel(new GridBagLayout());
            f.add((Component)center, "Center");
            this.addContent(center);
            JPanel top = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(5, 5, 5, 5);
            gc.fill = 2;
            JLabel title = Utils.createLabel((String)this.fNom);
            title.setFont(title.getFont().deriveFont(1, 14.0f));
            top.add((Component)title, gc);
            f.add((Component)top, "North");
            f.getContentPane().setPreferredSize(new Dimension(this.getBounds().width, this.getBounds().height));
            f.setLocationRelativeTo(null);
            f.setDefaultCloseOperation(2);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent pWindowEvent) {
                    that.remove(JPanneauGraphique.this.fBtRattacher);
                    JPanneauGraphique.this.addContent(that);
                    pWindowEvent.getWindow().dispose();
                    JPanneauGraphique.this.fBtFenetre.setVisible(true);
                    that.validate();
                    that.repaint();
                }
            });
            f.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent pE) {
                    if (pE.getClickCount() == 2) {
                        Serie serie = JPanneauGraphique.this.getDessin().getHighlightedSerie();
                        if (serie != null) {
                            SharedFrame f = new SharedFrame();
                            SwingUtilities.invokeLater(() -> this.lambda$mouseClicked$0((JFrame)f, serie, pE));
                        } else {
                            JPanneauGraphique.this.fBtRattacher.doClick();
                        }
                    }
                }

                private /* synthetic */ void lambda$mouseClicked$0(JFrame f, Serie serie, MouseEvent pE) {
                    JProprietesGraphique d = new JProprietesGraphique(f, JPanneauGraphique.this.getDessin());
                    d.selectSerie(serie);
                    d.setLocationRelativeTo(pE.getComponent());
                    d.setVisible(true);
                    f.dispose();
                    pE.getComponent().repaint();
                }
            });
            that.updateUI();
            that.repaint();
            f.pack();
            f.setExtendedState(6);
            f.setVisible(true);
            this.windowDetached(f);
        });
        this.fLibInfo = new JLabel(Utils.chargeIcone((String)"info.png", JPanneauGraphique.class));
        this.fLibInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent pEvent) {
                JPanneauGraphique.this.toolTip.setTipText(pLibInfo);
                int x = pEvent.getXOnScreen();
                int y = pEvent.getYOnScreen();
                if (JPanneauGraphique.this.popup != null) {
                    JPanneauGraphique.this.popup.hide();
                }
                JPanneauGraphique.this.popup = JPanneauGraphique.this.popupFactory.getPopup(JPanneauGraphique.this.fLibInfo, JPanneauGraphique.this.toolTip, x, y + 20);
                JPanneauGraphique.this.popup.show();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (JPanneauGraphique.this.popup != null) {
                    JPanneauGraphique.this.popup.hide();
                }
            }
        });
        if (pLibInfo == null) {
            this.fLibInfo.setVisible(false);
        }
        Box b1 = new Box(1);
        b1.setBorder(new BevelBorder(0));
        b1.setPreferredSize(new Dimension(3, 20));
        b1.setMinimumSize(new Dimension(3, 20));
        b1.setMaximumSize(new Dimension(3, 20));
        Box b2 = new Box(1);
        b2.setBorder(new BevelBorder(0));
        b2.setPreferredSize(new Dimension(3, 20));
        b2.setMinimumSize(new Dimension(3, 20));
        b2.setMaximumSize(new Dimension(3, 20));
        Box b3 = new Box(1);
        b3.setBorder(new BevelBorder(0));
        b3.setPreferredSize(new Dimension(3, 20));
        b3.setMinimumSize(new Dimension(3, 20));
        b3.setMaximumSize(new Dimension(3, 20));
        this.fControle.add(Box.createHorizontalStrut(5));
        this.fControle.add(btEnregistrerVal);
        this.fControle.add(this.fBtFenetre);
        this.fControle.add(Box.createHorizontalStrut(5));
        this.fControle.add(b1);
        this.fControle.add(Box.createHorizontalStrut(5));
        this.fControle.add(this.btZoomPlus);
        this.fControle.add(this.btZoomMoins);
        this.fControle.add(this.btAjuster);
        this.fControle.add(this.btConfigurer);
        this.fControle.add(btImprimer);
        this.fControle.add(btEnregistrerImg);
        JComponent[] tools = this.getTools();
        if (tools != null) {
            for (JComponent c : tools) {
                this.fControle.add(c);
            }
        }
        this.fControle.setFloatable(false);
        this.fControle.add(Box.createHorizontalStrut(5));
        this.fControle.add(b2);
        this.fControle.add(Box.createHorizontalStrut(5));
        this.fControle.add(this.fLibInfo);
        this.fControle.add(Box.createHorizontalStrut(5));
        this.fControle.add(b3);
        this.fControle.add(Box.createHorizontalStrut(5));
        this.fControle.add(libVal);
        this.fControle.add(Box.createHorizontalGlue());
        this.fHorizontalScrollBar = new JScrollBar(0);
        this.fVerticalScrollBar = new JScrollBar(1);
        this.fHorizontalScrollBar.addAdjustmentListener(e -> this.fDessin.posXChanged(e.getValue()));
        this.fVerticalScrollBar.addAdjustmentListener(e -> this.fDessin.posYChanged(e.getValue()));
        this.fDessin.addMouseWheelListener(pE -> {
            if (pE.getModifiersEx() == 1) {
                int value1 = this.fHorizontalScrollBar.getValue() + pE.getUnitsToScroll() * this.fHorizontalScrollBar.getUnitIncrement();
                value1 = Math.max(this.fHorizontalScrollBar.getMinimum(), Math.min(this.fHorizontalScrollBar.getMaximum(), value1));
                if (value1 != this.fHorizontalScrollBar.getValue()) {
                    this.fHorizontalScrollBar.setValue(value1);
                    this.fDessin.posXChanged(value1);
                }
            } else {
                int value2 = this.fVerticalScrollBar.getValue() + pE.getUnitsToScroll() * this.fVerticalScrollBar.getUnitIncrement();
                value2 = Math.max(this.fVerticalScrollBar.getMinimum(), Math.min(this.fVerticalScrollBar.getMaximum(), value2));
                if (value2 != this.fVerticalScrollBar.getValue()) {
                    this.fVerticalScrollBar.setValue(value2);
                    this.fDessin.posYChanged(value2);
                }
            }
        });
        this.miOutils = new JCheckBoxMenuItem();
        this.miOutils.setFont(Utilitaire.FONT_DEFAUT);
        AbstractAction actionOutils = new AbstractAction(Messages.getString("JPanneauGraphique.50")){

            @Override
            public void actionPerformed(ActionEvent pE) {
                JPanneauGraphique.this.fControle.setVisible(JPanneauGraphique.this.miOutils.isSelected());
                JPanneauGraphique.this.validate();
                JPanneauGraphique.this.repaint();
            }
        };
        this.miOutils.setAction(actionOutils);
        this.addContent(this);
        this.fDessin.setAscenseurs(this.fHorizontalScrollBar, this.fVerticalScrollBar);
        this.fDessin.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JPanneauGraphique.this.fControleEnabled && e.isPopupTrigger()) {
                    JPanneauGraphique.this.showPopup(e);
                }
            }

            private void maybeShowPopup(MouseEvent e) {
                if (JPanneauGraphique.this.fControleEnabled && e.isPopupTrigger()) {
                    JPanneauGraphique.this.showPopup(e);
                    return;
                }
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    Serie serie = JPanneauGraphique.this.getDessin().getHighlightedSerie();
                    if (serie != null) {
                        SharedFrame f = new SharedFrame();
                        SwingUtilities.invokeLater(() -> this.lambda$maybeShowPopup$0((JFrame)f, serie, e));
                    } else if (JPanneauGraphique.this.fBtFenetre.isVisible()) {
                        JPanneauGraphique.this.fBtFenetre.doClick();
                    } else if (JPanneauGraphique.this.fBtRattacher != null && JPanneauGraphique.this.fBtRattacher.isVisible()) {
                        JPanneauGraphique.this.fBtRattacher.doClick();
                    }
                }
            }

            private /* synthetic */ void lambda$maybeShowPopup$0(JFrame f, Serie serie, MouseEvent e) {
                JProprietesGraphique d = new JProprietesGraphique(f, JPanneauGraphique.this.getDessin());
                d.selectSerie(serie);
                d.setLocationRelativeTo(e.getComponent());
                d.setVisible(true);
                f.dispose();
                e.getComponent().repaint();
            }
        });
    }

    public void save() {
        if (this.fDessin.getSeries().isEmpty()) {
            JOptionPane.showMessageDialog(this, Messages.getString("JPanneauGraphique.36"));
        } else {
            SharedFrame f = new SharedFrame();
            SwingUtilities.invokeLater(() -> this.lambda$save$11((JFrame)f));
        }
    }

    private void windowDetached(JFrame pFrame) {
        for (ChangeListener listener : this.fDetachListeners) {
            listener.stateChanged(new ChangeEvent(pFrame));
        }
    }

    protected JComponent[] getTools() {
        return null;
    }

    public boolean isDetached() {
        return this.fBtRattacher != null && this.fBtRattacher.getParent() != null;
    }

    private void addContent(Container pParent) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        pParent.add((Component)this.fControle, constraints);
        constraints.fill = 1;
        constraints.weighty = 1.0;
        constraints.gridy = 1;
        pParent.add((Component)this.fDessin, constraints);
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.fill = 3;
        constraints.gridx = 1;
        pParent.add((Component)this.fVerticalScrollBar, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        pParent.add((Component)this.fHorizontalScrollBar, constraints);
    }

    private void removeContent(Container pParent) {
        pParent.remove(this.fDessin);
        pParent.remove(this.fControle);
        pParent.remove(this.fHorizontalScrollBar);
        pParent.remove(this.fVerticalScrollBar);
    }

    protected void showPopup(MouseEvent pEvent) {
        JPopupMenu popupDessin = new JPopupMenu();
        if (this.fActionConfigurer.isEnabled()) {
            JMenuItem miConfigurer = new JMenuItem(this.fActionConfigurer);
            miConfigurer.setFont(Utilitaire.FONT_DEFAUT);
            popupDessin.add(miConfigurer);
        }
        this.miOutils.getModel().setSelected(this.fControle.isVisible());
        popupDessin.add(this.miOutils);
        JCheckBoxMenuItem miLegende = new JCheckBoxMenuItem(Messages.getString("JPanneauGraphique.51"), this.fDessin.getLegende().isVisible());
        miLegende.setFont(Utilitaire.FONT_DEFAUT);
        miLegende.addActionListener(pArg0 -> {
            this.fDessin.getLegende().setVisible(miLegende.getModel().isSelected());
            this.fDessin.repaint();
        });
        popupDessin.add(miLegende);
        JCheckBoxMenuItem miTitre = new JCheckBoxMenuItem(Messages.getString("JPanneauGraphique.52"), this.fDessin.getTitre().isVisible());
        miTitre.setFont(Utilitaire.FONT_DEFAUT);
        miTitre.addActionListener(pArg0 -> {
            this.fDessin.getTitre().setVisible(miTitre.getModel().isSelected());
            this.fDessin.repaint();
        });
        popupDessin.add(miTitre);
        popupDessin.add(new JSeparator());
        for (Serie s : this.fDessin.getSeriesActives()) {
            if (!s.isVisibleInMenu()) continue;
            BufferedImage img = new BufferedImage(30, 6, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            s.dessineLegende(g, 0, 0, img.getWidth(), img.getHeight());
            g.dispose();
            JCheckBoxMenuItem miSerie = new JCheckBoxMenuItem(s.getNomLegende(), new ImageIcon(img), s.isVisible());
            miSerie.setFont(Utilitaire.FONT_DEFAUT);
            miSerie.addActionListener(pArg0 -> {
                s.setVisible(miSerie.getModel().isSelected());
                this.fDessin.repaint();
            });
            popupDessin.add(miSerie);
        }
        ArrayList<Fond> fonds = new ArrayList<Fond>();
        for (Repere repere : this.fDessin.getReperes()) {
            for (Fond f : repere.getFonds()) {
                if (!f.isVisibleInMenu()) continue;
                fonds.add(f);
            }
        }
        if (!fonds.isEmpty()) {
            popupDessin.add(new JSeparator());
            for (Fond f : fonds) {
                BufferedImage img = new BufferedImage(30, 6, 2);
                Graphics2D g = (Graphics2D)img.getGraphics();
                f.dessineLegende(g, img.getWidth(), img.getHeight());
                g.dispose();
                JCheckBoxMenuItem miFond = new JCheckBoxMenuItem(f.getNom(), new ImageIcon(img), f.isVisible());
                miFond.setFont(Utilitaire.FONT_DEFAUT);
                miFond.addActionListener(pArg0 -> {
                    f.setVisible(miFond.getModel().isSelected());
                    this.fDessin.repaint();
                });
                popupDessin.add(miFond);
            }
        }
        popupDessin.show(pEvent.getComponent(), pEvent.getX(), pEvent.getY());
    }

    public int ajouteRepere() {
        int res = this.fDessin.ajouteRepere();
        if (res > 0) {
            this.getRepere(res - 1).getAxeH().addLinkedAxe(this.getRepere(res).getAxeH());
        }
        return res;
    }

    public void setDetachable(boolean b) {
        this.fBtFenetre.setEnabled(b);
    }

    public String getNom() {
        return this.fNom;
    }

    public void setNom(String nom) {
        this.fNom = nom;
        this.fDessin.setTitle(this.fNom);
    }

    public Element getDomElement(Document doc) {
        Element elt = doc.createElement(MapXmlGraph.getInstance().getNomElement(JPanneauGraphique.class));
        elt.setAttribute(DOM_VERSION, VERSION);
        elt.setAttribute(DOM_OUTILS_VISIBLE, String.valueOf(this.fControle.isVisible()));
        elt.setAttribute(DOM_FICHIER_SAUVEGARDE, this.fFicSave == null ? "" : this.fFicSave);
        elt.appendChild(this.fDessin.getDomElement(doc));
        return elt;
    }

    public void setProperties(Node pNoeud) {
        if (!XmlUtils.getAttributeStringValue((Node)pNoeud, (String)DOM_VERSION, (String)"?").equals(VERSION)) {
            return;
        }
        this.fControle.setVisible(XmlUtils.getAttributeBooleanValue((Node)pNoeud, (String)DOM_OUTILS_VISIBLE, (boolean)true));
        this.miOutils.setSelected(this.fControle.isVisible());
        this.fFicSave = XmlUtils.getAttributeStringValue((Node)pNoeud, (String)DOM_FICHIER_SAUVEGARDE, (String)"");
        Node n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fDessin));
        if (n != null) {
            this.fDessin.setProperties(n);
        } else {
            Log.getInstance().warn(Messages.getString("JPanneauGraphique.56") + MapXmlGraph.getInstance().getNomElement((IXmlElement)this.fDessin) + Messages.getString("JPanneauGraphique.57"));
        }
    }

    public void load(File pFichier) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new FileInputStream(pFichier));
        this.setProperties(doc.getFirstChild());
    }

    public void hideControle() {
        this.fControle.setVisible(false);
    }

    public void hideScrollBars() {
        this.fDessin.setAscenseurs(null, null);
    }

    public void ajouterSerie(int pIndiceRepere, Serie pSerie) {
        if (pSerie == null) {
            return;
        }
        this.fDessin.ajouterSerie(pIndiceRepere, pSerie);
    }

    public void insererSerie(int pIndiceRepere, Serie pSerie) {
        if (pSerie == null) {
            return;
        }
        this.fDessin.insererSerie(pIndiceRepere, pSerie);
    }

    public void ajouterSeries(int pIndiceRepere, List<? extends Serie> pSeries) {
        if (pSeries == null) {
            return;
        }
        this.fDessin.ajouterSeries(pIndiceRepere, pSeries);
    }

    public void insererSeries(int pIndiceRepere, List<? extends Serie> pSeries) {
        if (pSeries == null) {
            return;
        }
        this.fDessin.insererSeries(pIndiceRepere, pSeries);
    }

    public void ajuster() {
        this.fDessin.ajuster();
    }

    public void ajusterPlageCourante() {
        this.fDessin.ajusterPlageCourante();
    }

    public void setBornes(int pIndiceRepere, double xMin, double xMax, double yMin, double yMax) {
        this.fDessin.getRepere(pIndiceRepere).setBornes(xMin, xMax, yMin, yMax);
    }

    public void setSens(int pIndiceRepere, Sens pSensH, Sens pSensV) {
        this.fDessin.getRepere(pIndiceRepere).getAxeH().setSens(pSensH);
        this.fDessin.getRepere(pIndiceRepere).getAxeV().setSens(pSensV);
    }

    public void setPosition(int pIndiceRepere, PositionAxeH pPositionH, PositionAxeV pPositionV) {
        this.fDessin.getRepere(pIndiceRepere).setPositionAxes(pPositionH, pPositionV);
    }

    public void setScaleFunctions(int pIndiceRepere, ScaleFunction pHFunction, ScaleFunction pVFunction) {
        this.fDessin.getRepere(pIndiceRepere).getAxeH().setScaleFunction(pHFunction);
        this.fDessin.getRepere(pIndiceRepere).getAxeV().setScaleFunction(pVFunction);
    }

    public boolean ajusterY(int pIndiceRepere, double pYMin, double pYMax) {
        return this.fDessin.getRepere(pIndiceRepere).ajusterY(pYMin, pYMax);
    }

    public boolean ajusterY(int pIndiceRepere) {
        return this.fDessin.getRepere(pIndiceRepere).ajusterY();
    }

    public void effacerSeries(int pIndiceRepere) {
        this.fDessin.effacerSeries(pIndiceRepere);
    }

    public void setNbGraduation(int pIndiceRepere, int pNbH, int pNbV) {
        this.fDessin.getRepere(pIndiceRepere).getAxeH().getGraduation().setNombre(pNbH);
        this.fDessin.getRepere(pIndiceRepere).getAxeV().getGraduation().setNombre(pNbV);
    }

    public void setNbQuadrillage(int pIndiceRepere, int pNbH, int pNbV) {
        this.fDessin.getRepere(pIndiceRepere).getQuadrillageH().setNombre(pNbH);
        this.fDessin.getRepere(pIndiceRepere).getQuadrillageV().setNombre(pNbV);
    }

    public void supprimerSerie(int pIndiceRepere, Serie pC) {
        if (pC != null) {
            this.fDessin.getRepere(pIndiceRepere).supprimerSerie(pC);
        }
    }

    public void supprimerSeries(int pIndiceRepere, List<? extends Serie> pSeries) {
        if (pSeries == null) {
            return;
        }
        for (Serie serie : pSeries) {
            this.fDessin.getRepere(pIndiceRepere).supprimerSerie(serie);
        }
    }

    public void supprimerSeries(int pIndiceRepere) {
        this.fDessin.getRepere(pIndiceRepere).supprimerSeries();
    }

    public void setLibCoord(JTextPane pLibCoord) {
        this.fDessin.setLibCoord(pLibCoord);
    }

    public void setEtiquette(int pIndiceRepere, String pH, String pV) {
        this.fDessin.getRepere(pIndiceRepere).getAxeH().setEtiquette(pH);
        this.fDessin.getRepere(pIndiceRepere).getAxeV().setEtiquette(pV);
    }

    public void setUnits(int pIndiceRepere, String pH, String pV) {
        this.fDessin.getRepere(pIndiceRepere).getAxeH().setUnit(pH);
        this.fDessin.getRepere(pIndiceRepere).getAxeV().setUnit(pV);
    }

    public void setLegende(boolean pVisible) {
        this.fDessin.setLegende(pVisible);
    }

    public List<Serie> getSeries() {
        return this.fDessin.getSeries();
    }

    public List<Serie> getSeries(int pIndiceRepere) {
        return this.fDessin.getRepere(pIndiceRepere).getSeries();
    }

    public void setIntervalleGraduation(int pIndiceRepere, double pIntH, double pIntV) {
        this.fDessin.getRepere(pIndiceRepere).getAxeH().getGraduation().setIntervalle(pIntH);
        this.fDessin.getRepere(pIndiceRepere).getAxeV().getGraduation().setIntervalle(pIntV);
    }

    public void setIntervalleQuadrillage(int pIndiceRepere, double pIntH, double pIntV) {
        this.fDessin.getRepere(pIndiceRepere).getQuadrillageH().setIntervalle(pIntH);
        this.fDessin.getRepere(pIndiceRepere).getQuadrillageV().setIntervalle(pIntV);
    }

    public void setPositionAxes(int pIndiceRepere, PositionAxeH pPosH, PositionAxeV pPosV) {
        this.fDessin.getRepere(pIndiceRepere).setPosAxeH(pPosH);
        this.fDessin.getRepere(pIndiceRepere).setPosAxeV(pPosV);
    }

    public void setBornesX(int pIndiceRepere, double pH, double pV) {
        this.fDessin.getRepere(pIndiceRepere).setBornesX(pH, pV);
    }

    public double getZoomH() {
        return this.fDessin.getZoomX();
    }

    public double getZoomV() {
        return this.fDessin.getZoomY();
    }

    public void setZoom(double pZoomH, double pZoomV) {
        this.fDessin.setZoom(pZoomH, pZoomV);
    }

    public boolean isControleVisible() {
        return this.fControle.isVisible();
    }

    public void setControleVisible(boolean pVisible) {
        this.miOutils.setSelected(pVisible);
        this.fControle.setVisible(pVisible);
    }

    public void saveValeursSeries(String pNomFic, int iMin, int iMax, List<Serie> series) throws IOException {
        this.fDessin.saveValeursSeries(pNomFic, iMin, iMax, series);
    }

    public void saveValeursSeries(String pNomFic, String[] pDateLabels, List<String> pLabels, int iMin, int iMax) throws IOException {
        this.fDessin.saveValeursSeries(pNomFic, pDateLabels, pLabels, iMin, iMax, this.getSeries());
    }

    public void saveValeursSeries(String pNomFic) throws IOException {
        List<Serie> series = this.getSeries();
        int nb = 0;
        for (Serie s : series) {
            nb = Math.max(nb, s.size());
        }
        this.fDessin.saveValeursSeries(pNomFic, 0.0, nb, series);
    }

    public Repere getRepere(int pIndiceRepere) {
        return this.fDessin.getRepere(pIndiceRepere);
    }

    public void setPasAffichage(int pIndiceRepere, int pPas) {
        this.getRepere(pIndiceRepere).setPasAffichage(pPas);
    }

    public void setCurseur(boolean pActif) {
        this.fDessin.setCurseur(pActif);
    }

    public JDessinGraphique getDessin() {
        return this.fDessin;
    }

    public void setHorizontalAdjustementListener(AdjustmentListener pListener) {
        if (this.fAdjustementListener != null) {
            this.fHorizontalScrollBar.removeAdjustmentListener(this.fAdjustementListener);
        }
        this.fAdjustementListener = pListener;
        this.fHorizontalScrollBar.addAdjustmentListener(this.fAdjustementListener);
    }

    public void removeHorizontalAdjustementListener() {
        if (this.fAdjustementListener != null) {
            this.fHorizontalScrollBar.removeAdjustmentListener(this.fAdjustementListener);
        }
    }

    public void setControleEnabled(boolean pControleEnabled) {
        this.fControleEnabled = pControleEnabled;
        if (!this.fControleEnabled) {
            this.setControleVisible(false);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.fDessin != null) {
            this.fDessin.repaint();
        }
    }

    @Override
    public void setVisible(boolean pAFlag) {
        super.setVisible(pAFlag);
    }

    public void addDetachListener(ChangeListener pChangeListener) {
        this.fDetachListeners.add(pChangeListener);
    }

    public void removeDetachListner(ChangeListener pChangeListener) {
        this.fDetachListeners.remove(pChangeListener);
    }

    public void setZoomEnabled(boolean pEnabled) {
        this.btZoomPlus.setVisible(pEnabled);
        this.btZoomMoins.setVisible(pEnabled);
    }

    public void setAdjustEnabled(boolean pEnabled) {
        this.btAjuster.setVisible(pEnabled);
    }

    public void setPropertiesEnabled(boolean pEnabled) {
        this.fActionConfigurer.setEnabled(pEnabled);
        this.btConfigurer.setVisible(pEnabled);
    }

    @Override
    public void setBusy(String message) {
        this.removeContent(this);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        this.fBusyLabel = Utils.createLabel((String)message);
        this.add((Component)this.fBusyLabel, constraints);
        this.updateUI();
    }

    @Override
    public void setReady() {
        if (this.fBusyLabel != null) {
            this.remove(this.fBusyLabel);
        }
        this.addContent(this);
        this.updateUI();
    }

    private /* synthetic */ void lambda$save$11(JFrame f) {
        JExportCsv dialog = new JExportCsv(f, this.fDessin);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        f.dispose();
        if (!dialog.isOk()) {
            return;
        }
        try {
            this.saveValeursSeries(dialog.getFichier(), dialog.getMin(), dialog.getMax(), dialog.getSeries());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(this, Messages.getString("JPanneauGraphique.42"));
        }
    }
}

