/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.Curseur;
import fr.dbe.graphique.DessinListener;
import fr.dbe.graphique.Fond;
import fr.dbe.graphique.Graduation;
import fr.dbe.graphique.IWidget;
import fr.dbe.graphique.LegendeWidget;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.Serie;
import fr.dbe.graphique.SerieListener;
import fr.dbe.graphique.TitleWidget;
import fr.dbe.graphique.formatter.IFormatter;
import fr.dbe.util.commun.ElementListenerHelper;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.log.Level;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JDessinGraphique
extends JPanel
implements Printable,
IXmlElement {
    public static final String PROPERTY_ZOOM = "zoom";
    public static final String PROPERTY_CENTRE = "centre";
    private static final String DOM_TITRE = "titre";
    private static final String DOM_ZOOM_X = "zoomX";
    private static final String DOM_ZOOM_Y = "zoomY";
    private static final String DOM_MARGE_DROITE = "marge-droite";
    private static final String DOM_MARGE_GAUCHE = "marge-gauche";
    private static final String DOM_MARGE_HAUT = "marge-haut";
    private static final String DOM_MARGE_BAS = "marge-bas";
    private static final String DOM_TAUX_AJUSTEMENT = "taux-ajustement";
    private static final String DOM_INDICE = "indice";
    private static final String DOM_ORTHONORME = "orthonorme";
    private static final String DOM_BORDER_COLOR = "border-color";
    private static final String DOM_CHART_BACKGROUND_COLOR = "chart-background";
    private static final String DOM_BACKGROUND = "background";
    private static final int SCROLLBAR_MAX_VALUE = 1000000;
    private final List<Repere> fReperes;
    private final Curseur fCurseur;
    private final List<DessinListener> fListeners;
    private final List<IWidget> fWidgets;
    private final ElementListenerHelper fElementListenerHelper = new ElementListenerHelper();
    private Marges fMarges;
    private double fZoomX = 1.0;
    private double fZoomY = 1.0;
    private double fTx;
    private double fTy;
    private transient JScrollBar fScrollBarH;
    private transient JScrollBar fScrollBarV;
    private String fTitle;
    private JTextPane fLibCoord;
    private Point fDebutDrag;
    private boolean fCurseurActif = true;
    private int fTauxAjustementV = 100;
    private boolean fRenduRapide = false;
    private boolean fAfficheNomCourbe;
    private boolean fOrthonorme;
    private Marges fMargesAxe;
    private Color fChartBackgroundColor;
    private Color fBorderColor;
    private BufferedImage fImage;
    private boolean fDrawImage;

    public JDessinGraphique(JTextPane plibCoord, boolean pIsCursorXOR) {
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(238, 238, 238, 255));
        this.setBorderColor(Color.GRAY);
        this.setChartBackgroundColor(Color.WHITE);
        this.fLibCoord = plibCoord;
        this.fMarges = new Marges(5.0, 5.0, 5.0, 5.0);
        this.fCurseur = new Curseur(pIsCursorXOR);
        this.fListeners = new ArrayList<DessinListener>(0);
        this.fWidgets = new ArrayList<IWidget>();
        this.fWidgets.add(new LegendeWidget(this));
        this.fWidgets.add(new TitleWidget(this));
        this.getTitre().setVisible(true);
        this.fReperes = new ArrayList<Repere>();
        this.ajouteRepere();
        this.setZoom(1.0, 1.0);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
                for (IWidget widget : JDessinGraphique.this.fWidgets) {
                    if (!widget.isDeplacable() || !widget.containsFast(e.getPoint())) continue;
                    widget.mouseExited(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                for (IWidget widget : JDessinGraphique.this.fWidgets) {
                    if (!widget.isDeplacable() || !widget.containsFast(e.getPoint())) continue;
                    widget.mouseEntered(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                for (IWidget widget : JDessinGraphique.this.fWidgets) {
                    if (!widget.isDeplacable() || !widget.containsFast(e.getPoint())) continue;
                    widget.mouseClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JDessinGraphique.this.requestFocus();
                for (IWidget widget : JDessinGraphique.this.fWidgets) {
                    if (!widget.isDeplacable()) continue;
                    if (widget.containsFast(e.getPoint())) {
                        widget.mousePressed(e);
                        if (e.getClickCount() == 2) {
                            e.consume();
                        }
                    }
                    if (e.getClickCount() != 1) continue;
                    widget.setSelected(false);
                    if (!widget.isVisible() || !widget.contains(e.getPoint()) || e.isPopupTrigger()) continue;
                    widget.setSelected(true);
                    widget.setDebutDrag(e.getPoint());
                    JDessinGraphique.this.fDebutDrag = e.getPoint();
                    JDessinGraphique.this.setCursor(Cursor.getPredefinedCursor(12));
                    JDessinGraphique.this.repaint();
                    Graphics g = JDessinGraphique.this.getGraphics();
                    widget.dessine(g);
                    g.dispose();
                    return;
                }
                if (e.isMetaDown() || e.isControlDown()) {
                    return;
                }
                Serie s = null;
                int i = -1;
                double dyMin = Double.POSITIVE_INFINITY;
                for (Serie serie : JDessinGraphique.this.getSeriesVisibles()) {
                    int indice;
                    double dy = serie.distance(e.getPoint());
                    if (!(dy < dyMin) || (indice = serie.getIndice(e.getPoint())) == -1) continue;
                    s = serie;
                    i = indice;
                    dyMin = dy;
                }
                if (dyMin < 10.0) {
                    JDessinGraphique.this.setCurseur(s, i);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                for (IWidget widget : JDessinGraphique.this.fWidgets) {
                    if (!widget.isDeplacable()) continue;
                    if (widget.containsFast(e.getPoint())) {
                        widget.mouseReleased(e);
                    }
                    if (!widget.isSelected() || JDessinGraphique.this.fDebutDrag == null) continue;
                    widget.setSelected(false);
                    widget.deplace(e.getPoint().getX() - JDessinGraphique.this.fDebutDrag.getX(), e.getPoint().getY() - JDessinGraphique.this.fDebutDrag.getY());
                    JDessinGraphique.this.fDebutDrag = null;
                    widget.setDebutDrag(null);
                }
                JDessinGraphique.this.setCursor(Cursor.getDefaultCursor());
                JDessinGraphique.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Dimension delta = null;
                for (IWidget widget : JDessinGraphique.this.fWidgets) {
                    if (!widget.isDeplacable()) continue;
                    if (widget.containsFast(e.getPoint())) {
                        widget.mouseDragged(e);
                    }
                    if (!widget.isSelected() || JDessinGraphique.this.fDebutDrag == null) continue;
                    delta = widget.deplace(e.getPoint().getX() - JDessinGraphique.this.fDebutDrag.getX(), e.getPoint().getY() - JDessinGraphique.this.fDebutDrag.getY());
                }
                if (delta != null) {
                    JDessinGraphique.this.fDebutDrag.x += delta.width;
                    JDessinGraphique.this.fDebutDrag.y += delta.height;
                }
                JDessinGraphique.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                for (IWidget widget : JDessinGraphique.this.fWidgets) {
                    if (!widget.isDeplacable()) continue;
                    if (widget.containsFast(e.getPoint())) {
                        widget.mouseMoved(e);
                    }
                    if (!widget.isVisible() || !widget.contains(e.getPoint())) continue;
                    JDessinGraphique.this.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                JDessinGraphique.this.setCursor(Cursor.getPredefinedCursor(0));
                if (e.isShiftDown()) {
                    Serie old;
                    Serie s = null;
                    int i = -1;
                    double dyMin = Double.POSITIVE_INFINITY;
                    for (Serie serie : JDessinGraphique.this.getSeriesVisibles()) {
                        int indice;
                        double dy = serie.distance(e.getPoint());
                        if (!(dy < dyMin) || (indice = serie.getIndice(e.getPoint())) == -1) continue;
                        s = serie;
                        dyMin = dy;
                    }
                    if (dyMin < 10.0 && s != (old = JDessinGraphique.this.getHighlightedSerie())) {
                        if (old != null) {
                            old.setHighlighted(false);
                        }
                        s.setHighlighted(true);
                        JDessinGraphique.this.repaint();
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    switch (e.getKeyCode()) {
                        case 27: {
                            JDessinGraphique.this.setCurseur(null, -1);
                            if (!e.isControlDown()) break;
                            for (Serie s : JDessinGraphique.this.getSeries()) {
                                s.setVisible(true);
                            }
                            JDessinGraphique.this.repaint();
                            break;
                        }
                        case 39: {
                            if (e.isShiftDown() || e.isMetaDown() || e.isControlDown()) break;
                            JDessinGraphique.this.deplaceCurseur(1);
                            break;
                        }
                        case 37: {
                            if (e.isShiftDown() || e.isMetaDown() || e.isControlDown()) break;
                            JDessinGraphique.this.deplaceCurseur(-1);
                            break;
                        }
                        case 40: {
                            JDessinGraphique.this.serieSuivante(e.isControlDown());
                            break;
                        }
                        case 38: {
                            JDessinGraphique.this.seriePrecedente(e.isControlDown());
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent pE) {
                if (JDessinGraphique.this.fScrollBarH != null) {
                    JDessinGraphique.this.posXChanged(JDessinGraphique.this.fScrollBarH.getValue());
                }
                JDessinGraphique.this.majDpix();
            }
        });
    }

    public ElementListenerHelper getElementListenerHelper() {
        return this.fElementListenerHelper;
    }

    public void addWidget(IWidget pWidget) {
        this.fWidgets.add(pWidget);
    }

    public void removeWidget(IWidget pWidget) {
        this.fWidgets.remove(pWidget);
    }

    protected double getTranslationH() {
        return this.fTx;
    }

    protected double getTranslationV() {
        return this.fTy;
    }

    public void posXChanged(double value) {
        double oldTx = this.fTx;
        this.fTx = -((double)this.getWidth()) * (this.fZoomX - 1.0) * value / 1000000.0;
        if (this.fTx != oldTx) {
            this.majDpix();
        }
    }

    public void posYChanged(double value) {
        double oldTy = this.fTy;
        this.fTy = -((double)this.getHeight()) * value / (1000000.0 / (this.fZoomY - 1.0));
        if (this.fTy != oldTy) {
            this.majDpix();
        }
    }

    public void setAscenseurs(JScrollBar sch, JScrollBar scv) {
        this.fScrollBarH = sch;
        this.fScrollBarV = scv;
        if (scv == null || sch == null) {
            return;
        }
        sch.setMinimum(0);
        if (this.fZoomX <= 1.0) {
            sch.setMaximum(0);
        } else {
            sch.setMinimum(0);
            sch.setMaximum(1000000);
        }
        sch.setBlockIncrement((int)(1000000.0 / (this.fZoomX - 1.0)));
        sch.setUnitIncrement(Math.max(1, (int)(1000.0 / this.fZoomX)));
        sch.setValue(0);
        scv.setMinimum(0);
        if (this.fZoomY <= 1.0) {
            scv.setMaximum(0);
        } else {
            scv.setMinimum(0);
            scv.setMaximum(1000000);
        }
        scv.setBlockIncrement((int)(1000000.0 / (this.fZoomY - 1.0)));
        scv.setUnitIncrement(Math.max(1, (int)(1000.0 / this.fZoomY)));
        scv.setValue(0);
        sch.setVisible(!(this.fZoomX <= 1.0));
        scv.setVisible(!(this.fZoomY <= 1.0));
    }

    private void deplaceCurseur(int pDelta) {
        Runnable r = () -> {
            Graphics g = this.getGraphics();
            if (g != null) {
                this.fCurseur.dessine(g, this);
            }
            this.fCurseur.deplace(pDelta);
            if (g != null) {
                this.fCurseur.dessine(g, this);
            }
            this.majCoord();
            if (g != null) {
                g.dispose();
            }
            if (this.horsEcran(this.fCurseur.getPoint())) {
                this.centre(this.fCurseur.getPoint());
                this.fDrawImage = false;
                this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void majCoord() {
        SwingUtilities.invokeLater(() -> {
            if (this.fCurseur.getSerie() != null && this.fCurseur.getPointGraphique() != null) {
                if (this.fAfficheNomCourbe) {
                    this.fLibCoord.setText("<html><span style='white-space:nowrap'>" + this.fCurseur + " (" + this.fCurseur.getSerie().getNom().replaceAll("</*html>", "") + ")</span></html>");
                } else {
                    this.fLibCoord.setText("<html>" + this.fCurseur + "</html>");
                }
                this.fLibCoord.setToolTipText("<html>" + this.fCurseur + "</html>");
            } else {
                this.fLibCoord.setText(null);
                this.fLibCoord.setToolTipText(null);
            }
        });
    }

    public boolean isAfficheNomCourbe() {
        return this.fAfficheNomCourbe;
    }

    public void setAfficheNomCourbe(boolean pAfficheNomCourbe) {
        this.fAfficheNomCourbe = pAfficheNomCourbe;
    }

    public void setCurseur(Serie pSerie, int pIndice) {
        if (!this.fCurseurActif) {
            return;
        }
        Runnable r = () -> {
            Graphics g = this.getGraphics();
            if (g != null && this.fCurseur != null) {
                this.fCurseur.dessine(g, this);
            }
            for (Serie s : this.getSeries()) {
                s.setHighlighted(false);
            }
            this.fCurseur.setSerie(pSerie);
            if (pSerie != null) {
                pSerie.setHighlighted(true);
            }
            this.fCurseur.setIndiceValeur(pIndice);
            if (g != null) {
                this.fCurseur.dessine(g, this);
            }
            this.majCoord();
            if (g != null) {
                g.dispose();
            }
            if (this.horsEcran(this.fCurseur.getPoint())) {
                this.centre(this.fCurseur.getPoint());
            }
            this.fDrawImage = false;
            this.repaint();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public double getZoomX() {
        return this.fZoomX;
    }

    public double getZoomY() {
        return this.fZoomY;
    }

    public void setZoom(double zoomX, double zoomY) {
        if (this.fZoomX != zoomX || this.fZoomY != zoomY) {
            if (this.fOrthonorme) {
                if (this.fZoomX != zoomX) {
                    this.fZoomX = zoomX;
                    this.fZoomY = zoomX;
                } else {
                    this.fZoomX = zoomY;
                    this.fZoomY = zoomY;
                }
            } else {
                this.fZoomX = zoomX;
                this.fZoomY = zoomY;
            }
            this.setAscenseurs(this.fScrollBarH, this.fScrollBarV);
            if (this.fCurseur != null) {
                this.centre(this.fCurseur.getPoint());
            }
            this.majDpix();
            this.fElementListenerHelper.fireValueChanged(PROPERTY_ZOOM, (Object)this);
        }
    }

    public void ajouterSerie(int pIndiceRepere, Serie c) {
        this.getRepere(pIndiceRepere).ajouterSerie(c);
        this.fireSerieAdded(c);
        this.repaint();
        c.addSerieListener(new SerieListener(){

            @Override
            public void serieRenamed(Serie serie) {
                JDessinGraphique.this.fireSerieRenamed(serie);
            }

            @Override
            public void serieColorChanged(Serie serie) {
                JDessinGraphique.this.repaint();
            }

            @Override
            public void serieVisibilityChanged(Serie pSerie) {
                JDessinGraphique.this.repaint();
            }
        });
    }

    public void insererSerie(int pIndiceRepere, Serie c) {
        this.getRepere(pIndiceRepere).insererSerie(c);
        this.fireSerieAdded(c);
        this.repaint();
        c.addSerieListener(new SerieListener(){

            @Override
            public void serieRenamed(Serie serie) {
                JDessinGraphique.this.fireSerieRenamed(serie);
            }

            @Override
            public void serieColorChanged(Serie serie) {
                JDessinGraphique.this.repaint();
            }

            @Override
            public void serieVisibilityChanged(Serie pSerie) {
                JDessinGraphique.this.repaint();
            }
        });
    }

    public void ajouterSeries(int pIndiceRepere, List<? extends Serie> series) {
        for (Serie serie : series) {
            this.ajouterSerie(pIndiceRepere, serie);
        }
    }

    public void insererSeries(int pIndiceRepere, List<? extends Serie> series) {
        for (Serie serie : series) {
            this.insererSerie(pIndiceRepere, serie);
        }
    }

    public void supprimerSerie(int pIndiceRepere, Serie c) {
        this.getRepere(pIndiceRepere).supprimerSerie(c);
        this.setCurseur(null, -1);
        this.fireSerieRemoved(c);
        this.repaint();
    }

    public Curseur getCurseur() {
        return this.fCurseur;
    }

    public void setCurseur(boolean pActif) {
        this.fCurseurActif = pActif;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) {
        if (pi >= 1) {
            return 1;
        }
        Image img = this.createImage(this.getWidth(), this.getHeight());
        Graphics2D gr = (Graphics2D)img.getGraphics();
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        gr.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        gr.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        gr.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.paint(gr);
        g.drawImage(img, (int)pf.getImageableX(), (int)pf.getImageableY(), (int)pf.getImageableWidth(), (int)pf.getImageableHeight(), null);
        gr.dispose();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics pGraphics) {
        if (this.fDrawImage) {
            pGraphics.drawImage(this.fImage, 0, 0, null);
            pGraphics.setClip(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            this.fCurseur.dessine(pGraphics, this, false);
            this.fDrawImage = false;
        } else {
            Graphics2D g;
            if (!this.fCurseur.isXOR()) {
                this.fImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                this.fCurseur.dessine(pGraphics, this, false);
                g = (Graphics2D)this.fImage.getGraphics();
            } else {
                g = (Graphics2D)pGraphics;
            }
            try {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                if (this.fRenduRapide) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                    g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                    g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                    g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                    g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                }
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                for (Repere r : this.fReperes) {
                    g.setColor(this.fChartBackgroundColor);
                    g.fillRect(r.getDrawingRectangle().x, r.getDrawingRectangle().y, r.getDrawingRectangle().width, r.getDrawingRectangle().height);
                    g.setColor(this.fBorderColor);
                    g.drawRect(r.getDrawingRectangle().x, r.getDrawingRectangle().y, r.getDrawingRectangle().width, r.getDrawingRectangle().height);
                }
                for (Repere r : this.fReperes) {
                    r.setClip(this.getClipSeries(pGraphics.getClipBounds()));
                }
                for (Repere r : this.fReperes) {
                    r.dessineFonds(g);
                }
                for (Repere r : this.fReperes) {
                    r.dessineQuadrillage(g);
                }
                for (Repere r : this.fReperes) {
                    r.dessineSeries(g);
                }
                for (Repere r : this.fReperes) {
                    r.dessineAxes(g);
                }
                for (IWidget widget : this.fWidgets) {
                    widget.dessine(g);
                }
                if (!this.fCurseur.isXOR()) {
                    pGraphics.drawImage(this.fImage, 0, 0, null);
                }
                this.fCurseur.dessine(pGraphics, this, false);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            finally {
                if (!this.fCurseur.isXOR()) {
                    g.dispose();
                }
            }
        }
    }

    public void drawImage() {
        this.fDrawImage = true;
        this.repaint();
    }

    public Color getChartBackgroundColor() {
        return this.fChartBackgroundColor;
    }

    public void setChartBackgroundColor(Color pChartBackgroundColor) {
        this.fChartBackgroundColor = pChartBackgroundColor;
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }

    public void setBorderColor(Color pBorderColor) {
        this.fBorderColor = pBorderColor;
    }

    public boolean horsEcran(Point p) {
        if (p == null) {
            return false;
        }
        return p.getX() < this.fMargesAxe.getGauche() || p.getX() > (double)this.getWidth() - this.fMargesAxe.getDroite() || p.getY() < this.fMargesAxe.getHaut() || p.getY() > (double)this.getHeight() - this.fMargesAxe.getBas();
    }

    public void centre(Point p, int pWidth) {
        if (p == null) {
            return;
        }
        double t = -this.fTx + p.getX() - (double)pWidth / 2.0;
        double valeur = t * 1000000.0 / ((double)pWidth * (this.fZoomX - 1.0));
        valeur = Math.min(valeur, (double)this.fScrollBarH.getMaximum());
        this.fScrollBarH.setValue((int)Math.round(valeur));
        this.posXChanged(this.fScrollBarH.getValue());
        t = -this.fTy + p.getY() - (double)this.getHeight() / 2.0;
        valeur = t * 1000000.0 / ((double)this.getHeight() * (this.fZoomY - 1.0));
        valeur = Math.min(valeur, (double)this.fScrollBarV.getMaximum());
        this.fScrollBarV.setValue((int)valeur);
        this.posYChanged(this.fScrollBarV.getValue());
        this.fElementListenerHelper.fireValueChanged(PROPERTY_CENTRE, (Object)p);
    }

    public void centre(Point p) {
        this.centre(p, this.getWidth());
    }

    public void addDessinListener(DessinListener l) {
        if (l != null && !this.fListeners.contains(l)) {
            this.fListeners.add(l);
        }
    }

    public void removeDessinListener(DessinListener l) {
        this.fListeners.remove(l);
    }

    public void fireSerieAdded(Serie s) {
        for (int i = this.fListeners.size() - 1; i >= 0; --i) {
            this.fListeners.get(i).serieAdded(this, s);
        }
    }

    public void fireSerieRemoved(Serie s) {
        for (int i = this.fListeners.size() - 1; i >= 0; --i) {
            this.fListeners.get(i).serieRemoved(this, s);
        }
    }

    public void fireSerieRenamed(Serie s) {
        for (int i = this.fListeners.size() - 1; i >= 0; --i) {
            this.fListeners.get(i).serieRenamed(this, s);
        }
    }

    public void firePropertiesChanged() {
        for (int i = this.fListeners.size() - 1; i >= 0; --i) {
            this.fListeners.get(i).propertiesChanged(this);
        }
    }

    public void zoomXPlus() {
        this.setZoom(this.fZoomX * 2.0, this.fZoomY);
    }

    public void zoomYPlus() {
        this.setZoom(this.fZoomX, this.fZoomY * 2.0);
    }

    public void zoomXMoins() {
        this.setZoom(Math.max(1.0, this.fZoomX / 2.0), this.fZoomY);
    }

    public void zoomYMoins() {
        this.setZoom(this.fZoomX, Math.max(1.0, this.fZoomY / 2.0));
    }

    public void effacerSeries() {
        for (Repere repere : this.fReperes) {
            repere.effacerSeries();
        }
        this.setCurseur(null, -1);
    }

    public void supprimerSeries() {
        for (Repere repere : this.fReperes) {
            repere.supprimerSeries();
        }
        this.setCurseur(null, -1);
    }

    public Element getDomElement(Document doc) {
        Element root = doc.createElement(MapXmlGraph.getInstance().getNomElement(JDessinGraphique.class));
        for (IWidget widget : this.fWidgets) {
            if (widget instanceof Graduation) continue;
            root.appendChild(widget.getDomElement(doc));
        }
        root.setAttribute(DOM_TITRE, String.valueOf(this.fTitle));
        root.setAttribute(DOM_ZOOM_X, String.valueOf(this.fZoomX));
        root.setAttribute(DOM_ZOOM_Y, String.valueOf(this.fZoomY));
        root.setAttribute(DOM_MARGE_DROITE, String.valueOf(this.fMarges.getDroite()));
        root.setAttribute(DOM_MARGE_GAUCHE, String.valueOf(this.fMarges.getGauche()));
        root.setAttribute(DOM_MARGE_HAUT, String.valueOf(this.fMarges.getHaut()));
        root.setAttribute(DOM_MARGE_BAS, String.valueOf(this.fMarges.getBas()));
        root.setAttribute(DOM_TAUX_AJUSTEMENT, String.valueOf(this.fTauxAjustementV));
        root.setAttribute(DOM_ORTHONORME, String.valueOf(this.fOrthonorme));
        root.setAttribute(DOM_BORDER_COLOR, String.valueOf(this.fBorderColor.getRGB()));
        root.setAttribute(DOM_BACKGROUND, String.valueOf(this.getBackground().getRGB()));
        root.setAttribute(DOM_CHART_BACKGROUND_COLOR, String.valueOf(this.fChartBackgroundColor.getRGB()));
        root.appendChild(XmlUtils.createColorNode((Document)doc, (Color)this.getBackground()));
        int i = 0;
        for (Repere repere : this.fReperes) {
            Element elt = repere.getDomElement(doc);
            elt.setAttribute(DOM_INDICE, String.valueOf(i++));
            root.appendChild(elt);
        }
        return root;
    }

    public void setProperties(Node pNoeud) {
        this.setTitle(XmlUtils.getAttributeStringValue((Node)pNoeud, (String)DOM_TITRE, (String)this.getTitle()));
        this.setOrthonorme(XmlUtils.getAttributeBooleanValue((Node)pNoeud, (String)DOM_ORTHONORME, (boolean)this.fOrthonorme));
        this.setZoom(XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_ZOOM_X, (double)1.0), XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_ZOOM_Y, (double)1.0));
        this.setMarges(new Marges(XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_GAUCHE, (double)0.0), XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_HAUT, (double)0.0), XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_BAS, (double)0.0), XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_MARGE_DROITE, (double)0.0)));
        this.setBackground(XmlUtils.getColor((Node)pNoeud));
        Node n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement(Repere.class));
        int ind = -1;
        while (n != null) {
            Node attr = n.getAttributes().getNamedItem(DOM_INDICE);
            if (attr != null) {
                ind = Utilitaire.parseInt((String)attr.getNodeValue());
                if (ind >= this.fReperes.size()) {
                    this.ajouteRepere();
                }
                this.getRepere(ind).setProperties(n);
            }
            n = XmlUtils.getFrereSuivant((Node)n, (String)n.getNodeName());
        }
        if (ind < 0) {
            Log.getInstance().warn(Messages.getString("JDessinGraphique.11") + MapXmlGraph.getInstance().getNomElement(Repere.class) + Messages.getString("JDessinGraphique.12"));
        }
        for (IWidget widget : this.fWidgets) {
            if (widget instanceof Graduation) continue;
            n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement((IXmlElement)widget));
            if (n != null) {
                widget.setProperties(n);
                continue;
            }
            Log.getInstance().log(Level.WARN, Messages.getString("JDessinGraphique.13") + MapXmlGraph.getInstance().getNomElement(widget.getClass()) + Messages.getString("JDessinGraphique.14"));
        }
        if (this.fReperes.isEmpty()) {
            this.ajouteRepere();
        }
        this.setTauxAjustementV(XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_TAUX_AJUSTEMENT, (int)100));
        this.setBorderColor(new Color(XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_BORDER_COLOR, (int)Color.GRAY.getRGB())));
        this.setChartBackgroundColor(new Color(XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_CHART_BACKGROUND_COLOR, (int)Color.WHITE.getRGB())));
        this.setBackground(new Color(XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_BACKGROUND, (int)new Color(230, 230, 230).getRGB())));
    }

    public void saveValeursSeries(String pNomFic, double xMin, double xMax, List<Serie> series) throws IOException {
        Courbe c;
        if (series.isEmpty()) {
            return;
        }
        StringWriter sw = new StringWriter(10000);
        PrintWriter pw = new PrintWriter(sw);
        String title = this.getRepere(0).getAxeH().getEtiquetteEtUnit();
        pw.print(title == null ? "" : title.replaceAll("<[^>]*>", ""));
        series.sort((pS1, pS2) -> (pS1.getNom() == null ? "" : pS1.getNom()).compareTo(pS2.getNom()));
        class CourbesIndices {
            final List<Courbe> courbes = new ArrayList<Courbe>();
            double xMin = Double.MAX_VALUE;
            double xMax = Double.MIN_VALUE;

            CourbesIndices() {
            }
        }
        HashMap<Double, CourbesIndices> mapCourbes = new HashMap<Double, CourbesIndices>();
        ArrayList<Serie> autresSeries = new ArrayList<Serie>();
        for (Serie serie : series) {
            if (serie instanceof Courbe) {
                c = (Courbe)serie;
                CourbesIndices ci = (CourbesIndices)mapCourbes.get(c.getDx());
                if (ci == null) {
                    ci = new CourbesIndices();
                    mapCourbes.put(c.getDx(), ci);
                }
                ci.courbes.add(c);
                double cMin = c.getXMin();
                double cMax = c.getXMax();
                if (cMin < ci.xMin) {
                    ci.xMin = cMin;
                }
                if (!(cMax > ci.xMax)) continue;
                ci.xMax = cMax;
                continue;
            }
            autresSeries.add(serie);
        }
        for (Map.Entry entry : mapCourbes.entrySet()) {
            List<Courbe> courbes = ((CourbesIndices)entry.getValue()).courbes;
            for (Serie serie : courbes) {
                pw.print(";" + (String)(serie.getNom() == null ? "" : serie.getNom().replaceAll("<[^>]*>", "") + (String)(serie.getRepere().getAxeV().getUnit() == null ? "" : (" (" + serie.getRepere().getAxeV().getUnit()).replaceAll("<[^>]*>", "").replace('\u00b3', '3').replace('\u00b2', '2') + ")")));
            }
            pw.println();
            c = courbes.get(0);
            IFormatter formatter = c.getRepere().getAxeH().getGraduation().getFormatter();
            double min = ((CourbesIndices)entry.getValue()).xMin;
            double max = ((CourbesIndices)entry.getValue()).xMax;
            for (double x = min; x <= max; x += ((Double)entry.getKey()).doubleValue()) {
                pw.print(formatter.format(x));
                for (Courbe cc : courbes) {
                    int indice = cc.getIndicePourX(x);
                    if (indice >= 0 && indice < cc.size()) {
                        double val = cc.getY(indice);
                        if (Double.isNaN(val)) {
                            pw.print(";");
                            continue;
                        }
                        pw.print(String.format(";%g", val).replace(',', '.'));
                        continue;
                    }
                    pw.print(";");
                }
                pw.println();
            }
        }
        for (Serie serie : autresSeries) {
            pw.println();
            pw.print(serie.getRepere().getAxeH().getEtiquette().replaceAll("<[^>]*>", "") + ";" + serie.getRepere().getAxeH().getEtiquette().replaceAll("<[^>]*>", ""));
            IFormatter formatter = serie.getRepere().getAxeH().getGraduation().getFormatter();
            int n = serie.size();
            for (int i = 0; i < n; ++i) {
                pw.print(formatter.format(serie.getX(i)));
                pw.print(String.format(";%g", serie.getY(i)).replace(',', '.'));
                pw.println();
            }
        }
        pw.flush();
        if (!((String)pNomFic).toLowerCase().endsWith(".csv")) {
            pNomFic = (String)pNomFic + ".csv";
        }
        Utilitaire.saveEncode((String)pNomFic, (String)sw.toString(), (String)"UTF-8");
        pw.close();
    }

    public void saveValeursSeries(String pNomFic, String[] pDateLabels, List<String> pLabels, int iMin, int iMax, List<Serie> series) throws IOException {
        StringWriter sw = new StringWriter(10000);
        PrintWriter pw = new PrintWriter(sw);
        String title = this.getRepere(0).getAxeH().getEtiquetteEtUnit();
        pw.print(title == null ? "" : title.replaceAll("<[^>]*>", ""));
        if (pDateLabels != null) {
            pw.print(";");
        }
        pw.print("Labels");
        int nb = 0;
        for (Serie s : series) {
            pw.print(";" + (String)(s.getNom() == null ? "" : s.getNom().replaceAll("<[^>]*>", "") + (String)(s.getRepere().getAxeV().getUnit() == null ? "" : (" (" + s.getRepere().getAxeV().getUnit()).replaceAll("<[^>]*>", "").replace('\u00b3', '3').replace('\u00b2', '2') + ")")));
            nb = Math.max(nb, s.size());
        }
        pw.println();
        if (series.isEmpty()) {
            return;
        }
        for (int i = Math.max(0, iMin); i <= Math.min(nb - 1, iMax); ++i) {
            if (pDateLabels != null) {
                pw.print(i < pDateLabels.length ? pDateLabels[i] : "");
                pw.print(";");
            }
            pw.print(i < pLabels.size() ? pLabels.get(i) : "");
            for (Serie s : series) {
                double val = i < s.size() ? s.getY(i) : 0.0;
                pw.print(String.format(";%g", val).replace(',', '.'));
            }
            pw.println();
        }
        pw.flush();
        if (!((String)pNomFic).toLowerCase().endsWith(".csv")) {
            pNomFic = (String)pNomFic + ".csv";
        }
        Utilitaire.saveEncode((String)pNomFic, (String)sw.toString(), (String)"ISO-8859-1");
        pw.close();
    }

    protected void serieSuivante(boolean alone) {
        List<Serie> series;
        List<Serie> list = series = alone ? this.getSeries() : this.getSeriesVisibles();
        if (series.isEmpty()) {
            return;
        }
        Serie old = null;
        Serie serie = null;
        for (Serie s : series) {
            if (!s.isHighlighted()) continue;
            old = s;
            break;
        }
        if (old == null) {
            return;
        }
        int i = series.indexOf(old);
        for (int n = 1; n < series.size(); ++n) {
            int j = (i + n) % series.size();
            if (!series.get(j).isCursorable()) continue;
            serie = series.get(j);
            break;
        }
        if (serie != null && serie != old) {
            int indiceValeur = -1;
            if (this.fCurseurActif && this.fCurseur.getSerie() == old) {
                indiceValeur = this.fCurseur.getIndiceValeur();
            }
            if (alone) {
                for (Serie s : series) {
                    s.setVisible(false);
                }
                serie.setVisible(true);
            } else {
                old.setHighlighted(false);
            }
            if (this.fCurseurActif && this.fCurseur.getSerie() == old) {
                double val = (double)indiceValeur + old.getXMin();
                this.setCurseur(serie, (int)(val - serie.getXMin()));
            } else {
                serie.setHighlighted(true);
            }
            this.repaint();
        }
    }

    protected void seriePrecedente(boolean alone) {
        List<Serie> series;
        List<Serie> list = series = alone ? this.getSeries() : this.getSeriesVisibles();
        if (series.isEmpty()) {
            return;
        }
        Serie old = null;
        Serie serie = null;
        for (Serie s : series) {
            if (!s.isHighlighted()) continue;
            old = s;
            break;
        }
        if (old == null) {
            return;
        }
        int i = series.indexOf(old);
        for (int n = 1; n < series.size(); ++n) {
            int j = (series.size() + i - n) % series.size();
            if (!series.get(j).isCursorable()) continue;
            serie = series.get(j);
            break;
        }
        if (serie != null && serie != old) {
            int indiceValeur = -1;
            if (this.fCurseurActif && this.fCurseur.getSerie() == old) {
                indiceValeur = this.fCurseur.getIndiceValeur();
            }
            if (alone) {
                for (Serie s : series) {
                    s.setVisible(false);
                }
                serie.setVisible(true);
            } else {
                old.setHighlighted(false);
            }
            if (this.fCurseurActif && this.fCurseur.getSerie() == old) {
                double val = (double)indiceValeur + old.getXMin();
                this.setCurseur(serie, (int)(val - serie.getXMin()));
            } else {
                serie.setHighlighted(true);
            }
            this.repaint();
        }
    }

    protected boolean isLegendeVisible() {
        return this.getLegende().isVisible();
    }

    public Repere getRepere(int pIndice) {
        return this.fReperes.get(pIndice);
    }

    public List<Serie> getSeries() {
        ArrayList<Serie> series = new ArrayList<Serie>();
        for (Repere r : this.fReperes) {
            series.addAll(r.getSeries());
        }
        return series;
    }

    public void ajuster() {
        ArrayList<Serie> series = new ArrayList<Serie>();
        for (Repere repere : this.fReperes) {
            series.addAll(repere.getSeries());
        }
        int nbVis = 0;
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        for (Serie s : series) {
            if (s.size() <= 0) continue;
            ++nbVis;
            if (s.getXMinAff() < xMin && !Double.isInfinite(s.getXMinAff())) {
                xMin = s.getXMinAff();
            }
            if (!(s.getXMaxAff() > xMax) || Double.isInfinite(s.getXMaxAff())) continue;
            xMax = s.getXMaxAff();
        }
        if (nbVis == 0) {
            return;
        }
        if (xMin == xMax) {
            xMin -= 1.0;
            xMax += 1.0;
        }
        if (xMin == Double.NEGATIVE_INFINITY || xMax == Double.POSITIVE_INFINITY) {
            xMin = -1.0;
            xMax = 1.0;
        }
        for (Repere repere : this.fReperes) {
            double yMin = Double.POSITIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (Serie s : repere.getSeries()) {
                if (s.size() <= 0) continue;
                if (s.getYMin() < yMin && !Double.isInfinite(s.getYMin())) {
                    yMin = s.getYMin();
                }
                if (!(s.getYMax() > yMax) || Double.isInfinite(s.getYMax())) continue;
                yMax = s.getYMax();
            }
            for (Fond f : repere.getFonds()) {
                if (!f.hasYMinMax() || !f.isVisible()) continue;
                if (f.getYMin() < yMin && !Double.isInfinite(f.getYMin())) {
                    yMin = f.getYMin();
                }
                if (!(f.getYMax() > yMax) || Double.isInfinite(f.getYMax())) continue;
                yMax = f.getYMax();
            }
            yMax = yMin + (yMax - yMin) * 100.0 / (double)this.getTauxAjustementV();
            if (yMin == Double.POSITIVE_INFINITY || yMax == Double.NEGATIVE_INFINITY) {
                yMin = -1.0;
                yMax = 1.0;
            }
            if (this.fOrthonorme) {
                double min = Math.min(xMin, yMin);
                double max = Math.max(xMax, yMax);
                repere.setBornes(min, max, min, max);
                continue;
            }
            repere.setBornes(xMin, xMax, yMin, yMax);
        }
    }

    public void ajusterPlageCourante() {
        for (Repere repere : this.fReperes) {
            repere.ajusterPlageCourante();
        }
    }

    public int ajouteRepere() {
        Repere r = new Repere(this);
        this.fReperes.add(r);
        if (this.fReperes.size() == 2 && this.fTauxAjustementV == 100) {
            this.setTauxAjustementV(50);
        }
        this.fWidgets.add(r.getAxeH().getGraduation());
        this.fWidgets.add(r.getAxeV().getGraduation());
        this.majDpix();
        return this.fReperes.size() - 1;
    }

    public void supprimerRepere(int pIndice) {
        Repere r = this.fReperes.get(pIndice);
        this.fReperes.remove(pIndice);
        this.fWidgets.remove(r.getAxeH().getGraduation());
        this.fWidgets.remove(r.getAxeV().getGraduation());
        this.majDpix();
    }

    public List<Repere> getReperes() {
        return this.fReperes;
    }

    public void setLibCoord(JTextPane pLibCoord) {
        this.fLibCoord = pLibCoord;
    }

    public void effacerSeries(int pIndiceRepere) {
        this.getRepere(pIndiceRepere).effacerSeries();
        this.setCurseur(null, -1);
    }

    public LegendeWidget getLegende() {
        return (LegendeWidget)this.fWidgets.get(0);
    }

    public void setLegende(boolean pLegende) {
        this.getLegende().setVisible(pLegende);
        this.repaint();
    }

    public Marges getMarges() {
        return this.fMarges;
    }

    public void setMarges(Marges pMarges) {
        this.fMarges = pMarges;
        this.majDpix();
    }

    public Marges getMargesAxe() {
        return this.fMargesAxe;
    }

    public void setMargesAxe(Marges pMargesAxe) {
        this.fMargesAxe = pMargesAxe;
        this.majDpix();
    }

    public int getTauxAjustementV() {
        return this.fTauxAjustementV;
    }

    public void setTauxAjustementV(int pTauxAjustementV) {
        if (this.fTauxAjustementV != (pTauxAjustementV = Math.max(pTauxAjustementV, 10))) {
            this.fTauxAjustementV = pTauxAjustementV;
            this.ajuster();
            this.repaint();
        }
    }

    public Rectangle getClipSeries(Rectangle pClip) {
        Rectangle2D clipSerie2D = this.fReperes.get(0).getDrawingRectangle();
        for (int i = 1; i < this.fReperes.size(); ++i) {
            clipSerie2D = ((Rectangle2D)clipSerie2D).createUnion(this.fReperes.get(i).getDrawingRectangle());
        }
        if (pClip == null) {
            return ((RectangularShape)clipSerie2D).getBounds();
        }
        return ((Rectangle2D)clipSerie2D).createIntersection(pClip).getBounds();
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String pTitle) {
        this.fTitle = pTitle;
        this.repaint();
    }

    public TitleWidget getTitre() {
        return (TitleWidget)this.fWidgets.get(1);
    }

    public void refreshCurseur() {
        if (this.fCurseurActif && this.fCurseur != null) {
            this.setCurseur(this.fCurseur.getSerie(), this.fCurseur.getIndiceValeur());
        }
    }

    public boolean isRenduRapide() {
        return this.fRenduRapide;
    }

    public void setRenduRapide(boolean pRenduRapide) {
        this.fRenduRapide = pRenduRapide;
    }

    public JScrollBar getScrollBarH() {
        return this.fScrollBarH;
    }

    public List<Serie> getSeriesVisibles() {
        ArrayList<Serie> series = new ArrayList<Serie>();
        for (Repere r : this.fReperes) {
            for (Serie s : r.getSeries()) {
                if (!s.isVisible()) continue;
                series.add(s);
            }
        }
        return series;
    }

    public List<Serie> getSeriesActives() {
        ArrayList<Serie> series = new ArrayList<Serie>();
        for (Repere r : this.fReperes) {
            series.addAll(r.getSeriesActives());
        }
        return series;
    }

    public void positionneY(double y, int pos, Axe pAxe) {
        double min;
        double max;
        if (!Double.isFinite(y)) {
            return;
        }
        if (pAxe.getScaleFunction() != null) {
            max = pAxe.getScaleFunction().transform(pAxe.getMax());
            min = pAxe.getScaleFunction().transform(pAxe.getMin());
            y = pAxe.getScaleFunction().transform(y);
        } else {
            max = pAxe.getMax();
            min = pAxe.getMin();
        }
        double dy = pAxe.getSens().equals((Object)Sens.DIRECT) ? max - y : y - min;
        double value = (int)(-(dy / (max - min) * (this.getZoomY() * (double)this.getHeight() - this.fMargesAxe.getHaut() - this.fMargesAxe.getBas()) + this.fMargesAxe.getHaut() - (double)pos));
        value = Math.min(0.0, value);
        value = Math.max(value, (double)(-this.getHeight()) * (this.getZoomY() - 1.0));
        value = -(value * 1000000.0 / (double)this.getHeight() / (this.getZoomY() - 1.0));
        this.fScrollBarV.setValue((int)value);
        this.posYChanged(value);
        this.repaint();
    }

    public List<Fond> getFonds() {
        ArrayList<Fond> fonds = new ArrayList<Fond>();
        for (Repere r : this.fReperes) {
            fonds.addAll(r.getFonds());
        }
        return fonds;
    }

    public boolean isOrthonorme() {
        return this.fOrthonorme;
    }

    public void setOrthonorme(boolean pOrthonorme) {
        if (this.fOrthonorme != pOrthonorme) {
            this.fOrthonorme = pOrthonorme;
            this.majDpix();
        }
    }

    protected void majDpix() {
        try {
            for (Repere r : this.fReperes) {
                r.majDpix();
            }
            for (Repere r : this.fReperes) {
                r.majDpix();
            }
        }
        catch (ConcurrentModificationException e) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.majDpix();
        }
        this.repaint();
    }

    public void ajusteMarges() {
        double gauche = 0.0;
        double droite = 0.0;
        double haut = 0.0;
        double bas = 0.0;
        for (Repere r : this.fReperes) {
            Marges m = r.estimeMarge();
            haut = Math.max(haut, m.getHaut());
            droite = Math.max(droite, m.getDroite());
            bas = Math.max(bas, m.getBas());
            gauche = Math.max(gauche, m.getGauche());
        }
        this.fMargesAxe = new Marges(haut + this.fMarges.getHaut(), droite + this.fMarges.getDroite(), bas + this.fMarges.getBas(), gauche + this.fMarges.getGauche());
    }

    @Override
    public void setSize(Dimension pD) {
        super.setSize(pD);
        this.majDpix();
    }

    public Serie getHighlightedSerie() {
        for (Serie serie : this.getSeriesVisibles()) {
            if (!serie.isHighlighted()) continue;
            return serie;
        }
        return null;
    }
}

