/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.PointCourbe;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.PolyLigne;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Bornes;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.XmlUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CourbeLibre
extends Serie {
    protected List<Point2D.Double> fValues;
    private boolean fEffacable = true;
    private ITypeDessin fTypeDessin;

    public CourbeLibre(String nom) {
        super(nom);
        this.xMin = 0.0;
        this.fValues = new ArrayList<Point2D.Double>(1000);
        this.fTypeDessin = new PolyLigne();
    }

    public boolean isEffacable() {
        return this.fEffacable;
    }

    public void setEffacable(boolean effacable) {
        this.fEffacable = effacable;
    }

    public void add(Point2D.Double pPoint) {
        this.fValues.add(pPoint);
        this.majMinMaxY();
    }

    @Override
    public void majMinMaxY() {
        this.xMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        for (int i = this.size() - 1; i >= 0; --i) {
            double x = this.getX(i);
            double y = this.getY(i);
            this.xMin = Math.min(Double.isNaN(x) ? this.xMin : x, this.xMin);
            this.xMax = Math.max(Double.isNaN(x) ? this.xMax : x, this.xMax);
            this.yMin = Math.min(Double.isNaN(y) ? this.yMin : y, this.yMin);
            this.yMax = Math.max(Double.isNaN(y) ? this.yMax : y, this.yMax);
        }
    }

    @Override
    public void dessine(Graphics g, double pXMin, double pXMax, int pPasAffichage) {
        if (!this.isVisible() || this.fRepere == null || this.size() == 0) {
            return;
        }
        this.fTypeDessin.dessine(this, g, pXMin, pXMax, pPasAffichage);
    }

    @Override
    public int size() {
        return this.fValues.size();
    }

    @Override
    public double getX(int indice) {
        return this.fValues.get(indice).getX();
    }

    @Override
    public double getY(int indice) {
        return this.fValues.get(indice).getY();
    }

    @Override
    public void remove(int indice) {
        this.fValues.remove(indice);
        this.majMinMaxY();
    }

    @Override
    public void clear() {
        if (this.fEffacable) {
            this.fValues.clear();
            this.xMax = this.xMin;
            this.yMin = Double.POSITIVE_INFINITY;
            this.yMax = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public int getIndice(Point pPoint) {
        double distance = Double.MAX_VALUE;
        int indice = 0;
        for (int i = 0; i < this.fValues.size(); ++i) {
            double d;
            Point2D.Double p = this.fValues.get(i);
            if (p == null || !((d = new Point((int)this.fRepere.getAxeH().valToPix(p.getX()), (int)this.fRepere.getAxeV().valToPix(p.getY())).distance(pPoint)) < distance)) continue;
            indice = i;
            distance = d;
        }
        return indice;
    }

    @Override
    public PointGraphique get(int pIndice) {
        return new PointCourbe(this.getX(pIndice), this.getY(pIndice));
    }

    @Override
    public double distance(Point pPoint) {
        double distance = Double.MAX_VALUE;
        for (Point2D.Double p : this.fValues) {
            if (p == null) continue;
            distance = Math.min(distance, new Point((int)this.fRepere.getAxeH().valToPix(p.getX()), (int)this.fRepere.getAxeV().valToPix(p.getY())).distance(pPoint));
        }
        return distance;
    }

    public ITypeDessin getTypeDessin() {
        return this.fTypeDessin;
    }

    public void setTypeDessin(ITypeDessin pTypeDessin) {
        this.fTypeDessin = pTypeDessin;
    }

    @Override
    public Bornes bornesY(double pXMin, double pXMax) {
        if (this.size() == 0) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Point2D.Double p : this.fValues) {
            double y = p.getY();
            double x = p.getX();
            if (!(x >= pXMin) || !(x <= pXMax)) continue;
            if (y < min) {
                min = y;
            }
            if (!(y > max)) continue;
            max = y;
        }
        return new Bornes(min, max);
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pX, int pY, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getCouleur());
        pGraphics2d.setStroke(this.getTypeDessin().getStroke());
        for (int y = pY - 2; y <= pY + 2; ++y) {
            pGraphics2d.drawLine(pX, y + pHeight / 2, pX + pWidth, y + pHeight / 2);
        }
    }

    @Override
    public Element getDomElement(Document pDoc) {
        Element elt = super.getDomElement(pDoc);
        elt.appendChild(this.fTypeDessin.getDomElement(pDoc));
        return elt;
    }

    @Override
    public void setProperties(Node pNoeud) {
        super.setProperties(pNoeud);
        Node n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        if (n != null) {
            this.fTypeDessin.setProperties(n);
        } else {
            Log.getInstance().warn(Messages.getString("Courbe.2") + MapXmlGraph.getInstance().getNomElement(ITypeDessin.class) + Messages.getString("Repere.3"));
        }
    }

    @Override
    public Plage plageFor(double pXMin, double pXMax) {
        return new Plage(0, this.fValues.size());
    }
}

