/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique.formatter;

import fr.dbe.graphique.formatter.IFormatter;
import java.text.DateFormat;
import java.util.Date;

public class DateFormatter
implements IFormatter {
    private final DateFormat fDateFormat;
    private final long fPas;
    private final long fOrigine;

    public DateFormatter(DateFormat pDateFormat, long pPas, long pOrigine) {
        this.fDateFormat = pDateFormat;
        this.fPas = pPas;
        this.fOrigine = pOrigine;
    }

    @Override
    public String format(double pValue) {
        return this.fDateFormat.format(new Date(this.fOrigine + (long)pValue * this.fPas));
    }

    @Override
    public String[] format(double[] pValue) {
        String[] res = new String[pValue.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.fDateFormat.format(new Date(this.fOrigine + (long)pValue[i] * this.fPas));
        }
        return res;
    }

    public long getOrigine() {
        return this.fOrigine;
    }

    public long getPas() {
        return this.fPas;
    }

    @Override
    public double valueFor(double pValue) {
        return pValue;
    }

    @Override
    public String formatPrecis(double pValue) {
        return this.format(pValue);
    }
}

