/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.commun.Vecteur;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Surface
implements ITypeDessin {
    private final Serie fAutreCourbe;
    private Stroke fStroke = new BasicStroke(1.0f);
    private Color fFillColor;

    public Surface(Serie pAutreCourbe, Color pFillColor) {
        this.fAutreCourbe = pAutreCourbe;
        this.setFillColor(pFillColor);
    }

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        if (pCourbe.size() < 2) {
            return;
        }
        Plage plage = pCourbe.plageFor(pXMin, pXMax);
        int i0 = plage.getIndiceMin();
        int i1 = plage.getIndiceMax();
        if (i0 >= pCourbe.size()) {
            return;
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        pG.setColor(pCourbe.getCouleur());
        Stroke oldStroke = ((Graphics2D)pG).getStroke();
        ((Graphics2D)pG).setStroke(this.fStroke);
        if (i0 < i1) {
            Vecteur xAutre = new Vecteur(i1 - i0 + 1, 10);
            Vecteur yAutre = new Vecteur(i1 - i0 + 1, 1);
            GeneralPath polyline = new GeneralPath(0, i1 - i0 + 1);
            GeneralPath polylineA = new GeneralPath(0, i1 - i0 + 1);
            Polygon polygon = new Polygon();
            double x = axeH.valToPix(pCourbe.getX(i0));
            double y = axeV.valToPix(pCourbe.getY(i0));
            double yA = axeV.valToPix(this.fAutreCourbe.getY(i0));
            if (Double.isFinite(y) && Double.isFinite(yA)) {
                polyline.moveTo(x, y);
                polylineA.moveTo(x, y);
                polygon.addPoint((int)x, (int)y);
                xAutre.ajouter(axeH.valToPix(this.fAutreCourbe.getX(i0)));
                yAutre.ajouter(axeV.valToPix(this.fAutreCourbe.getY(i0)));
            }
            try {
                for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
                    x = axeH.valToPix(pCourbe.getX(j));
                    y = axeV.valToPix(pCourbe.getY(j));
                    double xA = axeH.valToPix(this.fAutreCourbe.getX(j));
                    yA = axeV.valToPix(this.fAutreCourbe.getY(j));
                    if (Double.isFinite(y) && Double.isFinite(yA)) {
                        if (polyline.getCurrentPoint() == null) {
                            polyline.moveTo(x, y);
                            polylineA.moveTo(xA, yA);
                        } else {
                            polyline.lineTo(x, y);
                            polylineA.lineTo(xA, yA);
                        }
                        polygon.addPoint((int)x, (int)y);
                        xAutre.ajouter(xA);
                        yAutre.ajouter(yA);
                        continue;
                    }
                    if (polygon.npoints > 1) {
                        for (int p = xAutre.size() - 1; p >= 0; --p) {
                            polygon.addPoint((int)xAutre.get(p), (int)yAutre.get(p));
                        }
                        polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
                        pG.setColor(this.fFillColor);
                        ((Graphics2D)pG).fill(polygon);
                        polygon.reset();
                        xAutre.clear();
                        yAutre.clear();
                    }
                    pG.setColor(pCourbe.getCouleur());
                    ((Graphics2D)pG).draw(polyline);
                    ((Graphics2D)pG).draw(polylineA);
                    polyline.reset();
                    polylineA.reset();
                }
            }
            catch (ArrayIndexOutOfBoundsException p) {
                // empty catch block
            }
            if (polygon.npoints > 1) {
                for (int p = xAutre.size() - 1; p >= 0; --p) {
                    polygon.addPoint((int)xAutre.get(p), (int)yAutre.get(p));
                }
                pG.setColor(this.fFillColor);
                polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
                ((Graphics2D)pG).fill(polygon);
            }
            pG.setColor(pCourbe.getCouleur());
            ((Graphics2D)pG).draw(polyline);
            ((Graphics2D)pG).draw(polylineA);
        }
        ((Graphics2D)pG).setStroke(oldStroke);
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    @Override
    public Color getFillColor() {
        return this.fFillColor;
    }

    @Override
    public void setFillColor(Color pFillColor) {
        this.fFillColor = pFillColor;
    }

    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.appendChild(XmlUtils.createStrokeNode((Document)pDoc, (BasicStroke)((BasicStroke)this.fStroke)));
        root.appendChild(XmlUtils.createColorNode((Document)pDoc, (Color)this.fFillColor));
        return root;
    }

    public void setProperties(Node pNoeud) {
        this.setStroke(XmlUtils.getStroke((Node)pNoeud));
        this.setFillColor(XmlUtils.getColor((Node)pNoeud, (int)20));
    }

    @Override
    public boolean hasFillColor() {
        return true;
    }

    @Override
    public int getDXMaxAff() {
        return 0;
    }

    @Override
    public int getDXMinAff() {
        return 0;
    }
}

