/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.MinSpaceVerifier;
import fr.dbe.graphique.PositionComputer;
import fr.dbe.graphique.Positionnable;
import fr.dbe.graphique.Repartition;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlUtils;
import java.awt.Color;
import java.awt.Graphics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Quadrillage
implements IXmlElement,
Positionnable {
    private static final String DOM_VISIBLE = "visible";
    private static final String DOM_NOMBRE = "nbGraduation";
    private static final String DOM_INTERVALLE = "graduation";
    private static final String DOM_REPARTITION = "repartition";
    protected Color fCouleur = Color.LIGHT_GRAY;
    protected boolean fVisible = false;
    protected MinSpaceVerifier fMinSpaceVerifier;
    private Repartition fRepartition = Repartition.LIE;
    private double fIntervalle;
    private int fNombre;
    private double[] fPositions;

    public Color getCouleur() {
        return this.fCouleur;
    }

    public void setCouleur(Color pCouleur) {
        this.fCouleur = pCouleur;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void setVisible(boolean pVisible) {
        this.fVisible = pVisible;
    }

    @Override
    public double getIntervalle() {
        return this.fIntervalle;
    }

    @Override
    public void setIntervalle(double pIntervalle) {
        this.fRepartition = Repartition.INTERVALLE;
        this.fIntervalle = pIntervalle;
    }

    @Override
    public int getNombre() {
        return this.fNombre;
    }

    @Override
    public void setNombre(int pNombre) {
        this.fRepartition = Repartition.NOMBRE;
        this.fNombre = pNombre;
    }

    public void linkToGraduation() {
        this.fRepartition = Repartition.LIE;
    }

    public double[] getPositions() {
        return this.fPositions;
    }

    public void setPositions(double[] pPositions) {
        this.fRepartition = Repartition.POSITIONS;
        this.fPositions = pPositions;
    }

    protected double[] computePositions(Axe pAxe, double pPositionAxe) {
        if (this.fRepartition == Repartition.POSITIONS) {
            return this.fPositions;
        }
        return PositionComputer.compute(this, pAxe, pPositionAxe, this.fPositions);
    }

    public void dessine(Graphics g, Axe pAxe, double pPositionAxe) {
        if (!this.fVisible || this.fRepartition == Repartition.INTERVALLE && this.fIntervalle == 0.0 || this.fRepartition == Repartition.NOMBRE && this.fNombre == 0 || this.fRepartition == Repartition.POSITIONS && (this.fPositions == null || this.fPositions.length == 0)) {
            return;
        }
        this.dessine(g, pAxe, this.computePositions(pAxe, pPositionAxe));
    }

    public Element getDomElement(Document doc) {
        Element elt = doc.createElement(MapXmlGraph.getInstance().getNomElement((IXmlElement)this));
        elt.appendChild(XmlUtils.createColorNode((Document)doc, (Color)this.fCouleur));
        elt.setAttribute(DOM_REPARTITION, String.valueOf((Object)this.fRepartition));
        elt.setAttribute(DOM_INTERVALLE, String.valueOf(this.fIntervalle));
        elt.setAttribute(DOM_NOMBRE, String.valueOf(this.fNombre));
        elt.setAttribute(DOM_VISIBLE, String.valueOf(this.fVisible));
        return elt;
    }

    public void setProperties(Node pNoeud) {
        this.setVisible(XmlUtils.getAttributeBooleanValue((Node)pNoeud, (String)DOM_VISIBLE, (boolean)true));
        this.setIntervalle(XmlUtils.getAttributeDoubleValue((Node)pNoeud, (String)DOM_INTERVALLE, (double)1.0));
        this.setNombre(XmlUtils.getAttributeIntValue((Node)pNoeud, (String)DOM_NOMBRE, (int)5));
        this.setCouleur(XmlUtils.getColor((Node)pNoeud));
        this.fRepartition = Repartition.valueOf(XmlUtils.getAttributeStringValue((Node)pNoeud, (String)DOM_REPARTITION, (String)this.fRepartition.name()));
    }

    @Override
    public MinSpaceVerifier getMinSpaceVerifier() {
        return this.fMinSpaceVerifier;
    }

    public void setMinSpaceVerifier(MinSpaceVerifier pMinSpaceVerifier) {
        this.fMinSpaceVerifier = pMinSpaceVerifier;
    }

    protected abstract void dessine(Graphics var1, Axe var2, double[] var3);

    @Override
    public Repartition getRepartition() {
        return this.fRepartition;
    }

    @Override
    public boolean isIntValues() {
        return true;
    }

    @Override
    public boolean isValeursRondes() {
        return false;
    }
}

