/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.CourbeRadar;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Radar;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Serie;
import fr.dbe.graphique.ToileRadar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ToolTipManager;

public class GraphiqueRadar
extends JPanneauGraphique {
    private final Radar radar;
    private final List<String> fLabels;

    public GraphiqueRadar(String pNom, final String[] pLabels, double pStartAngle, double pMin, double pMax, double pMinAxis, double pTic) {
        super(pNom);
        this.fLabels = Arrays.asList(pLabels);
        this.setZoomEnabled(false);
        this.setAdjustEnabled(false);
        this.setCurseur(false);
        this.setPropertiesEnabled(false);
        this.setControleVisible(false);
        this.getDessin().getTitre().setVisible(false);
        this.getDessin().getTitre().setPosY(7);
        this.getDessin().getTitre().setAlignment(GroupLayout.Alignment.LEADING);
        Font f = this.getDessin().getTitre().getFont();
        this.getDessin().getTitre().setFont(new Font(f.getFamily(), f.getStyle(), f.getSize() - 4));
        Repere repere = this.getRepere(0);
        repere.setVisible(false);
        repere.setVisible(false);
        repere.setVisible(false);
        repere.getAxeH().getGraduation().setVisible(false);
        repere.getAxeV().getGraduation().setVisible(false);
        repere.getAxeV().setBornes(0.0, 1.0);
        repere.getAxeH().setCouleur(Color.lightGray);
        repere.getAxeH().setCouleurEtiquette(Color.BLACK);
        repere.getAxeH().setBornes(0.0, 1.0);
        ToileRadar toile = new ToileRadar("Radar chart", pLabels, pStartAngle, pMin, pMax, pMinAxis, pTic);
        repere.ajouteFond(toile);
        this.setLegende(true);
        this.getDessin().getLegende().deplace(600.0, 100.0);
        this.radar = new Radar(toile);
        this.radar.setStroke(new BasicStroke(2.0f));
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        this.getDessin().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(1);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
            }
        });
        this.getDessin().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                double d = 10.0;
                int ix = -1;
                Serie crix = null;
                for (Serie cr : GraphiqueRadar.this.getRepere(0).getDessin().getSeries()) {
                    List<Point2D> points = ((CourbeRadar)cr).getPoints();
                    for (int i = 0; i < points.size(); ++i) {
                        double d2;
                        double dist = points.get(i).distance(e.getPoint());
                        if (!(d2 <= d)) continue;
                        d = dist;
                        ix = i;
                        crix = (CourbeRadar)cr;
                    }
                }
                if (ix >= 0) {
                    String tt = pLabels[ix] + " " + crix.getNom() + " : " + new DecimalFormat("0.###").format(((Courbe)crix).getY(ix));
                    GraphiqueRadar.this.getDessin().setToolTipText(tt);
                }
            }
        });
    }

    @Override
    public void ajouterSerie(int pIndiceRepere, Serie pSerie) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ajouterSeries(int pIndiceRepere, List<? extends Serie> pSeries) {
        throw new UnsupportedOperationException();
    }

    public void setSeries(CourbeRadar[] pCourbesRadar) {
        pCourbesRadar[0].setFirst(true);
        for (CourbeRadar c : pCourbesRadar) {
            super.ajouterSerie(0, c);
            c.setTypeDessin(this.radar);
        }
    }

    @Override
    public void saveValeursSeries(String pNomFic, int iMin, int iMax, List<Serie> series) throws IOException {
        this.getDessin().saveValeursSeries(pNomFic, null, this.fLabels, iMin, iMax, series);
    }
}

