/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.Serie;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Curseur {
    private final boolean fXOR;
    private Serie fSerie;
    private int fIndiceValeur;

    public Curseur(boolean pIsXor) {
        this.fXOR = pIsXor;
    }

    public void dessine(Graphics g, JDessinGraphique d) {
        this.dessine(g, d, !this.fXOR);
    }

    public void dessine(Graphics g, JDessinGraphique d, boolean pRepaint) {
        if (this.fSerie == null || this.fSerie.size() == 0 || this.fIndiceValeur >= this.fSerie.size() || this.fIndiceValeur < 0) {
            return;
        }
        if (pRepaint) {
            d.drawImage();
        } else {
            g.setColor(this.fSerie.getCouleur(this.fIndiceValeur));
            if (this.fXOR) {
                g.setXORMode(d.getBackground());
            }
            double xp = this.fSerie.getRepere().getAxeH().valToPix(this.fSerie.getX(this.fIndiceValeur));
            double yp = (int)this.fSerie.getRepere().getAxeV().valToPix(this.fSerie.getY(this.fIndiceValeur));
            if (Double.isFinite(yp) && xp <= this.fSerie.getRepere().getAxeH().getRepere().getDrawingRectangle().getMaxX() && xp >= this.fSerie.getRepere().getAxeH().getRepere().getDrawingRectangle().getMinX() && yp <= this.fSerie.getRepere().getAxeH().getRepere().getDrawingRectangle().getMaxY() && yp >= this.fSerie.getRepere().getAxeH().getRepere().getDrawingRectangle().getMinY()) {
                g.drawLine((int)xp, 0, (int)xp, d.getHeight());
                g.drawLine(0, (int)yp, d.getWidth(), (int)yp);
                int[] x = new int[3];
                int[] y = new int[3];
                x[0] = (int)xp;
                y[0] = (int)yp;
                x[1] = (int)xp + 4;
                y[1] = (int)yp + 8;
                x[2] = (int)xp - 4;
                y[2] = (int)yp + 8;
                g.fillPolygon(x, y, 3);
            }
            g.setColor(Color.BLACK);
            if (this.fXOR) {
                g.setPaintMode();
            }
        }
    }

    public boolean deplace(int pDelta) {
        int signe = this.fSerie.getRepere().getAxeH().getSens().equals((Object)Sens.DIRECT) ? 1 : -1;
        int ni = this.fIndiceValeur + signe * pDelta;
        if (ni >= 0 && ni < this.fSerie.size()) {
            this.fIndiceValeur += signe * pDelta;
            return true;
        }
        return false;
    }

    public PointGraphique getPointGraphique() {
        if (this.fSerie == null || this.fSerie.size() == 0) {
            return null;
        }
        if (this.fIndiceValeur >= 0 && this.fSerie != null && this.fIndiceValeur < this.fSerie.size()) {
            return this.fSerie.get(this.fIndiceValeur);
        }
        return null;
    }

    public Point getPoint() {
        if (this.getPointGraphique() == null) {
            return null;
        }
        return this.fSerie.getRepere().convertir(this.getPointGraphique());
    }

    public Serie getSerie() {
        return this.fSerie;
    }

    public void setSerie(Serie pSerie) {
        this.fSerie = pSerie;
    }

    public int getIndiceValeur() {
        return this.fIndiceValeur;
    }

    protected void setIndiceValeur(int pIndiceValeur) {
        this.fIndiceValeur = pIndiceValeur;
    }

    public String toString() {
        if (this.getPointGraphique() == null) {
            return "";
        }
        return "x[" + this.getPointGraphique().toStringX() + "]=" + this.fSerie.getRepere().getAxeH().getGraduation().getFormatter().format(this.getPointGraphique().getX()) + ", y=" + this.fSerie.getRepere().getAxeV().getGraduation().getFormatter().formatPrecis(this.getPointGraphique().getY());
    }

    public boolean isXOR() {
        return this.fXOR;
    }
}

