/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.PointCourbe;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.PolyLigne;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Bornes;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.commun.UnmodifiableVector;
import fr.dbe.util.commun.Vecteur;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Courbe
extends Serie {
    protected Vecteur fY;
    private double fDx;
    private boolean fEffacable = true;
    private ITypeDessin fTypeDessin;

    public Courbe(String nom, double pXMin, double pDX) {
        super(nom);
        this.fDx = pDX;
        if (pDX < 0.0) {
            throw new IllegalArgumentException(Messages.getString("Courbe.0") + pDX + ").");
        }
        this.xMin = pXMin;
        this.fY = new Vecteur(1000, 1000);
        this.fTypeDessin = new PolyLigne();
    }

    public boolean isEffacable() {
        return this.fEffacable;
    }

    public void setEffacable(boolean effacable) {
        this.fEffacable = effacable;
    }

    public void setValue(int indice, double valY) {
        if (indice == 0) {
            this.yMin = Double.POSITIVE_INFINITY;
            this.yMax = Double.NEGATIVE_INFINITY;
        }
        if (indice == this.fY.size()) {
            this.fY.ajouter(valY);
        } else if (indice > this.fY.size()) {
            for (int i = this.fY.size(); i < indice; ++i) {
                this.fY.ajouter(Double.NaN);
            }
            this.fY.ajouter(valY);
        } else if (indice < this.fY.size()) {
            this.fY.set(indice, valY);
        }
        this.xMax = this.fDx * (double)(this.fY.size() - 1) + this.xMin;
        if (!Double.isNaN(valY)) {
            this.yMin = Math.min(this.yMin, valY);
            this.yMax = Math.max(this.yMax, valY);
        }
    }

    public void setValuesDirect(Vecteur v) {
        this.fY = v;
        this.xMax = this.fDx * (double)(this.fY.size() - 1) + this.xMin;
        this.majMinMaxY();
    }

    public void setValuesDirect(double[] d) {
        this.setValuesDirect((Vecteur)new UnmodifiableVector(d));
    }

    public void setValue(int indice, double valY, Graphics g) {
        this.setValue(indice, valY);
        if (this.size() > 1 && this.fRepere != null) {
            double x0 = this.fRepere.getAxeH().valToPix(this.getX(this.size() - 2));
            double y0 = this.fRepere.getAxeV().valToPix(this.getY(this.size() - 2));
            double x1 = this.fRepere.getAxeH().valToPix(this.getX(this.size() - 1));
            double y1 = this.fRepere.getAxeV().valToPix(this.getY(this.size() - 1));
            if (Double.isFinite(y1) && Double.isFinite(y0)) {
                g.setColor(this.fCouleur);
                g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
            }
        }
    }

    @Override
    public void dessine(Graphics g, double pXMin, double pXMax, int pPasAffichage) {
        if (!this.isVisible() || this.fRepere == null || this.size() == 0) {
            return;
        }
        try {
            this.fTypeDessin.dessine(this, g, pXMin, pXMax, pPasAffichage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.fY.size();
    }

    @Override
    public double getX(int indice) {
        return this.fDx * (double)indice + this.getXMin();
    }

    public int getIndicePourX(double pX) {
        return (int)((pX - this.getXMin()) / this.fDx);
    }

    @Override
    public double getY(int indice) {
        return this.fY.get(indice);
    }

    @Override
    public void remove(int indice) {
        this.fY.supprime(indice);
        this.majMinMaxY();
    }

    @Override
    public void clear() {
        if (this.fEffacable) {
            this.fY.clear();
            this.xMax = this.xMin;
            this.yMin = Double.POSITIVE_INFINITY;
            this.yMax = Double.NEGATIVE_INFINITY;
        }
    }

    public void clearDirect() {
        this.setValuesDirect(new double[0]);
    }

    public double getDx() {
        return this.fDx;
    }

    public void setDx(double dx) {
        if (this.fDx != dx) {
            boolean tmp = this.fEffacable;
            this.setEffacable(true);
            this.clear();
            this.setEffacable(tmp);
            this.fDx = dx;
        }
    }

    public void removeFirst() {
        boolean kBornes = this.yMin == this.fY.get(0) || this.yMax == this.fY.get(0);
        this.fY.supprime(0);
        this.xMin += 1.0;
        this.xMax += 1.0;
        if (kBornes) {
            this.yMin = Double.POSITIVE_INFINITY;
            this.yMax = Double.NEGATIVE_INFINITY;
            for (int i = this.fY.size() - 1; i >= 0; --i) {
                double valY = this.fY.get(i);
                if (Double.isNaN(valY)) continue;
                this.yMin = Math.min(this.yMin, valY);
                this.yMax = Math.max(this.yMax, valY);
            }
        }
    }

    public void setXMin(double pMin) {
        this.xMin = pMin;
        this.xMax = this.fDx * (double)(this.fY.size() - 1) + this.xMin;
    }

    public int getIndiceGauche(Point p) {
        if (p == null) {
            return -1;
        }
        if (this.size() < 2) {
            return -1;
        }
        double x0 = this.getX(0);
        double deltaX = this.fRepere.getAxeH().pixToVal(p.x) - x0;
        if (deltaX < 0.0) {
            deltaX = 0.0;
        }
        return (int)Math.max(Math.min(deltaX / this.fDx, (double)(this.size() - 1)), 0.0);
    }

    @Override
    public int getIndice(Point p) {
        if (p == null) {
            return -1;
        }
        if (this.size() < 2) {
            return -1;
        }
        double x0 = this.getX(0);
        double deltaX = this.fRepere.getAxeH().pixToVal(p.x) - x0;
        if (deltaX < 0.0) {
            deltaX = 0.0;
        }
        return (int)Math.max(Math.min(deltaX / this.fDx + 0.5, (double)(this.size() - 1)), 0.0);
    }

    @Override
    public PointGraphique get(int pIndice) {
        return new PointCourbe(this.getX(pIndice), this.getY(pIndice));
    }

    @Override
    public double distance(Point pPoint) {
        int ig = this.getIndiceGauche(pPoint);
        if (ig == -1) {
            return Double.POSITIVE_INFINITY;
        }
        int id = ig + 1;
        if (id >= this.size()) {
            return Math.sqrt(Math.pow(this.fRepere.getAxeV().valToPix(this.getY(ig)) - pPoint.getY(), 2.0) + Math.pow(this.fRepere.getAxeH().valToPix(this.getX(ig)) - pPoint.getX(), 2.0));
        }
        double xg = this.fRepere.getAxeH().valToPix(this.getX(ig));
        double xd = this.fRepere.getAxeH().valToPix(this.getX(id));
        double x = pPoint.x;
        double yg = this.fRepere.getAxeV().valToPix(this.getY(ig));
        double yd = this.fRepere.getAxeV().valToPix(this.getY(id));
        double y = pPoint.y;
        double a = Math.sqrt(Math.pow(xg - xd, 2.0) + Math.pow(yg - yd, 2.0));
        double b = Math.sqrt(Math.pow(xd - x, 2.0) + Math.pow(yd - y, 2.0));
        double c = Math.sqrt(Math.pow(xg - x, 2.0) + Math.pow(yg - y, 2.0));
        double p = 0.5 * (a + b + c);
        return 2.0 * Math.sqrt(p * (p - a) * (p - b) * (p - c)) / a;
    }

    public Vecteur getValues() {
        return this.fY;
    }

    public void setValues(Vecteur v) {
        if (v == null) {
            this.fY = new Vecteur(1, 1);
        } else {
            this.fY = new Vecteur(v.size() + 1, 100);
            this.fY.ajouter(v);
        }
        this.xMax = this.fDx * (double)(this.fY.size() - 1) + this.xMin;
        this.majMinMaxY();
    }

    public ITypeDessin getTypeDessin() {
        return this.fTypeDessin;
    }

    public void setTypeDessin(ITypeDessin pTypeDessin) {
        this.fTypeDessin = pTypeDessin;
    }

    public void ajoute(double valY) {
        this.fY.ajouter(valY);
        this.xMax = this.fDx * (double)(this.fY.size() - 1) + this.xMin;
        if (!Double.isNaN(valY)) {
            this.yMin = Math.min(this.yMin, valY);
            this.yMax = Math.max(this.yMax, valY);
        }
    }

    public void recopie(Courbe pCourbe) {
        this.xMax = pCourbe.xMax;
        this.xMin = pCourbe.xMin;
        this.fDx = pCourbe.fDx;
        this.yMax = pCourbe.yMax;
        this.yMin = pCourbe.yMin;
        this.fNom = pCourbe.fNom;
        this.fTypeDessin = pCourbe.fTypeDessin;
        this.fY = new Vecteur(pCourbe.fY.toArray());
    }

    public void decalerPlageAffichage(int pI) {
    }

    @Override
    public Bornes bornesY(double pXMin, double pXMax) {
        if (this.size() == 0) {
            return null;
        }
        int iMin = Math.max(0, (int)Math.floor((pXMin - this.getXMin()) / this.fDx));
        int iMax = Math.min(this.size() - 1, (int)Math.ceil((pXMax - this.getXMin()) / this.fDx));
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = iMin; i <= iMax; ++i) {
            double y = this.getY(i);
            if (y < min) {
                min = y;
            }
            if (!(y > max)) continue;
            max = y;
        }
        return new Bornes(min, max);
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pX, int pY, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getCouleur());
        pGraphics2d.setStroke(this.getTypeDessin().getStroke());
        for (int y = pY - 2; y <= pY + 2; ++y) {
            pGraphics2d.drawLine(pX, y + pHeight / 2, pX + pWidth, y + pHeight / 2);
        }
    }

    @Override
    public Element getDomElement(Document pDoc) {
        Element elt = super.getDomElement(pDoc);
        elt.appendChild(this.fTypeDessin.getDomElement(pDoc));
        return elt;
    }

    @Override
    public void setProperties(Node pNoeud) {
        super.setProperties(pNoeud);
        Node n = XmlUtils.getFils((Node)pNoeud, (String)MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        if (n != null) {
            this.fTypeDessin.setProperties(n);
        } else {
            Log.getInstance().warn(Messages.getString("Courbe.2") + MapXmlGraph.getInstance().getNomElement(ITypeDessin.class) + Messages.getString("Repere.3"));
        }
    }

    @Override
    public Plage plageFor(double pXMin, double pXMax) {
        int i0 = Math.max(0, (int)((pXMin - this.getXMin()) / this.getDx()) - 1);
        int i1 = Math.min(this.size(), (int)((pXMax - this.getXMin()) / this.getDx()) + 2);
        if (this.getConfigPlage() != null) {
            Plage p = this.getConfigPlage().getPlage();
            i0 = Math.max(i0, p.getIndiceMin());
            i1 = Math.min(i1, p.getIndiceMax());
        }
        return new Plage(i0, i1);
    }

    @Override
    public double getXMaxAff() {
        return this.getXMax() + (double)this.fTypeDessin.getDXMaxAff() * this.fDx;
    }

    @Override
    public double getXMinAff() {
        return this.getXMin() + (double)this.fTypeDessin.getDXMinAff() * this.fDx;
    }

    @Override
    public void setHighlighted(boolean pState) {
        if (pState != this.isHighlighted()) {
            super.setHighlighted(pState);
            BasicStroke stroke = (BasicStroke)this.getTypeDessin().getStroke();
            float lineWidth = pState ? stroke.getLineWidth() + 1.0f : stroke.getLineWidth() - 1.0f;
            this.getTypeDessin().setStroke(new BasicStroke(lineWidth, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase()));
        }
    }
}

