/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.BoxRepere;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.Messages;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.JButtonColorWithLib;
import fr.dbe.util.ihm.JTextFieldWithLabel;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;

class BoxGeneral
extends BoxAssistant {
    public static final int TAILLE_LIBELLE = 120;
    public static final int TAILLE_SAISIE = 150;
    private final JCheckBox fCbOrthonorme = Utils.createCheckBox((String)Messages.getString("BoxGeneral.10"));
    private final List<BoxRepere> fListBoxRepere;
    protected JTextFieldWithLabel fSleGauche = new JTextFieldWithLabel(Messages.getString("BoxGeneral.0"), 120, "20", 150, null);
    protected JTextFieldWithLabel fSleDroite = new JTextFieldWithLabel(Messages.getString("BoxGeneral.2"), 120, "20", 150, null);
    protected JTextFieldWithLabel fSleHaut = new JTextFieldWithLabel(Messages.getString("BoxGeneral.4"), 120, "20", 150, null);
    protected JTextFieldWithLabel fSleBas = new JTextFieldWithLabel(Messages.getString("BoxGeneral.6"), 120, "20", 150, null);
    protected JSlider fSlider = new JSlider(0, 10, 100, 100);
    protected JButtonColorWithLib fBtCouleurFond = new JButtonColorWithLib(120, Messages.getString("BoxGeneral.8"));
    protected JButtonColorWithLib fBtCouleurBord = new JButtonColorWithLib(120, Messages.getString("BoxGeneral.11"));
    protected JButtonColorWithLib fBtCouleurGraphique = new JButtonColorWithLib(120, Messages.getString("BoxGeneral.12"));
    private JDessinGraphique fDessin;

    public BoxGeneral(JAssistant pAssistant, JDessinGraphique pDessin, List<BoxRepere> pListBoxRepere) {
        super(pAssistant, 1);
        this.fListBoxRepere = pListBoxRepere;
        this.add(Utils.createVerticalBox((int)5, (Component[])new Component[]{Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fCbOrthonorme}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fBtCouleurFond}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fBtCouleurBord}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fBtCouleurGraphique}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fSleGauche}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fSleDroite}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fSleHaut}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fSleBas}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxGeneral.9"), (int)120), this.fSlider})}));
        this.fSlider.setOpaque(false);
        this.fSlider.setPreferredSize(new Dimension(150, 40));
        this.fSlider.setMaximumSize(this.fSlider.getPreferredSize());
        this.fSlider.setMinimumSize(this.fSlider.getPreferredSize());
        this.fSlider.setMajorTickSpacing(90);
        this.fSlider.setMinorTickSpacing(10);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(10, Utils.createLabel((String)"10"));
        labelTable.put(50, Utils.createLabel((String)"50"));
        labelTable.put(100, Utils.createLabel((String)"100"));
        this.fSlider.setLabelTable(labelTable);
        this.fSlider.setPaintTicks(true);
        this.fSlider.setPaintLabels(true);
        this.fSlider.addChangeListener(pChangeEvent -> {
            this.fDessin.setTauxAjustementV(this.fSlider.getValue());
            for (BoxRepere br : this.fListBoxRepere) {
                br.maj();
            }
        });
        this.addValidationFor(this.fSleHaut);
        this.addValidationFor(this.fSleBas);
        this.addValidationFor(this.fSleDroite);
        this.addValidationFor(this.fSleGauche);
        this.setDessin(pDessin);
    }

    public JDessinGraphique getDessin() {
        return this.fDessin;
    }

    public void setDessin(JDessinGraphique pDessin) {
        this.fDessin = pDessin;
        this.fSleGauche.setText("" + (int)this.fDessin.getMarges().getGauche());
        this.fSleDroite.setText("" + (int)this.fDessin.getMarges().getDroite());
        this.fSleHaut.setText("" + (int)this.fDessin.getMarges().getHaut());
        this.fSleBas.setText("" + (int)this.fDessin.getMarges().getBas());
        this.fBtCouleurFond.setCouleur(pDessin.getBackground());
        this.fBtCouleurBord.setCouleur(pDessin.getBorderColor());
        this.fBtCouleurGraphique.setCouleur(pDessin.getChartBackgroundColor());
        this.fSlider.setValue(pDessin.getTauxAjustementV());
        this.fCbOrthonorme.setSelected(this.fDessin.isOrthonorme());
    }

    public void majbtOk() {
        try {
            int h = Utilitaire.parseInt((String)this.fSleGauche.getText());
            if (h < 0 || h > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.17"));
                this.fSleGauche.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.18"));
            this.fSleGauche.setForeground(Color.RED);
        }
        try {
            int v = Utilitaire.parseInt((String)this.fSleDroite.getText());
            if (v < 0 || v > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.19"));
                this.fSleDroite.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.20"));
            this.fSleDroite.setForeground(Color.RED);
        }
        try {
            int v = Utilitaire.parseInt((String)this.fSleHaut.getText());
            if (v < 0 || v > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.21"));
                this.fSleHaut.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.22"));
            this.fSleHaut.setForeground(Color.RED);
        }
        try {
            int v = Utilitaire.parseInt((String)this.fSleBas.getText());
            if (v < 0 || v > 1000) {
                this.fAssistant.error(Messages.getString("BoxGeneral.23"));
                this.fSleBas.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxGeneral.24"));
            this.fSleBas.setForeground(Color.RED);
        }
    }

    public void doOk() {
        this.fDessin.setMarges(new Marges(Utilitaire.parseInt((String)this.fSleHaut.getText()), Utilitaire.parseInt((String)this.fSleDroite.getText()), Utilitaire.parseInt((String)this.fSleBas.getText()), Utilitaire.parseInt((String)this.fSleGauche.getText())));
        this.fDessin.setBackground(this.fBtCouleurFond.getCouleur());
        this.fDessin.setBorderColor(this.fBtCouleurBord.getCouleur());
        this.fDessin.setChartBackgroundColor(this.fBtCouleurGraphique.getCouleur());
        this.fDessin.setTauxAjustementV(this.fSlider.getValue());
        this.fDessin.setOrthonorme(this.fCbOrthonorme.isSelected());
    }
}

