/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.utils;

import fr.dbe.graphique.Serie;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParamsOut;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import fr.geonosis.karstmod.run.RunMonitor;
import fr.geonosis.karstmod.run.model.RunModel;
import fr.geonosis.karstmod.run.routine.SubcatchmentTable;
import fr.geonosis.karstmod.utils.csv.CSVWriter;
import fr.geonosis.karstmod.utils.csv.DefaultOutputColumn;
import fr.geonosis.karstmod.utils.csv.IOutputColumn;
import fr.geonosis.karstmod.viewfx.KarstMod;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.ReadOnlyListProperty;

public class ModelOutput {
    private final RunMonitor fMonitor;
    private final String fDirectory;
    private final String fPrefixe;
    private final boolean fNonEmptyOnly;
    private final boolean fActiveOnly;

    public ModelOutput(RunMonitor pMonitor, String pDirectory, String pPrefixe, boolean pNonEmptyOnly, boolean pActiveOnly) {
        this.fMonitor = pMonitor;
        this.fDirectory = pDirectory;
        this.fPrefixe = pPrefixe;
        this.fActiveOnly = pActiveOnly;
        this.fNonEmptyOnly = pNonEmptyOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(ModeKarstMod pMode, RunModel pRunModel) throws IOException {
        StringBuilder msg = new StringBuilder();
        Locale currentLocale = Locale.getDefault();
        try {
            Locale.setDefault(KarstMod.ORIGINAL_LOCALE);
            try {
                this.saveParamsOut();
            }
            catch (Exception e) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append(Messages.getString("JRun.54")).append(" : ").append(e.getMessage());
            }
            try {
                this.saveDischargeOut(pRunModel);
                this.saveWaterLevel(pRunModel);
            }
            catch (Exception e) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append(Messages.getString("JRun.52")).append(" : ").append(e.getMessage());
            }
            try {
                this.saveThetaQr(pRunModel);
            }
            catch (Exception e) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append(Messages.getString("JRun.57")).append(" : ").append(e.getMessage());
            }
            try {
                this.saveSubcatchments();
            }
            catch (Exception e) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append(Messages.getString("JRun.58")).append(" : ").append(e.getMessage());
            }
            if (pMode == ModeKarstMod.CALIBRATION) {
                try {
                    this.saveParamsBest();
                }
                catch (Exception e) {
                    if (msg.length() > 0) {
                        msg.append(", ");
                    }
                    msg.append(Messages.getString("JRun.55")).append(" : ").append(e.getMessage());
                }
            }
        }
        finally {
            Locale.setDefault(currentLocale);
        }
        if (msg.length() > 0) {
            throw new IOException(msg.toString());
        }
    }

    public void saveDischargeOut(RunModel pRunModel) throws IOException {
        Model model = this.fMonitor.getConfig().getModel();
        InputData inputData = this.fMonitor.getConfig().getInputData();
        ArrayList<IOutputColumn> columns = new ArrayList<IOutputColumn>();
        String timeUnit = Unit.getInstance().getBase().get(Dimension.TIME);
        this.createFirstColumns(columns, inputData);
        this.addColumnIfNotNull(columns, model.getFluxRainfall().isActive(), String.format("Rainfall (mm/%s)", timeUnit), pRunModel.getPInputValues());
        this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Psr (mm/%s)", timeUnit), pRunModel.getPsrValues());
        if (model.getSnowRoutine().isActive()) {
            if (model.getSnowRoutine().getSubcatchmentTable().isEmpty()) {
                this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), "Snow pack solid component (mm)", pRunModel.getSrSolidValues(0));
                this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), "Snow pack liquid component (mm)", pRunModel.getSrLiquidValues(0));
                this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Snow Melt (mm/%s)", timeUnit), pRunModel.getSrMeltValues(0));
                this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Refreezing water (mm/%s)", timeUnit), pRunModel.getSrRefreezingValues(0));
            } else {
                for (int i = 0; i < model.getSnowRoutine().getSubcatchmentTable().size(); ++i) {
                    double p = 1.0 / this.fMonitor.getConfig().getModel().getSnowRoutine().getSubcatchmentTable().getProportion(i);
                    this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Snow pack solid component [%d] (mm)", i + 1), pRunModel.getSrSolidValues(i), p);
                    this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Snow pack liquid component [%d] (mm)", i + 1), pRunModel.getSrLiquidValues(i), p);
                    this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Snow Melt [%d] (mm/%s)", i + 1, timeUnit), pRunModel.getSrMeltValues(i), p);
                    this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Refreezing water [%d] (mm/%s)", i + 1, timeUnit), pRunModel.getSrRefreezingValues(i), p);
                }
            }
        }
        this.addColumnIfNotNull(columns, model.getFluxET().isActive() || model.getPetRoutine().isActive(), String.format("ET (m/%s)", timeUnit), pRunModel.getETInputValues());
        this.addColumnIfNotNull(columns, model.getPetRoutine().isActive(), String.format("PET Oudin (mm/%s)", timeUnit), pRunModel.getPETValues());
        this.addColumnIfNotNull(columns, model.getFluxET().isActive() || model.getPetRoutine().isActive(), String.format("ET effective (mm/%s)", timeUnit), pRunModel.getETEffValues());
        this.addColumnIfNotNull(columns, true, "Observed discharge (m3/s)", pRunModel.getQobsValues());
        this.addColumnIfNotNull(columns, true, "Simulated discharge (m3/s)", pRunModel.getQSValues());
        if (this.fMonitor.getProbableDischarge() != null) {
            this.addColumnIfNotNull(columns, false, "Qprob (m3/s))", this.fMonitor.getProbableDischarge().values());
            this.addColumnIfNotNull(columns, false, "Probable discharge (m3/s)", this.fMonitor.getProbableDischarge().values());
            this.addColumnIfNotNull(columns, false, "Min simulated discharge (m3/s)", this.fMonitor.getProbableDischarge().getMinValues());
            this.addColumnIfNotNull(columns, false, "Max simulated discharge (m3/s)", this.fMonitor.getProbableDischarge().getMaxValues());
        }
        if (this.fMonitor.getConfidenceInterval(Varname.QS) != null) {
            this.addColumnIfNotNull(columns, false, "Discharge confidence interval low (m3/s)", this.fMonitor.getConfidenceInterval(Varname.QS).getBas());
            this.addColumnIfNotNull(columns, false, "Discharge confidence interval high (m3/s)", this.fMonitor.getConfidenceInterval(Varname.QS).getHaut());
        }
        this.addColumnIfNotNull(columns, false, "Temperature (\u00b0C)", this.fMonitor.getConfig().getInputData().getValues(ColumnName.T));
        this.addColumnIfNotNull(columns, false, "clear-sky solar radiation (W/m\u00b2)", this.fMonitor.getConfig().getInputData().getValues(ColumnName.SRAD));
        this.addColumnIfNotNull(columns, model.getQEL().isActive(), "QEL (m3/s)", pRunModel.getQELValues());
        this.addColumnIfNotNull(columns, model.getQEM().isActive(), "QEM (m3/s)", pRunModel.getQEMValues());
        this.addColumnIfNotNull(columns, model.getQEC().isActive() || model.getQrE().isActive(), "QEC (m3/s)", pRunModel.getQECValues());
        this.addColumnIfNotNull(columns, model.getQE().isActive(), "QE (m3/s)", pRunModel.getQEValues());
        this.addColumnIfNotNull(columns, model.getQES().isActive(), "QES (m3/s)", pRunModel.getQESValues());
        this.addColumnIfNotNull(columns, model.getQhyEC().isActive(), "QhyEC (m3/s)", pRunModel.getQhyECValues());
        this.addColumnIfNotNull(columns, model.getQhyES().isActive(), "QhyES (m3/s)", pRunModel.getQhyESValues());
        this.addColumnIfNotNull(columns, model.getQLS().isActive(), "QLS (m3/s)", pRunModel.getQLSValues());
        this.addColumnIfNotNull(columns, model.getQMS().isActive(), "QMS (m3/s)", pRunModel.getQMSValues());
        this.addColumnIfNotNull(columns, model.getQMC().isActive(), "QMC (m3/s)", pRunModel.getQMCValues());
        this.addColumnIfNotNull(columns, model.getQCS().isActive(), "QCS (m3/s)", pRunModel.getQCSValues());
        this.addColumnIfNotNull(columns, model.getQloss().isActive(), "Qloss (m3/s)", pRunModel.getQlossValues());
        if (this.fMonitor.getConfidenceInterval(Varname.QLOSS) != null) {
            this.addColumnIfNotNull(columns, false, "Qloss confidence interval low (m3/s)", this.fMonitor.getConfidenceInterval(Varname.QLOSS).getBas());
            this.addColumnIfNotNull(columns, false, "Qloss confidence interval high (m3/s)", this.fMonitor.getConfidenceInterval(Varname.QLOSS).getHaut());
        }
        this.addColumnIfNotNull(columns, model.getQrE().getParameterTo(model.getLoss()).isActive(), "QrE_loss (m3/s)", pRunModel.getQrElossValues());
        this.addColumnIfNotNull(columns, model.getQbM().isActive(), "QbMS (m3/s)", pRunModel.getQbMValues());
        this.addColumnIfNotNull(columns, model.getQrM().isActive(), "QrMS (m3/s)", pRunModel.getQrMValues());
        this.addColumnIfNotNull(columns, model.getQrM().getParameterTo(model.getLoss()).isActive(), "QrM_loss (m3/s)", pRunModel.getQrMlossValues());
        this.addColumnIfNotNull(columns, model.getQbL().isActive(), "QbLS (m3/s)", pRunModel.getQbLValues());
        this.addColumnIfNotNull(columns, model.getQrL().isActive(), "QrLS (m3/s)", pRunModel.getQrLValues());
        this.addColumnIfNotNull(columns, model.getQrL().getParameterTo(model.getLoss()).isActive(), "QrL_loss (m3/s)", pRunModel.getQrLlossValues());
        this.addColumnIfNotNull(columns, model.getQbC().isActive(), "QbCS (m3/s)", pRunModel.getQbCValues());
        this.addColumnIfNotNull(columns, model.getQrC().isActive(), "QrCS (m3/s)", pRunModel.getQrCValues());
        this.addColumnIfNotNull(columns, model.getQrC().getParameterTo(model.getLoss()).isActive(), "QrC_loss (m3/s)", pRunModel.getQrClossValues());
        this.addColumnIfNotNull(columns, model.getFluxQPumpS().isActive(), "Pumped discharge S (m3/s)", pRunModel.getQPumpSValues());
        this.addColumnIfNotNull(columns, model.getFluxQPumpL().isActive(), "Pumped discharge L (m3/s)", pRunModel.getQPumpLValues());
        this.addColumnIfNotNull(columns, model.getFluxQPumpM().isActive(), "Pumped discharge M (m3/s)", pRunModel.getQPumpMValues());
        this.addColumnIfNotNull(columns, model.getFluxQPumpC().isActive(), "Pumped discharge C (m3/s)", pRunModel.getQPumpCValues());
        CSVWriter.save(this.outputFile("discharge_out"), columns, this.fMonitor.getGlobalStage().getDebut(), this.fMonitor.getGlobalStage().getFin());
    }

    public void saveWaterLevel(RunModel pRunModel) throws IOException {
        Model model = this.fMonitor.getConfig().getModel();
        InputData inputData = this.fMonitor.getConfig().getInputData();
        ArrayList<IOutputColumn> columns = new ArrayList<IOutputColumn>();
        String timeUnit = Unit.getInstance().getBase().get(Dimension.TIME);
        this.createFirstColumns(columns, inputData);
        this.addColumnIfNotNull(columns, model.getFluxRainfall().isActive(), String.format("Rainfall (mm/%s)", timeUnit), pRunModel.getPInputValues());
        this.addColumnIfNotNull(columns, model.getSnowRoutine().isActive(), String.format("Psr (mm/%s)", timeUnit), pRunModel.getPsrValues());
        this.addColumnIfNotNull(columns, model.getFluxET().isActive() || model.getPetRoutine().isActive(), String.format("ET (mm/%s)", timeUnit), pRunModel.getETInputValues());
        this.addColumnIfNotNull(columns, model.getPetRoutine().isActive(), String.format("PET Oudin (mm%s)", timeUnit), pRunModel.getPETValues());
        this.addColumnIfNotNull(columns, model.getReservoirE().isActive(), "Water level in E (mm)", pRunModel.getEValues());
        this.addColumnIfNotNull(columns, model.getReservoirL().isActive(), "Water level in L (mm)", pRunModel.getLValues());
        this.addColumnIfNotNull(columns, model.getReservoirM().isActive(), "Water level in M (mm)", pRunModel.getMValues());
        this.addColumnIfNotNull(columns, model.getReservoirC().isActive(), "Water level in C (mm)", pRunModel.getCValues());
        this.addColumnIfNotNull(columns, model.getReservoirE().getPiezo().isActive(), "Observed piezometry ZE (m)", pRunModel.getHObsZE());
        this.addColumnIfNotNull(columns, model.getReservoirE().getPiezo().isActive(), "Simulated piezometry ZE (m)", pRunModel.getZEValues());
        if (this.fMonitor.getConfidenceInterval(Varname.ZE) != null) {
            this.addColumnIfNotNull(columns, false, "Piezometry ZE confidence interval low (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZE).getBas());
            this.addColumnIfNotNull(columns, false, "Piezometry ZE confidence interval high (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZE).getHaut());
        }
        this.addColumnIfNotNull(columns, model.getReservoirL().getPiezo().isActive(), "Observed piezometry ZL (m)", pRunModel.getHObsZL());
        this.addColumnIfNotNull(columns, model.getReservoirL().getPiezo().isActive(), "Simulated piezometry ZL (m)", pRunModel.getZLValues());
        if (this.fMonitor.getConfidenceInterval(Varname.ZL) != null) {
            this.addColumnIfNotNull(columns, false, "Piezometry ZL confidence interval low (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZL).getBas());
            this.addColumnIfNotNull(columns, false, "Piezometry ZL confidence interval high (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZL).getHaut());
        }
        this.addColumnIfNotNull(columns, model.getReservoirM().getPiezo().isActive(), "Observed piezometry ZM (m)", pRunModel.getHObsZM());
        this.addColumnIfNotNull(columns, model.getReservoirM().getPiezo().isActive(), "Simulated piezometry ZM (m)", pRunModel.getZMValues());
        if (this.fMonitor.getConfidenceInterval(Varname.ZM) != null) {
            this.addColumnIfNotNull(columns, false, "Piezometry ZM confidence interval low (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZM).getBas());
            this.addColumnIfNotNull(columns, false, "Piezometry ZM confidence interval high (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZM).getHaut());
        }
        this.addColumnIfNotNull(columns, model.getReservoirC().getPiezo().isActive(), "Observed piezometry ZC (m)", pRunModel.getHObsZC());
        this.addColumnIfNotNull(columns, model.getReservoirC().getPiezo().isActive(), "Simulated piezometry ZC (m)", pRunModel.getZCValues());
        if (this.fMonitor.getConfidenceInterval(Varname.ZC) != null) {
            this.addColumnIfNotNull(columns, false, "Piezometry ZC confidence interval low (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZC).getBas());
            this.addColumnIfNotNull(columns, false, "Piezometry ZC confidence interval high (m3/s)", this.fMonitor.getConfidenceInterval(Varname.ZC).getHaut());
        }
        CSVWriter.save(this.outputFile("water_level"), columns, this.fMonitor.getGlobalStage().getDebut(), this.fMonitor.getGlobalStage().getFin() + 1);
    }

    public void saveParamsBest() throws IOException {
        ReadOnlyListProperty<Parameter> parameters = this.fMonitor.getConfig().getModel().getActiveParameters();
        try (PrintWriter pw = new PrintWriter(this.outputFile("params_best"), StandardCharsets.UTF_8);){
            for (Parameter pParameter : parameters) {
                String unite = Unit.getInstance().getBase().get(pParameter.getDimension());
                pw.print(pParameter.getLabel() + (String)(unite == null || unite.isBlank() ? "" : " (" + unite.replace('\u00b3', '3').replace('\u00b2', '2') + ")"));
                pw.print(";");
                pw.println(String.format("%g", pParameter.getValue()).replace(',', '.'));
            }
            pw.print(Messages.getString("JRun.25") + ";");
            pw.println(String.format("%g", this.fMonitor.getWobjCalibrationBest().getRes()).replace(',', '.'));
            pw.print(Messages.getString("JRun.27") + ";");
            pw.println(String.format("%g", this.fMonitor.getWobjValidationForCalibrationBest().getRes()).replace(',', '.'));
            pw.flush();
        }
    }

    public void saveThetaQr(RunModel pRunModel) throws IOException {
        if (this.fMonitor.getConfig().getModel().getReservoirM().getConfig(ReservoirConfigType.INFINITE_TC).isActive() || this.fMonitor.getConfig().getModel().getReservoirM().getConfig(ReservoirConfigType.INFINITE_TC).isActive() || this.fMonitor.getConfig().getModel().getReservoirM().getConfig(ReservoirConfigType.INFINITE_TC).isActive() || this.fMonitor.getConfig().getModel().getReservoirM().getConfig(ReservoirConfigType.INFINITE_TC).isActive()) {
            double[] thetaQrE = pRunModel.getThetaQrEValues();
            double[] thetaQrL = pRunModel.getThetaQrLValues();
            double[] thetaQrM = pRunModel.getThetaQrMValues();
            double[] thetaQrC = pRunModel.getThetaQrCValues();
            try (PrintWriter pw = new PrintWriter(this.outputFile("theta_qr"), StandardCharsets.UTF_8);){
                pw.println("thetaQrE;thetaQrL;thetaQrM;thetaQrC");
                for (int i = this.fMonitor.getGlobalStage().getDebut(); i <= this.fMonitor.getGlobalStage().getFin(); ++i) {
                    pw.println(String.format("%g;%g;%g;%g", thetaQrE[i], thetaQrL[i], thetaQrM[i], thetaQrC[i]).replace(',', '.'));
                }
                pw.flush();
            }
        }
    }

    public void saveParamsOut(double pWobjCalibration, double pWobjValidation, RunModel pRunModel) throws IOException {
        try (PrintWriter pw = new PrintWriter(this.outputFile("params_out"), StandardCharsets.UTF_8);){
            pw.printf("%s;%s", Messages.getString("JRun.25"), Messages.getString("JRun.27"));
            Arrays.stream(pRunModel.getActiveParameters()).forEach(param -> pw.printf(";%s", param.columnTitle()));
            pw.print(String.format("%n%g;%g", pWobjCalibration, pWobjValidation).replace(',', '.'));
            Arrays.stream(pRunModel.activeParamValues()).forEach(v -> pw.printf(";%s", ModelOutput.formatValue(v).replace(',', '.')));
            pw.flush();
        }
    }

    public void saveParamsOut() throws IOException {
        try (PrintWriter pw = new PrintWriter(this.outputFile("params_out"), StandardCharsets.UTF_8);){
            pw.printf("%s;%s", Messages.getString("JRun.25"), Messages.getString("JRun.27"));
            Arrays.stream(this.fMonitor.getParamsOutArray().getParameters()).forEach(param -> pw.printf(";%s", param.columnTitle()));
            pw.println();
            ParamsOut[] pos = this.fMonitor.getParamsOutArray().getParamsOut();
            for (int i = 0; i < Math.max(1, this.fMonitor.getParamsOutArray().getNbValues()); ++i) {
                ParamsOut po = pos[i];
                pw.print(String.format("%g;%g", po.getWobjCalibration(), po.getWobjValidation()).replace(',', '.'));
                for (int j = 0; j < this.fMonitor.getParamsOutArray().getParameters().length; ++j) {
                    double x = po.getParamValues()[j];
                    pw.print(";");
                    pw.print(ModelOutput.formatValue(x).replace(',', '.'));
                }
                pw.println();
            }
            pw.flush();
        }
    }

    public void saveSubcatchments() throws IOException {
        if (this.fMonitor.getConfig().getModel().getSnowRoutine().isActive() && this.fMonitor.getConfig().getModel().getSnowRoutine().getSubcatchmentTable().size() > 0) {
            SubcatchmentTable table = this.fMonitor.getConfig().getModel().getSnowRoutine().getSubcatchmentTable();
            try (PrintWriter pw = new PrintWriter(this.outputFile("subcatchments_out"), StandardCharsets.UTF_8);){
                pw.println("id\tproportion\ttemp_shift");
                for (int i = 0; i < table.size(); ++i) {
                    pw.println(String.format("%d\t%g\t%g", i + 1, table.getProportion(i), table.getTempShift(i)).replace(',', '.'));
                }
                pw.flush();
            }
        }
    }

    private void createFirstColumns(List<IOutputColumn> columns, InputData inputData) {
        if (inputData.getDateLabels() != null && inputData.getDateLabels().length > 0) {
            columns.add(new DefaultOutputColumn("time (" + Unit.getInstance().getBase().get(Dimension.TIME) + ")", inputData.getDateLabels().length, i -> inputData.getDateLabels()[i]));
        }
        if (!ModelOutput.isBlank(inputData.getLabels())) {
            columns.add(new DefaultOutputColumn("Labels", inputData.getLabels().size(), i -> inputData.getLabels().get((int)i)));
        }
    }

    public static boolean isBlank(List<String> pList) {
        if (pList == null || pList.isEmpty()) {
            return true;
        }
        for (String s : pList) {
            if (s == null || s.isBlank()) continue;
            return false;
        }
        return true;
    }

    public IOutputColumn createColumn(boolean pNonEmptyOnly, String pTitle, double[] pData) {
        return this.createColumn(pNonEmptyOnly, pTitle, pData, 1.0);
    }

    public IOutputColumn createColumn(boolean pNonEmptyOnly, String pTitle, double[] pData, double pCoeff) {
        if (pNonEmptyOnly) {
            if (pData == null || pData.length == 0) {
                return null;
            }
            boolean empty = true;
            int max = Math.max(pData.length - 1, this.fMonitor.getGlobalStage().getFin());
            for (int i2 = this.fMonitor.getGlobalStage().getDebut(); i2 <= max; ++i2) {
                double d = pData[i2];
                if (Double.isNaN(d) || d == 0.0) continue;
                empty = false;
                break;
            }
            if (empty) {
                return null;
            }
        }
        if (pData == null) {
            pData = new double[]{};
        }
        double[] finalPData = pData;
        return new DefaultOutputColumn(pTitle, pData.length, i -> ModelOutput.formatValue(finalPData[i] * pCoeff));
    }

    public static String formatValue(Serie pSerie, Integer pIndex) {
        return ModelOutput.formatValue(pSerie.getY(pIndex));
    }

    public static String formatValue(double pValue) {
        return String.format("%g", pValue).replace(',', '.');
    }

    private void addColumnIfNotNull(List<IOutputColumn> columns, boolean active, String pTitle, double[] pData) {
        this.addColumnIfNotNull(columns, active, pTitle, pData, 1.0);
    }

    private void addColumnIfNotNull(List<IOutputColumn> columns, boolean active, String pTitle, double[] pData, double pCoeff) {
        IOutputColumn column = this.createColumn(this.fNonEmptyOnly, pTitle, pData, pCoeff);
        if (column != null && (active || !this.fActiveOnly)) {
            columns.add(column);
        }
    }

    private String outputFile(String pName) {
        return new File(this.fDirectory, (String)(this.fPrefixe == null ? "" : this.fPrefixe + "_") + pName + ".csv").getAbsolutePath();
    }
}

