/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import fr.geonosis.karstmod.modele.IFlowGroupElement;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.draw.AbstractElementGroup;
import fr.geonosis.karstmod.viewfx.draw.ArrowGroup;
import fr.geonosis.karstmod.viewfx.draw.FlowPathElement;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Point2D;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

public class FlowGroup
extends AbstractElementGroup<IFlowGroupElement>
implements Observable {
    private final Path fPath;
    private final ArrowGroup fArrow;
    private final HtmlTextBox fLabelBox;
    private final List<InvalidationListener> fListeners = new ArrayList<InvalidationListener>();
    private Point2D fDefaultLabelLocation;
    private double fStartX;
    private double fStartY;
    private double fEndX;
    private double fEndY;

    public FlowGroup(IFlowGroupElement pElt, Paint pColor, Double ... pPoints) {
        this(pElt, pColor, true, pPoints);
    }

    public FlowGroup(IFlowGroupElement pElt, Paint pColor, FlowPathElement ... pElements) {
        this(pElt, pColor, true, pElements);
    }

    public FlowGroup(IFlowGroupElement pElt, StringProperty pHtmlLabelProperty, Paint pColor, Double ... pPoints) {
        this(pElt, pHtmlLabelProperty, pColor, true, true, pPoints);
    }

    public FlowGroup(IFlowGroupElement pElt, Paint pColor, boolean pArrow, Double ... pPoints) {
        this(pElt, pElt.htmlLabelProperty(), pColor, pArrow, true, pPoints);
    }

    public FlowGroup(IFlowGroupElement pElt, Paint pColor, boolean pArrow, FlowPathElement ... pElements) {
        this(pElt, pElt.htmlLabelProperty(), pColor, pArrow, true, pElements);
    }

    public FlowGroup(IFlowGroupElement pElt, Paint pColor, boolean pArrow, boolean pHideable, Double ... pPoints) {
        this(pElt, pElt.htmlLabelProperty(), pColor, pArrow, pHideable, pPoints);
    }

    private FlowGroup(IFlowGroupElement pElt, StringProperty pHtmlLabelProperty, Paint pColor, boolean pArrow, boolean pHideable) {
        super(pElt, pHideable);
        if (pArrow) {
            this.fArrow = new ArrowGroup(pColor);
            this.getChildren().add((Object)this.fArrow);
        } else {
            this.fArrow = null;
        }
        this.fPath = new Path();
        this.fPath.setStrokeWidth(2.5);
        this.fPath.setStroke(pColor);
        this.getChildren().add((Object)this.fPath);
        this.fLabelBox = new HtmlTextBox((String)pHtmlLabelProperty.get(), StylesV2.FONT_FLOW_LABEL);
        this.fLabelBox.setTextColor(pColor);
        this.fLabelBox.setStyle("-fx-background-color: -fx-background");
        this.getChildren().add((Object)this.fLabelBox);
        ChangeListener activeListener = (pObservable, pOldValue, pNewValue) -> {
            this.setOpacity(pNewValue != false ? 1.0 : 0.2);
            if (this.getElt() instanceof Parameter) {
                if (pNewValue.booleanValue()) {
                    this.fPath.setStrokeWidth(2.5);
                    this.fPath.getStrokeDashArray().clear();
                } else {
                    this.fPath.setStrokeWidth(1.0);
                    this.fPath.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 5.0});
                    this.setOpacity(0.13333333333333333);
                }
            }
        };
        pElt.activeProperty().addListener(activeListener);
        activeListener.changed(null, null, (Object)pElt.isActive());
    }

    public FlowGroup(IFlowGroupElement pElt, StringProperty pHtmlLabelProperty, Paint pColor, boolean pArrow, boolean pHideable, Double ... pPoints) {
        this(pElt, pHtmlLabelProperty, pColor, pArrow, pHideable);
        this.setPoints(pPoints);
        this.setLabelTranslation(0.0, 0.0);
    }

    public FlowGroup(IFlowGroupElement pElt, StringProperty pHtmlLabelProperty, Paint pColor, boolean pArrow, boolean pHideable, FlowPathElement ... pElements) {
        this(pElt, pHtmlLabelProperty, pColor, pArrow, pHideable);
        this.setElements(pElements);
        this.setLabelTranslation(0.0, 0.0);
    }

    public void setElements(FlowPathElement ... pElements) {
        this.fStartX = pElements[0].x();
        this.fStartY = pElements[1].y();
        int nbPoints = pElements.length;
        if (this.fArrow != null) {
            FlowPathElement lt1 = pElements[pElements.length - 2];
            FlowPathElement lt2 = pElements[pElements.length - 1];
            this.fArrow.setLine(lt1.x(), lt1.y(), lt2.x(), lt2.y());
            this.fPath.getElements().clear();
            for (int i = 0; i < nbPoints - 1; ++i) {
                this.fPath.getElements().addAll((Object[])new PathElement[]{pElements[i].element()});
            }
            this.fEndX = this.fArrow.getEndX();
            this.fEndY = this.fArrow.getEndY();
            this.fPath.getElements().add((Object)new LineTo(this.fArrow.getStartX(), this.fArrow.getStartY()));
        } else {
            FlowPathElement lastElt = pElements[nbPoints - 1];
            this.fEndX = lastElt.x();
            this.fEndY = lastElt.y();
            this.fPath.getElements().clear();
            for (FlowPathElement elt : pElements) {
                this.fPath.getElements().addAll((Object[])new PathElement[]{elt.element()});
            }
        }
        FlowPathElement beforeLastElt = pElements[nbPoints - 2];
        this.fDefaultLabelLocation = new Point2D((beforeLastElt.x() + this.fArrow.getStartX()) / 2.0, (beforeLastElt.y() + this.fArrow.getStartY()) / 2.0);
        this.fireChanged();
    }

    public void setPoints(Double ... pPoints) {
        this.fStartX = pPoints[0];
        this.fStartY = pPoints[1];
        int nbPoints = pPoints.length;
        if (this.fArrow != null) {
            this.fArrow.setLine(pPoints[nbPoints - 4], pPoints[nbPoints - 3], pPoints[nbPoints - 2], pPoints[nbPoints - 1]);
            Double[] pts = (Double[])pPoints.clone();
            this.fEndX = this.fArrow.getEndX();
            this.fEndY = this.fArrow.getEndY();
            pts[nbPoints - 2] = this.fArrow.getStartX();
            pts[nbPoints - 1] = this.fArrow.getStartY();
            this.createPath(pts);
        } else {
            this.fEndX = pPoints[nbPoints - 2];
            this.fEndY = pPoints[nbPoints - 1];
            this.createPath(pPoints);
        }
        this.fireChanged();
    }

    private void createPath(Double[] pPts) {
        this.fPath.getElements().clear();
        this.fPath.getElements().add((Object)new MoveTo(pPts[0].doubleValue(), pPts[1].doubleValue()));
        int i = 2;
        while (i + 1 < pPts.length) {
            this.fPath.getElements().add((Object)new LineTo(pPts[i].doubleValue(), pPts[i + 1].doubleValue()));
            i += 2;
        }
        int n = pPts.length;
        this.fDefaultLabelLocation = new Point2D((pPts[n - 4] + pPts[n - 2]) / 2.0, (pPts[n - 3] + pPts[n - 1]) / 2.0);
    }

    public void setLabelLocation(double pX, double pY) {
        double xLabel = pX - this.fLabelBox.getComputedWidth() / 2.0;
        double yLabel = pY - this.fLabelBox.getComputedHeight() / 2.0;
        this.fLabelBox.setTranslateX(xLabel);
        this.fLabelBox.setTranslateY(yLabel);
    }

    public void setLabelTranslation(double pDx, double pDy) {
        this.setLabelLocation(this.fDefaultLabelLocation.getX() + pDx, this.fDefaultLabelLocation.getY() + pDy);
    }

    public void setPaint(Paint pPaint) {
        this.fPath.setStroke(pPaint);
        this.fLabelBox.setTextColor(pPaint);
        if (this.fArrow != null) {
            this.fArrow.setPaint(pPaint);
        }
    }

    public double startX() {
        return this.fStartX;
    }

    public double endX() {
        return this.fEndX;
    }

    public double startY() {
        return this.fStartY;
    }

    public double endY() {
        return this.fEndY;
    }

    public void setLabelTranslateY(double pTy) {
        this.fLabelBox.setTranslateY(pTy);
    }

    public double getLabelTranslateY() {
        return this.fLabelBox.getTranslateY();
    }

    public void addLabelTranslateY(int pTranslateY) {
        this.fLabelBox.setTranslateY(this.fLabelBox.getTranslateY() + (double)pTranslateY);
    }

    public void addLabelTranslateX(int pTranslateX) {
        this.fLabelBox.setTranslateX(this.fLabelBox.getTranslateX() + (double)pTranslateX);
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    private void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }
}

