/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.dbe.graphique.Activable;
import fr.dbe.graphique.Busyable;
import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.CourbeConstante;
import fr.dbe.graphique.Histogramme;
import fr.dbe.graphique.PolyLigne;
import fr.dbe.graphique.PolyLigneCreneau;
import fr.dbe.graphique.PositionBarreHistogramme;
import fr.dbe.graphique.Surface;
import fr.dbe.graphique.formatter.LabelFormatter;
import fr.dbe.util.commun.ColorUtils;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.ihm.SharedFrame;
import fr.dbe.util.ihm.customdialog.CustomDialog;
import fr.dbe.util.ihm.customdialog.IntegerValidator;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.Utils;
import fr.geonosis.karstmod.compute.ConfidenceInterval;
import fr.geonosis.karstmod.compute.ProbableDischarge;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueAutoCorr;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueBilanMasse;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueCumulsVolumes;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueDebitsClasses;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueObjCalVsObjVal;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueParametres;
import fr.geonosis.karstmod.ihm.graphs.JGraphiquePluiesDebits;
import fr.geonosis.karstmod.ihm.graphs.JGraphiquePluiesDebitsInternes;
import fr.geonosis.karstmod.ihm.graphs.JGraphiquePluiesHauteurs;
import fr.geonosis.karstmod.ihm.graphs.JGraphiquePluiesHauteursInternes;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueQSimMoinsQobs;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueQSimVsQobs;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueSSI;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueTAndET;
import fr.geonosis.karstmod.ihm.graphs.JGraphiqueXCorr;
import fr.geonosis.karstmod.ihm.graphs.JPanelModelEvaluation;
import fr.geonosis.karstmod.ihm.graphs.JPanelObj1vsObj2;
import fr.geonosis.karstmod.ihm.graphs.JPanelQSimVsQobs;
import fr.geonosis.karstmod.ihm.graphs.JTableauParametres;
import fr.geonosis.karstmod.ihm.graphs.JTableauWObj;
import fr.geonosis.karstmod.ihm.graphs.ssi.JTableauSSI;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterSSI;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.RunParameters;
import fr.geonosis.karstmod.modele.SensitivityIndexes;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.obj.WobjRunResults;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.observable.ParentsHandler;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import fr.geonosis.karstmod.run.RunMonitor;
import fr.geonosis.karstmod.run.model.RunModel;
import fr.geonosis.karstmod.viewfx.ResultTab;
import fr.geonosis.karstmod.viewfx.SSIDialog;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.embed.swing.SwingNode;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class ResultsPaneController {
    private static final String CALIBRATION = Messages.getString("JResults.0");
    private static final String VALIDATION = Messages.getString("JResults.1");
    private static final String CHAUFFE = Messages.getString("JResults.2");
    private static final String DEBIT_CALCULE = Messages.getString("JResults.3");
    private static final String DEBIT_OBSERVE = Messages.getString("JResults.4");
    private static final String DEBIT_POMPE = Messages.getString("pumpedDischarge.displayName");
    private static final String DEBIT_APPORT = Messages.getString("sinkedDischarge.displayName");
    private static final String ET = Messages.getString("JResults.6");
    private static final String ET_EFF = Messages.getString("JResults.60");
    private static final String TEMPERATURE = Messages.getString("temperature.displayName");
    private static final String SRAD = "Srad";
    private static final String PLUIES = Messages.getString("JResults.7");
    private static final String QLOSS_DISCHARGE = Messages.getString("Qloss.displayName");
    private static final String PET = Messages.getString("JResults.600");
    private static final String PSR = Messages.getString("JResults.700");
    private KarstModConfig fConfig;
    private List<Courbe> fSimulatedCourbes;
    private Courbe fCourbeT;
    private Courbe fCourbeSrad;
    private Courbe fCourbeQlossSim;
    private Courbe fCourbeQlossObs;
    private Courbe fCourbeP;
    private Courbe fCourbeHP;
    private Courbe fCourbePInternes;
    private Courbe fCourbePOrPsr;
    private Courbe fCourbeHPOrPsr;
    private Courbe fCourbeHIPOrPsr;
    private Courbe fCourbePOrPsrInternes;
    private Courbe fCourbePT;
    private Courbe fCourbeET;
    private Courbe fCourbeHET;
    private Courbe fCourbeETInternes;
    private Courbe fCourbeETT;
    private Courbe fCourbeETOrPET;
    private Courbe fCourbeHETOrPET;
    private Courbe fCourbeHIETOrPET;
    private Courbe fCourbeETOrPETInternes;
    private Courbe fCourbeETEff;
    private Courbe fCourbeETEffT;
    private Courbe fCourbePsr;
    private Courbe fCourbeHPsr;
    private Courbe fCourbePsrInternes;
    private Courbe fCourbePsrT;
    private Courbe fCourbePET;
    private Courbe fCourbeHPET;
    private Courbe fCourbePETInternes;
    private Courbe fCourbePETT;
    private Courbe fCourbeQpumpC;
    private Courbe fCourbeQpumpM;
    private Courbe fCourbeQpumpL;
    private Courbe fCourbeQpumpS;
    private Courbe fCourbeQsinkC;
    private Courbe fCourbeQsinkM;
    private Courbe fCourbeQsinkL;
    private Courbe fCourbeQsinkS;
    private Courbe fCourbeQobs;
    private Courbe fCourbeQobsInterne;
    private Courbe fCourbeQsim;
    private Courbe fCourbeQsimInterne;
    private Courbe fCourbeHQobs;
    private Courbe fCourbeHQsim;
    private Courbe fCourbeHauteurE;
    private Courbe fCourbeHauteurL;
    private Courbe fCourbeHauteurM;
    private Courbe fCourbeHauteurC;
    private CourbeConstante fLigneZ0E;
    private CourbeConstante fLigneZ0L;
    private CourbeConstante fLigneZ0M;
    private CourbeConstante fLigneZ0C;
    private Courbe fCourbeZobsE;
    private Courbe fCourbeZobsL;
    private Courbe fCourbeZobsM;
    private Courbe fCourbeZobsC;
    private Courbe fCourbeZsimE;
    private Courbe fCourbeZsimL;
    private Courbe fCourbeZsimM;
    private Courbe fCourbeZsimC;
    private FondPlage fChauffe;
    private FondPlage fCalibration;
    private FondPlage fValidation;
    private Courbe fCourbeQEM;
    private Courbe fCourbeQEL;
    private Courbe fCourbeQE;
    private Courbe fCourbeQEC;
    private Courbe fCourbeQES;
    private Courbe fCourbeQhyEC;
    private Courbe fCourbeQhyES;
    private Courbe fCourbeQMS;
    private Courbe fCourbeQMC;
    private Courbe fCourbeQCS;
    private Courbe fCourbeQLS;
    private Courbe fCourbeQloss;
    private Courbe fCourbeQrEloss;
    private Courbe fCourbeQrLloss;
    private Courbe fCourbeQrMloss;
    private Courbe fCourbeQrCloss;
    private Courbe fCourbeQbL;
    private Courbe fCourbeQrL;
    private Courbe fCourbeQbM;
    private Courbe fCourbeQrM;
    private Courbe fCourbeQbC;
    private Courbe fCourbeQrC;
    private Courbe fCourbeQprob;
    private Courbe fCourbeQsimMin;
    private Courbe fCourbeQsimMax;
    private Map<Varname, CourbesCI> fCourbesCI;
    private RunParameters fRunParameters;
    private JTableauParametres fTableauParametres;
    private JTableauWObj fTableauWObj;
    private JTableauSSI fTableauSSI;
    private InputData fInputData;
    private Model fModel;
    private JPanelModelEvaluation fPanelModelEvaluation;
    private JPanelObj1vsObj2 fPanelObj1VsObj2;
    private JGraphiqueDebitsClasses fGraphiqueDebitsClassesCalibration;
    private JGraphiqueDebitsClasses fGraphiqueDebitsClassesValidation;
    private JGraphiqueXCorr fGraphiqueXCorrPluieDebitCalibration;
    private JGraphiqueXCorr fGraphiqueXCorrPluieDebitValidation;
    private JGraphiqueXCorr fGraphiqueXCorrDebitMesureDebitSimuleCalibration;
    private JGraphiqueXCorr fGraphiqueXCorrDebitMesureDebitSimuleValidation;
    private JGraphiqueAutoCorr fGraphiqueAutocorrQCalibration;
    private JGraphiqueAutoCorr fGraphiqueAutocorrQValidation;
    private JGraphiqueQSimMoinsQobs fGraphiqueQSimMoinsQobs;
    private JGraphiqueObjCalVsObjVal fGraphiqueObjCalVsObjVal;
    private JGraphiquePluiesDebits fGraphiquePluiesDebits;
    private JGraphiquePluiesHauteurs fGraphiquePluiesHauteurs;
    private JGraphiquePluiesHauteursInternes fGraphiquePluiesHauteursInternes;
    private JGraphiquePluiesDebitsInternes fGraphiquePluiesDebitsInternes;
    private JGraphiqueCumulsVolumes fGraphiqueCumulsVolumes;
    private JPanelQSimVsQobs fPanelQSimVsObs;
    private JGraphiqueQSimVsQobs fGraphiqueQSimVsObs;
    private JGraphiqueQSimVsQobs fGraphiqueQLossSimVsObs;
    private JGraphiqueBilanMasse fGraphiqueBilanMasse;
    private JGraphiqueParametres fGraphiqueParametres;
    private JGraphiqueSSI fGraphiqueSSI;
    private JGraphiqueTAndET fGraphiqueTAndET;
    private AbstractAction fActionContinueSSI;
    @FXML
    private VBox rootPane;
    @FXML
    private Button btOptParamSet;
    @FXML
    private Button btTAndET;
    @FXML
    private Button btPAndDisch;
    @FXML
    private Button btPAndIntDisch;
    @FXML
    private Button btPAndLevel;
    @FXML
    private Button btPAndIntLevel;
    @FXML
    private Button btCumVol;
    @FXML
    private Button btMassBal;
    @FXML
    private Button btModelEval;
    @FXML
    private Button btQSvsQobs;
    @FXML
    private Button btQSminusQobs;
    @FXML
    private Button btProbPlot;
    @FXML
    private Button btCorrPQ;
    @FXML
    private Button btCorrQobsQS;
    @FXML
    private Button btAutoCorrQobsQS;
    @FXML
    private Button btWObsvsParam;
    @FXML
    private Button btObj1vsObj2;
    @FXML
    private Button btWobjCalvsVal;
    @FXML
    private Button btSSI;
    @FXML
    private SwingNode swingNode;
    private Map<TabName, ResultTab> fButtonMap;
    private TabName fSelectedTab;

    private static void updateStages(FondPlage pFondPlage, List<StageBounds> pStages) {
        List<Plage> plages = pFondPlage.getPlages();
        plages.clear();
        if (pStages != null && !pStages.isEmpty()) {
            for (StageBounds stageBounds : pStages) {
                plages.add(new Plage(stageBounds.getDebut(), stageBounds.getFin()));
            }
        }
        Collections.sort(plages);
    }

    @FXML
    private void initialize() {
        this.swingNode.setOnMousePressed(evt -> {
            this.swingNode.requestFocus();
            if (this.swingNode.getContent() != null) {
                this.swingNode.getContent().requestFocus();
            }
        });
    }

    private void setup(TabName pTabName, Button pButton, JComponent pComponent) {
        this.setup(pTabName, pButton, pComponent, pButton.getText());
    }

    private void setup(TabName pTabName, Button pButton, JComponent pComponent, String pTooltipText) {
        if (pTooltipText != null) {
            Tooltip.install((Node)pButton, (Tooltip)new Tooltip(pTooltipText));
        }
        this.fButtonMap.put(pTabName, new ResultTab(pButton, pComponent));
        pButton.setOnAction(evt -> {
            this.swingNode.setContent(pComponent);
            for (ResultTab tab : this.fButtonMap.values()) {
                tab.getButton().getStyleClass().remove((Object)"tab-button-selected");
            }
            pButton.getStyleClass().add((Object)"tab-button-selected");
            this.fSelectedTab = pTabName;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ResultsPaneController.this.swingNode.getContent().repaint();
                }
            }, 100L);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ResultsPaneController.this.swingNode.getContent().repaint();
                }
            }, 1000L);
        });
        pButton.setFocusTraversable(false);
    }

    public void selectTab(TabName pTabName) {
        Platform.runLater(() -> this.fButtonMap.get((Object)pTabName).getButton().getOnAction().handle(null));
    }

    public void disableTab(TabName pTabName, boolean pDisabled) {
        Platform.runLater(() -> {
            try {
                Button button = this.fButtonMap.get((Object)pTabName).getButton();
                button.setDisable(pDisabled);
                if (pDisabled) {
                    button.getStyleClass().remove((Object)"tab-button-selected");
                }
                if (pDisabled && this.fSelectedTab == pTabName) {
                    this.selectTab(TabName.P_AND_DISCHARGE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public TabName selectedTab() {
        return this.fSelectedTab;
    }

    public void enableAllTabs() {
        Platform.runLater(() -> {
            for (ResultTab tab : this.fButtonMap.values()) {
                tab.getButton().setDisable(false);
            }
        });
    }

    public void repaintSelectedTab() {
        SwingUtilities.invokeLater(() -> {
            if (this.fSelectedTab != null) {
                this.fButtonMap.get((Object)this.fSelectedTab).getComponent().repaint();
            }
        });
    }

    public void setConfig(KarstModConfig pConfig) {
        this.fButtonMap = new HashMap<TabName, ResultTab>();
        this.fConfig = pConfig;
        this.fRunParameters = pConfig.getRunParameters();
        this.fRunParameters.getCalibrationStages().addListener(pC -> this.stagesUpdated());
        this.fRunParameters.getValidationStages().addListener(pC -> this.stagesUpdated());
        this.fRunParameters.warmupBeginningProperty().addListener((pObservable, pOldValue, pNewValue) -> this.stagesUpdated());
        this.fModel = pConfig.getModel();
        this.fInputData = pConfig.getInputData();
        this.fInputData.addListener(pObservable -> this.inputDataChanged());
        this.createCourbes();
        this.createBackgrounds();
        this.createGraphiques();
        this.fTableauParametres = new JTableauParametres();
        this.fTableauWObj = new JTableauWObj();
        JPanel paramPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        paramPanel.add((Component)this.fTableauParametres, constraints);
        constraints.gridx = 1;
        paramPanel.add((Component)this.fTableauWObj, constraints);
        this.fTableauSSI = new JTableauSSI();
        this.fGraphiqueSSI = new JGraphiqueSSI();
        this.majOutputLabels();
        this.fActionContinueSSI = new AbstractAction("Continue"){
            private int n;
            {
                this.n = 1000;
            }

            @Override
            public void actionPerformed(ActionEvent pE) {
                SharedFrame f = new SharedFrame();
                SwingUtilities.invokeLater(() -> {
                    CustomDialog<Integer> dialog = new CustomDialog<Integer>((Frame)f, "N", "Input", new IntegerValidator(1, Integer.MAX_VALUE));
                    dialog.setText(String.valueOf(this.n));
                    dialog.pack();
                    dialog.setLocationRelativeTo(ResultsPaneController.this.fTableauSSI);
                    dialog.setVisible(true);
                    f.dispose();
                    if (dialog.getValidated() != null) {
                        this.n = dialog.getValidated();
                        Platform.runLater(() -> SSIDialog.getInstance().continuePrevious(this.n));
                    } else {
                        dialog.dispose();
                    }
                });
            }
        };
        JButton buttonContinueSSI = fr.dbe.util.ihm.Utils.createButton(this.fActionContinueSSI);
        this.fModel.addListener(o -> SwingUtilities.invokeLater(() -> {
            this.fActionContinueSSI.setEnabled(false);
            buttonContinueSSI.setToolTipText("Model modified");
        }));
        this.fActionContinueSSI.setEnabled(false);
        JSplitPane panelSSI = new JSplitPane(1);
        JPanel leftPanelSSI = new JPanel(new BorderLayout());
        leftPanelSSI.add((Component)this.fTableauSSI, "Center");
        leftPanelSSI.add((Component)fr.dbe.util.ihm.Utils.createHorizontalBox(0, true, buttonContinueSSI), "South");
        panelSSI.setDividerLocation(350);
        panelSSI.add(leftPanelSSI);
        panelSSI.add(this.fGraphiqueSSI);
        Unit.getInstance().baseProperty().addListener((pObservable, pOldvalue, pNewValue) -> this.majOutputLabels());
        this.stagesUpdated();
        this.inputDataChanged();
        this.bindVisibility();
        this.setup(TabName.OPTIMAL_PARAMETER_SET, this.btOptParamSet, paramPanel);
        this.setup(TabName.T_AND_ET, this.btTAndET, this.fGraphiqueTAndET);
        this.setup(TabName.P_AND_DISCHARGE, this.btPAndDisch, this.fGraphiquePluiesDebits);
        this.setup(TabName.P_AND_INTERNAL_DISCHARGES, this.btPAndIntDisch, this.fGraphiquePluiesDebitsInternes);
        this.setup(TabName.P_AND_WATER_LEVELS, this.btPAndLevel, this.fGraphiquePluiesHauteurs);
        this.setup(TabName.P_AND_INTERNAL_WATER_LEVELS, this.btPAndIntLevel, this.fGraphiquePluiesHauteursInternes);
        this.setup(TabName.MASS_BALANCE, this.btMassBal, this.fGraphiqueBilanMasse);
        this.setup(TabName.MODEL_EVALUATION, this.btModelEval, this.fPanelModelEvaluation);
        this.setup(TabName.CUMUL_VOLUMES, this.btCumVol, this.fGraphiqueCumulsVolumes);
        this.setup(TabName.QS_VS_QOBS, this.btQSvsQobs, this.fPanelQSimVsObs);
        this.setup(TabName.QS_MINUS_QOBS, this.btQSminusQobs, this.fGraphiqueQSimMoinsQobs);
        Platform.runLater(() -> {
            HtmlTextBox tb = new HtmlTextBox("Q<sub>S</sub> vs Q<sub>obs</sub>");
            tb.setTextColor(this.btQSvsQobs.getTextFill());
            tb.setTranslateY(0.0);
            this.btQSvsQobs.setGraphic((Node)tb);
            this.btQSvsQobs.setText("");
            tb = new HtmlTextBox("Q<sub>S</sub> - Q<sub>obs</sub>");
            tb.setTextColor(this.btQSminusQobs.getTextFill());
            tb.setTranslateY(0.0);
            this.btQSminusQobs.setGraphic((Node)tb);
            this.btQSminusQobs.setText("");
        });
        this.setup(TabName.PROBABILITY_PLOT, this.btProbPlot, this.createPlotPane(this.fGraphiqueDebitsClassesCalibration, this.fGraphiqueDebitsClassesValidation));
        this.setup(TabName.CORRELATION_P_Q, this.btCorrPQ, this.createPlotPane(this.fGraphiqueXCorrPluieDebitCalibration, this.fGraphiqueXCorrPluieDebitValidation));
        this.setup(TabName.CORRELATION_QOBS_QS, this.btCorrQobsQS, this.createPlotPane(this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration, this.fGraphiqueXCorrDebitMesureDebitSimuleValidation));
        this.setup(TabName.AUTOCORRELATION_QOBS_QS, this.btAutoCorrQobsQS, this.createPlotPane(this.fGraphiqueAutocorrQCalibration, this.fGraphiqueAutocorrQValidation));
        Platform.runLater(() -> {
            HtmlTextBox tb = new HtmlTextBox("Corr Q<sub>obs</sub>/Q<sub>S</sub>");
            tb.setTextColor(this.btCorrQobsQS.getTextFill());
            tb.setTranslateY(0.0);
            this.btCorrQobsQS.setGraphic((Node)tb);
            this.btCorrQobsQS.setText("");
            tb = new HtmlTextBox("Autocorr Q<sub>obs</sub> &#38; Q<sub>S</sub>");
            tb.setTextColor(this.btAutoCorrQobsQS.getTextFill());
            tb.setTranslateY(0.0);
            this.btAutoCorrQobsQS.setGraphic((Node)tb);
            this.btAutoCorrQobsQS.setText("");
        });
        this.setup(TabName.WOBJ_VS_PARAMETERS, this.btWObsvsParam, this.fGraphiqueParametres);
        this.setup(TabName.OBJ1_VS_OBJ2, this.btObj1vsObj2, this.fPanelObj1VsObj2);
        this.setup(TabName.WOBJ_CAL_VS_VAL, this.btWobjCalvsVal, this.fGraphiqueObjCalVsObjVal);
        this.setup(TabName.SSI, this.btSSI, panelSSI);
        this.selectTab(TabName.P_AND_DISCHARGE);
        this.updatePiezoGraphVisibility();
    }

    private JComponent createPlotPane(JComponent ... pComponents) {
        JPanel pplot = new JPanel(new GridLayout(1, pComponents.length, 5, 0));
        for (JComponent component : pComponents) {
            pplot.add(component);
        }
        return pplot;
    }

    private void updatePiezoGraphVisibility() {
        boolean piezo = false;
        for (Reservoir r : this.fModel.getActiveReservoirList()) {
            if (!r.getPiezo().isActive()) continue;
            piezo = true;
            break;
        }
        this.disableTab(TabName.P_AND_WATER_LEVELS, !piezo);
    }

    private void bindVisibility() {
        ChangeListener piezoListener = (pObservable, pOldValue, pNewValue) -> {
            this.fLigneZ0E.setVisible((boolean)pNewValue);
            this.fLigneZ0E.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZobsE.setVisible((boolean)pNewValue);
            this.fCourbeZobsE.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZsimE.setVisible((boolean)pNewValue);
            this.fCourbeZsimE.setVisibleInMenu((boolean)pNewValue);
            this.updatePiezoGraphVisibility();
        };
        this.fModel.getReservoirE().getPiezo().activeProperty().addListener(piezoListener);
        piezoListener.changed(null, null, (Object)this.fModel.getReservoirE().getPiezo().isActive());
        piezoListener = (pObservable, pOldValue, pNewValue) -> {
            this.fLigneZ0L.setVisible((boolean)pNewValue);
            this.fLigneZ0L.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZobsL.setVisible((boolean)pNewValue);
            this.fCourbeZobsL.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZsimL.setVisible((boolean)pNewValue);
            this.fCourbeZsimL.setVisibleInMenu((boolean)pNewValue);
            this.updatePiezoGraphVisibility();
        };
        this.fModel.getReservoirL().getPiezo().activeProperty().addListener(piezoListener);
        piezoListener.changed(null, null, (Object)this.fModel.getReservoirL().getPiezo().isActive());
        piezoListener = (pObservable, pOldValue, pNewValue) -> {
            this.fLigneZ0M.setVisible((boolean)pNewValue);
            this.fLigneZ0M.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZobsM.setVisible((boolean)pNewValue);
            this.fCourbeZobsM.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZsimM.setVisible((boolean)pNewValue);
            this.fCourbeZsimM.setVisibleInMenu((boolean)pNewValue);
            this.updatePiezoGraphVisibility();
        };
        this.fModel.getReservoirM().getPiezo().activeProperty().addListener(piezoListener);
        piezoListener.changed(null, null, (Object)this.fModel.getReservoirM().getPiezo().isActive());
        piezoListener = (pObservable, pOldValue, pNewValue) -> {
            this.fLigneZ0C.setVisible((boolean)pNewValue);
            this.fLigneZ0C.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZobsC.setVisible((boolean)pNewValue);
            this.fCourbeZobsC.setVisibleInMenu((boolean)pNewValue);
            this.fCourbeZsimC.setVisible((boolean)pNewValue);
            this.fCourbeZsimC.setVisibleInMenu((boolean)pNewValue);
            this.updatePiezoGraphVisibility();
        };
        this.fModel.getReservoirC().getPiezo().activeProperty().addListener(piezoListener);
        piezoListener.changed(null, null, (Object)this.fModel.getReservoirC().getPiezo().isActive());
        this.bindVisibility(this.fCourbeQloss, this.fModel.getQloss());
        this.bindVisibility(this.fCourbeQE, this.fModel.getQE());
        this.bindVisibility(this.fCourbeQEL, this.fModel.getQEL(), this.fModel.getQbE().getParameterTo(this.fModel.getReservoirL()));
        this.bindVisibility(this.fCourbeQEM, this.fModel.getQEM(), this.fModel.getQbE().getParameterTo(this.fModel.getReservoirM()));
        this.bindVisibility(this.fCourbeQEC, this.fModel.getQEC(), this.fModel.getQbE().getParameterTo(this.fModel.getReservoirC()), this.fModel.getQrE().getParameterTo(this.fModel.getReservoirC()));
        this.bindVisibility(this.fCourbeQrEloss, this.fModel.getQrE().getParameterTo(this.fModel.getLoss()));
        this.bindVisibility(this.fCourbeQhyEC, this.fModel.getQhyEC());
        this.bindVisibility(this.fCourbeQhyES, this.fModel.getQhyES());
        this.bindVisibility(this.fCourbeQES, this.fModel.getQES(), this.fModel.getQrE().getParameterTo(this.fModel.getExutoire()), this.fModel.getQbE().getParameterTo(this.fModel.getExutoire()));
        this.bindVisibility(this.fCourbeQMC, this.fModel.getQMC());
        this.bindVisibility(this.fCourbeQMS, new TcInfChild(this.fModel.getReservoirM(), this.fModel.getQMS(), this.fModel.getQbM().getParameterTo(this.fModel.getExutoire()), this.fModel.getQrM().getParameterTo(this.fModel.getExutoire())));
        this.bindVisibility(this.fCourbeQrMloss, this.fModel.getQrM().getParameterTo(this.fModel.getLoss()));
        this.bindVisibility(this.fCourbeQbM, this.fModel.getQbM().getParameterTo(this.fModel.getExutoire()));
        this.bindVisibility(this.fCourbeQrM, this.fModel.getQrM().getParameterTo(this.fModel.getExutoire()));
        this.bindVisibility(this.fCourbeQLS, new TcInfChild(this.fModel.getReservoirL(), this.fModel.getQLS(), this.fModel.getQbL().getParameterTo(this.fModel.getExutoire()), this.fModel.getQrL().getParameterTo(this.fModel.getExutoire())));
        this.bindVisibility(this.fCourbeQrEloss, this.fModel.getQrL().getParameterTo(this.fModel.getLoss()));
        this.bindVisibility(this.fCourbeQrLloss, this.fModel.getQrL().getParameterTo(this.fModel.getLoss()));
        this.bindVisibility(this.fCourbeQbL, this.fModel.getQbL().getParameterTo(this.fModel.getExutoire()));
        this.bindVisibility(this.fCourbeQrL, this.fModel.getQrL().getParameterTo(this.fModel.getExutoire()));
        this.bindVisibility(this.fCourbeQCS, new TcInfChild(this.fModel.getReservoirC(), this.fModel.getQCS(), this.fModel.getQbC().getParameterTo(this.fModel.getExutoire()), this.fModel.getQrC().getParameterTo(this.fModel.getExutoire())));
        this.bindVisibility(this.fCourbeQrCloss, this.fModel.getQrC().getParameterTo(this.fModel.getLoss()));
        this.bindVisibility(this.fCourbeQbC, this.fModel.getQbC().getParameterTo(this.fModel.getExutoire()));
        this.bindVisibility(this.fCourbeQrC, this.fModel.getQrC().getParameterTo(this.fModel.getExutoire()));
        this.bindVisibility(this.fCourbeHauteurE, this.fModel.getReservoirE());
        this.bindVisibility(this.fCourbeHauteurL, this.fModel.getReservoirL());
        this.bindVisibility(this.fCourbeHauteurM, this.fModel.getReservoirM());
        this.bindVisibility(this.fCourbeHauteurC, this.fModel.getReservoirC());
        this.bindVisibility(this.fCourbeZobsE, this.fModel.getReservoirE().getPiezo());
        this.bindVisibility(this.fCourbeZsimE, this.fModel.getReservoirE().getPiezo());
        this.bindVisibility(this.fCourbeZobsL, this.fModel.getReservoirL().getPiezo());
        this.bindVisibility(this.fCourbeZsimL, this.fModel.getReservoirL().getPiezo());
        this.bindVisibility(this.fCourbeZobsM, this.fModel.getReservoirM().getPiezo());
        this.bindVisibility(this.fCourbeZsimM, this.fModel.getReservoirM().getPiezo());
        this.bindVisibility(this.fCourbeZobsC, this.fModel.getReservoirC().getPiezo());
        this.bindVisibility(this.fCourbeZsimC, this.fModel.getReservoirC().getPiezo());
        this.bindVisibility(this.fCourbeQsim, this.fModel.getExutoire());
        this.bindVisibility(this.fCourbeHQsim, this.fModel.getExutoire());
        this.bindVisibility(this.fCourbeQsimInterne, this.fModel.getExutoire());
        this.fInputData.presenceProperty(ColumnName.QLOSS).addListener((o, old, n) -> {
            this.fCourbeQlossObs.setActive(n != false && this.fModel.getQloss().isActive());
            this.fGraphiqueQLossSimVsObs.setVisible(this.fCourbeQlossObs.isActive());
        });
        this.fModel.getQloss().activeProperty().addListener((o, old, n) -> {
            this.fCourbeQlossObs.setActive(n != false && this.fModel.getQloss().isActive());
            this.fGraphiqueQLossSimVsObs.setVisible(this.fCourbeQlossObs.isActive());
        });
        this.fCourbeQlossObs.setActive(this.fInputData.contains(ColumnName.QLOSS) && this.fModel.getQloss().isActive());
        this.fGraphiqueQLossSimVsObs.setVisible(this.fCourbeQlossObs.isActive());
        this.bindVisibility(this.fCourbeQlossSim, this.fModel.getQloss());
        this.bindVisibility(this.fCourbeP, this.fModel.getFluxRainfall());
        this.bindVisibility(this.fCourbeHP, this.fModel.getFluxRainfall());
        this.bindVisibility(this.fCourbePInternes, this.fModel.getFluxRainfall());
        this.bindVisibility(this.fCourbePOrPsr, this.fModel.getFluxRainfall());
        this.bindVisibility(this.fCourbePOrPsrInternes, this.fModel.getFluxRainfall());
        this.bindVisibility(this.fCourbeHPOrPsr, this.fModel.getFluxRainfall());
        this.bindVisibility(this.fCourbeHIPOrPsr, this.fModel.getFluxRainfall());
        this.bindVisibility(this.fCourbeET, this.fModel.getFluxET());
        this.bindVisibility(this.fCourbeETInternes, this.fModel.getFluxET());
        this.bindVisibility(this.fCourbeHET, this.fModel.getFluxET());
        this.bindVisibility(this.fCourbeETOrPET, this.fModel.getFluxET(), this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbeHETOrPET, this.fModel.getFluxET(), this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbeHIETOrPET, this.fModel.getFluxET(), this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbeETOrPETInternes, this.fModel.getFluxET(), this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbePsr, this.fModel.getSnowRoutine());
        this.bindVisibility(this.fCourbePsrT, this.fModel.getSnowRoutine());
        this.bindVisibility(this.fCourbeHPsr, this.fModel.getSnowRoutine());
        this.bindVisibility(this.fCourbePsrInternes, this.fModel.getSnowRoutine());
        this.bindVisibility(this.fCourbePET, this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbePETT, this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbePETInternes, this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbeHPET, this.fModel.getPetRoutine());
        this.bindVisibility(this.fCourbeQpumpL, this.fModel.getFluxQPumpL());
        this.bindVisibility(this.fCourbeQpumpM, this.fModel.getFluxQPumpM());
        this.bindVisibility(this.fCourbeQpumpC, this.fModel.getFluxQPumpC());
        this.bindVisibility(this.fCourbeQpumpS, this.fModel.getFluxQPumpS());
        this.bindVisibility(this.fCourbeQsinkL, this.fModel.getFluxQSinkL());
        this.bindVisibility(this.fCourbeQsinkM, this.fModel.getFluxQSinkM());
        this.bindVisibility(this.fCourbeQsinkC, this.fModel.getFluxQSinkC());
        this.bindVisibility(this.fCourbeQsinkS, this.fModel.getFluxQSinkS());
    }

    private void bindVisibility(Activable pCourbe, IChild ... pElements) {
        ChangeListener lis = (pObservable, pOldValue, pNewValue) -> {
            boolean active = false;
            for (IChild e : pElements) {
                active |= e.isActive();
            }
            pCourbe.setActive(active);
            this.repaintSelectedTab();
        };
        for (IChild e : pElements) {
            e.activeProperty().addListener(lis);
        }
        lis.changed(null, null, null);
    }

    private void createGraphiques() {
        this.fGraphiquePluiesDebits = new JGraphiquePluiesDebits(this.fCourbePOrPsr, this.fCourbeETOrPET, this.fCourbeQpumpL, this.fCourbeQpumpM, this.fCourbeQpumpC, this.fCourbeQpumpS, this.fCourbeQsinkL, this.fCourbeQsinkM, this.fCourbeQsinkC, this.fCourbeQsinkS, this.fCourbeQobs, this.fChauffe, this.fCalibration, this.fValidation, this.fCourbeQsim, this.fCourbeQsimMin, this.fCourbeQsimMax, this.fCourbeQprob, this.fCourbesCI.get((Object)Varname.QS), this.fCourbeQlossObs, this.fCourbeQlossSim);
        this.fGraphiquePluiesDebits.addDetachListener(evt -> {
            if (evt.getSource() != null) {
                JComponent c = this.swingNode.getContent();
                this.swingNode.setContent(null);
                SwingUtilities.invokeLater(() -> {
                    ((JFrame)evt.getSource()).requestFocus();
                    this.fGraphiquePluiesDebits.getDessin().requestFocus();
                    this.swingNode.setContent(c);
                });
            }
        });
        this.fGraphiqueTAndET = new JGraphiqueTAndET(this.fCourbeT, this.fCourbeSrad, this.fCourbePT, this.fCourbePsrT, this.fCourbeETT, this.fCourbePETT, this.fCourbeETEffT, this.fChauffe, this.fCalibration, this.fValidation);
        this.fGraphiquePluiesHauteurs = new JGraphiquePluiesHauteurs(this.fCourbeHPOrPsr, this.fCourbeHETOrPET, this.fChauffe, this.fCalibration, this.fValidation, this.fLigneZ0E, this.fCourbeZobsE, this.fCourbeZsimE, this.fLigneZ0L, this.fCourbeZobsL, this.fCourbeZsimL, this.fLigneZ0M, this.fCourbeZobsM, this.fCourbeZsimM, this.fLigneZ0C, this.fCourbeZobsC, this.fCourbeZsimC, this.fCourbesCI.get((Object)Varname.ZE), this.fCourbesCI.get((Object)Varname.ZL), this.fCourbesCI.get((Object)Varname.ZM), this.fCourbesCI.get((Object)Varname.ZC));
        this.fGraphiquePluiesHauteursInternes = new JGraphiquePluiesHauteursInternes(this.fCourbeHIPOrPsr, this.fCourbeHIETOrPET, this.fChauffe, this.fCalibration, this.fValidation, this.fCourbeHauteurE, this.fCourbeHauteurL, this.fCourbeHauteurM, this.fCourbeHauteurC);
        this.fGraphiquePluiesDebitsInternes = new JGraphiquePluiesDebitsInternes(this.fCourbePOrPsrInternes, this.fCourbeETOrPETInternes, this.fCourbeETEff, this.fCourbeQEL, this.fCourbeQEM, this.fCourbeQEC, this.fCourbeQE, this.fCourbeQES, this.fCourbeQhyEC, this.fCourbeQhyES, this.fCourbeQLS, this.fCourbeQMS, this.fCourbeQMC, this.fCourbeQCS, this.fCourbeQloss, this.fCourbeQrEloss, this.fCourbeQrLloss, this.fCourbeQrMloss, this.fCourbeQrCloss, this.fCourbeQobsInterne, this.fCourbeQsimInterne, this.fChauffe, this.fCalibration, this.fValidation, this.fCourbeQbM, this.fCourbeQrM, this.fCourbeQbL, this.fCourbeQrL, this.fCourbeQbC, this.fCourbeQrC, this.fCourbesCI.get((Object)Varname.QLOSS));
        this.fGraphiquePluiesDebits.linkWith(this.fGraphiquePluiesDebitsInternes, this.fGraphiquePluiesHauteurs, this.fGraphiquePluiesHauteursInternes, this.fGraphiqueTAndET);
        this.fGraphiquePluiesDebitsInternes.linkWith(this.fGraphiquePluiesDebits, this.fGraphiquePluiesHauteurs, this.fGraphiquePluiesHauteursInternes, this.fGraphiqueTAndET);
        this.fGraphiquePluiesHauteurs.linkWith(this.fGraphiquePluiesDebits, this.fGraphiquePluiesDebitsInternes, this.fGraphiquePluiesHauteursInternes, this.fGraphiqueTAndET);
        this.fGraphiquePluiesHauteursInternes.linkWith(this.fGraphiquePluiesDebits, this.fGraphiquePluiesDebitsInternes, this.fGraphiquePluiesHauteurs, this.fGraphiqueTAndET);
        this.fGraphiqueTAndET.linkWith(this.fGraphiquePluiesDebits, this.fGraphiquePluiesDebitsInternes, this.fGraphiquePluiesHauteurs, this.fGraphiquePluiesHauteursInternes);
        this.fGraphiqueCumulsVolumes = new JGraphiqueCumulsVolumes(this.fCourbeQobs, this.fCourbeQsim, this.fCourbeQlossObs, this.fCourbeQlossSim, this.fCalibration, this.fValidation);
        this.fGraphiqueQSimVsObs = new JGraphiqueQSimVsQobs(this.fCourbeQobs, Messages.getString("QOBSS.htmlName"), this.fCourbeQsim, Messages.getString("QS.htmlName"), this.fCalibration, this.fValidation);
        this.fGraphiqueQLossSimVsObs = new JGraphiqueQSimVsQobs(this.fCourbeQlossObs, Messages.getString("Qloss.htmlName") + " <sub>obs</sub>", this.fCourbeQlossSim, Messages.getString("Qloss.htmlName") + " <sub>sim</sub>", this.fCalibration, this.fValidation);
        this.fPanelQSimVsObs = new JPanelQSimVsQobs(this.fGraphiqueQSimVsObs, this.fGraphiqueQLossSimVsObs);
        this.fGraphiqueBilanMasse = new JGraphiqueBilanMasse(this.fCourbePOrPsr, this.fCourbeETEff, this.fCourbeQloss, this.fCourbeQrEloss, this.fCourbeQrLloss, this.fCourbeQrMloss, this.fCourbeQrCloss, this.fCourbeQsim, this.fCourbeQpumpL, this.fCourbeQpumpM, this.fCourbeQpumpC, this.fCourbeQpumpS, this.fCourbeQsinkL, this.fCourbeQsinkM, this.fCourbeQsinkC, this.fCourbeQsinkS, this.fCalibration, this.fValidation, this.fCourbeHauteurE, this.fCourbeHauteurL, this.fCourbeHauteurM, this.fCourbeHauteurC);
        this.fPanelModelEvaluation = new JPanelModelEvaluation();
        this.fGraphiqueParametres = new JGraphiqueParametres(this.fModel);
        this.fPanelObj1VsObj2 = new JPanelObj1vsObj2();
        this.fGraphiqueObjCalVsObjVal = new JGraphiqueObjCalVsObjVal();
        this.fGraphiqueDebitsClassesCalibration = new JGraphiqueDebitsClasses(this.fCourbeQobs, this.fCourbeQsim, this.fCalibration, null);
        this.fGraphiqueDebitsClassesCalibration.setNom(Messages.getString("JResults.40") + " calibration");
        this.fGraphiqueDebitsClassesCalibration.getDessin().setTitle("Calibration");
        this.fGraphiqueDebitsClassesValidation = new JGraphiqueDebitsClasses(this.fCourbeQobs, this.fCourbeQsim, this.fValidation, null);
        this.fGraphiqueDebitsClassesValidation.setNom(Messages.getString("JResults.40") + " validation");
        this.fGraphiqueDebitsClassesValidation.getDessin().setTitle("Validation");
        this.fGraphiqueXCorrPluieDebitCalibration = new JGraphiqueXCorr(this.fCourbePOrPsr, this.fCourbeQobs, this.fCourbeQsim, this.fCalibration, "Calibration");
        this.fGraphiqueXCorrPluieDebitCalibration.setNom(Messages.getString("JResults.41") + " calibration");
        this.fGraphiqueXCorrPluieDebitCalibration.getDessin().setTitle("Calibration");
        this.fGraphiqueXCorrPluieDebitValidation = new JGraphiqueXCorr(this.fCourbePOrPsr, this.fCourbeQobs, this.fCourbeQsim, this.fValidation, "Validation");
        this.fGraphiqueXCorrPluieDebitValidation.setNom(Messages.getString("JResults.41") + " validation");
        this.fGraphiqueXCorrPluieDebitValidation.getDessin().setTitle("Validation");
        this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration = new JGraphiqueXCorr(this.fCourbeQobs, null, this.fCourbeQsim, this.fCalibration, "Calibration");
        this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration.setNom(Utils.addHtmlTag(Messages.getString("JResults.43") + " calibration"));
        this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration.getDessin().setTitle("Calibration");
        this.fGraphiqueXCorrDebitMesureDebitSimuleValidation = new JGraphiqueXCorr(this.fCourbeQobs, null, this.fCourbeQsim, this.fValidation, "Validation");
        this.fGraphiqueXCorrDebitMesureDebitSimuleValidation.setNom(Utils.addHtmlTag(Messages.getString("JResults.43") + " validation"));
        this.fGraphiqueXCorrDebitMesureDebitSimuleValidation.getDessin().setTitle("Validation");
        this.fGraphiqueAutocorrQCalibration = new JGraphiqueAutoCorr(new Courbe[]{this.fCourbeQobs, this.fCourbeQsim}, this.fCalibration, "Calibration");
        this.fGraphiqueAutocorrQCalibration.setNom(Utils.addHtmlTag(Messages.getString("JResults.48") + " calibration"));
        this.fGraphiqueAutocorrQCalibration.getDessin().setTitle("Calibration");
        this.fGraphiqueAutocorrQValidation = new JGraphiqueAutoCorr(new Courbe[]{this.fCourbeQobs, this.fCourbeQsim}, this.fValidation, "Validation");
        this.fGraphiqueAutocorrQValidation.setNom(Utils.addHtmlTag(Messages.getString("JResults.48") + " validation"));
        this.fGraphiqueAutocorrQValidation.getDessin().setTitle("Validation");
        this.fGraphiqueQSimMoinsQobs = new JGraphiqueQSimMoinsQobs(this.fCourbeQobs, this.fCourbeQsim, this.fCourbeQlossObs, this.fCourbeQlossSim, this.fCalibration, this.fValidation);
        this.fGraphiqueQSimMoinsQobs.linkWith(this.fGraphiqueBilanMasse, this.fGraphiqueCumulsVolumes);
        this.fGraphiqueCumulsVolumes.linkWith(this.fGraphiqueQSimMoinsQobs, this.fGraphiqueBilanMasse);
        this.fGraphiqueBilanMasse.linkWith(this.fGraphiqueQSimMoinsQobs, this.fGraphiqueCumulsVolumes);
    }

    private void createBackgrounds() {
        this.fChauffe = new FondPlage(CHAUFFE);
        this.fChauffe.setColor(Styles.COULEUR_TRAIT_CHAUFFE);
        this.fChauffe.setStroke(new BasicStroke(1.0f));
        this.fChauffe.setFillColor(Styles.COULEUR_FOND_CHAUFFE);
        this.fCalibration = new FondPlage(CALIBRATION, 0.0, 100.0);
        this.fCalibration.setColor(Styles.COULEUR_TRAIT_CALIBRATION);
        this.fCalibration.setStroke(new BasicStroke(1.0f));
        this.fCalibration.setFillColor(Styles.COULEUR_FOND_CALIBRATION);
        this.fValidation = new FondPlage(VALIDATION, 0.0, 100.0);
        this.fValidation.setColor(Styles.COULEUR_TRAIT_VALIDATION);
        this.fValidation.setStroke(new BasicStroke(1.0f));
        this.fValidation.setFillColor(Styles.COULEUR_FOND_VALIDATION);
    }

    private void createCourbes() {
        this.fSimulatedCourbes = new ArrayList<Courbe>();
        this.fCourbesCI = new HashMap<Varname, CourbesCI>();
        this.fCourbeT = new Courbe(TEMPERATURE, 0.0, 1.0);
        this.fCourbeT.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbeT.setCouleur(Styles.COULEURS_COURBE_TEMPERATURE);
        this.fCourbeSrad = new Courbe(SRAD, 0.0, 1.0);
        this.fCourbeSrad.setCouleur(Styles.COULEURS_COURBE_SRAD);
        this.fCourbeQlossSim = new Courbe(DEBIT_CALCULE + " " + QLOSS_DISCHARGE, 0.0, 1.0);
        this.fCourbeQlossSim.setCouleur(Styles.COULEURS_COURBE_QLOSS_SIM);
        this.fCourbeQlossObs = new Courbe(DEBIT_OBSERVE + " " + QLOSS_DISCHARGE, 0.0, 1.0);
        this.fCourbeQlossObs.setCouleur(Styles.COULEURS_COURBE_QLOSS_OBS);
        this.fCourbeP = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbeP.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbeP.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbePT = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbePT.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbePT.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbePInternes = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbePInternes.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbePInternes.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbeHP = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbeHP.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbeHP.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbePOrPsr = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbePOrPsr.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbePOrPsr.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbeHPOrPsr = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbeHPOrPsr.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbeHPOrPsr.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbeHIPOrPsr = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbeHIPOrPsr.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbeHIPOrPsr.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbePOrPsrInternes = new Courbe(PLUIES, 0.0, 1.0);
        this.fCourbePOrPsrInternes.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbePOrPsrInternes.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbePsr = new Courbe(PSR, 0.0, 1.0);
        this.fCourbePsr.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbePsr.setCouleur(Styles.COULEURS_COURBE_PSR);
        this.fSimulatedCourbes.add(this.fCourbePsr);
        this.fCourbePsrT = new Courbe(PSR, 0.0, 1.0);
        this.fCourbePsrT.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbePsrT.setCouleur(Styles.COULEURS_COURBE_PSR);
        this.fSimulatedCourbes.add(this.fCourbePsrT);
        this.fCourbePsrInternes = new Courbe(PSR, 0.0, 1.0);
        this.fCourbePsrInternes.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbePsrInternes.setCouleur(Styles.COULEURS_COURBE_PSR);
        this.fSimulatedCourbes.add(this.fCourbePsrInternes);
        this.fCourbeHPsr = new Courbe(PSR, 0.0, 1.0);
        this.fCourbeHPsr.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE));
        this.fCourbeHPsr.setCouleur(Styles.COULEURS_COURBE_PSR);
        this.fSimulatedCourbes.add(this.fCourbeHPsr);
        this.fCourbeET = new Courbe(ET, 0.0, 1.0);
        this.fCourbeET.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeET.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbeETT = new Courbe(ET, 0.0, 1.0);
        this.fCourbeETT.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeETT.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbeETInternes = new Courbe(ET, 0.0, 1.0);
        this.fCourbeETInternes.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeETInternes.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbeHET = new Courbe(ET, 0.0, 1.0);
        this.fCourbeETInternes.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeHET.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbeETOrPET = new Courbe("ET", 0.0, 1.0);
        this.fCourbeETOrPET.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbeETOrPET.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbeHETOrPET = new Courbe("ET", 0.0, 1.0);
        this.fCourbeHETOrPET.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbeHETOrPET.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbeHIETOrPET = new Courbe("ET", 0.0, 1.0);
        this.fCourbeHIETOrPET.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbeHIETOrPET.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbeETOrPETInternes = new Courbe("ET", 0.0, 1.0);
        this.fCourbeETOrPETInternes.setCouleur(Styles.COULEURS_COURBE_PLUIES);
        this.fCourbeETOrPETInternes.setCouleur(Styles.COULEURS_COURBE_ET);
        this.fCourbePET = new Courbe(PET, 0.0, 1.0);
        this.fCourbePET.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbePET.setCouleur(Styles.COULEURS_COURBE_PET);
        this.fSimulatedCourbes.add(this.fCourbePET);
        this.fCourbePETT = new Courbe(PET, 0.0, 1.0);
        this.fCourbePETT.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbePETT.setCouleur(Styles.COULEURS_COURBE_PET);
        this.fSimulatedCourbes.add(this.fCourbePETT);
        this.fCourbePETInternes = new Courbe(PET, 0.0, 1.0);
        this.fCourbePETInternes.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbePETInternes.setCouleur(Styles.COULEURS_COURBE_PET);
        this.fSimulatedCourbes.add(this.fCourbePETInternes);
        this.fCourbeHPET = new Courbe(PET, 0.0, 1.0);
        this.fCourbeETInternes.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeHPET.setCouleur(Styles.COULEURS_COURBE_PET);
        this.fSimulatedCourbes.add(this.fCourbeHPET);
        this.fCourbeQpumpL = new Courbe(DEBIT_POMPE + " " + Messages.getString("L.name"), 0.0, 1.0);
        this.fCourbeQpumpL.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQpumpL.setCouleur(Styles.COULEURS_COURBE_QPUMP_L);
        this.fCourbeQpumpM = new Courbe(DEBIT_POMPE + " " + Messages.getString("M.name"), 0.0, 1.0);
        this.fCourbeQpumpM.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQpumpM.setCouleur(Styles.COULEURS_COURBE_QPUMP_M);
        this.fCourbeQpumpC = new Courbe(DEBIT_POMPE + " " + Messages.getString("C.name"), 0.0, 1.0);
        this.fCourbeQpumpC.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQpumpC.setCouleur(Styles.COULEURS_COURBE_QPUMP_C);
        this.fCourbeQpumpS = new Courbe(DEBIT_POMPE + " " + Messages.getString("S.name"), 0.0, 1.0);
        this.fCourbeQpumpS.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQpumpS.setCouleur(Styles.COULEURS_COURBE_QPUMP_S);
        this.fCourbeQsinkL = new Courbe(DEBIT_APPORT + " " + Messages.getString("L.name"), 0.0, 1.0);
        this.fCourbeQsinkL.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsinkL.setCouleur(Styles.COULEURS_COURBE_QSINK_L);
        this.fCourbeQsinkM = new Courbe(DEBIT_APPORT + " " + Messages.getString("M.name"), 0.0, 1.0);
        this.fCourbeQsinkM.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsinkM.setCouleur(Styles.COULEURS_COURBE_QSINK_M);
        this.fCourbeQsinkC = new Courbe(DEBIT_APPORT + " " + Messages.getString("C.name"), 0.0, 1.0);
        this.fCourbeQsinkC.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsinkC.setCouleur(Styles.COULEURS_COURBE_QSINK_C);
        this.fCourbeQsinkS = new Courbe(DEBIT_APPORT + " " + Messages.getString("S.name"), 0.0, 1.0);
        this.fCourbeQsinkS.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsinkS.setCouleur(Styles.COULEURS_COURBE_QSINK_S);
        this.fCourbeQobs = new Courbe(DEBIT_OBSERVE, 0.0, 1.0);
        this.fCourbeQobs.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQobs.setCouleur(Styles.COULEURS_COURBE_QOBS);
        this.fCourbeQobsInterne = new Courbe(DEBIT_OBSERVE, 0.0, 1.0);
        this.fCourbeQobsInterne.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQobsInterne.setCouleur(Styles.COULEURS_COURBE_QOBS);
        this.fCourbeHQobs = new Courbe(DEBIT_OBSERVE, 0.0, 1.0);
        this.fCourbeHQobs.setCouleur(Styles.COULEURS_COURBE_QOBS);
        this.fLigneZ0E = new CourbeConstante("<html>Z<sub>0E</sub></html>", 0.0, 1.0);
        this.fLigneZ0E.setCouleur(Styles.COULEURS_COURBE_Z0_E);
        this.fLigneZ0L = new CourbeConstante("<html>Z<sub>0L</sub></html>", 0.0, 1.0);
        this.fLigneZ0L.setCouleur(Styles.COULEURS_COURBE_Z0_L);
        this.fLigneZ0M = new CourbeConstante("<html>Z<sub>0M</sub></html>", 0.0, 1.0);
        this.fLigneZ0M.setCouleur(Styles.COULEURS_COURBE_Z0_M);
        this.fLigneZ0C = new CourbeConstante("<html>Z<sub>0C</sub></html>", 0.0, 1.0);
        this.fLigneZ0C.setCouleur(Styles.COULEURS_COURBE_Z0_C);
        this.fCourbeZobsE = new Courbe("Observed piezometry " + Messages.getString("piezoE.varName"), 0.0, 1.0);
        this.fCourbeZobsE.setCouleur(Styles.COULEURS_COURBE_Z_OBS_E);
        this.fCourbeZobsL = new Courbe("Observed piezometry " + Messages.getString("piezoL.varName"), 0.0, 1.0);
        this.fCourbeZobsL.setCouleur(Styles.COULEURS_COURBE_Z_OBS_L);
        this.fCourbeZobsM = new Courbe("Observed piezometry " + Messages.getString("piezoM.varName"), 0.0, 1.0);
        this.fCourbeZobsM.setCouleur(Styles.COULEURS_COURBE_Z_OBS_M);
        this.fCourbeZobsC = new Courbe("Observed piezometry " + Messages.getString("piezoC.varName"), 0.0, 1.0);
        this.fCourbeZobsC.setCouleur(Styles.COULEURS_COURBE_Z_OBS_C);
        this.fCourbeQsim = new Courbe(DEBIT_CALCULE, 0.0, 1.0);
        this.fCourbeQsim.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsim.setCouleur(Styles.COULEURS_COURBE_QSIM);
        this.fSimulatedCourbes.add(this.fCourbeQsim);
        this.fCourbeETEff = new Courbe(ET_EFF, 0.0, 1.0);
        this.fCourbeETEff.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeETEff.setCouleur(Styles.COULEURS_COURBE_ET_EFF);
        this.fSimulatedCourbes.add(this.fCourbeETEff);
        this.fCourbeETEffT = new Courbe(ET_EFF, 0.0, 1.0);
        this.fCourbeETEffT.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeETEffT.setCouleur(Styles.COULEURS_COURBE_ET_EFF);
        this.fSimulatedCourbes.add(this.fCourbeETEffT);
        this.fCourbeQsimInterne = new Courbe(DEBIT_CALCULE, 0.0, 1.0);
        this.fCourbeQsimInterne.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsimInterne.setCouleur(Styles.COULEURS_COURBE_QSIM);
        this.fSimulatedCourbes.add(this.fCourbeQsimInterne);
        this.fCourbeHQsim = new Courbe(DEBIT_CALCULE, 0.0, 1.0);
        this.fCourbeHQsim.setCouleur(Styles.COULEURS_COURBE_QSIM);
        this.fSimulatedCourbes.add(this.fCourbeHQsim);
        this.fCourbeHauteurE = new Courbe(Utils.addHtmlTag(Messages.getString("waterLevelIn") + " " + Messages.getString("E.htmlName")), 0.0, 1.0);
        this.fCourbeHauteurE.setCouleur(Styles.COULEURS_COURBE_HAUTEUR_E);
        this.fSimulatedCourbes.add(this.fCourbeHauteurE);
        this.fCourbeHauteurL = new Courbe(Utils.addHtmlTag(Messages.getString("waterLevelIn") + " " + Messages.getString("L.htmlName")), 0.0, 1.0);
        this.fCourbeHauteurL.setCouleur(Styles.COULEURS_COURBE_HAUTEUR_L);
        this.fSimulatedCourbes.add(this.fCourbeHauteurL);
        this.fCourbeHauteurM = new Courbe(Utils.addHtmlTag(Messages.getString("waterLevelIn") + " " + Messages.getString("M.htmlName")), 0.0, 1.0);
        this.fCourbeHauteurM.setCouleur(Styles.COULEURS_COURBE_HAUTEUR_M);
        this.fSimulatedCourbes.add(this.fCourbeHauteurM);
        this.fCourbeHauteurC = new Courbe(Utils.addHtmlTag(Messages.getString("waterLevelIn") + " " + Messages.getString("C.htmlName")), 0.0, 1.0);
        this.fCourbeHauteurC.setCouleur(Styles.COULEURS_COURBE_HAUTEUR_C);
        this.fSimulatedCourbes.add(this.fCourbeHauteurC);
        this.fCourbeZsimE = new Courbe(Utils.addHtmlTag("Simulated piezometry " + Messages.getString("piezoE.varName")), 0.0, 1.0);
        this.fCourbeZsimE.setCouleur(Styles.COULEURS_COURBE_Z_SIM_E);
        this.fSimulatedCourbes.add(this.fCourbeZsimE);
        this.fCourbeZsimL = new Courbe(Utils.addHtmlTag("Simulated piezometry " + Messages.getString("piezoL.varName")), 0.0, 1.0);
        this.fCourbeZsimL.setCouleur(Styles.COULEURS_COURBE_Z_SIM_L);
        this.fSimulatedCourbes.add(this.fCourbeZsimL);
        this.fCourbeZsimM = new Courbe(Utils.addHtmlTag("Simulated piezometry " + Messages.getString("piezoM.varName")), 0.0, 1.0);
        this.fCourbeZsimM.setCouleur(Styles.COULEURS_COURBE_Z_SIM_M);
        this.fSimulatedCourbes.add(this.fCourbeZsimM);
        this.fCourbeZsimC = new Courbe(Utils.addHtmlTag("Simulated piezometry " + Messages.getString("piezoC.varName")), 0.0, 1.0);
        this.fCourbeZsimC.setCouleur(Styles.COULEURS_COURBE_Z_SIM_C);
        this.fSimulatedCourbes.add(this.fCourbeZsimC);
        this.fCourbeQEM = new Courbe(Messages.getHtmlString("QEM.htmlName"), 0.0, 1.0);
        this.fCourbeQEM.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQEM.setCouleur(Styles.COULEURS_COURBE_QLEM);
        this.fSimulatedCourbes.add(this.fCourbeQEM);
        this.fCourbeQEL = new Courbe(Messages.getHtmlString("QEL.htmlName"), 0.0, 1.0);
        this.fCourbeQEL.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQEL.setCouleur(Styles.COULEURS_COURBE_QLEL);
        this.fSimulatedCourbes.add(this.fCourbeQEL);
        this.fCourbeQE = new Courbe(Messages.getHtmlString("QE.htmlName"), 0.0, 1.0);
        this.fCourbeQE.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQE.setCouleur(Styles.COULEURS_COURBE_QLEC);
        this.fSimulatedCourbes.add(this.fCourbeQE);
        this.fCourbeQEC = new Courbe(Messages.getHtmlString("QEC.htmlName"), 0.0, 1.0);
        this.fCourbeQEC.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQEC.setCouleur(Styles.COULEURS_COURBE_QLEC);
        this.fSimulatedCourbes.add(this.fCourbeQEC);
        this.fCourbeQES = new Courbe(Messages.getHtmlString("QES.htmlName"), 0.0, 1.0);
        this.fCourbeQES.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQES.setCouleur(Styles.COULEURS_COURBE_QLES);
        this.fSimulatedCourbes.add(this.fCourbeQES);
        this.fCourbeQhyEC = new Courbe(Messages.getHtmlString("QhyEC.htmlName"), 0.0, 1.0);
        this.fCourbeQhyEC.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQhyEC.setCouleur(Styles.COULEURS_COURBE_QHYEC);
        this.fSimulatedCourbes.add(this.fCourbeQhyEC);
        this.fCourbeQhyES = new Courbe(Messages.getHtmlString("QhyES.htmlName"), 0.0, 1.0);
        this.fCourbeQhyES.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQhyES.setCouleur(Styles.COULEURS_COURBE_QHYES);
        this.fSimulatedCourbes.add(this.fCourbeQhyES);
        this.fCourbeQLS = new Courbe(Messages.getHtmlString("QLS.htmlName"), 0.0, 1.0);
        this.fCourbeQLS.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQLS.setCouleur(Styles.COULEURS_COURBE_QLCS);
        this.fSimulatedCourbes.add(this.fCourbeQLS);
        this.fCourbeQMS = new Courbe(Messages.getHtmlString("QMS.htmlName"), 0.0, 1.0);
        this.fCourbeQMS.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQMS.setCouleur(Styles.COULEURS_COURBE_QLMS);
        this.fSimulatedCourbes.add(this.fCourbeQMS);
        this.fCourbeQMC = new Courbe(Messages.getHtmlString("QMC.htmlName"), 0.0, 1.0);
        this.fCourbeQMC.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQMC.setCouleur(Styles.COULEURS_COURBE_QEMC);
        this.fSimulatedCourbes.add(this.fCourbeQMC);
        this.fCourbeQCS = new Courbe(Messages.getHtmlString("QCS.htmlName"), 0.0, 1.0);
        this.fCourbeQCS.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQCS.setCouleur(Styles.COULEURS_COURBE_QLCS);
        this.fSimulatedCourbes.add(this.fCourbeQCS);
        this.fCourbeQloss = new Courbe("<html>" + Messages.getString("Qloss.htmlName") + "</html>", 0.0, 1.0);
        this.fCourbeQloss.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQloss);
        this.fCourbeQrEloss = new Courbe("<html>Q<sub>r" + this.fModel.getReservoirE().getHtmlLabel() + "_loss</sub></html>", 0.0, 1.0);
        this.fCourbeQrEloss.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQrEloss);
        this.fCourbeQrLloss = new Courbe("<html>Q<sub>r" + this.fModel.getReservoirL().getHtmlLabel() + "_loss</sub></html>", 0.0, 1.0);
        this.fCourbeQrLloss.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQrLloss);
        this.fCourbeQbL = new Courbe("<html>" + Messages.getString("Qb.htmlName").replace("@@from", this.fModel.getReservoirL().getHtmlLabel()).replaceAll("@@to", this.fModel.getExutoire().getHtmlLabel()) + "</html>", 0.0, 1.0);
        this.fCourbeQbL.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQbL.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQbL);
        this.fCourbeQrL = new Courbe("<html>" + Messages.getString("Qr.htmlName").replace("@@from", this.fModel.getReservoirL().getHtmlLabel()).replaceAll("@@to", this.fModel.getExutoire().getHtmlLabel()) + "</html>", 0.0, 1.0);
        this.fCourbeQrL.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQrL.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQrL);
        this.fCourbeQrMloss = new Courbe("<html>Q<sub>r" + this.fModel.getReservoirM().getHtmlLabel() + "_loss</sub></html>", 0.0, 1.0);
        this.fCourbeQrMloss.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQrMloss);
        this.fCourbeQbM = new Courbe("<html>" + Messages.getString("Qb.htmlName").replace("@@from", this.fModel.getReservoirM().getHtmlLabel()).replaceAll("@@to", this.fModel.getExutoire().getHtmlLabel()) + "</html>", 0.0, 1.0);
        this.fCourbeQbM.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQbM.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQbM);
        this.fCourbeQrM = new Courbe("<html>" + Messages.getString("Qr.htmlName").replace("@@from", this.fModel.getReservoirM().getHtmlLabel()).replaceAll("@@to", this.fModel.getExutoire().getHtmlLabel()) + "</html>", 0.0, 1.0);
        this.fCourbeQrM.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQrM.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQrM);
        this.fCourbeQrCloss = new Courbe("<html>Q<sub>r" + this.fModel.getReservoirC().getHtmlLabel() + "_loss</sub></html>", 0.0, 1.0);
        this.fCourbeQrCloss.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQrCloss);
        this.fCourbeQbC = new Courbe("<html>" + Messages.getString("Qb.htmlName").replace("@@from", this.fModel.getReservoirC().getHtmlLabel()).replaceAll("@@to", this.fModel.getExutoire().getHtmlLabel()) + "</html>", 0.0, 1.0);
        this.fCourbeQbC.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQbC.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQbC);
        this.fCourbeQrC = new Courbe("<html>" + Messages.getString("Qr.htmlName").replace("@@from", this.fModel.getReservoirC().getHtmlLabel()).replaceAll("@@to", this.fModel.getExutoire().getHtmlLabel()) + "</html>", 0.0, 1.0);
        this.fCourbeQrC.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQrC.setCouleur(Styles.COULEURS_COURBE_QRE);
        this.fSimulatedCourbes.add(this.fCourbeQrC);
        this.fCourbeQprob = new Courbe(Messages.getHtmlString("Qprob.htmlName"), 0.0, 1.0);
        this.fCourbeQprob.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQprob.setCouleur(Styles.COULEURS_COURBE_QPROB);
        this.fSimulatedCourbes.add(this.fCourbeQprob);
        this.fCourbeQsimMin = new Courbe(Messages.getString("JResults.36"), 0.0, 1.0);
        this.fCourbeQsimMin.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsimMin.setCouleur(Styles.COULEURS_COURBE_QCALCMIN);
        this.fCourbeQsimMin.setTypeDessin(new PolyLigne());
        this.fCourbeQsimMin.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{4.0f, 2.0f}, 0.0f));
        this.fSimulatedCourbes.add(this.fCourbeQsimMin);
        this.fCourbeQsimMax = new Courbe(Messages.getString("JResults.37"), 0.0, 1.0);
        this.fCourbeQsimMax.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
        this.fCourbeQsimMax.setCouleur(Styles.COULEURS_COURBE_QCALCMAX);
        this.fCourbeQsimMax.setTypeDessin(new PolyLigne());
        this.fCourbeQsimMax.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{4.0f, 2.0f}, 0.0f));
        this.fSimulatedCourbes.add(this.fCourbeQsimMax);
        for (final Varname varname : Varname.values()) {
            final Courbe courbeBas = new Courbe(varname + " " + Messages.getString("JResults.44") + " low", 0.0, 1.0);
            courbeBas.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
            courbeBas.setCouleur(Styles.COULEURS_COURBE_CI.get((Object)varname));
            courbeBas.setTypeDessin(new PolyLigne());
            courbeBas.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 1.0f}, 0.0f));
            courbeBas.setVisibleInMenu(false);
            this.fSimulatedCourbes.add(courbeBas);
            Courbe courbeHaut = new Courbe(varname + " " + Messages.getString("JResults.44") + " high", 0.0, 1.0){

                @Override
                public void setVisible(boolean etat) {
                    super.setVisible(etat);
                    courbeBas.setVisible(etat);
                }

                @Override
                public String getNomLegende() {
                    return varname + " " + Messages.getString("JResults.44");
                }
            };
            courbeBas.setActive(false);
            courbeHaut.setActive(false);
            courbeHaut.setTypeDessin(new PolyLigneCreneau(PositionBarreHistogramme.DROITE));
            courbeHaut.setCouleur(Styles.COULEURS_COURBE_CI.get((Object)varname));
            courbeHaut.setTypeDessin(new Surface(courbeBas, Styles.COULEUR_FOND_COURBE_CI.get((Object)varname)));
            courbeHaut.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 1.0f}, 0.0f));
            this.fSimulatedCourbes.add(courbeHaut);
            this.fCourbesCI.put(varname, new CourbesCI(courbeHaut, courbeBas));
        }
    }

    private void loadData() {
        this.fCourbeT.setValuesDirect(this.fInputData.getValues(ColumnName.T));
        this.fCourbeSrad.setValuesDirect(this.fInputData.getValues(ColumnName.SRAD));
        this.fCourbeHET.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeETInternes.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeET.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeETT.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeETOrPET.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeHETOrPET.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeHIETOrPET.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeETOrPETInternes.setValuesDirect(this.fInputData.getValues(ColumnName.ET));
        this.fCourbeHP.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbePInternes.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbeQlossObs.setValuesDirect(this.fInputData.getValues(ColumnName.QLOSS));
        this.fCourbeP.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbePT.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbePOrPsr.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbeHPOrPsr.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbeHIPOrPsr.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbePOrPsrInternes.setValuesDirect(this.fInputData.getValues(ColumnName.P));
        this.fCourbeQpumpC.setValuesDirect(this.fInputData.getValues(ColumnName.QPUMPC));
        this.fCourbeQpumpM.setValuesDirect(this.fInputData.getValues(ColumnName.QPUMPM));
        this.fCourbeQpumpL.setValuesDirect(this.fInputData.getValues(ColumnName.QPUMPL));
        this.fCourbeQpumpS.setValuesDirect(this.fInputData.getValues(ColumnName.QPUMPS));
        this.fCourbeQsinkC.setValuesDirect(this.fInputData.getValues(ColumnName.QSINKC));
        this.fCourbeQsinkM.setValuesDirect(this.fInputData.getValues(ColumnName.QSINKM));
        this.fCourbeQsinkL.setValuesDirect(this.fInputData.getValues(ColumnName.QSINKL));
        this.fCourbeQsinkS.setValuesDirect(this.fInputData.getValues(ColumnName.QSINKS));
        this.fCourbeQobs.setValuesDirect(this.fInputData.getValues(ColumnName.QOBSS));
        this.fCourbeZobsE.setValuesDirect(this.fInputData.getValues(ColumnName.ZOBSE));
        this.fCourbeZobsL.setValuesDirect(this.fInputData.getValues(ColumnName.ZOBSL));
        this.fCourbeZobsM.setValuesDirect(this.fInputData.getValues(ColumnName.ZOBSM));
        this.fCourbeZobsC.setValuesDirect(this.fInputData.getValues(ColumnName.ZOBSC));
        this.fCourbeQobsInterne.setValuesDirect(this.fInputData.getValues(ColumnName.QOBSS));
        this.fCourbeHQobs.setValuesDirect(this.fInputData.getValues(ColumnName.QOBSS));
        this.fTableauSSI.setValues(new HashMap<Parameter, SensitivityIndexes>());
        this.fGraphiqueSSI.maj(new HashMap<Parameter, ParameterSSI>(), false);
    }

    private void majOutputLabels() {
        String temperatureUnit = " (" + Messages.getString("BaseUnite.11") + ")";
        String etUnit = " (" + Messages.getString("BaseUnite.1") + ")";
        String rainfallUnit = " (" + Messages.getString("BaseUnite.1") + ")";
        String piezoUnit = " (" + Messages.getString("BaseUnite.10") + ")";
        String levelUnit = " (" + Messages.getString("BaseUnite.10") + ")";
        String dischargeUnit = " (" + Messages.getString("BaseUnite.9") + ")";
        this.fCourbeT.setOutputLabel(Messages.getString("temperature.name") + temperatureUnit);
        this.fCourbeSrad.setOutputLabel("Srad W/m\u00b2" + temperatureUnit);
        this.fCourbeQlossObs.setOutputLabel(DEBIT_OBSERVE + " " + Messages.getString("Qloss.name") + dischargeUnit);
        this.fCourbeQlossSim.setOutputLabel(DEBIT_CALCULE + " " + Messages.getString("Qloss.name") + dischargeUnit);
        this.fCourbeP.setOutputLabel(Messages.getString("pluie.name") + rainfallUnit);
        this.fCourbeP.setOutputLabel(Messages.getString("pluie.name") + rainfallUnit);
        this.fCourbePT.setOutputLabel(Messages.getString("pluie.name") + rainfallUnit);
        this.fCourbePInternes.setOutputLabel(Messages.getString("pluie.name") + rainfallUnit);
        this.fCourbeHP.setOutputLabel(Messages.getString("pluie.name") + rainfallUnit);
        this.fCourbePsr.setOutputLabel(Messages.getString("psr.name") + rainfallUnit);
        this.fCourbePsrT.setOutputLabel(Messages.getString("psr.name") + rainfallUnit);
        this.fCourbePsrInternes.setOutputLabel(Messages.getString("psr.name") + rainfallUnit);
        this.fCourbeHPsr.setOutputLabel(Messages.getString("psr.name") + rainfallUnit);
        this.fCourbeET.setOutputLabel(Messages.getString("evapotranspiration.name") + etUnit);
        this.fCourbeETT.setOutputLabel(Messages.getString("evapotranspiration.name") + etUnit);
        this.fCourbeETInternes.setOutputLabel(Messages.getString("evapotranspiration.name") + etUnit);
        this.fCourbeHET.setOutputLabel(Messages.getString("evapotranspiration.name") + etUnit);
        this.fCourbePET.setOutputLabel(Messages.getString("PET.name") + etUnit);
        this.fCourbePETT.setOutputLabel(Messages.getString("PET.name") + etUnit);
        this.fCourbePETInternes.setOutputLabel(Messages.getString("PET.name") + etUnit);
        this.fCourbeHPET.setOutputLabel(Messages.getString("PET.name") + etUnit);
        this.fCourbeQpumpC.setOutputLabel(DEBIT_POMPE + " " + Messages.getString("C.name") + dischargeUnit);
        this.fCourbeQpumpM.setOutputLabel(DEBIT_POMPE + " " + Messages.getString("M.name") + dischargeUnit);
        this.fCourbeQpumpL.setOutputLabel(DEBIT_POMPE + " " + Messages.getString("L.name") + dischargeUnit);
        this.fCourbeQpumpS.setOutputLabel(DEBIT_POMPE + " " + Messages.getString("S.name") + dischargeUnit);
        this.fCourbeQsinkC.setOutputLabel(DEBIT_APPORT + " " + Messages.getString("C.name") + dischargeUnit);
        this.fCourbeQsinkM.setOutputLabel(DEBIT_APPORT + " " + Messages.getString("M.name") + dischargeUnit);
        this.fCourbeQsinkL.setOutputLabel(DEBIT_APPORT + " " + Messages.getString("L.name") + dischargeUnit);
        this.fCourbeQsinkS.setOutputLabel(DEBIT_APPORT + " " + Messages.getString("S.name") + dischargeUnit);
        this.fCourbeQobs.setOutputLabel(DEBIT_OBSERVE + dischargeUnit);
        this.fCourbeQobsInterne.setOutputLabel(DEBIT_OBSERVE + dischargeUnit);
        this.fCourbeHQobs.setOutputLabel(DEBIT_OBSERVE + dischargeUnit);
        this.fCourbeQsim.setOutputLabel(DEBIT_CALCULE + dischargeUnit);
        this.fCourbeETEff.setOutputLabel(ET_EFF + etUnit);
        this.fCourbeETEffT.setOutputLabel(ET_EFF + etUnit);
        this.fCourbeQsimInterne.setOutputLabel(DEBIT_CALCULE + dischargeUnit);
        this.fCourbeHQsim.setOutputLabel(DEBIT_CALCULE + dischargeUnit);
        this.fCourbeHauteurE.setOutputLabel(Messages.getString("waterLevelIn") + " " + Messages.getString("E.name") + levelUnit);
        this.fCourbeHauteurL.setOutputLabel(Messages.getString("waterLevelIn") + " " + Messages.getString("L.name") + levelUnit);
        this.fCourbeHauteurM.setOutputLabel(Messages.getString("waterLevelIn") + " " + Messages.getString("M.name") + levelUnit);
        this.fCourbeHauteurC.setOutputLabel(Messages.getString("waterLevelIn") + " " + Messages.getString("C.name") + levelUnit);
        this.fCourbeZsimE.setOutputLabel(Messages.getString("piezometryIn") + " " + Messages.getString("piezoE.varName") + piezoUnit);
        this.fCourbeZsimL.setOutputLabel(Messages.getString("piezometryIn") + " " + Messages.getString("piezoL.varName") + piezoUnit);
        this.fCourbeZsimM.setOutputLabel(Messages.getString("piezometryIn") + " " + Messages.getString("piezoM.varName") + piezoUnit);
        this.fCourbeZsimC.setOutputLabel(Messages.getString("piezometryIn") + " " + Messages.getString("piezoC.varName") + piezoUnit);
        this.fCourbeQEM.setOutputLabel(Messages.getString("QEM.name") + dischargeUnit);
        this.fCourbeQEL.setOutputLabel(Messages.getString("QEL.name") + dischargeUnit);
        this.fCourbeQEC.setOutputLabel(Messages.getString("QEC.name") + dischargeUnit);
        this.fCourbeQE.setOutputLabel(Messages.getString("QE.name") + dischargeUnit);
        this.fCourbeQES.setOutputLabel(Messages.getString("QES.name") + dischargeUnit);
        this.fCourbeQhyEC.setOutputLabel(Messages.getString("QhyEC.name") + dischargeUnit);
        this.fCourbeQhyES.setOutputLabel(Messages.getString("QhyES.name") + dischargeUnit);
        this.fCourbeQLS.setOutputLabel(Messages.getString("QLS.name") + dischargeUnit);
        this.fCourbeQMS.setOutputLabel(Messages.getString("QMS.name") + dischargeUnit);
        this.fCourbeQMC.setOutputLabel(Messages.getString("QMC.name") + dischargeUnit);
        this.fCourbeQCS.setOutputLabel(Messages.getString("QCS.name") + dischargeUnit);
        this.fCourbeQloss.setOutputLabel(Messages.getString("Qloss.name") + this.fModel.getReservoirE().getName() + dischargeUnit);
        this.fCourbeQrLloss.setOutputLabel("Qr" + this.fModel.getReservoirE().getName() + "_loss" + dischargeUnit);
        this.fCourbeQrLloss.setOutputLabel("Qr" + this.fModel.getReservoirL().getName() + "_loss" + dischargeUnit);
        this.fCourbeQrMloss.setOutputLabel("Qr" + this.fModel.getReservoirM().getName() + "_loss" + dischargeUnit);
        this.fCourbeQrCloss.setOutputLabel("Qr" + this.fModel.getReservoirC().getName() + "_loss" + dischargeUnit);
        this.fCourbeQprob.setOutputLabel(Messages.getString("Qprob.name") + dischargeUnit);
        LabelFormatter formatter = new LabelFormatter(this.fInputData.getDateLabels());
        this.fGraphiquePluiesDebits.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
        this.fGraphiqueTAndET.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
        this.fGraphiquePluiesDebitsInternes.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
        this.fGraphiquePluiesHauteurs.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
        this.fGraphiquePluiesHauteursInternes.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
        this.fGraphiqueCumulsVolumes.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
        this.fGraphiqueBilanMasse.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
        this.fGraphiqueQSimMoinsQobs.getRepere(0).getAxeH().getGraduation().setFormatter(formatter);
    }

    public JGraphiquePluiesDebits getGraphiquePluiesDebits() {
        return this.fGraphiquePluiesDebits;
    }

    public JGraphiquePluiesHauteursInternes getGraphiquePluiesHauteursInternes() {
        return this.fGraphiquePluiesHauteursInternes;
    }

    public JGraphiquePluiesHauteurs getGraphiquePluiesHauteurs() {
        return this.fGraphiquePluiesHauteurs;
    }

    public JGraphiquePluiesDebitsInternes getGraphiquePluiesDebitsInternes() {
        return this.fGraphiquePluiesDebitsInternes;
    }

    public JGraphiqueParametres getGraphiqueParametres() {
        return this.fGraphiqueParametres;
    }

    private void stagesUpdated() {
        FondPlage oldChauffe = this.fChauffe.clone();
        FondPlage oldCalibration = this.fCalibration.clone();
        FondPlage oldValidation = this.fValidation.clone();
        this.fChauffe.getPlages().clear();
        this.fCalibration.getPlages().clear();
        this.fValidation.getPlages().clear();
        ResultsPaneController.updateStages(this.fCalibration, this.fRunParameters.getCalibrationStages());
        ResultsPaneController.updateStages(this.fValidation, this.fRunParameters.getValidationStages());
        Plage pChauffe = new Plage(this.fRunParameters.getWarmupBeginning(), Math.min(this.fCalibration.getMin(), this.fValidation.getMin()) - 1);
        if (this.fChauffe.getPlages().size() != 1 || !this.fChauffe.getPlages().get(0).equals(pChauffe)) {
            this.fChauffe.getPlages().add(pChauffe);
        }
        if (!this.fRunParameters.isValid() || oldChauffe.equals(this.fChauffe) && oldCalibration.equals(this.fCalibration) && oldValidation.equals(this.fValidation)) {
            return;
        }
        this.repaintSelectedTab();
    }

    private void inputDataChanged() {
        this.fRunParameters.validate();
        this.loadData();
        this.fCourbeT.setActive(this.fInputData.contains(ColumnName.T));
        this.fCourbeSrad.setActive(this.fInputData.contains(ColumnName.SRAD));
        this.fCourbeET.setActive(this.fInputData.contains(ColumnName.ET));
        this.clearQsim(true);
        this.majOutputLabels();
        this.fGraphiqueCumulsVolumes.maj();
        this.fGraphiqueQSimVsObs.maj();
        this.fGraphiqueQLossSimVsObs.maj();
        this.fGraphiqueQSimMoinsQobs.maj();
        this.fGraphiqueBilanMasse.maj(this.fModel.getExutoire().getRa(), this.fInputData.getIOShift());
        this.fGraphiqueDebitsClassesCalibration.maj();
        this.fGraphiqueDebitsClassesValidation.maj();
        this.fGraphiqueXCorrPluieDebitCalibration.maj();
        this.fGraphiqueXCorrPluieDebitValidation.maj();
        this.fGraphiqueCumulsVolumes.setZoom(1.0, 1.0);
        this.fGraphiqueQSimVsObs.setZoom(1.0, 1.0);
        this.fGraphiqueQLossSimVsObs.setZoom(1.0, 1.0);
        this.fGraphiqueQSimMoinsQobs.setZoom(1.0, 1.0);
        this.fGraphiqueBilanMasse.setZoom(1.0, 1.0);
        this.fGraphiqueDebitsClassesCalibration.setZoom(1.0, 1.0);
        this.fGraphiqueDebitsClassesValidation.setZoom(1.0, 1.0);
        this.fGraphiqueXCorrPluieDebitCalibration.setZoom(1.0, 1.0);
        this.fGraphiqueXCorrPluieDebitValidation.setZoom(1.0, 1.0);
        this.fGraphiquePluiesDebits.ajuster();
        this.fGraphiqueTAndET.ajuster();
        this.fGraphiquePluiesHauteurs.ajuster();
        this.fGraphiquePluiesHauteursInternes.ajuster();
        this.fGraphiquePluiesDebitsInternes.ajuster();
        this.fGraphiquePluiesDebits.setZoom(1.0, 1.0);
        this.fGraphiquePluiesHauteurs.setZoom(1.0, 1.0);
        this.fGraphiquePluiesHauteursInternes.setZoom(1.0, 1.0);
        this.fGraphiquePluiesDebitsInternes.setZoom(1.0, 1.0);
        this.fGraphiqueTAndET.setZoom(1.0, 1.0);
        this.updatePiezoGraphVisibility();
        this.repaintSelectedTab();
        this.fitToPeriod();
    }

    public void clearQsim(boolean pClearGraphiqueParameters) {
        for (Courbe c : this.fSimulatedCourbes) {
            c.clearDirect();
        }
        this.fGraphiqueBilanMasse.clear();
        this.fGraphiqueCumulsVolumes.clear();
        this.fGraphiqueDebitsClassesCalibration.clear();
        this.fGraphiqueDebitsClassesValidation.clear();
        this.fPanelObj1VsObj2.clear();
        this.fGraphiqueObjCalVsObjVal.clear();
        this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration.clear();
        this.fGraphiqueXCorrDebitMesureDebitSimuleValidation.clear();
        this.fGraphiqueXCorrPluieDebitCalibration.clear();
        this.fGraphiqueXCorrPluieDebitValidation.clear();
        if (pClearGraphiqueParameters) {
            this.fGraphiqueParametres.clear();
        }
    }

    public void update(RunMonitor pRunMonitor, WobjRunResults pResults, List<Parameter> pParameters) {
        ProbableDischarge probableDischarge = pRunMonitor.getProbableDischarge();
        SwingUtilities.invokeLater(() -> {
            for (Busyable graphique : new Busyable[]{this.fGraphiqueObjCalVsObjVal, this.fPanelObj1VsObj2, this.fPanelModelEvaluation}) {
                graphique.setBusy("Result computation in progress...");
            }
        });
        this.update(pParameters, pResults, pRunMonitor);
        int nbTasks = Runtime.getRuntime().availableProcessors();
        ExecutorService eservice = Executors.newFixedThreadPool(nbTasks);
        ExecutorCompletionService<Object> cservice = new ExecutorCompletionService<Object>(eservice);
        cservice.submit(() -> {
            this.fGraphiqueBilanMasse.maj(this.fModel.getExutoire().getRa(), this.fInputData.getIOShift());
            this.fGraphiqueBilanMasse.setReady();
            return null;
        });
        cservice.submit(() -> {
            if (probableDischarge != null) {
                this.fCourbeQprob.setValuesDirect(probableDischarge.values());
                this.fCourbeQsimMin.setValuesDirect(probableDischarge.getMinValues());
                this.fCourbeQsimMax.setValuesDirect(probableDischarge.getMaxValues());
            } else {
                this.fCourbeQprob.clearDirect();
                this.fCourbeQsimMin.clearDirect();
                this.fCourbeQsimMax.clearDirect();
            }
            return null;
        });
        cservice.submit(() -> {
            this.fPanelModelEvaluation.setReady();
            this.fPanelModelEvaluation.update(pRunMonitor, this.fRunParameters, this.fInputData.getIOShift());
            return null;
        });
        cservice.submit(() -> {
            this.fPanelObj1VsObj2.setReady();
            this.fPanelObj1VsObj2.update(pResults);
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueObjCalVsObjVal.setReady();
            this.fGraphiqueObjCalVsObjVal.maj(pResults);
            return null;
        });
        eservice.shutdown();
        this.majTabs();
    }

    public void update(List<Parameter> pParameters, WobjRunResults pResults, RunMonitor pRunMonitor) {
        this.fTableauParametres.setParametres(pParameters);
        RunModel runModel = pRunMonitor.getBestRunModel();
        this.fTableauWObj.setResults(pResults, pRunMonitor);
        SwingUtilities.invokeLater(() -> {
            for (Busyable graphique : new Busyable[]{this.fGraphiqueBilanMasse, this.fGraphiqueCumulsVolumes, this.fGraphiqueDebitsClassesCalibration, this.fGraphiqueDebitsClassesValidation, this.fGraphiqueQSimVsObs, this.fGraphiqueQLossSimVsObs, this.fGraphiqueQSimMoinsQobs, this.fGraphiqueXCorrPluieDebitCalibration, this.fGraphiqueXCorrPluieDebitValidation, this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration, this.fGraphiqueXCorrDebitMesureDebitSimuleValidation, this.fGraphiqueAutocorrQCalibration, this.fGraphiqueAutocorrQValidation}) {
                graphique.setBusy("Result computation in progress...");
            }
        });
        String pLabel = this.fModel.getSnowRoutine().isActive() ? "Psr" : "P";
        String etLabel = this.fModel.getPetRoutine().isActive() ? "PET" : "ET";
        this.fGraphiqueXCorrPluieDebitCalibration.getDessin().setTitle("Calibration (" + pLabel + ")");
        this.fGraphiqueXCorrPluieDebitValidation.getDessin().setTitle("Validation (" + pLabel + ")");
        String pName = this.fModel.getSnowRoutine().isActive() ? Messages.getString("psr.name") : Messages.getString("pluie.displayName");
        String etName = this.fModel.getPetRoutine().isActive() ? Messages.getString("PET.name") : Messages.getString("ET.name");
        String heightUnit = " (" + Messages.getString("BaseUnite.1") + ")";
        this.fCourbePOrPsr.setNom(pName);
        this.fCourbePOrPsr.setOutputLabel(pName + heightUnit);
        this.fCourbeHPOrPsr.setNom(pName);
        this.fCourbeHPOrPsr.setOutputLabel(pName + heightUnit);
        this.fCourbeHIPOrPsr.setNom(pName);
        this.fCourbeHIPOrPsr.setOutputLabel(pName + heightUnit);
        this.fCourbePOrPsrInternes.setNom(pName);
        this.fCourbePOrPsrInternes.setOutputLabel(pName + heightUnit);
        this.fCourbeETOrPET.setNom(etName);
        this.fCourbeETOrPET.setOutputLabel(etName + heightUnit);
        this.fCourbeHETOrPET.setNom(etName);
        this.fCourbeHETOrPET.setOutputLabel(etName + heightUnit);
        this.fCourbeHIETOrPET.setNom(etName);
        this.fCourbeHIETOrPET.setOutputLabel(etName + heightUnit);
        this.fCourbeETOrPETInternes.setNom(etName);
        this.fCourbeETOrPETInternes.setOutputLabel(etName + heightUnit);
        this.fCourbeQlossSim.setValuesDirect(runModel.getQlossValues());
        this.fCourbePOrPsr.setValuesDirect(runModel.getPOrPsrValues());
        this.fCourbeHPOrPsr.setValuesDirect(runModel.getPOrPsrValues());
        this.fCourbeHIPOrPsr.setValuesDirect(runModel.getPOrPsrValues());
        this.fCourbePOrPsrInternes.setValuesDirect(runModel.getPOrPsrValues());
        this.fCourbePsr.setValuesDirect(runModel.getPsrValues());
        this.fCourbePsrT.setValuesDirect(runModel.getPsrValues());
        this.fCourbePsrInternes.setValuesDirect(runModel.getPsrValues());
        this.fCourbeHPsr.setValuesDirect(runModel.getPsrValues());
        this.fCourbePET.setValuesDirect(runModel.getPETValues());
        this.fCourbeETOrPET.setValuesDirect(runModel.getETOrPETValues());
        this.fCourbeHETOrPET.setValuesDirect(runModel.getETOrPETValues());
        this.fCourbeHIETOrPET.setValuesDirect(runModel.getETOrPETValues());
        this.fCourbeETOrPETInternes.setValuesDirect(runModel.getETOrPETValues());
        this.fCourbePET.setValuesDirect(runModel.getPETValues());
        this.fCourbePET.setValuesDirect(runModel.getPETValues());
        this.fCourbePETT.setValuesDirect(runModel.getPETValues());
        this.fCourbePETInternes.setValuesDirect(runModel.getPETValues());
        this.fCourbeHPET.setValuesDirect(runModel.getPETValues());
        this.fCourbeQloss.setValuesDirect(runModel.getQlossValues());
        this.fCourbeQrEloss.setValuesDirect(runModel.getQrElossValues());
        this.fCourbeQrLloss.setValuesDirect(runModel.getQrLlossValues());
        this.fCourbeQbL.setValuesDirect(runModel.getQbLValues());
        this.fCourbeQrL.setValuesDirect(runModel.getQrLValues());
        this.fCourbeQrMloss.setValuesDirect(runModel.getQrMlossValues());
        this.fCourbeQbM.setValuesDirect(runModel.getQbMValues());
        this.fCourbeQrM.setValuesDirect(runModel.getQrMValues());
        this.fCourbeQrCloss.setValuesDirect(runModel.getQrClossValues());
        this.fCourbeQbC.setValuesDirect(runModel.getQbCValues());
        this.fCourbeQrC.setValuesDirect(runModel.getQrCValues());
        this.fCourbeQEL.setValuesDirect(runModel.getQELValues());
        this.fCourbeQEM.setValuesDirect(runModel.getQEMValues());
        this.fCourbeQEC.setValuesDirect(runModel.getQECValues());
        this.fCourbeQE.setValuesDirect(runModel.getQEValues());
        this.fCourbeQhyEC.setValuesDirect(runModel.getQhyECValues());
        this.fCourbeQES.setValuesDirect(runModel.getQESValues());
        this.fCourbeQhyES.setValuesDirect(runModel.getQhyESValues());
        this.fCourbeQMC.setValuesDirect(runModel.getQMCValues());
        this.fCourbeQLS.setValuesDirect(runModel.getQLSValues());
        this.fCourbeQMS.setValuesDirect(runModel.getQMSValues());
        this.fCourbeQCS.setValuesDirect(runModel.getQCSValues());
        this.fCourbeHauteurE.setValuesDirect(runModel.getEValues());
        this.fCourbeHauteurL.setValuesDirect(runModel.getLValues());
        this.fCourbeHauteurM.setValuesDirect(runModel.getMValues());
        this.fCourbeHauteurC.setValuesDirect(runModel.getCValues());
        this.fLigneZ0E.setValue(this.fModel.getReservoirE().getPiezo().getParameter("Z0").getValue(), runModel.getZEValues().length);
        this.fLigneZ0L.setValue(this.fModel.getReservoirL().getPiezo().getParameter("Z0").getValue(), runModel.getZLValues().length);
        this.fLigneZ0M.setValue(this.fModel.getReservoirM().getPiezo().getParameter("Z0").getValue(), runModel.getZMValues().length);
        this.fLigneZ0C.setValue(this.fModel.getReservoirC().getPiezo().getParameter("Z0").getValue(), runModel.getZCValues().length);
        this.fCourbeZsimE.setValuesDirect(runModel.getZEValues());
        this.fCourbeZsimL.setValuesDirect(runModel.getZLValues());
        this.fCourbeZsimM.setValuesDirect(runModel.getZMValues());
        this.fCourbeZsimC.setValuesDirect(runModel.getZCValues());
        this.fCourbeQsim.setValuesDirect(runModel.getQSValues());
        this.fCourbeHQsim.setValuesDirect(runModel.getQSValues());
        this.fCourbeQsimInterne.setValuesDirect(runModel.getQSValues());
        this.fCourbeETEff.setValuesDirect(runModel.getETEffValues());
        this.fCourbeETEffT.setValuesDirect(runModel.getETEffValues());
        for (CourbesCI courbesCI : this.fCourbesCI.values()) {
            courbesCI.bas().clearDirect();
            courbesCI.haut().clearDirect();
        }
        this.fGraphiquePluiesHauteurs.ajusterPlageCourante();
        this.fGraphiquePluiesHauteursInternes.ajusterPlageCourante();
        this.fGraphiquePluiesDebits.ajusterPlageCourante();
        this.fGraphiquePluiesDebitsInternes.ajusterPlageCourante();
        this.fGraphiqueTAndET.ajusterPlageCourante();
        this.swingNode.getContent().repaint();
        for (CourbesCI courbesCI : this.fCourbesCI.values()) {
            courbesCI.bas().setActive(false);
            courbesCI.haut().setActive(false);
        }
        int nbTasks = Runtime.getRuntime().availableProcessors();
        ExecutorService eservice = Executors.newFixedThreadPool(nbTasks);
        ExecutorCompletionService<Object> cservice = new ExecutorCompletionService<Object>(eservice);
        cservice.submit(() -> {
            this.fGraphiqueBilanMasse.maj(this.fModel.getExutoire().getRa(), this.fInputData.getIOShift());
            this.fGraphiqueBilanMasse.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueCumulsVolumes.maj();
            this.fGraphiqueCumulsVolumes.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueDebitsClassesCalibration.maj();
            this.fGraphiqueDebitsClassesCalibration.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueDebitsClassesValidation.maj();
            this.fGraphiqueDebitsClassesValidation.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueQSimVsObs.maj();
            this.fGraphiqueQSimVsObs.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueQLossSimVsObs.maj();
            this.fGraphiqueQLossSimVsObs.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueQSimMoinsQobs.maj();
            this.fGraphiqueQSimMoinsQobs.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueXCorrPluieDebitCalibration.maj();
            this.fGraphiqueXCorrPluieDebitCalibration.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueXCorrPluieDebitValidation.maj();
            this.fGraphiqueXCorrPluieDebitValidation.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration.maj();
            this.fGraphiqueXCorrDebitMesureDebitSimuleCalibration.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueXCorrDebitMesureDebitSimuleValidation.maj();
            this.fGraphiqueXCorrDebitMesureDebitSimuleValidation.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueAutocorrQCalibration.maj();
            this.fGraphiqueAutocorrQCalibration.setReady();
            return null;
        });
        cservice.submit(() -> {
            this.fGraphiqueAutocorrQValidation.maj();
            this.fGraphiqueAutocorrQValidation.setReady();
            return null;
        });
        eservice.shutdown();
    }

    private void majTabs() {
        this.enableAllTabs();
        this.updatePiezoGraphVisibility();
        switch (this.fConfig.getMode()) {
            case CALIBRATION: {
                boolean disabled = this.fRunParameters.getWobjFunction().getActivePartNumber() < 2;
                this.disableTab(TabName.OBJ1_VS_OBJ2, disabled);
                if (disabled && this.selectedTab() == TabName.OBJ1_VS_OBJ2) {
                    this.selectTab(TabName.P_AND_DISCHARGE);
                } else if (this.selectedTab() == TabName.OBJ1_VS_OBJ2) {
                    this.selectTab(TabName.OBJ1_VS_OBJ2);
                }
                Platform.runLater(() -> this.btOptParamSet.setText(Messages.getString("JResults.29")));
                break;
            }
            case RUN: {
                this.disableTab(TabName.OPTIMAL_PARAMETER_SET, true);
                if (this.selectedTab() == TabName.OPTIMAL_PARAMETER_SET) {
                    this.selectTab(TabName.P_AND_DISCHARGE);
                }
                this.disableTab(TabName.WOBJ_VS_PARAMETERS, true);
                if (this.selectedTab() == TabName.WOBJ_VS_PARAMETERS) {
                    this.selectTab(TabName.P_AND_DISCHARGE);
                }
                this.disableTab(TabName.OBJ1_VS_OBJ2, true);
                if (this.selectedTab() == TabName.OBJ1_VS_OBJ2) {
                    this.selectTab(TabName.P_AND_DISCHARGE);
                }
                this.disableTab(TabName.WOBJ_CAL_VS_VAL, true);
                if (this.selectedTab() == TabName.WOBJ_CAL_VS_VAL) {
                    this.selectTab(TabName.P_AND_DISCHARGE);
                }
                this.disableTab(TabName.SSI, true);
                if (this.selectedTab() == TabName.SSI) {
                    this.selectTab(TabName.P_AND_DISCHARGE);
                }
                Platform.runLater(() -> this.btOptParamSet.setText(Messages.getString("JResults.292")));
            }
        }
    }

    public void majConfidenceInterval(Varname pVarname, ConfidenceInterval pConfidenceInterval, boolean pShow) {
        CourbesCI courbesCI = this.fCourbesCI.get((Object)pVarname);
        Courbe courbeCIBas = courbesCI.bas();
        Courbe courbeCIHaut = courbesCI.haut();
        courbeCIBas.setValuesDirect(pConfidenceInterval.getBas());
        courbeCIHaut.setValuesDirect(pConfidenceInterval.getHaut());
        if (pShow) {
            courbeCIBas.setActive(true);
            courbeCIHaut.setActive(true);
            courbeCIBas.setVisible(true);
            courbeCIHaut.setVisible(true);
            this.selectTab(TabName.P_AND_DISCHARGE);
        }
        this.fGraphiquePluiesDebits.repaint();
    }

    public void majSSI(Map<Parameter, ParameterSSI> pMap, boolean pAddValues) {
        this.disableTab(TabName.SSI, false);
        this.selectTab(TabName.SSI);
        HashMap<Parameter, SensitivityIndexes> lastRes = new HashMap<Parameter, SensitivityIndexes>();
        Color[] colors = ColorUtils.genHSB(pMap.size());
        int i = 0;
        for (Map.Entry<Parameter, ParameterSSI> entry : pMap.entrySet()) {
            entry.getKey().setColor(colors[i++]);
            lastRes.put(entry.getKey(), entry.getValue().lastSensitivityIndex());
        }
        this.fTableauSSI.setValues(lastRes);
        this.fGraphiqueSSI.maj(pMap, pAddValues);
        SwingUtilities.invokeLater(() -> this.fActionContinueSSI.setEnabled(true));
    }

    public void fitToPeriod() {
        if (this.fCalibration != null && this.fValidation != null && this.fChauffe != null) {
            this.fGraphiquePluiesDebits.fitPeriods();
            this.fGraphiquePluiesDebitsInternes.fitPeriods();
            this.fGraphiquePluiesHauteurs.fitPeriods();
            this.fGraphiquePluiesHauteursInternes.fitPeriods();
            this.fGraphiqueTAndET.fitPeriods();
        }
    }

    public void setVisible(boolean pVisible) {
        this.rootPane.setOpacity(pVisible ? 1.0 : 0.2);
    }

    static class TcInfChild
    implements IChild {
        private final Reservoir fReservoir;
        private final Flow fFlow;
        private final Parameter fbParameter;
        private final Parameter frParameter;

        public TcInfChild(Reservoir pReservoir, Flow pFlow, Parameter pBParameter, Parameter pRParameter) {
            this.fReservoir = pReservoir;
            this.fFlow = pFlow;
            this.fbParameter = pBParameter;
            this.frParameter = pRParameter;
        }

        @Override
        public boolean isActive() {
            boolean tcInf = this.fReservoir.getConfig(ReservoirConfigType.INFINITE_TC).isActive();
            return !tcInf && this.fFlow.isActive() || tcInf && this.fbParameter.isActive() && this.frParameter.isActive();
        }

        public void removeListener(InvalidationListener pListener) {
        }

        public void addListener(InvalidationListener pListener) {
        }

        @Override
        public boolean isSelected() {
            return false;
        }

        @Override
        public ParentsHandler getParentsHandler() {
            return null;
        }

        @Override
        public BooleanProperty activeProperty() {
            return new SimpleBooleanProperty(){

                public void addListener(ChangeListener<? super Boolean> pListener) {
                    fReservoir.getConfig(ReservoirConfigType.INFINITE_TC).activeProperty().addListener(pListener);
                    fFlow.activeProperty().addListener(pListener);
                    fbParameter.activeProperty().addListener(pListener);
                    frParameter.activeProperty().addListener(pListener);
                }
            };
        }
    }

    public class CourbesCI {
        private final Courbe haut;
        private final Courbe bas;

        public CourbesCI(Courbe pHaut, Courbe pBas) {
            this.haut = pHaut;
            this.bas = pBas;
        }

        public Courbe haut() {
            return this.haut;
        }

        public Courbe bas() {
            return this.bas;
        }
    }

    public static enum TabName {
        OPTIMAL_PARAMETER_SET("Optimal parameter set"),
        T_AND_ET("Temperature and evapotranspiration"),
        P_AND_DISCHARGE("Rainfall and discharges"),
        P_AND_INTERNAL_DISCHARGES("Rainfall and internal discharges"),
        P_AND_WATER_LEVELS("Rainfall and water levels"),
        P_AND_INTERNAL_WATER_LEVELS("Rainfall and internal water levels"),
        CUMUL_VOLUMES,
        MASS_BALANCE,
        QS_VS_QOBS,
        QS_MINUS_QOBS,
        MODEL_EVALUATION,
        PROBABILITY_PLOT("Probability plot"),
        CORRELATION_P_Q("Correlation P/Q"),
        CORRELATION_QOBS_QS("Correlation Qobs/QS"),
        AUTOCORRELATION_QOBS_QS("Autocorrelation Qobs and QS"),
        WOBJ_VS_PARAMETERS("WOBJ vs parameters"),
        OBJ1_VS_OBJ2,
        WOBJ_CAL_VS_VAL("WOBJ calibration vs WOBJ validation"),
        SSI("Sobol sensitivity indexes");

        private final String fTooltipText;

        private TabName() {
            this.fTooltipText = null;
        }

        private TabName(String pTooltipText) {
            this.fTooltipText = pTooltipText;
        }

        public String getTooltipText() {
            return this.fTooltipText;
        }
    }
}

