/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterConstraint;
import fr.geonosis.karstmod.modele.ParameterConstraintType;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;

public class ParamConstraintPaneController {
    @FXML
    private CheckBox checkBox;
    @FXML
    private RadioButton rbEqual;
    @FXML
    private RadioButton rbLesser;
    @FXML
    private RadioButton rbGreater;
    @FXML
    private ToggleGroup constraintGroup;
    @FXML
    private HBox box;
    private HtmlTextBox fEqualField;
    private HtmlTextBox fLesserField;
    private HtmlTextBox fGreaterField;
    private ParameterConstraint fConstraint;

    @FXML
    private void initialize() {
        this.box.managedProperty().bind((ObservableValue)this.box.visibleProperty());
    }

    public void setParameter(Parameter pParameter) {
        this.fConstraint = pParameter.getConstraint();
        this.fEqualField = new HtmlTextBox("= " + this.fConstraint.getParameter().getHtmlLabel());
        this.fLesserField = new HtmlTextBox("\u2264 " + this.fConstraint.getParameter().getHtmlLabel());
        this.fGreaterField = new HtmlTextBox("\u2265 " + this.fConstraint.getParameter().getHtmlLabel());
        this.fEqualField.setTranslateX(5.0);
        this.fLesserField.setTranslateX(5.0);
        this.fGreaterField.setTranslateX(5.0);
        this.rbEqual.setGraphic((Node)this.fEqualField);
        this.rbLesser.setGraphic((Node)this.fLesserField);
        this.rbGreater.setGraphic((Node)this.fGreaterField);
        this.fEqualField.setPrefWidth(this.fEqualField.getComputedWidth() + 10.0);
        this.fLesserField.setPrefWidth(this.fLesserField.getComputedWidth() + 10.0);
        this.fGreaterField.setPrefWidth(this.fGreaterField.getComputedWidth() + 10.0);
        this.checkBox.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            boolean disable = pNewValue == false;
            this.rbEqual.setDisable(disable);
            this.rbLesser.setDisable(disable);
            this.rbGreater.setDisable(disable);
        });
        this.checkBox.selectedProperty().bindBidirectional((Property)this.fConstraint.selectedProperty());
        this.fConstraint.getParentsHandler().addActiveListener(observable -> {
            this.box.setVisible(this.fConstraint.getParentsHandler().isActive());
            this.majLabelColors();
        });
        this.fConstraint.addListener(o -> this.majLabelColors());
        this.fConstraint.typeProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            switch (this.fConstraint.getType()) {
                case EQUAL: {
                    this.rbEqual.setSelected(true);
                    break;
                }
                case LESSER: {
                    this.rbLesser.setSelected(true);
                    break;
                }
                case GREATER: {
                    this.rbGreater.setSelected(true);
                }
            }
            this.majLabelColors();
        });
        this.rbEqual.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (pNewValue.booleanValue()) {
                this.fConstraint.setType(ParameterConstraintType.EQUAL);
            }
        });
        this.rbLesser.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (pNewValue.booleanValue()) {
                this.fConstraint.setType(ParameterConstraintType.LESSER);
            }
        });
        this.rbGreater.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (pNewValue.booleanValue()) {
                this.fConstraint.setType(ParameterConstraintType.GREATER);
            }
        });
        switch (this.fConstraint.getType()) {
            case EQUAL: {
                this.rbEqual.setSelected(true);
                break;
            }
            case LESSER: {
                this.rbLesser.setSelected(true);
                break;
            }
            case GREATER: {
                this.rbGreater.setSelected(true);
            }
        }
        this.box.setVisible(this.fConstraint.getParentsHandler().isActive());
    }

    private void majLabelColors() {
        this.fEqualField.setTextColor((Paint)(this.fConstraint.isActive() && this.fConstraint.getType() == ParameterConstraintType.EQUAL ? StylesV2.COLOR_DEFAULT : StylesV2.COLOR_PARAMETER_NOT_SELECTED));
        this.fLesserField.setTextColor((Paint)(this.fConstraint.isActive() && this.fConstraint.getType() == ParameterConstraintType.LESSER ? StylesV2.COLOR_DEFAULT : StylesV2.COLOR_PARAMETER_NOT_SELECTED));
        this.fGreaterField.setTextColor((Paint)(this.fConstraint.isActive() && this.fConstraint.getType() == ParameterConstraintType.GREATER ? StylesV2.COLOR_DEFAULT : StylesV2.COLOR_PARAMETER_NOT_SELECTED));
    }
}

