/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.viewfx.InterpolationDialogPaneController;
import fr.geonosis.karstmod.viewfx.StylesV2;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class InterpolateDialog
extends Stage {
    private InterpolationDialogPaneController fController;

    public static InterpolateDialog getInstance() {
        return InterpolateDialogHolder.INSTANCE;
    }

    private InterpolateDialog() {
        Pane dialogContent;
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.setLocation(InterpolateDialog.class.getResource("InterpolationDialogPane.fxml"));
        try {
            dialogContent = (Pane)loader.load();
        }
        catch (IOException e) {
            KarstModLogger.severe("Internal error when loading interpolation dialog. Karstmod is going to be closed", e, false);
            new ModalResizableAlert(Alert.AlertType.ERROR, "Internal error when loading interpolation dialog. Karstmod is going to be closed", new ButtonType[0]).showAndWait();
            System.exit(1);
            return;
        }
        this.fController = (InterpolationDialogPaneController)loader.getController();
        this.setTitle("Interpolate missing data");
        this.initModality(Modality.APPLICATION_MODAL);
        Scene scene = new Scene((Parent)dialogContent);
        scene.getStylesheets().add((Object)StylesV2.class.getResource("km.css").toExternalForm());
        this.setScene(scene);
    }

    public boolean showDialog(InputData pInputData) {
        this.fController.setInputData(pInputData);
        this.showAndWait();
        return this.fController.getButtonType() == ButtonType.OK;
    }

    private static class InterpolateDialogHolder {
        private static final InterpolateDialog INSTANCE = new InterpolateDialog();

        private InterpolateDialogHolder() {
        }
    }
}

