/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.KarstModPreferences;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.viewfx.InterpolateDialog;
import fr.geonosis.karstmod.viewfx.ModelParamsPaneController;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import java.io.File;
import java.io.IOException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;

public class DataPaneController {
    @FXML
    private TextField filepathField;
    @FXML
    private ImageView errorImg;
    @FXML
    private Button browseButton;
    @FXML
    private Label ioShiftLabel;
    @FXML
    private Spinner<Integer> ioShiftSpinner;
    @FXML
    private Label timeStepUnitLabel;
    @FXML
    private Label timeStepUnit;
    @FXML
    private Pane rootPane;
    private InputData fInputData;

    public static DataPaneController create(InputData pInputData) throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(DataPaneController.class.getClassLoader());
        loader.setLocation(ModelParamsPaneController.class.getResource("DataPane.fxml"));
        loader.load();
        DataPaneController view = (DataPaneController)loader.getController();
        view.setInputData(pInputData);
        return view;
    }

    @FXML
    private void initialize() {
        this.errorImg.managedProperty().bind((ObservableValue)this.errorImg.visibleProperty());
        this.errorImg.setVisible(false);
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> this.timeStepUnit.setText(Unit.getInstance().getBase().get(Dimension.TIME)));
        this.timeStepUnit.setText(Unit.getInstance().getBase().get(Dimension.TIME));
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 99, 0);
        this.ioShiftSpinner.setValueFactory((SpinnerValueFactory)valueFactory);
    }

    private void setInputData(InputData pInputData) {
        this.fInputData = pInputData;
        MyTooltip errorTooltip = new MyTooltip(this.fInputData.getErrorMessage(), 0.0, 60000.0, 200.0);
        Tooltip.install((Node)this.errorImg, (Tooltip)errorTooltip);
        ChangeListener listener = (pObservable, pOldValue, pNewValue) -> {
            this.fInputData.setFilepath((String)pNewValue);
            boolean ok = this.fInputData.getErrorMessage() == null || this.fInputData.getErrorMessage().isEmpty();
            this.errorImg.setVisible(!ok);
            errorTooltip.setText(this.fInputData.getErrorMessage());
            if (ok && this.fInputData.needsInterpolation() && !this.interpolate(this.fInputData)) {
                this.errorImg.setVisible(true);
                errorTooltip.setText("Interpolation cancelled");
                this.fInputData.copy(new InputData());
            }
        };
        this.fInputData.filepathProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (!pNewValue.equals(this.filepathField.getText())) {
                this.filepathField.textProperty().removeListener(listener);
                this.filepathField.setText(pNewValue);
                this.filepathField.textProperty().addListener(listener);
            }
        });
        this.ioShiftSpinner.valueProperty().addListener((pObservable, pOldValue, pNewValue) -> this.fInputData.setIOShift((Integer)pNewValue));
        this.ioShiftSpinner.getValueFactory().setValue((Object)this.fInputData.getIOShift());
        this.filepathField.textProperty().addListener(listener);
        this.filepathField.setText(this.fInputData.getFilepath());
    }

    @FXML
    private void browse() {
        File selectedFile;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Choose data file");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
        File dir = this.filepathField.getText() != null && this.filepathField.getText().trim().length() > 0 ? new File(this.filepathField.getText()).getParentFile() : new File(KarstModPreferences.get(KarstModPreferences.Key.LAST_DATA_DIR, "."));
        if (dir != null && dir.exists() && dir.isDirectory()) {
            fileChooser.setInitialDirectory(dir);
        }
        while ((selectedFile = fileChooser.showOpenDialog(this.filepathField.getScene().getWindow())) != null) {
            KarstModPreferences.put(KarstModPreferences.Key.LAST_DATA_DIR, selectedFile.getParent());
            InputData inputData = new InputData();
            inputData.setFilepath(selectedFile.getAbsolutePath());
            if (inputData.getErrorMessage() != null) {
                new ModalResizableAlert(Alert.AlertType.ERROR, inputData.getErrorMessage(), ButtonType.OK).showAndWait();
                continue;
            }
            if (!inputData.needsInterpolation()) {
                this.fInputData.copy(inputData);
                this.filepathField.positionCaret(this.filepathField.getText().length() - 1);
                this.errorImg.setVisible(false);
            } else if (inputData.needsInterpolation()) {
                if (this.interpolate(inputData)) {
                    this.fInputData.copy(inputData);
                    this.filepathField.positionCaret(this.filepathField.getText().length() - 1);
                    this.errorImg.setVisible(false);
                } else {
                    this.errorImg.setVisible(true);
                    MyTooltip errorTooltip = new MyTooltip(this.fInputData.getErrorMessage(), 0.0, 60000.0, 200.0);
                    Tooltip.install((Node)this.errorImg, (Tooltip)errorTooltip);
                    errorTooltip.setText("Interpolation cancelled");
                }
            }
            return;
        }
    }

    private boolean interpolate(InputData pInputData) {
        return InterpolateDialog.getInstance().showDialog(pInputData);
    }

    public Pane getRootPane() {
        return this.rootPane;
    }
}

