/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;

public class CalibrationResultsPaneController
extends CheckBox {
    @FXML
    private Pane rootPane;
    @FXML
    private Label objNumber;
    @FXML
    private Label calibration;
    @FXML
    private Label validation;
    @FXML
    private Pane simuLabelPane;

    public static CalibrationResultsPaneController create() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(CalibrationResultsPaneController.class.getClassLoader());
        loader.setLocation(CalibrationResultsPaneController.class.getResource("CalibrationResultsPane.fxml"));
        loader.load();
        return (CalibrationResultsPaneController)((Object)loader.getController());
    }

    @FXML
    private void initialize() {
        this.simuLabelPane.getChildren().add((Object)new HtmlTextBox("<html>Simulations satisfying WOBJ \u2265 WOBJ<sub>min</sub>:</html>"));
    }

    public void setObjNum(String pValue) {
        this.objNumber.setText(pValue);
    }

    public Pane getRootPane() {
        return this.rootPane;
    }

    public void clear() {
        this.setObjNum("0");
        this.calibration.setText("");
        this.validation.setText("");
    }

    public void setValues(double pCalibration, double pValidation) {
        this.calibration.setText(Double.isInfinite(pCalibration) ? "-" : String.format("%.3g", pCalibration));
        this.validation.setText(Double.isInfinite(pValidation) ? "-" : String.format("%.3g", pValidation));
    }
}

