/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.utils.csv;

import fr.geonosis.karstmod.utils.csv.parser.IColumnType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Column<T> {
    private final String fName;
    private final IColumnType<T> fDataType;
    private final Set<String> fIndexedValues;

    public Column(Object pName, IColumnType<T> pDataType) {
        this(pName.toString(), pDataType, new HashSet<String>());
    }

    public Column(Object pName, IColumnType<T> pDataType, Set<String> pIndexedValues) {
        if (Objects.isNull(pName) || pName.toString().isBlank()) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        if (Objects.isNull(pDataType)) {
            throw new IllegalArgumentException("datatype cannot be null or blank");
        }
        if (Objects.isNull(pIndexedValues)) {
            throw new IllegalArgumentException("indexedValues cannot be null or blank");
        }
        this.fName = pName.toString();
        this.fDataType = pDataType;
        this.fIndexedValues = Set.copyOf(pIndexedValues);
    }

    public IColumnType<T> getDataType() {
        return this.fDataType;
    }

    public String getName() {
        return this.fName;
    }

    public Set<String> getIndexedValues() {
        return this.fIndexedValues;
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        Column column = (Column)pO;
        return Objects.equals(this.fName, column.fName);
    }

    public int hashCode() {
        return Objects.hash(this.fName);
    }
}

