/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.routine;

import fr.geonosis.karstmod.run.routine.SubcatchmentTable;

public class HbvSnowRoutine {
    private final double[] fTemp;
    private final double[] fPrec;
    private final double[] fSrad;

    public HbvSnowRoutine(double[] pTemp, double[] pPrec, double[] pSrad) {
        this.fTemp = pTemp;
        this.fPrec = pPrec;
        this.fSrad = pSrad;
    }

    public Output compute(double pTs, double pMf, double pCfr, double pCwh, double pRC) {
        return this.compute(this.fTemp, pTs, pMf, pCfr, pCwh, pRC);
    }

    public Output compute(double pTs, double pMf, double pCfr, double pCwh, double pRC, SubcatchmentTable pSubcatchmentTable) {
        if (pSubcatchmentTable == null || pSubcatchmentTable.isEmpty()) {
            return this.compute(this.fTemp, pTs, pMf, pCfr, pCwh, pRC);
        }
        int n = this.fPrec.length;
        Output output = new Output();
        output.setPsr(new double[n]);
        output.setLiquid(new double[pSubcatchmentTable.size()][n]);
        output.setSolid(new double[pSubcatchmentTable.size()][n]);
        output.setMelt(new double[pSubcatchmentTable.size()][n]);
        output.setRefreezing(new double[pSubcatchmentTable.size()][n]);
        double[] ps = new double[pSubcatchmentTable.size()];
        double[] temp = new double[n];
        double[] P = new double[n];
        for (int i = 0; i < ps.length; ++i) {
            double p = pSubcatchmentTable.getProportion(i);
            for (int t = 0; t < n; ++t) {
                temp[t] = this.fTemp[t] + pSubcatchmentTable.getTempShift(i);
            }
            Output scOutput = this.compute(temp, pTs, pMf, pCfr, pCwh, pRC);
            double[] liquid = scOutput.getLiquid()[0];
            double[] solid = scOutput.getSolid()[0];
            double[] melt = scOutput.getMelt()[0];
            double[] refreezing = scOutput.getRefreezing()[0];
            double[] psc = scOutput.getPsr();
            for (int t = 0; t < n; ++t) {
                int n2 = t;
                P[n2] = P[n2] + psc[t] * p;
                liquid[t] = liquid[t] * p;
                solid[t] = solid[t] * p;
                melt[t] = melt[t] * p;
                refreezing[t] = refreezing[t] * p;
            }
            output.setLiquid(i, liquid);
            output.setSolid(i, solid);
            output.setMelt(i, melt);
            output.setRefreezing(i, refreezing);
        }
        output.setPsr(P);
        return output;
    }

    private Output compute(double[] pTemp, double pTs, double pMf, double pCfr, double pCwh, double pRC) {
        int n = this.fPrec.length;
        double v = 0.0;
        double vl = 0.0;
        double[] P = new double[n];
        double[] solid = new double[n];
        double[] liquid = new double[n];
        double[] melt = new double[n];
        double[] refreezing = new double[n];
        boolean srad = this.fSrad != null;
        for (int t = 0; t < n; ++t) {
            double temp = pTemp[t];
            double rain = temp < pTs ? 0.0 : this.fPrec[t];
            double snow = temp >= pTs ? 0.0 : this.fPrec[t];
            double Ta = temp < pTs ? 0.0 : temp - pTs;
            double Tn = temp >= pTs ? 0.0 : pTs - temp;
            double m = Math.min(pMf * Ta + (srad ? pRC * this.fSrad[t] * Ta : 0.0), v);
            double rfz = Math.min(pCfr * pMf * Tn, vl);
            v = v - m + snow + rfz;
            vl = vl + m + rain - rfz;
            int n2 = t;
            solid[n2] = solid[n2] + v;
            int n3 = t;
            liquid[n3] = liquid[n3] + vl;
            int n4 = t;
            melt[n4] = melt[n4] + m;
            int n5 = t;
            refreezing[n5] = refreezing[n5] + rfz;
            if (!(vl > pCwh * v)) continue;
            P[t] = vl - pCwh * v;
            vl = pCwh * v;
        }
        return new Output(P, new double[][]{solid}, new double[][]{liquid}, new double[][]{melt}, new double[][]{refreezing});
    }

    public static class Output {
        private double[] fPsr;
        private double[][] fSolid;
        private double[][] fLiquid;
        private double[][] fMelt;
        private double[][] fRefreezing;

        public Output() {
        }

        public Output(double[] pPsr, double[][] pSolid, double[][] pLiquid, double[][] pMelt, double[][] pRefreezing) {
            this.fPsr = pPsr;
            this.fSolid = pSolid;
            this.fLiquid = pLiquid;
            this.fMelt = pMelt;
            this.fRefreezing = pRefreezing;
        }

        public void setPsr(double[] pPsr) {
            this.fPsr = pPsr;
        }

        public void setSolid(double[][] pSolid) {
            this.fSolid = pSolid;
        }

        public void setLiquid(double[][] pLiquid) {
            this.fLiquid = pLiquid;
        }

        public void setMelt(double[][] pMelt) {
            this.fMelt = pMelt;
        }

        public void setRefreezing(int i, double[] pRefreezing) {
            this.fRefreezing[i] = pRefreezing;
        }

        public void setSolid(int i, double[] pSolid) {
            this.fSolid[i] = pSolid;
        }

        public void setLiquid(int i, double[] pLiquid) {
            this.fLiquid[i] = pLiquid;
        }

        public void setMelt(int i, double[] pMelt) {
            this.fMelt[i] = pMelt;
        }

        public void setRefreezing(double[][] pRefreezing) {
            this.fRefreezing = pRefreezing;
        }

        public double[] getPsr() {
            return this.fPsr;
        }

        public double[][] getSolid() {
            return this.fSolid;
        }

        public double[][] getLiquid() {
            return this.fLiquid;
        }

        public double[][] getMelt() {
            return this.fMelt;
        }

        public double[][] getRefreezing() {
            return this.fRefreezing;
        }
    }
}

