/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model;

import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.run.model.Functions;
import fr.geonosis.karstmod.run.model.RunModelParameters;
import fr.geonosis.karstmod.run.model.RunModelStructure;
import java.util.Arrays;
import java.util.Objects;

public class RunModelData {
    public boolean ehy;
    public int ioShift = 0;
    public double dtrest;
    public double[] PInit;
    public double[] P;
    public double[] Psr;
    public double[] ETInit;
    public double[] ET;
    public double[] PET;
    public double[] QpumpL;
    public double[] QpumpM;
    public double[] QpumpC;
    public double[] QpumpS;
    public double[] Qobs;
    public double[] ZobsE;
    public double[] ZobsL;
    public double[] ZobsM;
    public double[] ZobsC;
    public double[] QsinkL;
    public double[] QsinkM;
    public double[] QsinkC;
    public double[] QsinkS;
    public double[] ETeff;
    public double[] QpumpSeff;
    public double[] Qhy;
    public double[] QES;
    public double[] QEM;
    public double[] QEL;
    public double[] QEC;
    public double[] QE;
    public double[] QMC;
    public double[] QLS;
    public double[] QMS;
    public double[] QCS;
    public double[] E;
    public double[] L;
    public double[] M;
    public double[] C;
    public double[] QS;
    public double[] ZE;
    public double[] ZL;
    public double[] ZM;
    public double[] ZC;
    public double[] thetaQrEexport;
    public double[] thetaQrLexport;
    public double[] thetaQrMexport;
    public double[] thetaQrCexport;
    public double[] thetaE;
    public double[] thetaL;
    public double[] thetaM;
    public double[] thetaC;
    public double[] kIfE;
    public double[] kIfL;
    public double[] kIfM;
    public double[] kIfC;
    public double[] hE;
    public double[] hL;
    public double[] hM;
    public double[] hC;
    public double[] Qloss;
    public double[] QrEloss;
    public double[] QrLloss;
    public double[] QrMloss;
    public double[] QrCloss;
    public double[] QrL;
    public double[] QbL;
    public double[] QrM;
    public double[] QbM;
    public double[] QrC;
    public double[] QbC;
    public boolean SolE;
    public boolean SolL;
    public boolean SolM;
    public boolean SolC;
    public int badsolE;
    public double[][] srLiquid;
    public double[][] srSolid;
    public double[][] srMelt;
    public double[][] srRefreezing;

    public RunModelData() {
    }

    public RunModelData(InputData pInputData, RunModelStructure pStructure, int tmax) {
        int size1 = tmax + 1;
        int size2 = tmax + 2;
        double[] empty1 = new double[size1];
        this.Qobs = pInputData.getValues(ColumnName.QOBSS);
        this.ZobsE = pInputData.getValues(ColumnName.ZOBSE);
        this.ZobsL = pInputData.getValues(ColumnName.ZOBSL);
        this.ZobsM = pInputData.getValues(ColumnName.ZOBSM);
        this.ZobsC = pInputData.getValues(ColumnName.ZOBSC);
        this.ETInit = pStructure.aET ? pInputData.getValues(ColumnName.ET) : empty1;
        this.ETeff = new double[size1];
        this.PInit = pStructure.aP ? pInputData.getValues(ColumnName.P) : empty1;
        this.QpumpL = pStructure.aQpumpL ? (double[])pInputData.getValues(ColumnName.QPUMPL).clone() : empty1;
        this.QpumpM = pStructure.aQpumpM ? (double[])pInputData.getValues(ColumnName.QPUMPM).clone() : empty1;
        this.QpumpC = pStructure.aQpumpC ? (double[])pInputData.getValues(ColumnName.QPUMPC).clone() : empty1;
        this.QpumpS = pStructure.aQpumpS ? (double[])pInputData.getValues(ColumnName.QPUMPS).clone() : empty1;
        this.QsinkL = pStructure.aQsinkL ? (double[])pInputData.getValues(ColumnName.QSINKL).clone() : empty1;
        this.QsinkM = pStructure.aQsinkM ? (double[])pInputData.getValues(ColumnName.QSINKM).clone() : empty1;
        this.QsinkC = pStructure.aQsinkC ? (double[])pInputData.getValues(ColumnName.QSINKC).clone() : empty1;
        this.QsinkS = pStructure.aQsinkS ? (double[])pInputData.getValues(ColumnName.QSINKS).clone() : empty1;
        this.QpumpSeff = new double[size1];
        this.E = new double[size2];
        this.L = new double[size2];
        this.M = new double[size2];
        this.C = new double[size2];
        this.QS = new double[size1];
        this.ZE = new double[size1];
        this.ZL = new double[size1];
        this.ZM = new double[size1];
        this.ZC = new double[size1];
        this.thetaQrEexport = new double[size2];
        this.thetaQrLexport = new double[size2];
        this.thetaQrMexport = new double[size2];
        this.thetaQrCexport = new double[size2];
        this.QEL = new double[size1];
        this.QEM = new double[size1];
        this.QE = new double[size1];
        this.QEC = new double[size1];
        this.QES = new double[size1];
        this.QLS = new double[size1];
        this.QMS = new double[size1];
        this.QCS = new double[size1];
        this.QMC = new double[size1];
        this.Qhy = new double[size1];
    }

    public void init(RunModelStructure pStructure, RunModelParameters pParams) {
        Functions.InitTcinfResult tmp;
        int diJR = -1;
        this.dtrest = pParams.dt;
        this.badsolE = 0;
        int size1 = this.QES.length;
        if (pStructure.aQloss) {
            this.Qloss = new double[size1];
        }
        if (pStructure.TcinfE) {
            this.QrEloss = new double[size1];
            pParams.nrE = (int)Math.min(80L, 10L + Math.round(50.0 * (1.0 - pParams.alphaE)));
            double[] phiE = new double[pParams.nrmax];
            this.thetaE = new double[pParams.nrmax];
            this.kIfE = new double[pParams.nrmax];
            this.hE = new double[pParams.nrmax];
            Arrays.fill(this.hE, pParams.Eo);
            if (pParams.nrE > 1) {
                double d = pParams.alphaE;
                double d2 = pParams.Tau0E;
                int n = pParams.nrE;
                int n2 = pParams.nrmax;
                Objects.requireNonNull(pParams);
                double d3 = pParams.small;
                double d4 = pParams.eps;
                Objects.requireNonNull(pParams);
                tmp = Functions.initTcinf(d, d2, n, this.thetaE, this.kIfE, n2, 1000.0, d3, d4, 1000, phiE);
                this.kIfE = tmp.k;
                this.thetaE = tmp.theta;
            } else {
                this.kIfE[1 + diJR] = 1.0 / pParams.Tau0E;
                this.thetaE[1 + diJR] = 1.0;
            }
        }
        if (pStructure.TcinfL) {
            this.QrLloss = new double[size1];
            this.QrL = new double[size1];
            this.QbL = new double[size1];
            pParams.nrL = (int)Math.min(80L, 10L + Math.round(50.0 * (1.0 - pParams.alphaL)));
            double[] phiL = new double[pParams.nrmax];
            this.thetaL = new double[pParams.nrmax];
            this.kIfL = new double[pParams.nrmax];
            this.hL = new double[pParams.nrmax];
            Arrays.fill(this.hL, pParams.Lo);
            if (pParams.nrL > 1) {
                double d = pParams.alphaL;
                double d5 = pParams.Tau0L;
                int n = pParams.nrL;
                int n3 = pParams.nrmax;
                Objects.requireNonNull(pParams);
                double d6 = pParams.small;
                double d7 = pParams.eps;
                Objects.requireNonNull(pParams);
                tmp = Functions.initTcinf(d, d5, n, this.thetaL, this.kIfL, n3, 1000.0, d6, d7, 1000, phiL);
                this.kIfL = tmp.k;
                this.thetaL = tmp.theta;
            } else {
                this.kIfL[1 + diJR] = 1.0 / pParams.Tau0L;
                this.thetaL[1 + diJR] = 1.0;
            }
        }
        if (pStructure.TcinfM) {
            this.QrMloss = new double[size1];
            this.QrM = new double[size1];
            this.QbM = new double[size1];
            pParams.nrM = (int)Math.min(80L, 10L + Math.round(50.0 * (1.0 - pParams.alphaM)));
            double[] phiM = new double[pParams.nrmax];
            this.thetaM = new double[pParams.nrmax];
            this.kIfM = new double[pParams.nrmax];
            this.hM = new double[pParams.nrmax];
            Arrays.fill(this.hM, pParams.Mo);
            if (pParams.nrM > 1) {
                double d = pParams.alphaM;
                double d8 = pParams.Tau0M;
                int n = pParams.nrM;
                int n4 = pParams.nrmax;
                Objects.requireNonNull(pParams);
                double d9 = pParams.small;
                double d10 = pParams.eps;
                Objects.requireNonNull(pParams);
                tmp = Functions.initTcinf(d, d8, n, this.thetaM, this.kIfM, n4, 1000.0, d9, d10, 1000, phiM);
                this.kIfM = tmp.k;
                this.thetaM = tmp.theta;
            } else {
                this.kIfM[1 + diJR] = 1.0 / pParams.Tau0M;
                this.thetaM[1 + diJR] = 1.0;
            }
        }
        if (pStructure.TcinfC) {
            this.QrCloss = new double[size1];
            this.QrC = new double[size1];
            this.QbC = new double[size1];
            pParams.nrC = (int)Math.min(80L, 10L + Math.round(50.0 * (1.0 - pParams.alphaC)));
            double[] phiC = new double[pParams.nrmax];
            this.thetaC = new double[pParams.nrmax];
            this.kIfC = new double[pParams.nrmax];
            this.hC = new double[pParams.nrmax];
            Arrays.fill(this.hC, pParams.Co);
            if (pParams.nrC > 1) {
                double d = pParams.alphaC;
                double d11 = pParams.Tau0C;
                int n = pParams.nrC;
                int n5 = pParams.nrmax;
                Objects.requireNonNull(pParams);
                double d12 = pParams.small;
                double d13 = pParams.eps;
                Objects.requireNonNull(pParams);
                tmp = Functions.initTcinf(d, d11, n, this.thetaC, this.kIfC, n5, 1000.0, d12, d13, 1000, phiC);
                this.kIfC = tmp.k;
                this.thetaC = tmp.theta;
            } else {
                this.kIfC[1 + diJR] = 1.0 / pParams.Tau0C;
                this.thetaC[1 + diJR] = 1.0;
            }
        }
    }
}

