/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model;

import fr.geonosis.karstmod.run.model.Functions;
import fr.geonosis.karstmod.run.model.IResolE;
import fr.geonosis.karstmod.run.model.RunModelData;
import fr.geonosis.karstmod.run.model.RunModelParameters;
import fr.geonosis.karstmod.run.model.RunModelStructure;

public class ResolLineariseeResE
implements IResolE {
    private final RunModelStructure fStructure;

    public ResolLineariseeResE(RunModelStructure pStructure) {
        this.fStructure = pStructure;
    }

    @Override
    public double solve(RunModelParameters pParams, RunModelData pData, int i) {
        double klossi = 0.0;
        double khyi = 0.0;
        double kESi = 0.0;
        double kECi = 0.0;
        double kELi = 0.0;
        double kEMi = 0.0;
        if (this.fStructure.aQloss) {
            klossi = Functions.kiSeuil(pParams.kloss, pParams.Eloss, pParams.aloss, pData.E[i]);
        }
        if (this.fStructure.aQhy) {
            double d = khyi = pData.ehy || !this.fStructure.aQhyDhy ? Functions.kiSeuil(pParams.khy, pParams.Ehy, pParams.ahy, pData.E[i]) : 0.0;
        }
        if (this.fStructure.aQES) {
            kESi = Functions.ki(pParams.kES, pParams.aES, pData.E[i]);
        }
        if (this.fStructure.aQEC) {
            kECi = Functions.ki(pParams.kEC, pParams.aEC, pData.E[i]);
        }
        if (this.fStructure.aQEL) {
            kELi = Functions.ki(pParams.kEL, pParams.aEL, pData.E[i]);
        }
        if (this.fStructure.aQEM) {
            kEMi = Functions.ki(pParams.kEM, pParams.aEM, pData.E[i]);
        }
        double kE = (this.fStructure.aQES ? kESi : 0.0) + (this.fStructure.aQloss ? klossi : 0.0) + (this.fStructure.aQhy ? khyi : 0.0) + (this.fStructure.aQEL ? kELi : 0.0) + (this.fStructure.aQEM ? kEMi : 0.0) + (this.fStructure.aQEC ? kECi : 0.0);
        int badsolE1 = kE >= 1.0 ? 1 : 0;
        double SE = pData.P[i] - pData.ET[i] + (this.fStructure.aQloss ? klossi * pParams.Eloss : 0.0) + (this.fStructure.aQhy ? khyi * pParams.Ehy : 0.0);
        double E12 = Functions.eth(pData.E[i], kE, SE, pParams.dt / 2.0, false, pParams.Emin);
        if (pData.E[i + 1] < pParams.Emin) {
            pData.E[i + 1] = pParams.Emin;
        }
        if (this.fStructure.aQhy && this.fStructure.aQhyDhy && E12 > pParams.Ehy + pParams.Dhy) {
            pData.ehy = true;
        }
        if (this.fStructure.aQloss) {
            klossi = Functions.kiSeuil(pParams.kloss, pParams.Eloss, pParams.aloss, E12);
        }
        if (this.fStructure.aQhy) {
            double d = khyi = pData.ehy || !this.fStructure.aQhyDhy ? Functions.kiSeuil(pParams.khy, pParams.Ehy, pParams.ahy, E12) : 0.0;
        }
        if (this.fStructure.aQES) {
            kESi = Functions.ki(pParams.kES, pParams.aES, E12);
        }
        if (this.fStructure.aQEC) {
            kECi = Functions.ki(pParams.kEC, pParams.aEC, E12);
        }
        if (this.fStructure.aQEL) {
            kELi = Functions.ki(pParams.kEL, pParams.aEL, E12);
        }
        if (this.fStructure.aQEM) {
            kEMi = Functions.ki(pParams.kEM, pParams.aEM, E12);
        }
        kE = (this.fStructure.aQES ? kESi : 0.0) + (this.fStructure.aQloss ? klossi : 0.0) + (this.fStructure.aQhy ? khyi : 0.0) + (this.fStructure.aQEL ? kELi : 0.0) + (this.fStructure.aQEM ? kEMi : 0.0) + (this.fStructure.aQEC ? kECi : 0.0);
        int badsolE2 = kE >= 1.0 ? 1 : 0;
        pData.badsolE = badsolE1 + badsolE2;
        SE = pData.P[i] - pData.ET[i] + (this.fStructure.aQloss ? klossi * pParams.Eloss : 0.0) + (this.fStructure.aQhy ? khyi * pParams.Ehy : 0.0);
        pData.E[i + 1] = Functions.eth(pData.E[i], kE, SE, pParams.dt, false, pParams.Emin);
        if (pData.E[i + 1] < pParams.Emin) {
            pData.E[i + 1] = pParams.Emin;
        }
        double Qtot = SE + (pData.E[i] - pData.E[i + 1]) / pParams.dt;
        if (kE != 0.0) {
            if (Qtot < 0.0) {
                Qtot = 0.0;
            }
            if (this.fStructure.aQloss) {
                pData.Qloss[i] = klossi * (Qtot / kE - pParams.Eloss);
            }
            if (this.fStructure.aQhy) {
                pData.Qhy[i] = khyi * (Qtot / kE - pParams.Ehy);
            }
            if (this.fStructure.aQES) {
                pData.QES[i] = kESi * Qtot / kE;
            }
            if (this.fStructure.aQEL) {
                pData.QEL[i] = kELi * Qtot / kE;
            }
            if (this.fStructure.aQEM) {
                pData.QEM[i] = kEMi * Qtot / kE;
            }
            if (this.fStructure.aQEC) {
                pData.QEC[i] = kECi * Qtot / kE;
            }
        } else {
            Qtot = 0.0;
            if (this.fStructure.aQloss) {
                pData.Qloss[i] = 0.0;
            }
            if (this.fStructure.aQhy) {
                pData.Qhy[i] = 0.0;
            }
            if (this.fStructure.aQES) {
                pData.QES[i] = 0.0;
            }
            if (this.fStructure.aQEL) {
                pData.QEL[i] = 0.0;
            }
            if (this.fStructure.aQEM) {
                pData.QEM[i] = 0.0;
            }
            if (this.fStructure.aQEC) {
                pData.QEC[i] = 0.0;
            }
        }
        if (this.fStructure.aQhy && this.fStructure.aQhyDhy && pParams.Ehy > 0.0) {
            if (pData.ehy && pData.E[i + 1] <= pParams.Ehy) {
                pData.ehy = false;
            } else if (!pData.ehy && pData.E[i + 1] > pParams.Ehy + pParams.Dhy) {
                pData.ehy = true;
            }
        } else {
            pData.ehy = false;
        }
        return Qtot;
    }
}

