/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model;

import fr.geonosis.karstmod.run.model.Functions;
import fr.geonosis.karstmod.run.model.IResolE;
import fr.geonosis.karstmod.run.model.RunModelData;
import fr.geonosis.karstmod.run.model.RunModelParameters;
import fr.geonosis.karstmod.run.model.RunModelStructure;
import java.util.Arrays;

public class ResolAnalytiqueResE
implements IResolE {
    private static final int diJR = -1;
    public int ithhydown;
    public int ithlossdown;
    public int ithzerodown;
    public int ithlossup;
    public int ithzeroup;
    public int ithhyup;
    public double[] Ethdown;
    public double[] klistdown;
    public double[] kthdown;
    public double[] Rtabdown;
    public double plossdown;
    public double phydown;
    public double pELdown;
    public double pEMdown;
    public double pECdown;
    public double pESdown;
    public double[] Ethup;
    public double[] klistup;
    public double[] kthup;
    public double[] Rtabup;
    public double plossup;
    public double phyup;
    public double pELup;
    public double pEMup;
    public double pECup;
    public double pESup;
    public int nthup;
    public int nthdown;
    private final RunModelStructure fStructure;

    public ResolAnalytiqueResE(RunModelStructure pStructure, RunModelParameters pParameters) {
        int j;
        int i;
        int imax;
        double[][] MEup;
        this.fStructure = pStructure;
        int nth = 0;
        this.nthup = -1;
        this.nthdown = -1;
        double[][] MEdown = new double[4][3];
        double[][] dArray = MEup = pStructure.aQhyDhy ? new double[4][3] : null;
        if (pStructure.aQloss) {
            MEdown[nth] = new double[]{pParameters.Eloss, pParameters.kloss, 1.0};
            if (pStructure.aQhyDhy) {
                MEup[nth] = new double[]{pParameters.Eloss, pParameters.kloss, 1.0};
            }
            ++nth;
        }
        if (pStructure.aQhy) {
            MEdown[nth] = new double[]{pParameters.Ehy, pParameters.khy, 2.0};
            if (pStructure.aQhyDhy) {
                MEup[nth] = new double[]{pParameters.Ehy + pParameters.Dhy, pParameters.khy, 20.0};
            }
            ++nth;
        }
        if (pStructure.aQEM || pStructure.aQEL || pStructure.aQEC || pStructure.aQES) {
            MEdown[nth] = new double[]{0.0, (pStructure.aQEM ? pParameters.kEM : 0.0) + (pStructure.aQEL ? pParameters.kEL : 0.0) + (pStructure.aQEC ? pParameters.kEC : 0.0) + (pStructure.aQES ? pParameters.kES : 0.0), 3.0};
            if (pStructure.aQhyDhy) {
                MEup[nth] = new double[]{0.0, (pStructure.aQEM ? pParameters.kEM : 0.0) + (pStructure.aQEL ? pParameters.kEL : 0.0) + (pStructure.aQEC ? pParameters.kEC : 0.0) + (pStructure.aQES ? pParameters.kES : 0.0), 3.0};
            }
            ++nth;
        }
        MEdown[nth] = new double[]{pParameters.Emin, 0.0, 0.0};
        if (pStructure.aQhyDhy) {
            MEup[nth] = new double[]{pParameters.Emin, 0.0, 0.0};
        }
        MEdown = (double[][])Arrays.copyOf(MEdown, nth + 1);
        Arrays.sort(MEdown, (pO1, pO2) -> {
            double res = pO1[0] - pO2[0];
            return res < 0.0 ? -1 : (res > 0.0 ? 1 : 0);
        });
        if (pStructure.aQhyDhy) {
            MEup = (double[][])Arrays.copyOf(MEup, nth + 1);
            Arrays.sort(MEup, (pO1, pO2) -> {
                double res = pO1[0] - pO2[0];
                return res < 0.0 ? -1 : (res > 0.0 ? 1 : 0);
            });
        }
        int imaxup = imax = nth + 1 + -1;
        this.ithlossdown = -1;
        this.ithhydown = -1;
        this.ithzerodown = -1;
        this.ithlossup = -1;
        this.ithhyup = -1;
        this.ithzeroup = -1;
        for (i = 0; i <= imax; ++i) {
            if (MEdown[i][2] == 1.0) {
                this.ithlossdown = i;
            }
            if (MEdown[i][2] == 2.0) {
                this.ithhydown = i;
            }
            if (MEdown[i][2] == 3.0) {
                this.ithzerodown = i;
            }
            if (i == imax) continue;
            if (MEdown[i + 1][2] == 1.0) {
                this.ithlossdown = i;
            }
            if (MEdown[i + 1][2] == 2.0) {
                this.ithhydown = i;
            }
            if (MEdown[i + 1][2] == 3.0) {
                this.ithzerodown = i;
            }
            if (MEdown[i + 1][0] != MEdown[i][0]) continue;
            MEdown[i][1] = MEdown[i][1] + MEdown[i + 1][1];
            if (MEdown.length - 1 - (i + 1) >= 0) {
                System.arraycopy(MEdown, i + 1 + 1, MEdown, i + 1, MEdown.length - 1 - (i + 1));
            }
            MEdown = (double[][])Arrays.copyOf(MEdown, MEdown.length - 1);
            --imax;
            --i;
            nth = Math.max(0, nth - 1);
        }
        this.nthdown = MEdown.length - 1;
        if (pStructure.aQhy && pStructure.aQhyDhy) {
            for (i = 0; i <= imaxup; ++i) {
                if (MEup[i][2] == 1.0) {
                    this.ithlossup = i;
                }
                if (MEup[i][2] == 20.0) {
                    this.ithhyup = i;
                }
                if (MEup[i][2] == 3.0) {
                    this.ithzeroup = i;
                }
                if (i == imaxup) continue;
                if (MEup[i + 1][2] == 1.0) {
                    this.ithlossup = i;
                }
                if (MEup[i + 1][2] == 20.0) {
                    this.ithhyup = i;
                }
                if (MEup[i + 1][2] == 3.0) {
                    this.ithzeroup = i;
                }
                if (MEup[i][0] != MEup[i + 1][0]) continue;
                MEup[i][1] = MEup[i][1] + MEup[i + 1][1];
                if (MEup.length - 1 - (i + 1) >= 0) {
                    System.arraycopy(MEup, i + 1 + 1, MEup, i + 1, MEup.length - 1 - (i + 1));
                }
                MEup = (double[][])Arrays.copyOf(MEup, MEup.length - 1);
                --imaxup;
                --i;
            }
            this.nthup = MEup.length - 1;
        }
        this.Ethdown = new double[MEdown.length];
        this.klistdown = new double[MEdown.length];
        this.kthdown = new double[MEdown.length];
        this.Rtabdown = new double[MEdown.length];
        for (j = 0; j < MEdown.length; ++j) {
            this.Ethdown[j] = MEdown[j][0];
            this.klistdown[j] = MEdown[j][1];
        }
        this.kthdown[0] = this.klistdown[0];
        this.Rtabdown[0] = this.klistdown[0] * this.Ethdown[0];
        for (j = 1; j < MEdown.length; ++j) {
            this.kthdown[j] = this.kthdown[j - 1] + this.klistdown[j];
            this.Rtabdown[j] = this.Rtabdown[j - 1] + this.klistdown[j] * this.Ethdown[j];
        }
        this.plossdown = Double.NaN;
        this.phydown = Double.NaN;
        this.pESdown = Double.NaN;
        this.pELdown = Double.NaN;
        this.pEMdown = Double.NaN;
        this.pECdown = Double.NaN;
        if (pStructure.aQloss) {
            this.plossdown = pParameters.kloss / this.klistdown[this.ithlossdown];
        }
        if (pStructure.aQhy) {
            this.phydown = pParameters.khy / this.klistdown[this.ithhydown];
        }
        if (pStructure.aQES) {
            this.pESdown = pParameters.kES / this.klistdown[this.ithzerodown];
        }
        if (pStructure.aQEL) {
            this.pELdown = pParameters.kEL / this.klistdown[this.ithzerodown];
        }
        if (pStructure.aQEM) {
            this.pEMdown = pParameters.kEM / this.klistdown[this.ithzerodown];
        }
        if (pStructure.aQEC) {
            this.pECdown = pParameters.kEC / this.klistdown[this.ithzerodown];
        }
        this.plossup = Double.NaN;
        this.phyup = Double.NaN;
        this.pESup = Double.NaN;
        this.pELup = Double.NaN;
        this.pEMup = Double.NaN;
        this.pECup = Double.NaN;
        this.Ethup = null;
        this.klistup = null;
        this.kthup = null;
        this.Rtabup = null;
        if (pStructure.aQhy && pStructure.aQhyDhy) {
            this.Ethup = new double[MEup.length];
            this.klistup = new double[MEup.length];
            this.kthup = new double[MEup.length];
            this.Rtabup = new double[MEup.length];
            for (j = 0; j < MEup.length; ++j) {
                this.Ethup[j] = MEup[j][0];
                this.klistup[j] = MEup[j][1];
            }
            this.kthup[0] = this.klistup[0];
            this.Rtabup[0] = this.klistup[0] * this.Ethup[0];
            for (j = 1; j < MEup.length; ++j) {
                this.kthup[j] = this.kthup[j - 1] + this.klistup[j];
                this.Rtabup[j] = this.Rtabup[j - 1] + this.klistup[j] * this.Ethup[j];
            }
            if (pStructure.aQloss) {
                this.plossup = pParameters.kloss / this.klistup[this.ithlossup];
            }
            this.phyup = pParameters.khy / this.klistup[this.ithhyup];
            if (pStructure.aQES) {
                this.pESup = pParameters.kES / this.klistup[this.ithzeroup];
            }
            if (pStructure.aQEL) {
                this.pELup = pParameters.kEL / this.klistup[this.ithzeroup];
            }
            if (pStructure.aQEM) {
                this.pEMup = pParameters.kEM / this.klistup[this.ithzeroup];
            }
            if (pStructure.aQEC) {
                this.pECup = pParameters.kEC / this.klistup[this.ithzeroup];
            }
        }
    }

    @Override
    public double solve(RunModelParameters pParams, RunModelData pData, int i) {
        int nth;
        int ithzero;
        int ithloss;
        double pEC;
        double pEM;
        double pEL;
        double pES;
        double phy;
        double ploss;
        double[] klist;
        double[] Rtab;
        double[] kth;
        double[] Eth;
        int ithhy = -1;
        if (this.fStructure.aQhy && this.fStructure.aQhyDhy && !pData.ehy) {
            Eth = this.Ethup;
            kth = this.kthup;
            Rtab = this.Rtabup;
            klist = this.klistup;
            ploss = this.plossup;
            phy = this.phyup;
            pES = this.pESup;
            pEL = this.pELup;
            pEM = this.pEMup;
            pEC = this.pECup;
            ithloss = this.ithlossup;
            ithhy = this.ithhyup;
            ithzero = this.ithzeroup;
            nth = this.nthup;
        } else {
            Eth = this.Ethdown;
            kth = this.kthdown;
            Rtab = this.Rtabdown;
            klist = this.klistdown;
            ploss = this.plossdown;
            phy = this.phydown;
            pES = this.pESdown;
            pEL = this.pELdown;
            pEM = this.pEMdown;
            pEC = this.pECdown;
            ithloss = this.ithlossdown;
            if (this.fStructure.aQhy) {
                ithhy = this.ithhydown;
            }
            ithzero = this.ithzerodown;
            nth = this.nthdown;
        }
        Functions.EiSeuilsResults eiRes = Functions.eiSeuils(pData.E[i], pData.P[i] - pData.ET[i], Eth, kth, Rtab, nth, 1.0, pData.dtrest);
        pData.E[i + 1] = eiRes.Etmp;
        if (this.fStructure.aQhy && this.fStructure.aQhyDhy) {
            if (pData.ehy && eiRes.Etmp <= pParams.Ehy) {
                pData.ehy = false;
            } else if (!pData.ehy && eiRes.Etmp > pParams.Ehy + pParams.Dhy) {
                pData.ehy = true;
            }
        } else {
            pData.ehy = false;
        }
        double Qtot = Functions.sum(eiRes.Qtotth);
        double[] Q = new double[nth + 1];
        if (nth == 0) {
            if (this.fStructure.aQES) {
                pData.QES[i] = pES * Qtot;
            }
            if (this.fStructure.aQEL) {
                pData.QEL[i] = pEL * Qtot;
            }
            if (this.fStructure.aQEM) {
                pData.QEM[i] = pEM * Qtot;
            }
            if (this.fStructure.aQEC) {
                pData.QEC[i] = pEC * Qtot;
            }
        } else if (Qtot != 0.0) {
            double d;
            for (int j = nth + 1 + -1; j >= 0; --j) {
                if (eiRes.Qtotth[j] == 0.0) continue;
                for (int k = j; k >= 0; --k) {
                    Q[k] = Q[k] + klist[k] / kth[j] * (eiRes.Qtotth[j] + Rtab[j] * eiRes.dteff[j]) - klist[k] * Eth[k] * eiRes.dteff[j];
                }
            }
            double dif = Functions.sum(Q) - Functions.sum(eiRes.Qtotth);
            if (Math.abs(d) > 1.0E-5) {
                throw new RuntimeException(String.format("ERROR ! Qtot \u2260 Qtotth (|Qtot - Qtotth| =  %g", dif));
            }
            for (int j = 0; j < Q.length; ++j) {
                if (!(Q[j] < 0.0)) continue;
                Q[j] = 0.0;
            }
            if (this.fStructure.aQloss) {
                pData.Qloss[i] = ploss * Q[ithloss];
            }
            if (this.fStructure.aQhy) {
                pData.Qhy[i] = phy * Q[ithhy];
            }
            if (this.fStructure.aQES) {
                pData.QES[i] = pES * Q[ithzero];
            }
            if (this.fStructure.aQEL) {
                pData.QEL[i] = pEL * Q[ithzero];
            }
            if (this.fStructure.aQEM) {
                pData.QEM[i] = pEM * Q[ithzero];
            }
            if (this.fStructure.aQEC) {
                pData.QEC[i] = pEC * Q[ithzero];
            }
        } else {
            if (this.fStructure.aQloss) {
                pData.Qloss[i] = 0.0;
            }
            if (this.fStructure.aQhy) {
                pData.Qhy[i] = 0.0;
            }
            if (this.fStructure.aQES) {
                pData.QES[i] = 0.0;
            }
            if (this.fStructure.aQEL) {
                pData.QEL[i] = 0.0;
            }
            if (this.fStructure.aQEM) {
                pData.QEM[i] = 0.0;
            }
            if (this.fStructure.aQEC) {
                pData.QEC[i] = 0.0;
            }
        }
        return Qtot;
    }
}

