/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import fr.geonosis.karstmod.modele.montecarlo.IRandomGenerator;
import fr.geonosis.karstmod.run.AbstractSSIRunner;
import fr.geonosis.karstmod.run.SSIModel;
import java.util.concurrent.atomic.AtomicInteger;

public class Ishigami
extends AbstractSSIRunner {
    private final double a = 7.0;
    private final double b = 0.1;
    private final AtomicInteger counter = new AtomicInteger();
    private final double fMax;

    public Ishigami(IRandomGenerator pGenerator, int pMax) {
        super(pGenerator);
        this.fMax = pMax;
    }

    @Override
    public void worked() {
    }

    @Override
    public int next() {
        int res = this.counter.incrementAndGet();
        return (double)res <= this.fMax ? res : -1;
    }

    @Override
    protected SSIModel createModel() {
        return new SSIModel(){

            @Override
            public int getNbParams() {
                return 3;
            }

            @Override
            public double eval(double[] pParams) {
                double xx0 = Math.PI - 2.0 * pParams[0] * Math.PI;
                double xx1 = Math.PI - 2.0 * pParams[1] * Math.PI;
                double xx2 = Math.PI - 2.0 * pParams[2] * Math.PI;
                return Math.sin(xx0) + 7.0 * Math.pow(Math.sin(xx1), 2.0) + 0.1 * Math.pow(xx2, 4.0) * Math.sin(xx0);
            }
        };
    }

    @Override
    protected int getNbParams() {
        return 3;
    }

    @Override
    public int getNbTasks() {
        return Runtime.getRuntime().availableProcessors();
    }
}

