/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.observable;

import fr.geonosis.karstmod.modele.observable.ChildrenHandler;
import fr.geonosis.karstmod.modele.observable.IActive;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.observable.IParent;
import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;

public class ParentsHandler {
    private final IChild fChild;
    private final ArrayList<IParent> fParents;

    public ParentsHandler(IChild pChild) {
        this.fChild = pChild;
        this.fParents = new ArrayList();
    }

    public void addParent(IParent pParent) {
        if (pParent == null) {
            return;
        }
        this.fParents.add(pParent);
        pParent.getChildrenHandler().addChild(this.fChild);
    }

    public void addParents(final IActive pActive, IParent ... pParents) {
        for (final IParent parent : pParents) {
            this.addParent(new IParent(){

                @Override
                public boolean isActive() {
                    return pActive.isActive();
                }

                @Override
                public ChildrenHandler getChildrenHandler() {
                    return parent.getChildrenHandler();
                }

                @Override
                public ReadOnlyBooleanProperty activeProperty() {
                    return parent.activeProperty();
                }
            });
        }
    }

    public boolean isActive() {
        for (IParent parent : this.fParents) {
            if (parent.isActive()) continue;
            return false;
        }
        return true;
    }

    public boolean isActive(IParent pExcept) {
        for (IParent parent : this.fParents) {
            if (parent == pExcept || parent.isActive()) continue;
            return false;
        }
        return true;
    }

    public void removeParent(IParent pParent) {
        this.fParents.remove(pParent);
    }

    public void addActiveListener(InvalidationListener pInvalidationListener) {
        for (IParent parent : this.fParents) {
            parent.activeProperty().addListener(pInvalidationListener);
        }
    }
}

