/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj.parser;

import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.BE;
import fr.geonosis.karstmod.modele.obj.KGE;
import fr.geonosis.karstmod.modele.obj.KGENP;
import fr.geonosis.karstmod.modele.obj.NSE;
import fr.geonosis.karstmod.modele.obj.RPearson;
import fr.geonosis.karstmod.modele.obj.RSpearman;
import fr.geonosis.karstmod.modele.obj.VE;
import fr.geonosis.karstmod.modele.obj.WobjDataConverter;
import fr.geonosis.karstmod.modele.obj.antlr.WobjLexer;
import fr.geonosis.karstmod.modele.obj.antlr.WobjParser;
import fr.geonosis.karstmod.modele.obj.parser.Part;
import fr.geonosis.karstmod.modele.obj.parser.ThrowingErrorListener;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.utils.csv.DoubleRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class WobjExpression {
    private final List<Part> fParts = new ArrayList<Part>();
    private String fExpr;

    public static WobjExpression buildExpression(String pExpr) throws ParseCancellationException {
        CodePointCharStream in = CharStreams.fromString(pExpr.toLowerCase());
        WobjLexer lexer = new WobjLexer(in);
        lexer.removeErrorListener(ConsoleErrorListener.INSTANCE);
        lexer.addErrorListener(ThrowingErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        WobjParser parser = new WobjParser(tokens);
        parser.removeErrorListener(ConsoleErrorListener.INSTANCE);
        parser.addErrorListener(ThrowingErrorListener.INSTANCE);
        WobjParser.ExprContext tree = parser.expr();
        WobjExpression exp = new WobjExpression();
        exp.fExpr = pExpr;
        exp.build(tree);
        return exp;
    }

    private void build(ParseTree pRoot) throws ParseCancellationException {
        for (int i = 0; i < pRoot.getChildCount(); i += 2) {
            WobjDataConverter trans;
            ParseTree transNode;
            Class wobjFuncClass;
            int j;
            double coef;
            ArrayList<AbstractObjectiveFunction.FctParam> parameters = new ArrayList<AbstractObjectiveFunction.FctParam>();
            ParseTree node = pRoot.getChild(i);
            if (!(node instanceof WobjParser.PartContext)) {
                throw new ParseCancellationException("Part expected");
            }
            if (node.getChild(0) instanceof WobjParser.CoefContext) {
                coef = Double.parseDouble(node.getChild(0).getText().replaceAll(",", "."));
                j = "*".equals(node.getChild(1).getText()) ? 2 : 1;
            } else {
                coef = 1.0;
                j = 0;
            }
            ParseTree objfuncNode = node.getChild(j);
            if (!(objfuncNode instanceof WobjParser.ObjfuncContext || objfuncNode instanceof WobjParser.ObjfuncQContext || objfuncNode instanceof WobjParser.ObjfuncKGEContext)) {
                throw new ParseCancellationException("wobj function expected");
            }
            switch (objfuncNode.getText().toLowerCase()) {
                case "be": {
                    wobjFuncClass = BE.class;
                    break;
                }
                case "ve": {
                    wobjFuncClass = VE.class;
                    break;
                }
                case "nse": {
                    wobjFuncClass = NSE.class;
                    break;
                }
                case "kge": {
                    wobjFuncClass = KGE.class;
                    break;
                }
                case "kgenp": {
                    wobjFuncClass = KGENP.class;
                    break;
                }
                case "rpearson": {
                    wobjFuncClass = RPearson.class;
                    break;
                }
                case "rspearman": {
                    wobjFuncClass = RSpearman.class;
                    break;
                }
                default: {
                    wobjFuncClass = null;
                }
            }
            if (Objects.isNull(wobjFuncClass)) {
                throw new ParseCancellationException("wobj function unknown : " + objfuncNode.getText());
            }
            if (wobjFuncClass == KGE.class && node.getChild(j + 1) instanceof TerminalNode && "[".equals(node.getChild(j + 1).getText())) {
                parameters.add(new AbstractObjectiveFunction.FctParam("sr", Double.parseDouble(node.getChild(j + 2).getChild(0).getText().replaceAll(",", "."))));
                parameters.add(new AbstractObjectiveFunction.FctParam("sa", Double.parseDouble(node.getChild(j + 4).getChild(0).getText().replaceAll(",", "."))));
                parameters.add(new AbstractObjectiveFunction.FctParam("sb", Double.parseDouble(node.getChild(j + 6).getChild(0).getText().replaceAll(",", "."))));
                j += 7;
            }
            if (!((transNode = node.getChild(j + 2)) instanceof WobjParser.TransContext) && !(transNode instanceof WobjParser.TransQContext)) {
                throw new ParseCancellationException("transformation expected");
            }
            ParseTree convNode = transNode.getChild(0);
            if (convNode instanceof WobjParser.IdentityContext || convNode instanceof WobjParser.IdentityQContext) {
                trans = WobjDataConverter.IDENTITY;
            } else if (convNode instanceof WobjParser.InvertContext || convNode instanceof WobjParser.InvertQContext) {
                trans = WobjDataConverter.INVERSE;
            } else if (convNode instanceof WobjParser.SqrtContext || convNode instanceof WobjParser.SqrtQContext) {
                trans = WobjDataConverter.SQRT;
            } else if (convNode instanceof WobjParser.SqrtInvertContext || convNode instanceof WobjParser.SqrtInvertQContext) {
                trans = WobjDataConverter.SQRT_INVERSE;
            } else {
                throw new ParseCancellationException("variable transformation unknown :" + transNode.getText());
            }
            ParseTree varNode = null;
            for (int k = 0; k < convNode.getChildCount(); ++k) {
                if (!(convNode.getChild(k) instanceof WobjParser.VarContext) && !(convNode.getChild(k) instanceof WobjParser.VarQContext)) continue;
                varNode = convNode.getChild(k);
            }
            if (Objects.isNull(varNode)) {
                throw new ParseCancellationException("var expected");
            }
            Varname varname = Varname.valueOf(varNode.getChild(0).getText().toUpperCase());
            Double min = null;
            Double max = null;
            if (varNode.getChildCount() == 2) {
                ParseTree rangeNode = varNode.getChild(1);
                if (!(rangeNode instanceof WobjParser.RangeContext)) {
                    throw new ParseCancellationException("Range expected");
                }
                if (rangeNode.getChildCount() > 3) {
                    if (",".equals(rangeNode.getChild(2).getText())) {
                        min = Double.parseDouble(rangeNode.getChild(1).getText().replaceAll(",", "."));
                        if (rangeNode.getChildCount() == 5) {
                            max = Double.parseDouble(rangeNode.getChild(3).getText().replaceAll(",", "."));
                        }
                    } else {
                        max = Double.parseDouble(rangeNode.getChild(2).getText().replaceAll(",", "."));
                    }
                }
            }
            if (!varname.canBeUsedIn(wobjFuncClass)) {
                throw new ParseCancellationException("variable " + varname + " can't be used with " + wobjFuncClass.getSimpleName());
            }
            this.fParts.add(new Part(coef, wobjFuncClass, trans, varname, new DoubleRange(min, max), parameters));
        }
    }

    public String getExpr() {
        return this.fExpr;
    }

    public List<Part> getParts() {
        return List.copyOf(this.fParts);
    }

    public String toString() {
        return this.fParts.stream().map(Part::toString).collect(Collectors.joining("\n"));
    }
}

