/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj;

import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.WobjResult;
import fr.geonosis.karstmod.modele.obj.WobjResultList;

public class WobjRunResults {
    private final WobjResultList fCalibrationResults;
    private final WobjResultList fValidationResults;
    private final GlobalObjectiveFunction fGlobalObjectiveFunction;
    private WobjResult fWobjCalibrationBest;
    private WobjResult fWobjValidationForCalibrationBest;

    public WobjRunResults(GlobalObjectiveFunction pGlobalObjectiveFunction, WobjResultList pCalibrationResults, WobjResultList pValidationResults) {
        this.fCalibrationResults = pCalibrationResults;
        this.fValidationResults = pValidationResults;
        this.fGlobalObjectiveFunction = pGlobalObjectiveFunction;
    }

    public WobjRunResults(GlobalObjectiveFunction pGlobalObjectiveFunction, int pCapacity, WobjResult pWobjCalibrationBest, WobjResult pWobjValidationForCalibrationBest) {
        this.fGlobalObjectiveFunction = pGlobalObjectiveFunction;
        this.fCalibrationResults = new WobjResultList(pCapacity, this.fGlobalObjectiveFunction.getActivePartNumber());
        this.fValidationResults = new WobjResultList(pCapacity, this.fGlobalObjectiveFunction.getActivePartNumber());
        this.fWobjCalibrationBest = pWobjCalibrationBest;
        this.fWobjValidationForCalibrationBest = pWobjValidationForCalibrationBest;
    }

    public void merge(WobjRunResults pResults) {
        if (pResults != null) {
            this.fCalibrationResults.merge(pResults.fCalibrationResults);
            this.fValidationResults.merge(pResults.fValidationResults);
        }
    }

    public WobjResultList getCalibrationResults() {
        return this.fCalibrationResults;
    }

    public WobjResultList getValidationResults() {
        return this.fValidationResults;
    }

    public WobjResult getWobjCalibrationBest() {
        return this.fWobjCalibrationBest;
    }

    public WobjResult getWobjValidationForCalibrationBest() {
        return this.fWobjValidationForCalibrationBest;
    }

    public GlobalObjectiveFunction getGlobalObjectiveFunction() {
        return this.fGlobalObjectiveFunction;
    }

    public String getGlobalFctLabel() {
        return this.fGlobalObjectiveFunction.toString();
    }

    public String functionLabel(int pIndice) {
        return this.fGlobalObjectiveFunction.getDescriptors().get(pIndice).toStringWithoutWeight();
    }

    public double getWeight(int pIndice) {
        return this.fGlobalObjectiveFunction.getDescriptors().get(pIndice).getWeight();
    }
}

