/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj;

import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionDescriptor;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionFactory;
import fr.geonosis.karstmod.modele.obj.WobjResult;
import fr.geonosis.karstmod.modele.obj.WobjResultList;
import fr.geonosis.karstmod.modele.obj.WobjVar;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.run.model.RunResult;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;

public class GlobalObjectiveFunction
implements Observable {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private static final String KEY_EXPR = "expr";
    private final List<ObjectiveFunctionDescriptor> fDescriptors;
    private final List<AbstractObjectiveFunction> fFunctions;
    private final List<InvalidationListener> fListeners = new ArrayList<InvalidationListener>();
    private final List<Double> fWeights;
    private WobjResultList fWobjResults;
    private double fWobjMin;
    private boolean fFromExpression = false;
    private double fCoefSum = 0.0;

    public GlobalObjectiveFunction() {
        this.fDescriptors = new ArrayList<ObjectiveFunctionDescriptor>();
        this.fFunctions = new ArrayList<AbstractObjectiveFunction>();
        this.fWeights = new ArrayList<Double>();
    }

    public void addPart(ObjectiveFunctionDescriptor pDescriptor) {
        this.addDescriptor(pDescriptor);
        this.fireChanged();
    }

    private void addDescriptor(ObjectiveFunctionDescriptor pDescriptor) {
        this.fDescriptors.add(pDescriptor);
        if (pDescriptor.getWeight() != 0.0) {
            this.fWeights.add(pDescriptor.getWeight());
        }
        this.fCoefSum += pDescriptor.getWeight();
    }

    public boolean isFromExpression() {
        return this.fFromExpression;
    }

    public void setFromExpression(boolean pFromExpression) {
        this.fFromExpression = pFromExpression;
    }

    public void load(Properties pProperties, String pPrefixe) throws Exception {
        try {
            this.clear();
            HashSet<Integer> fctIndices = new HashSet<Integer>();
            for (Object key : pProperties.keySet()) {
                if (!key.toString().startsWith(pPrefixe + "f")) continue;
                try {
                    fctIndices.add(Integer.parseInt(key.toString().substring((pPrefixe + "f").length()).split("\\.")[0]));
                }
                catch (Exception ex) {
                    throw new Exception("Unexpected key in property file : " + key);
                }
            }
            Iterator<Object> iterator = fctIndices.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.addDescriptor(new ObjectiveFunctionDescriptor(pProperties, pPrefixe + "f" + i + "."));
            }
            this.fFromExpression = Boolean.parseBoolean(pProperties.getProperty(pPrefixe + KEY_EXPR, "false"));
        }
        catch (Exception ex) {
            this.clear();
            throw ex;
        }
        finally {
            this.fireChanged();
        }
    }

    public void save(Properties pProperties, String pPrefixe) {
        for (int i = 0; i < this.fDescriptors.size(); ++i) {
            this.fDescriptors.get(i).save(pProperties, pPrefixe + "f" + (i + 1) + ".");
        }
        pProperties.put(pPrefixe + KEY_EXPR, String.valueOf(this.fFromExpression));
    }

    public List<ObjectiveFunctionDescriptor> getDescriptors() {
        return List.copyOf(this.fDescriptors);
    }

    public void init(InputData pInputData, List<StageBounds> pStages, int pNMax, double pWobjMin, int pIoShift) {
        this.fWobjMin = pWobjMin;
        this.fFunctions.clear();
        for (ObjectiveFunctionDescriptor descriptor : this.fDescriptors) {
            if (descriptor.getWeight() == 0.0) continue;
            WobjVar var = new WobjVar(descriptor.getVarname(), pInputData.getValues(descriptor.getVarname().getColumnName()), descriptor.getRange(), descriptor.getConverter(), pStages);
            AbstractObjectiveFunction function = ObjectiveFunctionFactory.createFunction(descriptor.getFunctionClass(), descriptor.getParameters());
            this.fFunctions.add(function);
            function.init(var, pIoShift);
        }
        this.fWobjResults = new WobjResultList(pNMax, this.fFunctions.size());
    }

    public WobjResult compute(RunResult pResult) {
        double[] objs = new double[this.fFunctions.size()];
        for (int i = 0; i < this.fFunctions.size(); ++i) {
            objs[i] = this.fWeights.get(i) / this.fCoefSum * this.fFunctions.get(i).computeValue(this.fFunctions.get(i).createSimVar(pResult.getValues(this.fFunctions.get(i).getVarName())));
        }
        return new WobjResult(objs);
    }

    public void save(WobjResult pResult) {
        if (pResult.getRes() >= this.fWobjMin) {
            this.fWobjResults.addValues(pResult);
        }
    }

    public synchronized WobjResult computeAndSave(RunResult pResult) {
        WobjResult wobjResult = this.compute(pResult);
        this.save(wobjResult);
        return wobjResult;
    }

    public String toString() {
        if (this.fDescriptors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ObjectiveFunctionDescriptor descriptor : this.fDescriptors) {
            String s = descriptor.toString();
            if (s.length() <= 0) continue;
            sb.append(s).append(" + ");
        }
        if (sb.length() >= 3) {
            sb.setLength(sb.length() - 3);
        }
        return sb.toString();
    }

    public String toHtmlString() {
        if (this.fDescriptors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (ObjectiveFunctionDescriptor descriptor : this.fDescriptors) {
            String s = descriptor.toString();
            if (s.length() <= 0) continue;
            sb.append(s).append(" + ");
        }
        sb.setLength(sb.length() - 3);
        sb.append("</html>");
        return sb.toString();
    }

    public GlobalObjectiveFunction clone() {
        GlobalObjectiveFunction res = new GlobalObjectiveFunction();
        for (ObjectiveFunctionDescriptor descriptor : this.fDescriptors) {
            res.addPart(descriptor.clone());
        }
        return res;
    }

    public WobjResultList getWobjResults() {
        return this.fWobjResults;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (ObjectiveFunctionDescriptor descriptor : this.fDescriptors) {
            result = 31 * result + this.fDescriptors.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalObjectiveFunction other = (GlobalObjectiveFunction)obj;
        for (int i = 0; i < this.fDescriptors.size(); ++i) {
            if (Objects.equals(this.fDescriptors.get(i), other.fDescriptors.get(i))) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.fDescriptors.clear();
        this.fFunctions.clear();
        this.fWeights.clear();
        this.fCoefSum = 0.0;
        this.fireChanged();
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    private void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }

    public int getActivePartNumber() {
        return (int)this.fDescriptors.stream().filter(d -> d.getWeight() != 0.0).count();
    }

    public Set<Varname> getUsedVarnames() {
        TreeSet<Varname> varnames = new TreeSet<Varname>();
        for (ObjectiveFunctionDescriptor descriptor : this.fDescriptors) {
            if (!(descriptor.getWeight() > 0.0)) continue;
            varnames.add(descriptor.getVarname());
        }
        return varnames;
    }

    public AbstractObjectiveFunction getFunction(int pI) {
        return this.fFunctions.get(pI);
    }

    public double getCoefSum() {
        return this.fCoefSum;
    }

    public boolean containsFunction(Class<? extends AbstractObjectiveFunction> pClass) {
        for (ObjectiveFunctionDescriptor d : this.fDescriptors) {
            if (!d.getFunctionClass().equals(pClass) || d.getWeight() == 0.0) continue;
            return true;
        }
        return false;
    }
}

