/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow.law;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.SensLoiVidange;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.TypeLoiVidange;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.law.AbstractDischargeLaw;

public class NashFallLaw
extends AbstractDischargeLaw {
    public static final String K = Messages.getString("LoiLineaire.0");
    public static final String ATTR_K = "k";
    public static final String ATTR_N = "n";
    private Parameter fK;
    private Parameter fN;

    public NashFallLaw() {
        this.fParameters = new ParameterList();
        this.initParametres();
    }

    @Override
    public void setFluxVidange(ClassicalDischargeFlow pFluxVidange) {
        this.fFluxVidange = pFluxVidange;
        for (Parameter p : this.getParameters()) {
            p.setLabel(p.getShortName() + this.fFluxVidange.getName().substring(1));
            p.setLibelleHtml(p.getHtmlLabel() + this.fFluxVidange.getHtmlLabel().substring(this.fFluxVidange.getHtmlLabel().indexOf("<sub>")));
        }
    }

    @Override
    public void reset() {
    }

    private void initParametres() {
        this.fK = new Parameter(ATTR_K, K, "<i>" + K + "</i>", true, false, TypeInit.LOG, Dimension.K, 0.001, 0.1);
        this.fK.setValue(0.01);
        this.fN = new Parameter(ATTR_N, ATTR_N, "<i>n</i>", true, false, TypeInit.DEFAULT, Dimension.NONE, 2.0, 3.0);
        this.fN.setValue(2.0);
        this.fParameters.add(this.fN);
        this.fParameters.add(this.fK);
    }

    @Override
    public TypeLoiVidange getType() {
        return TypeLoiVidange.LENTE;
    }

    @Override
    public SensLoiVidange getSens() {
        return SensLoiVidange.ALLER;
    }

    @Override
    public String getName() {
        return Messages.getString("LoiLineaire.5");
    }

    @Override
    public String detail() {
        return this.getName() + "\n  - " + K + " : " + this.fK;
    }

    @Override
    public String getToolTip(String pDe, String pA) {
        return "TODO";
    }

    public Parameter getK() {
        return this.fK;
    }

    public Parameter getN() {
        return this.fN;
    }

    @Override
    public boolean needsAlwaysCompute() {
        return false;
    }
}

