/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.ICible;
import fr.geonosis.karstmod.modele.IElement;
import fr.geonosis.karstmod.modele.IParametrable;
import fr.geonosis.karstmod.modele.ISource;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.Piezo;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Reservoir
extends AbstractElement
implements ISource,
ICible,
IParametrable {
    private static final String PAS_DE_FLUX_ENTRANT = Messages.getString("Reservoir.0");
    private static final String PAS_DE_FLUX_SORTANT = Messages.getString("Reservoir.1");
    public static final String MIN = Messages.getString("Reservoir.3");
    private final List<IChild> fInputs;
    private final List<Flow> fOutputFlows = new ArrayList<Flow>();
    private final Piezo fPiezo;
    private final boolean fActivable;
    private boolean fInputRequired;
    private final List<ReservoirConfig> fConfigs;

    public Reservoir(String pNom, String pLibelleHtml, boolean pActivable) {
        super(pNom, pLibelleHtml, pNom);
        this.fInputs = new ArrayList<IChild>();
        this.fPiezo = new Piezo(pNom);
        this.fPiezo.getParentsHandler().addParent(this);
        this.addParameters(this.fPiezo.getParameters());
        this.fConfigs = new ArrayList<ReservoirConfig>();
        this.fActivable = pActivable;
        this.setSelected(false);
        this.fInputRequired = true;
        this.tooltipTextproperty().set((Object)("<html>" + this.getHtmlLabel() + "<html>"));
        this.htmlLabelProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)("<html>" + this.getHtmlLabel() + "<html>")));
    }

    @Override
    public void addInput(IChild pInput) {
        this.fInputs.add(pInput);
        pInput.getParentsHandler().addParent(this);
    }

    @Override
    public void addOutputFlow(Flow pFlow) {
        this.fOutputFlows.add(pFlow);
        pFlow.getParentsHandler().addParent(this);
    }

    public String toString() {
        return this.getName();
    }

    public String toStringHtml() {
        return this.getHtmlLabel();
    }

    @Override
    public MessageList validate() {
        MessageList messages = super.validate();
        if (this.isActive() && this.fInputRequired && !IElement.auMoinsUnfluxActive(this.fInputs) && !IElement.auMoinsUnfluxBidirectionnelActive(this.fOutputFlows)) {
            messages.addError(PAS_DE_FLUX_ENTRANT, this.getName());
        }
        if (this.isActive() && !IElement.auMoinsUnfluxActive(this.fOutputFlows) && !IElement.auMoinsUnfluxBidirectionnelActive(this.fInputs)) {
            messages.addError(PAS_DE_FLUX_SORTANT, this.getName());
        }
        if (this.activeConfig() != null) {
            messages.addAll(this.activeConfig().validate());
        } else {
            messages.addError("no configuration selected", this.getName());
        }
        return messages;
    }

    @Override
    public String detail() {
        return super.detail() + "  - " + this.getName();
    }

    public List<Flow> getOutputFlows() {
        return this.fOutputFlows;
    }

    public Piezo getPiezo() {
        return this.fPiezo;
    }

    public List<ReservoirConfig> getConfigs() {
        return this.fConfigs;
    }

    @Override
    public boolean isActivable() {
        return this.fActivable;
    }

    public List<IChild> getInputFlows() {
        return this.fInputs;
    }

    public boolean selectNextConfig() {
        int sel = -1;
        for (int i = 0; sel == -1 && i < this.fConfigs.size(); ++i) {
            if (!this.fConfigs.get(i).isSelected()) continue;
            sel = i;
        }
        for (int i = 0; i < this.fConfigs.size(); ++i) {
            ReservoirConfig config = this.fConfigs.get((sel + i + 1) % this.fConfigs.size());
            if (!config.getParentsHandler().isActive()) continue;
            config.setSelected(true);
            return true;
        }
        return false;
    }

    public ReservoirConfig activeConfig() {
        for (ReservoirConfig config : this.fConfigs) {
            if (!config.isActive()) continue;
            return config;
        }
        return null;
    }

    @Override
    String getPropertiesPrefixe(String pPrefixe) {
        return pPrefixe + this.getPropertyName().replaceAll(" ", "_") + ".";
    }

    @Override
    public void save(Properties pProperties, String pPrefixe, boolean pActiveOnly) {
        super.save(pProperties, pPrefixe, pActiveOnly);
        for (ReservoirConfig config : this.fConfigs) {
            config.save(pProperties, this.getPropertiesPrefixe(pPrefixe), pActiveOnly);
        }
        pProperties.put(this.getPropertiesPrefixe(pPrefixe) + "piezo.selected", String.valueOf(this.fPiezo.isSelected()));
    }

    @Override
    public void load(Properties pProperties, String pPrefixe) throws Exception {
        super.load(pProperties, pPrefixe);
        String key = this.getPropertiesPrefixe(pPrefixe) + "piezo.selected";
        if (!pProperties.containsKey(key)) {
            throw new Exception(Messages.getString("AbstractElement.2") + " : " + key);
        }
        this.fPiezo.setSelected(Boolean.parseBoolean(pProperties.getProperty(key)));
        for (ReservoirConfig config : this.fConfigs) {
            config.load(pProperties, this.getPropertiesPrefixe(pPrefixe));
        }
    }

    public ReservoirConfig getConfig(ReservoirConfigType pType) {
        for (ReservoirConfig config : this.fConfigs) {
            if (config.getType() != pType) continue;
            return config;
        }
        return null;
    }

    public Parameter getH0() {
        for (ReservoirConfig config : this.fConfigs) {
            if (!config.isActive()) continue;
            return config.getH0();
        }
        return null;
    }

    public boolean isInputRequired() {
        return this.fInputRequired;
    }

    public void setInputRequired(boolean pInputRequired) {
        this.fInputRequired = pInputRequired;
    }
}

