/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.TypeInit;

public class Piezo
extends AbstractElement {
    public static final String ATTR_W = "w";
    public static final String ATTR_Z0 = "Z0";
    private Parameter fW;
    private Parameter fZ0;

    public Piezo(String pNomReservoir) {
        super("Z" + pNomReservoir, "Z<sub>" + pNomReservoir + "</sub>", "piezo");
        this.setAlwaysVisible(true);
        this.initParametres(pNomReservoir);
        this.tooltipTextproperty().set((Object)("<html>Piezometer " + this.getHtmlLabel() + "</html>"));
        this.htmlLabelProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)("<html>Piezometer " + this.getHtmlLabel() + "</html>")));
    }

    private void initParametres(String pNomReservoir) {
        this.fW = new Parameter(ATTR_W, "\u03c9" + pNomReservoir, "\u03c9<sub>" + pNomReservoir + "</sub>", true, false, TypeInit.DEFAULT, Dimension.NONE, 0.001, 0.01);
        this.addParameter(this.fW);
        this.fW.addValidator(new RangeValidator(0.0, false, null, false));
        this.fZ0 = new Parameter(ATTR_Z0, ATTR_Z0 + pNomReservoir, "Z<sub>0" + pNomReservoir + "</sub>", true, false, TypeInit.DEFAULT, Dimension.PIEZO, 0.0, 0.0);
        this.addParameter(this.fZ0);
    }

    public String toString() {
        return "Piezometer " + this.getName();
    }

    public String toStringHtml() {
        return "Piezometer " + this.getHtmlLabel();
    }

    @Override
    public String detail() {
        return super.detail() + "  - Piezo :   - w : " + this.fW + "  - Z0 : " + this.fZ0 + "\n";
    }
}

