/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.KarstModException;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.IFlowGroupElement;
import fr.geonosis.karstmod.modele.IParameterValidator;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.ParameterConstraint;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.modele.observable.ChildrenHandler;
import fr.geonosis.karstmod.modele.observable.IParent;
import fr.geonosis.karstmod.modele.observable.ParentsHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;

public class Parameter
implements IParent,
IFlowGroupElement {
    private static final String NAME_PARAMETER = "@@name";
    public static final String ATTR_SELECTED = "selected";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_VALUE = "value";
    private final String fShortName;
    private final StringProperty fHtmlLabelProperty;
    private final String fAttrName;
    private final ObjectProperty<Double> fMinProperty;
    private final ObjectProperty<Double> fMaxProperty;
    private final ObjectProperty<Double> fValueProperty;
    private final BooleanProperty fCalibrateProperty;
    private final BooleanProperty fSelectedProperty = new SimpleBooleanProperty();
    private final TypeInit fTypeInit;
    private final Dimension fDimension;
    private final IntegerProperty fModeProperty;
    private final BooleanProperty fActiveProperty = new SimpleBooleanProperty();
    private final List<InvalidationListener> fListeners;
    private final ParentsHandler fParentsHandler;
    private final ChildrenHandler fChildrenHandler;
    private final boolean fHasValue;
    private final List<IParameterValidator> fValidators;
    private String fLabel;
    private double fMinIni;
    private double fMaxIni;
    private boolean fActivable;
    private ParameterConstraint fConstraint;
    private Color fColor;
    private ChangeListener<Object> fConstraintListener;
    private int fLevel;
    private boolean fConstant;
    private boolean fTop = true;
    private final StringProperty fTooltipTextProperty;

    public Parameter(String pNomAttribut, String pLibelle, String pLibelleHtml, boolean pSelected, boolean pActivable, TypeInit pTypeInit, Dimension pDimension, double pMin, double pMax) {
        this(pNomAttribut, pLibelle, pLibelleHtml, pSelected, pActivable, pTypeInit, pDimension);
        this.setMin(pMin);
        this.setMax(pMax);
        this.fMinIni = pMin;
        this.fMaxIni = pMax;
    }

    public Parameter(String pNomAttribut, String pLibelle, String pLibelleHtml, boolean pSelected, boolean pActivable, TypeInit pTypeInit, Dimension pDimension) {
        this.fMinProperty = new SimpleObjectProperty();
        this.fMaxProperty = new SimpleObjectProperty();
        this.fValueProperty = new SimpleObjectProperty();
        this.fModeProperty = new SimpleIntegerProperty();
        this.fCalibrateProperty = new SimpleBooleanProperty();
        this.fTooltipTextProperty = new SimpleStringProperty();
        this.fParentsHandler = new ParentsHandler(this);
        this.fChildrenHandler = new ChildrenHandler(this);
        this.fListeners = new ArrayList<InvalidationListener>();
        this.fValidators = new ArrayList<IParameterValidator>();
        this.fSelectedProperty.addListener((pObservable, pOldValue, pNewValue) -> this.fActiveProperty.set(this.isActive()));
        for (Property property : new Property[]{this.fSelectedProperty, this.fMinProperty, this.fMaxProperty, this.fValueProperty}) {
            property.addListener((pObservable, pOldValue, pNewValue) -> this.fireChanged());
        }
        for (Property property : new Property[]{this.fActiveProperty, this.fModeProperty, this.fMaxProperty, this.fMinProperty}) {
            property.addListener((pObservable, pOldValue, pNewValue) -> this.fCalibrateProperty.set(this.needsCalibration()));
        }
        this.setMin(0.0);
        this.setMax(0.0);
        this.setValue(0.0);
        this.setMode(ModeKarstMod.CALIBRATION);
        this.fHasValue = true;
        this.fAttrName = pNomAttribut;
        this.fShortName = pLibelle;
        this.fLabel = pLibelle;
        this.fHtmlLabelProperty = new SimpleStringProperty(pLibelleHtml);
        this.fSelectedProperty.set(pSelected);
        this.fActivable = pActivable;
        this.fTypeInit = pTypeInit;
        this.fDimension = pDimension;
    }

    public Parameter(String pNomAttribut, String pLibelle, String pLibelleHtml, boolean pSelected) {
        this.fCalibrateProperty = new SimpleBooleanProperty(false);
        this.fTooltipTextProperty = new SimpleStringProperty();
        this.fModeProperty = new SimpleIntegerProperty();
        this.fParentsHandler = new ParentsHandler(this);
        this.fChildrenHandler = new ChildrenHandler(this);
        this.fListeners = new ArrayList<InvalidationListener>();
        this.fValidators = new ArrayList<IParameterValidator>();
        this.fValueProperty = null;
        this.fMinProperty = null;
        this.fMaxProperty = null;
        this.fSelectedProperty.addListener((pObservable, pOldValue, pNewValue) -> {
            this.fActiveProperty.set(this.isActive());
            this.fireChanged();
        });
        this.setMode(ModeKarstMod.CALIBRATION);
        this.fAttrName = pNomAttribut;
        this.fShortName = pLibelle;
        this.fLabel = pLibelle;
        this.fHtmlLabelProperty = new SimpleStringProperty(pLibelleHtml);
        this.fSelectedProperty.set(pSelected);
        this.fActivable = true;
        this.fHasValue = false;
        this.fTypeInit = null;
        this.fDimension = null;
    }

    public void addValidator(IParameterValidator pValidator) {
        this.fValidators.add(pValidator);
    }

    public List<Parameter> getValidateChainedParameters() {
        ArrayList<Parameter> res = new ArrayList<Parameter>();
        if (!this.fValidators.isEmpty()) {
            for (IParameterValidator validator : this.fValidators) {
                res.addAll(validator.chainedParameters());
            }
        }
        return res;
    }

    @Override
    public ChildrenHandler getChildrenHandler() {
        return this.fChildrenHandler;
    }

    @Override
    public ParentsHandler getParentsHandler() {
        return this.fParentsHandler;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String pLibelle) {
        this.fLabel = pLibelle;
    }

    public Double getMin() {
        return (Double)this.fMinProperty.get();
    }

    public void setMin(double pMin) {
        this.fMinProperty.set((Object)pMin);
    }

    public Double getMax() {
        return this.fConstant ? this.getMin() : (Double)this.fMaxProperty.get();
    }

    public void setMax(double pMax) {
        this.fMaxProperty.set((Object)pMax);
    }

    @Override
    public boolean isActive() {
        return this.isSelected() && this.fParentsHandler.isActive();
    }

    @Override
    public boolean isSelected() {
        return this.fSelectedProperty.get();
    }

    @Override
    public void setSelected(boolean pSelected) {
        this.fSelectedProperty.set(pSelected);
    }

    public Double getValue() {
        if (this.fConstant) {
            return (Double)this.fMinProperty.getValue();
        }
        if (this.fValueProperty == null) {
            return this.isSelected() ? 1.0 : 0.0;
        }
        return (Double)this.fValueProperty.get();
    }

    public void setValue(double pValeur) {
        this.fValueProperty.set((Object)pValeur);
        if (this.fConstant) {
            this.setMin(pValeur);
            this.setMax(pValeur);
        }
    }

    @Override
    public boolean isActivable() {
        return this.fActivable;
    }

    public void setActivable(boolean pActivable) {
        this.fActivable = pActivable;
    }

    public String getAttrName() {
        return this.fAttrName;
    }

    public void save(Properties pProperties, String pPrefixe, boolean pActiveOnly) {
        String prefixe = this.getPropertiesPrefixe(pPrefixe);
        if (!pActiveOnly || this.isActive()) {
            pProperties.put(prefixe + ATTR_SELECTED, String.valueOf(this.fSelectedProperty.get()));
            if (this.fMinProperty != null) {
                pProperties.put(prefixe + ATTR_MIN, String.valueOf(this.getMin()));
            }
            if (this.fMaxProperty != null) {
                pProperties.put(prefixe + ATTR_MAX, String.valueOf(this.getMax()));
            }
            if (this.fValueProperty != null) {
                pProperties.put(prefixe + ATTR_VALUE, String.valueOf(this.getValue()));
            }
            if (this.fConstraint != null) {
                this.fConstraint.save(pProperties, pPrefixe + "constraint.", pActiveOnly);
            }
        }
    }

    public void load(Properties pProperties, String pPrefixe) throws Exception {
        String prefixe = this.getPropertiesPrefixe(pPrefixe);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(ATTR_SELECTED);
        if (this.fMinProperty != null) {
            keys.add(ATTR_MIN);
        }
        if (this.fMaxProperty != null) {
            keys.add(ATTR_MAX);
        }
        if (this.fValueProperty != null) {
            keys.add(ATTR_VALUE);
        }
        for (String string : keys) {
            String string2 = prefixe + string;
            if (pProperties.containsKey(string2)) continue;
            throw new KarstModException(Messages.getString("Parametre.0") + " " + string2 + " " + Messages.getString("Parametre.8") + ".");
        }
        this.setSelected(Boolean.parseBoolean(pProperties.getProperty(prefixe + ATTR_SELECTED)));
        if (this.fMinProperty != null) {
            this.setMin(Double.parseDouble(pProperties.getProperty(prefixe + ATTR_MIN)));
        }
        if (this.fMaxProperty != null) {
            this.setMax(Double.parseDouble(pProperties.getProperty(prefixe + ATTR_MAX)));
        }
        if (this.fValueProperty != null) {
            this.setValue(Double.parseDouble(pProperties.getProperty(prefixe + ATTR_VALUE)));
        }
        if (this.fConstraint != null) {
            this.fConstraint.load(pProperties, pPrefixe + "constraint.");
        }
    }

    private String getPropertiesPrefixe(String pPrefixe) {
        return pPrefixe + this.getAttrName().replace(" ", "_") + ".";
    }

    public MessageList validate() {
        MessageList list = new MessageList();
        if (this.hasValue()) {
            if (this.getMode() == ModeKarstMod.CALIBRATION) {
                if (this.fConstraint != null && this.fConstraint.isActive()) {
                    switch (this.fConstraint.getType()) {
                        case EQUAL: {
                            break;
                        }
                        case GREATER: {
                            if (this.getMax() == null || Double.isNaN(this.getMax())) {
                                list.addError(Messages.getString("Parametre.16"), this.getLabel());
                                break;
                            }
                            if (!(this.getMax() < this.fConstraint.getParameter().getMax())) break;
                            list.addError(Messages.getString("Parametre.21").replace(NAME_PARAMETER, this.fConstraint.getParameter().getLabel()), this.getLabel());
                            break;
                        }
                        case LESSER: {
                            if (this.getMin() == null || Double.isNaN(this.getMin())) {
                                list.addError(Messages.getString("Parametre.14"), this.getLabel());
                                break;
                            }
                            if (!(this.getMin() > this.fConstraint.getParameter().getMin())) break;
                            list.addError(Messages.getString("Parametre.22").replace(NAME_PARAMETER, this.fConstraint.getParameter().getLabel()), this.getLabel());
                        }
                    }
                } else {
                    if (this.getMin() == null || Double.isNaN(this.getMin())) {
                        if (this.isConstant()) {
                            list.addError(Messages.getString("Parametre.171"), this.getLabel());
                        } else {
                            list.addError(Messages.getString("Parametre.14"), this.getLabel());
                        }
                    }
                    if (!this.isConstant() && (this.getMax() == null || Double.isNaN(this.getMax()))) {
                        list.addError(Messages.getString("Parametre.16"), this.getLabel());
                    }
                    if (this.getMin() != null && this.getMax() != null && this.getMin() > this.getMax()) {
                        list.addError(Messages.getString("Parametre.18"), this.getLabel());
                    }
                }
            } else if (this.getMode() == ModeKarstMod.RUN) {
                if (this.getValue() == null || Double.isNaN(this.getValue())) {
                    list.addError(Messages.getString("Parametre.17"), this.getLabel());
                } else if (this.fConstraint != null && this.fConstraint.isActive()) {
                    switch (this.fConstraint.getType()) {
                        case EQUAL: {
                            break;
                        }
                        case GREATER: {
                            if (!(this.getValue() < this.fConstraint.getParameter().getValue())) break;
                            list.addError(Messages.getString("Parametre.210").replace(NAME_PARAMETER, this.fConstraint.getParameter().getLabel()), this.getLabel());
                            break;
                        }
                        case LESSER: {
                            if (!(this.getValue() > this.fConstraint.getParameter().getValue())) break;
                            list.addError(Messages.getString("Parametre.220").replace(NAME_PARAMETER, this.fConstraint.getParameter().getLabel()), this.getLabel());
                        }
                    }
                }
            }
        }
        for (IParameterValidator validator : this.fValidators) {
            list.addAll(validator.validate(this));
        }
        return list;
    }

    public TypeInit getTypeInit() {
        return this.fTypeInit;
    }

    public Dimension getDimension() {
        return this.fDimension;
    }

    public void setLibelleHtml(String pLibelleHtml) {
        this.fHtmlLabelProperty.set((Object)pLibelleHtml);
    }

    @Override
    public StringProperty htmlLabelProperty() {
        return this.fHtmlLabelProperty;
    }

    public void raz() {
        if (this.fMinProperty != null) {
            this.setMin(this.fMinIni);
        }
        if (this.fMaxProperty != null) {
            this.setMax(this.fMaxIni);
        }
        if (this.fValueProperty != null) {
            this.setValue(Double.NaN);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Messages.getString("Parametre.0") + " [fLibelle=" + this.fLabel);
        if (this.fHasValue) {
            sb.append(", fMin=").append(this.fMinProperty.get()).append(", fMax=").append(this.fMaxProperty.get()).append(", fValeur=").append(this.fValueProperty.get());
        }
        sb.append("]\n");
        return sb.toString();
    }

    public boolean needsCalibration() {
        return this.fHasValue && this.getMode() == ModeKarstMod.CALIBRATION && this.isActive() && !this.getMax().equals(this.getMin()) && (this.fConstraint == null || !this.fConstraint.isActive() || this.fConstraint.needsCalibration());
    }

    public String getShortName() {
        return this.fShortName;
    }

    public ParameterConstraint getConstraint() {
        return this.fConstraint;
    }

    public void setConstraint(ParameterConstraint pConstraint) {
        if (this.fConstraint == pConstraint) {
            return;
        }
        if (this.fConstraint != null) {
            this.fConstraint.getParentsHandler().removeParent(this);
            this.fConstraint.calibrateProperty().removeListener(this.fConstraintListener);
            this.fConstraint.activeProperty().removeListener(this.fConstraintListener);
        }
        this.fConstraint = pConstraint;
        this.fConstraint.getParentsHandler().addParent(this);
        this.fConstraintListener = (pObservable, pOldValue, pNewValue) -> this.fCalibrateProperty.set(this.needsCalibration());
        this.fConstraint.calibrateProperty().addListener(this.fConstraintListener);
        this.fConstraint.activeProperty().addListener(this.fConstraintListener);
        this.fConstraint.addListener(pObs -> this.fireChanged());
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color pColor) {
        this.fColor = pColor;
    }

    public ObjectProperty<Double> minProperty() {
        return this.fMinProperty;
    }

    public ObjectProperty<Double> maxProperty() {
        return this.fMaxProperty;
    }

    public ObjectProperty<Double> valueProperty() {
        return this.fValueProperty;
    }

    public BooleanProperty selectedProperty() {
        return this.fSelectedProperty;
    }

    public IntegerProperty modeProperty() {
        return this.fModeProperty;
    }

    @Override
    public BooleanProperty activeProperty() {
        return this.fActiveProperty;
    }

    public BooleanProperty calibrateProperty() {
        return this.fCalibrateProperty;
    }

    public ModeKarstMod getMode() {
        return ModeKarstMod.values()[this.fModeProperty.get()];
    }

    public void setMode(ModeKarstMod pMode) {
        this.fModeProperty.set(pMode.ordinal());
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    private void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }

    public boolean hasValue() {
        return this.fHasValue;
    }

    @Override
    public String getToolTipText() {
        return (String)this.htmlLabelProperty().get();
    }

    @Override
    public String getHtmlFormulaLabel() {
        return (String)this.htmlLabelProperty().get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fAttrName == null ? 0 : this.fAttrName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.fLabel == null) {
            return other.fLabel == null;
        }
        return this.fLabel.equals(other.fLabel);
    }

    public int getLevel() {
        return this.fLevel;
    }

    public void setLevel(int pLevel) {
        this.fLevel = pLevel;
    }

    public String getHtmlLabel() {
        return (String)this.htmlLabelProperty().get();
    }

    public boolean isTop() {
        return this.fTop;
    }

    public void setTop(boolean pTop) {
        this.fTop = pTop;
    }

    public void resetToMidValue() {
        if (this.fHasValue) {
            if (this.fTypeInit == TypeInit.DEFAULT) {
                this.setValue((this.getMin() + this.getMax()) / 2.0);
            } else if (this.fTypeInit == TypeInit.LOG) {
                this.setValue(Math.pow(10.0, (Math.log10(this.getMin()) + Math.log10(this.getMax())) / 2.0));
            }
        }
    }

    public boolean isConstant() {
        return this.fConstant;
    }

    public void setConstant(boolean pConstant) {
        this.fConstant = pConstant;
    }

    @Override
    public StringProperty tooltipTextproperty() {
        return this.fTooltipTextProperty;
    }

    public String columnTitle() {
        String unit = Unit.getInstance().getBase().get(this.fDimension);
        return String.format("%s%s", this.fLabel, unit == null || unit.isBlank() ? "" : " (" + unit.replace('\u00b3', '3').replace('\u00b2', '2') + ")");
    }
}

