/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.Message;
import fr.geonosis.karstmod.modele.MessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageList {
    private final Map<MessageType, List<Message>> fMessages = new HashMap<MessageType, List<Message>>();

    public MessageList() {
        for (MessageType type : MessageType.values()) {
            this.fMessages.put(type, new ArrayList());
        }
    }

    public void add(MessageType pType, String pMessage) {
        this.fMessages.get((Object)pType).add(new Message(pMessage, pType));
    }

    public void add(MessageType pType, String pMessage, String pFieldName) {
        this.fMessages.get((Object)pType).add(new Message(pMessage, pType, pFieldName));
    }

    public void addInfo(String pMessage, String pFieldName) {
        this.add(MessageType.INFO, pMessage, pFieldName);
    }

    public void addWarning(String pMessage, String pFieldName) {
        this.add(MessageType.WARNING, pMessage, pFieldName);
    }

    public void addError(String pMessage, String pFieldName) {
        this.add(MessageType.ERROR, pMessage, pFieldName);
    }

    public boolean has(MessageType pType) {
        return !this.fMessages.get((Object)pType).isEmpty();
    }

    public List<Message> getMessages(MessageType pType) {
        return this.fMessages.get((Object)pType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MessageType type : new MessageType[]{MessageType.ERROR, MessageType.WARNING, MessageType.INFO}) {
            for (Message msg : this.fMessages.get((Object)type)) {
                sb.append(msg).append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString().replaceAll("<[^>]*>", "").replaceAll("</[^>]*>", "");
    }

    public String toBasicString() {
        StringBuilder sb = new StringBuilder();
        for (MessageType type : new MessageType[]{MessageType.ERROR, MessageType.WARNING, MessageType.INFO}) {
            for (Message msg : this.fMessages.get((Object)type)) {
                Object s = msg.getMessage();
                if (s != null && ((String)s).trim().length() > 0) {
                    s = ((String)s).substring(0, 1).toUpperCase() + ((String)s).substring(1);
                }
                if (s == null) continue;
                if (!((String)s).endsWith(".")) {
                    s = (String)s + ".";
                }
                sb.append((String)s).append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void addAll(MessageList pMessageList) {
        for (Map.Entry<MessageType, List<Message>> entry : pMessageList.fMessages.entrySet()) {
            this.fMessages.get((Object)entry.getKey()).addAll((Collection<Message>)entry.getValue());
        }
    }
}

