/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.dbe.util.commun.SortedProperties;
import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.BaseUnit;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.RunParameters;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.modele.montecarlo.AMSobolGenerator;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.modele.observable.ChildrenHandler;
import fr.geonosis.karstmod.modele.observable.IParent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public class KarstModConfig
implements Observable {
    private final Model fModel;
    private final RunParameters fRunParameters;
    private final InputData fInputData;
    private final ObjectProperty<File> fConfigFileProperty;
    private final List<InvalidationListener> fListeners;
    private final Object fLock = new Object();
    private ModeKarstMod fMode;
    private boolean fParamsFromFile;
    private AMSobolGenerator fRandomGenerator;
    private final Map<Varname, Double> fDEQuantiles;

    public KarstModConfig() {
        this.fModel = new Model();
        this.fInputData = new InputData();
        this.fRunParameters = new RunParameters(this.fModel, this.fInputData);
        this.fConfigFileProperty = new SimpleObjectProperty();
        this.fMode = ModeKarstMod.CALIBRATION;
        this.fDEQuantiles = new EnumMap<Varname, Double>(Varname.class);
        for (Varname v : Varname.values()) {
            this.setDEQuantile(v, 0.5);
        }
        EnumMap<ColumnName, List<AbstractElement>> map = new EnumMap<ColumnName, List<AbstractElement>>(ColumnName.class);
        map.put(ColumnName.QPUMPL, List.of(this.fModel.getFluxQPumpL()));
        map.put(ColumnName.QPUMPM, List.of(this.fModel.getFluxQPumpM()));
        map.put(ColumnName.QPUMPC, List.of(this.fModel.getFluxQPumpC()));
        map.put(ColumnName.QPUMPS, List.of(this.fModel.getFluxQPumpS()));
        map.put(ColumnName.QSINKL, List.of(this.fModel.getFluxQSinkL()));
        map.put(ColumnName.QSINKM, List.of(this.fModel.getFluxQSinkM()));
        map.put(ColumnName.QSINKC, List.of(this.fModel.getFluxQSinkC()));
        map.put(ColumnName.QSINKS, List.of(this.fModel.getFluxQSinkS()));
        map.put(ColumnName.ZOBSE, List.of(this.fModel.getReservoirE().getPiezo()));
        map.put(ColumnName.ZOBSL, List.of(this.fModel.getReservoirL().getPiezo()));
        map.put(ColumnName.ZOBSM, List.of(this.fModel.getReservoirM().getPiezo()));
        map.put(ColumnName.ZOBSC, List.of(this.fModel.getReservoirC().getPiezo()));
        map.put(ColumnName.ET, List.of(this.fModel.getFluxET()));
        map.put(ColumnName.T, List.of(this.fModel.getPetRoutine(), this.fModel.getSnowRoutine()));
        SimpleBooleanProperty activeProperty = new SimpleBooleanProperty(false);
        IParent parent = new IParent((BooleanProperty)activeProperty){
            final /* synthetic */ BooleanProperty val$activeProperty;
            {
                this.val$activeProperty = booleanProperty;
            }

            @Override
            public ChildrenHandler getChildrenHandler() {
                return new ChildrenHandler(KarstModConfig.this.fModel.getSnowRoutine().getRc());
            }

            @Override
            public ReadOnlyBooleanProperty activeProperty() {
                return this.val$activeProperty;
            }

            @Override
            public boolean isActive() {
                return this.val$activeProperty.get();
            }
        };
        this.fInputData.addListener(arg_0 -> this.lambda$new$0((BooleanProperty)activeProperty, arg_0));
        this.fModel.getSnowRoutine().getRc().getParentsHandler().addParent(parent);
        for (Map.Entry entry : map.entrySet()) {
            final ColumnName columnName = (ColumnName)((Object)entry.getKey());
            for (AbstractElement elt : (List)entry.getValue()) {
                elt.getParentsHandler().addParent(new IParent(){
                    private final ChildrenHandler fChildrenHandler = new ChildrenHandler(this);

                    @Override
                    public boolean isActive() {
                        return KarstModConfig.this.fInputData.contains(columnName);
                    }

                    @Override
                    public ChildrenHandler getChildrenHandler() {
                        return this.fChildrenHandler;
                    }

                    @Override
                    public ReadOnlyBooleanProperty activeProperty() {
                        return KarstModConfig.this.fInputData.presenceProperty(columnName);
                    }
                });
                this.fInputData.presenceProperty(columnName).addListener((observable, oldValue, newValue) -> this.updateTooltip(elt, columnName));
                this.updateTooltip(elt, columnName);
                elt.activeProperty().set(elt.isActive());
            }
        }
        new Thread(() -> {
            GregorianCalendar gc = new GregorianCalendar();
            long seed = 2L * (long)(gc.get(15) / 1000 / 60) * (long)(gc.get(14) + 100 * gc.get(13) + 6000 * gc.get(12) + 360000 * gc.get(11));
            seed &= 0xFFFFFFL;
            this.fRandomGenerator = new AMSobolGenerator(Math.max(1, this.fModel.getParameters().size()));
            Object object = this.fLock;
            synchronized (object) {
                this.fRandomGenerator.setSeed((int)seed);
            }
        }).start();
        this.fListeners = new ArrayList<InvalidationListener>();
        for (Observable o : new Observable[]{this.fModel, this.fInputData, this.fRunParameters.warmupBeginningProperty(), this.fRunParameters.calibrationStagesProperty(), this.fRunParameters.validationStagesProperty(), this.fRunParameters.wobjMinProperty(), this.fRunParameters.getWobjFunction()}) {
            o.addListener(obs -> this.fireChanged());
        }
    }

    private void updateTooltip(AbstractElement pElt, ColumnName pColumnName) {
        Object content = (String)pElt.tooltipTextproperty().get();
        if (content == null) {
            content = "";
        }
        String div = "<br/><div id='warn'>";
        content = ((String)content).replaceAll(div + ".*</div>", "");
        if (!this.fInputData.presenceProperty(pColumnName).get()) {
            content = (String)content + div + "Not activable : no " + pColumnName.getLabel() + " time serie " + (String)(pColumnName.name().equalsIgnoreCase(pColumnName.getLabel()) ? "" : "(" + pColumnName + ")") + "</div>";
        }
        pElt.tooltipTextproperty().set(content);
    }

    public Model getModel() {
        return this.fModel;
    }

    public RunParameters getRunParameters() {
        return this.fRunParameters;
    }

    public InputData getInputData() {
        return this.fInputData;
    }

    public File getConfigFile() {
        return (File)this.fConfigFileProperty.get();
    }

    public ObjectProperty<File> configFileProperty() {
        return this.fConfigFileProperty;
    }

    public Properties save(File pConfigFile) throws IOException {
        Properties properties;
        File oldFile = this.getConfigFile();
        FileWriter fileWriter = new FileWriter(pConfigFile);
        try {
            this.fConfigFileProperty.set((Object)pConfigFile);
            properties = this.save(fileWriter);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                this.fConfigFileProperty.set((Object)oldFile);
                throw ex;
            }
        }
        fileWriter.close();
        return properties;
    }

    public Properties save(Writer pWriter) throws IOException {
        Properties properties = this.saveProperties();
        properties.store(pWriter, "");
        return properties;
    }

    public Properties load(File pConfigFile) throws Exception {
        Properties properties = new Properties();
        try (FileReader fr = new FileReader(pConfigFile);){
            properties.load(fr);
            this.majVersion(properties);
            this.fModel.load(properties);
            this.fInputData.load(properties, pConfigFile);
            this.fRunParameters.load(properties);
            this.fConfigFileProperty.set((Object)pConfigFile);
        }
        return properties;
    }

    private void majVersion(Properties pProperties) {
        String version = pProperties.getProperty("version");
        if (version == null) {
            return;
        }
        for (Varname v : Varname.values()) {
            this.setDEQuantile(v, Double.valueOf(pProperties.getProperty("de.quantile." + v.name(), "0.5")));
        }
        if (version.startsWith("2.2.0.u")) {
            for (String s : List.of("E", "L", "M", "C")) {
                this.updateMissingProperty(pProperties, "model." + s + ".piezo.selected", "false");
                this.updateMissingProperty(pProperties, "model." + s + ".w.selected", "true");
                this.updateMissingProperty(pProperties, "model." + s + ".w.value", "0.01");
                this.updateMissingProperty(pProperties, "model." + s + ".w.min", "0.001");
                this.updateMissingProperty(pProperties, "model." + s + ".w.max", "0.01");
                this.updateMissingProperty(pProperties, "model." + s + ".Z0.selected", "true");
                this.updateMissingProperty(pProperties, "model." + s + ".Z0.value", "0");
                this.updateMissingProperty(pProperties, "model." + s + ".Z0.min", "0");
                this.updateMissingProperty(pProperties, "model." + s + ".Z0.max", "0");
            }
            for (String s : List.of("L", "M", "C", "S")) {
                this.updateMissingProperty(pProperties, "model.Qsink" + s + ".selected", "false");
            }
            for (String s : List.of("PET_routine", "Snow_routine")) {
                this.updateMissingProperty(pProperties, "model." + s + ".selected", "false");
            }
            this.updateMissingProperty(pProperties, "model.PET_routine.latitude.selected", "true");
            this.updateMissingProperty(pProperties, "model.PET_routine.latitude.value", "0");
            this.updateMissingProperty(pProperties, "model.PET_routine.latitude.min", "0");
            this.updateMissingProperty(pProperties, "model.PET_routine.latitude.max", "0");
            this.updateMissingProperty(pProperties, "model.PET_routine.k1.selected", "true");
            this.updateMissingProperty(pProperties, "model.PET_routine.k1.value", "100");
            this.updateMissingProperty(pProperties, "model.PET_routine.k1.min", "100");
            this.updateMissingProperty(pProperties, "model.PET_routine.k1.max", "100");
            this.updateMissingProperty(pProperties, "model.PET_routine.k2.selected", "true");
            this.updateMissingProperty(pProperties, "model.PET_routine.k2.value", "5");
            this.updateMissingProperty(pProperties, "model.PET_routine.k2.min", "5");
            this.updateMissingProperty(pProperties, "model.PET_routine.k2.max", "5");
            this.updateMissingProperty(pProperties, "model.Snow_routine.Ts.selected", "true");
            this.updateMissingProperty(pProperties, "model.Snow_routine.Ts.value", "0");
            this.updateMissingProperty(pProperties, "model.Snow_routine.Ts.min", "0");
            this.updateMissingProperty(pProperties, "model.Snow_routine.Ts.max", "0");
            this.updateMissingProperty(pProperties, "model.Snow_routine.MF.selected", "true");
            this.updateMissingProperty(pProperties, "model.Snow_routine.MF.value", "0.1");
            this.updateMissingProperty(pProperties, "model.Snow_routine.MF.min", "0.1");
            this.updateMissingProperty(pProperties, "model.Snow_routine.MF.max", "1");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CFR.selected", "true");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CFR.value", "0.001");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CFR.min", "0.001");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CFR.max", "1");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CWH.selected", "true");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CWH.value", "0.001");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CWH.min", "0.001");
            this.updateMissingProperty(pProperties, "model.Snow_routine.CWH.max", "1");
        }
        if (version.startsWith("2.2.0.") && !pProperties.containsKey("model.E.classical.k.selected")) {
            this.updateMissingProperty(pProperties, "model.E.classical.k.max", "0.01");
            this.updateMissingProperty(pProperties, "model.E.classical.k.min", "1.0E-4");
            this.updateMissingProperty(pProperties, "model.E.classical.k.selected", "true");
            this.updateMissingProperty(pProperties, "model.E.classical.k.value", "0.01");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.max", "4");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.min", "0.2");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.selected", "true");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.value", "1.0");
        }
        if (version.compareTo("2.1") <= 0) {
            this.updateMissingProperty(pProperties, "model.E.classical.linkedReservoirs.selected", "false");
            this.updateMissingProperty(pProperties, "model.E.classical.xEC.max", "1.0");
            this.updateMissingProperty(pProperties, "model.E.classical.xEC.min", "0.0");
            this.updateMissingProperty(pProperties, "model.E.classical.xEC.selected", "true");
            this.updateMissingProperty(pProperties, "model.E.classical.xEC.value", "0.0");
            this.updateMissingProperty(pProperties, "model.E.classical.xEM.max", "1.0");
            this.updateMissingProperty(pProperties, "model.E.classical.xEM.min", "0.0");
            this.updateMissingProperty(pProperties, "model.E.classical.xEM.selected", "true");
            this.updateMissingProperty(pProperties, "model.E.classical.xEM.value", "0.0");
            this.updateMissingProperty(pProperties, "model.QE.alpha.max", "4.0");
            this.updateMissingProperty(pProperties, "model.QE.alpha.min", "0.2");
            this.updateMissingProperty(pProperties, "model.QE.alpha.selected", "false");
            this.updateMissingProperty(pProperties, "model.QE.alpha.value", "0.0");
            this.updateMissingProperty(pProperties, "model.QE.k.max", "0.01");
            this.updateMissingProperty(pProperties, "model.QE.k.min", "1.0E-4");
            this.updateMissingProperty(pProperties, "model.QE.k.selected", "true");
            this.updateMissingProperty(pProperties, "model.QE.k.value", "0.0");
            this.updateMissingProperty(pProperties, "model.QE.selected", "true");
            this.updateMissingProperty(pProperties, "model.hyNode.selected", "true");
            this.updateMissingProperty(pProperties, "model.QhyEC.xhy.max", "1.0");
            this.updateMissingProperty(pProperties, "model.QhyEC.xhy.min", "0.0");
            this.updateMissingProperty(pProperties, "model.QhyEC.xhy.selected", "true");
            this.updateMissingProperty(pProperties, "model.QhyEC.xhy.value", "0.0");
            for (String s : new String[]{"E", "L", "M", "C"}) {
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.selected", s), "false");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.alpha%s.min", s, s), "0.2");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.alpha%s.max", s, s), "0.8");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.alpha%s.selected", s, s), "true");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.alpha%s.value", s, s), "0.5");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.tau0%s.max", s, s), "15.0");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.tau0%s.min", s, s), "5.0");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.tau0%s.selected", s, s), "true");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.tau0%s.value", s, s), "10.0");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmax%s.min", s, s), "0.2");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmax%s.max", s, s), "0.8");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmax%s.selected", s, s), "true");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmax%s.value", s, s), "300");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmin%s.max", s, s), "15.0");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmin%s.min", s, s), "5.0");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmin%s.selected", s, s), "true");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.hmin%s.value", s, s), "10.0");
                this.updateMissingProperty(pProperties, String.format("model.Qb%s.selected", s), "true");
                this.updateMissingProperty(pProperties, String.format("model.Qr%s.selected", s), "true");
                this.updateMissingProperty(pProperties, String.format("model.Qb%s.to_S.selected", s), "true");
                this.updateMissingProperty(pProperties, String.format("model.Qr%s.to_loss.selected", s), "true");
                this.updateMissingProperty(pProperties, String.format("model.Qr%s.to_S.selected", s), "true");
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.h0.selected", s), pProperties.getProperty(String.format("model.%s.classical.h0.selected", s)));
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.h0.value", s), pProperties.getProperty(String.format("model.%s.classical.h0.value", s)));
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.h0.max", s), pProperties.getProperty(String.format("model.%s.classical.h0.max", s)));
                this.updateMissingProperty(pProperties, String.format("model.%s.infinite_tc.h0.min", s), pProperties.getProperty(String.format("model.%s.classical.h0.min", s)));
            }
            this.updateMissingProperty(pProperties, "model.QbE.to_L.selected", "true");
            this.updateMissingProperty(pProperties, "model.QbE.to_M.selected", "true");
            this.updateMissingProperty(pProperties, "model.QbE.to_C.selected", "true");
            this.updateMissingProperty(pProperties, "model.QrE.to_C.selected", "true");
            this.updateMissingProperty(pProperties, "model.Qhy.xhy.max", pProperties.getProperty("model.QhyEC.p.max", "1"));
            this.updateMissingProperty(pProperties, "model.Qhy.xhy.min", pProperties.getProperty("model.QhyEC.p.min", "0"));
            this.updateMissingProperty(pProperties, "model.Qhy.xhy.selected", pProperties.getProperty("model.QhyEC.p.selected", "false"));
            this.updateMissingProperty(pProperties, "model.Qhy.xhy.value", pProperties.getProperty("model.QhyEC.p.value", "1"));
            this.updateMissingProperty(pProperties, "model.QrE.xC.max", "1.0");
            this.updateMissingProperty(pProperties, "model.QrE.xC.min", "0.0");
            this.updateMissingProperty(pProperties, "model.QrE.xC.selected", "true");
            this.updateMissingProperty(pProperties, "model.QrE.xC.value", "0.0");
            this.updateMissingProperty(pProperties, "model.QrE.xLoss.max", "1.0");
            this.updateMissingProperty(pProperties, "model.QrE.xLoss.min", "0.0");
            this.updateMissingProperty(pProperties, "model.QrE.xLoss.selected", "true");
            this.updateMissingProperty(pProperties, "model.QrE.xLoss.value", "0.0");
            this.updateMissingProperty(pProperties, "model.E.classical.k.max", "0.01");
            this.updateMissingProperty(pProperties, "model.E.classical.k.min", "1E-4");
            this.updateMissingProperty(pProperties, "model.E.classical.k.selected", "true");
            this.updateMissingProperty(pProperties, "model.E.classical.k.value", "0.01");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.max", "4");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.min", "0.2");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.selected", "true");
            this.updateMissingProperty(pProperties, "model.E.classical.alpha.value", "1.0");
        }
        if (version.compareTo("3.0.7") <= 0) {
            this.updateMissingProperty(pProperties, "model.Snow_routine.RC.max", "1");
            this.updateMissingProperty(pProperties, "model.Snow_routine.RC.min", "0.001");
            this.updateMissingProperty(pProperties, "model.Snow_routine.RC.selected", "true");
            this.updateMissingProperty(pProperties, "model.Snow_routine.RC.value", "1.0");
        }
    }

    private void updateMissingProperty(Properties pProperties, String pKey, String pValue) {
        pProperties.computeIfAbsent(pKey, (Function<? super Object, ?>)((Function<Object, Object>)v -> pValue));
    }

    public ModeKarstMod getMode() {
        return this.fMode;
    }

    public void setMode(ModeKarstMod pMode) {
        this.fMode = pMode;
        for (Parameter parameter : this.fModel.getParameters()) {
            parameter.setMode(pMode);
        }
    }

    public AMSobolGenerator getRandomGenerator() {
        return this.fRandomGenerator;
    }

    public MessageList validate() {
        MessageList msgList = new MessageList();
        msgList.addAll(this.fModel.validate());
        msgList.addAll(this.fRunParameters.validate());
        return msgList;
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    private void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
        this.validate();
    }

    public Properties saveProperties() {
        SortedProperties properties = new SortedProperties();
        properties.setProperty("version", "3.1.0");
        this.fModel.save(properties, false);
        this.fRunParameters.save(properties);
        this.fInputData.save(properties, this.getConfigFile());
        for (Varname v : Varname.values()) {
            properties.setProperty("de.quantile." + v.name(), String.valueOf(this.fDEQuantiles.get((Object)v)));
        }
        return properties;
    }

    public void setDEQuantile(Varname pVarname, double pQ) {
        this.fDEQuantiles.put(pVarname, pQ);
    }

    public double getDEQuantile(Varname pVarname) {
        return this.fDEQuantiles.get((Object)pVarname);
    }

    public boolean isParamsFromFile() {
        return this.fParamsFromFile;
    }

    public void setParamsFromFile(boolean pParamsFromFile) {
        this.fParamsFromFile = pParamsFromFile;
    }

    private /* synthetic */ void lambda$new$0(BooleanProperty activeProperty, Observable i) {
        activeProperty.set(this.fInputData.contains(ColumnName.SRAD) && BaseUnit.HOUR == Unit.getInstance().getBase());
        this.fModel.getSnowRoutine().getRc().calibrateProperty().set(this.fModel.getSnowRoutine().getRc().needsCalibration());
    }
}

