/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.launcher;

import fr.geonosis.karstmod.launcher.JUpdateDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

public class UpdatableApplication {
    private final String fProgramName;
    private final String fDisplayName;
    private final String fRepositoryURL;
    private final Icon fIcon;
    private final String fLatestVersion;
    private final File fLocalJarDir;
    private String fCurrentVersion;

    public UpdatableApplication(String pName, String pDisplayName, String pJarDir, String pRepositoryURL, Icon pIcon) {
        this.fProgramName = pName;
        this.fDisplayName = pDisplayName;
        this.fRepositoryURL = pRepositoryURL;
        this.fIcon = pIcon;
        this.fLocalJarDir = new File(System.getProperty("user.dir"), pJarDir);
        this.fCurrentVersion = this.findCurrentVersion();
        this.fLatestVersion = this.latestVersion();
    }

    public Process launch(String[] pArgs) {
        this.fCurrentVersion = this.findCurrentVersion();
        if (this.fCurrentVersion == null) {
            return null;
        }
        int n = 0;
        if (pArgs != null) {
            n = pArgs.length;
        }
        String[] args = new String[3 + n];
        args[0] = "java";
        args[1] = "-jar";
        args[2] = new File(this.fLocalJarDir, this.jarFileName(this.fCurrentVersion)).getAbsolutePath();
        if (n > 0) {
            System.arraycopy(pArgs, 0, args, 3, n);
        }
        try {
            return Runtime.getRuntime().exec(args);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String jarFileName(String pVersionNumber) {
        return this.fProgramName + "_" + pVersionNumber + ".jar";
    }

    private String findCurrentVersion() {
        Pattern jarPattern = Pattern.compile(this.fProgramName + "_(.+)\\.jar");
        ArrayList versions = new ArrayList();
        this.fLocalJarDir.listFiles((pDir, pName) -> {
            Matcher m = jarPattern.matcher(pName);
            if (m.matches()) {
                String version = m.group(1);
                versions.add(version);
            }
            return false;
        });
        if (!versions.isEmpty()) {
            Collections.sort(versions);
            return (String)versions.get(versions.size() - 1);
        }
        return null;
    }

    private String latestVersion() {
        try {
            URL urlLatest = new URL(this.fRepositoryURL + "/latest");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlLatest.openStream()));
            return bufferedReader.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean update() {
        if (this.fLatestVersion != null && this.fCurrentVersion != null && this.fLatestVersion.compareTo(this.fCurrentVersion) > 0) {
            JUpdateDialog updateDialog = new JUpdateDialog(this);
            updateDialog.setVisible(true);
            boolean res = updateDialog.restartRequested();
            updateDialog.dispose();
            return res;
        }
        return false;
    }

    public String getURL(String pVersionNumber) {
        return this.fRepositoryURL + "/" + this.jarFileName(pVersionNumber);
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public String getProgramName() {
        return this.fProgramName;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    public String getLatestVersion() {
        return this.fLatestVersion;
    }

    public String getRepositoryURL() {
        return this.fRepositoryURL;
    }

    public File getLocalJarDir() {
        return this.fLocalJarDir;
    }
}

