/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs.de;

import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Serie;
import fr.dbe.util.ihm.SharedFrame;
import fr.geonosis.karstmod.compute.PeriodType;
import fr.geonosis.karstmod.ihm.graphs.de.KGECanvas;
import fr.geonosis.karstmod.modele.obj.KGE;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;

public class KGEChart
extends JPanneauGraphique {
    private static final String PREFS_KEY_SAVE = "fr.geonosis.karstmod.ihm.graphs.kge.save";
    private final KGE fCalib;
    private final KGE fValid;

    public KGEChart(String pName, final KGE pCalib, final KGE pValid) {
        super(pName);
        this.fCalib = pCalib;
        this.fValid = pValid;
        double min = Double.MAX_VALUE;
        for (KGE kge : List.of(pCalib, pValid)) {
            min = Math.min(min, kge.eff());
        }
        if (min <= -2.0) {
            this.setBusy("Value of 'DE' is out of bounds for visualization!");
            return;
        }
        this.setZoomEnabled(false);
        this.setAdjustEnabled(false);
        this.setCurseur(false);
        this.setPropertiesEnabled(false);
        this.setControleVisible(false);
        this.getDessin().getTitre().setVisible(false);
        this.getDessin().getTitre().setAlignment(GroupLayout.Alignment.LEADING);
        Font f = this.getDessin().getTitre().getFont();
        this.getDessin().getTitre().setFont(new Font(f.getFamily(), f.getStyle(), f.getSize() - 4));
        Repere repere = this.getRepere(0);
        repere.setVisible(false);
        repere.getAxeH().getGraduation().setVisible(false);
        repere.getAxeV().getGraduation().setVisible(false);
        repere.getAxeV().setBornes(0.0, 1.0);
        repere.getAxeH().setCouleur(Color.lightGray);
        repere.getAxeH().setCouleurEtiquette(Color.BLACK);
        repere.getAxeH().setBornes(0.0, 1.0);
        final KGECanvas canvas = new KGECanvas(pCalib, pValid);
        repere.ajouteFond(canvas);
        this.setLegende(true);
        this.getDessin().getLegende().deplace(600.0, 100.0);
        final int defaultDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        final int defaultInitialDelay = ToolTipManager.sharedInstance().getInitialDelay();
        this.getDessin().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(1);
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setInitialDelay(defaultInitialDelay);
                ToolTipManager.sharedInstance().setDismissDelay(defaultDismissDelay);
            }
        });
        this.getDessin().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PeriodType period = canvas.periodAt(e.getPoint());
                if (period != null) {
                    switch (period) {
                        case CALIBRATION: {
                            KGEChart.this.getDessin().setToolTipText(KGEChart.this.toolTipText4(period, pCalib));
                            break;
                        }
                        case VALIDATION: {
                            KGEChart.this.getDessin().setToolTipText(KGEChart.this.toolTipText4(period, pValid));
                        }
                    }
                } else {
                    KGEChart.this.getDessin().setToolTipText(null);
                }
            }
        });
    }

    private String toolTipText4(PeriodType pPeriodType, KGE pKge) {
        return String.format("<html><p>%s</p><table><tr><td>eff</td><td>%.3f</td></tr><tr><td>phi</td><td>%.3f</td></tr><tr><td>\u03b1</td><td>%.3f</td></tr><tr><td>\u03b2</td><td>%.3f</td></tr><tr><td>r</td><td>%.3f</td></tr></table></html>", pPeriodType.toString(), pKge.eff(), pKge.phi(), pKge.getAlpha(), pKge.getBeta(), pKge.getR());
    }

    @Override
    public void ajouterSerie(int pIndiceRepere, Serie pSerie) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ajouterSeries(int pIndiceRepere, List<? extends Serie> pSeries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        SharedFrame f = new SharedFrame();
        SwingUtilities.invokeLater(() -> {
            try {
                JFileChooser jfc = new JFileChooser();
                jfc.setAcceptAllFileFilterUsed(false);
                jfc.setMultiSelectionEnabled(false);
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getAbsolutePath().toLowerCase().endsWith(".txt") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Messages.getString("JPanneauGraphique.38");
                    }
                });
                jfc.setSelectedFile(new File(Preferences.userRoot().get(PREFS_KEY_SAVE, ".")));
                boolean continuer = true;
                while (continuer) {
                    if (jfc.showSaveDialog(this.getDessin()) == 1) {
                        return;
                    }
                    if (jfc.getSelectedFile().exists()) {
                        switch (JOptionPane.showConfirmDialog(this.getDessin(), Messages.getString("JPanneauGraphique.39"), Messages.getString("JPanneauGraphique.40"), 1)) {
                            case 0: {
                                continuer = false;
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                        continue;
                    }
                    continuer = false;
                }
                Preferences.userRoot().put(PREFS_KEY_SAVE, jfc.getSelectedFile().toString());
                try (PrintWriter pw = new PrintWriter(jfc.getSelectedFile().toString());){
                    pw.println(";Calibration;Validation");
                    pw.println("Diagnostic-Efficiency;" + this.fCalib.eff() + ";" + this.fValid.eff());
                    pw.println("Trigonometric inverse tangent" + this.fCalib.phi() + ";" + this.fValid.phi());
                    pw.println("Temporal correlation between observed and simulated time series" + this.fCalib.getAlpha() + ";" + this.fValid.getAlpha());
                    pw.println("Error contribution of high flows" + this.fCalib.getBeta() + ";" + this.fValid.getBeta());
                    pw.println("Error contribution of low flows<" + this.fCalib.getR() + ";" + this.fValid.getR());
                    pw.flush();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getDessin(), Messages.getString("JPanneauGraphique.41"));
            }
        });
    }
}

