/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.util.ihm.JTable2ExcelAdapter;
import fr.dbe.util.ihm.TableColumnAdjuster;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class JTableauParametres
extends JPanel {
    private final JTable fTable = new JTable();
    private final TableColumnAdjuster fAdjuster;

    public JTableauParametres() {
        super(new GridBagLayout());
        JScrollPane sp = new JScrollPane(this.fTable);
        sp.getVerticalScrollBar().setUnitIncrement(16);
        sp.getViewport().setPreferredSize(new Dimension(0, 0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 23;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        constraints.ipady = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)sp, constraints);
        this.fTable.setFont(Styles.FONT_DEFAUT);
        JTableHeader th = new JTableHeader();
        th.setDefaultRenderer((table, value, isSelected, hasFocus, row, column) -> {
            JLabel c = new JLabel();
            ((Component)c).setBackground(Color.WHITE);
            return c;
        });
        this.fTable.setTableHeader(th);
        this.fTable.setAutoResizeMode(0);
        this.fTable.setRowHeight(20);
        final Color couleur = new Color(240, 240, 240);
        this.fTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
                Component c = super.getTableCellRendererComponent(pTable, pValue, pIsSelected, pHasFocus, pRow, pColumn);
                if (pIsSelected) {
                    this.setBackground(Color.lightGray);
                } else {
                    this.setBackground(pRow % 2 == 0 ? Color.WHITE : couleur);
                }
                this.setForeground(Color.BLACK);
                ((JComponent)c).setBorder(null);
                return c;
            }
        });
        this.fAdjuster = new TableColumnAdjuster(this.fTable, 5);
        this.fAdjuster.setOnlyAdjustLarger(false);
        JTable2ExcelAdapter t2ea = new JTable2ExcelAdapter(this.fTable);
        t2ea.enableCopy();
        this.fTable.setModel(new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int pRow, int pColumn) {
                return false;
            }
        });
        this.fTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pE) {
                if (pE.getClickCount() == 2) {
                    int i;
                    int px = pE.getPoint().x;
                    int x = 0;
                    for (i = 0; i < JTableauParametres.this.fTable.getColumnCount(); ++i) {
                        if (Math.abs(px - x) <= 3) {
                            if (pE.isShiftDown()) {
                                JTableauParametres.this.fAdjuster.adjustColumns();
                            } else {
                                JTableauParametres.this.fAdjuster.adjustColumn(i - 1);
                            }
                            return;
                        }
                        x += JTableauParametres.this.fTable.getColumnModel().getColumn(i).getWidth();
                    }
                    if (Math.abs(px - x) <= 3) {
                        if (pE.isShiftDown()) {
                            JTableauParametres.this.fAdjuster.adjustColumns();
                        } else {
                            JTableauParametres.this.fAdjuster.adjustColumn(i - 1);
                        }
                    }
                }
            }
        });
    }

    public void setParametres(List<Parameter> pParametres) {
        Object[][] values = new String[pParametres.size()][2];
        Object[] titles = new String[]{Messages.getString("JTableauParametres.4"), Messages.getString("JTableauParametres.5")};
        int i = 0;
        for (Parameter parameter : pParametres) {
            values[i][0] = "<html>" + parameter.getHtmlLabel() + "</html>";
            values[i][1] = this.format(parameter.getValue()) + " " + Unit.getInstance().getBase().get(parameter.getDimension());
            ++i;
        }
        ((DefaultTableModel)this.fTable.getModel()).setDataVector(values, titles);
        this.fAdjuster.adjustColumns();
    }

    private String format(double pValue) {
        String pattern = Math.abs(pValue) > 0.001 || pValue == 0.0 ? "#.###" : "0.###E0";
        DecimalFormat format = new DecimalFormat(pattern);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setNaN("NaN");
        format.setDecimalFormatSymbols(dfs);
        return format.format(pValue);
    }
}

