/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.LabelWidget;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionAxeV;
import fr.dbe.util.commun.Plage;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.compute.XCorr;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.BorderFactory;

public class JGraphiqueXCorr
extends JPanneauGraphique {
    private final Courbe fCourbeObs;
    private final Courbe fCourbeSim;
    private final FondPlage fFondPlage;
    private final Courbe fCourbeX;
    private final Courbe fCourbeYObs;
    private final Courbe fCourbeYSim;
    private LabelWidget fLabelWidget;

    public JGraphiqueXCorr(Courbe pCourbeCause, Courbe pCourbeConsequenceObs, Courbe pCourbeConsequenceSim, FondPlage pFondPlage, String pControlLabel) {
        super("", pControlLabel, false);
        this.fFondPlage = pFondPlage;
        this.fCourbeX = pCourbeCause;
        this.fCourbeYObs = pCourbeConsequenceObs;
        this.fCourbeYSim = pCourbeConsequenceSim;
        if (this.fCourbeYObs != null) {
            this.fCourbeObs = new Courbe(Messages.getString("observe.firstUpper"), 0.0, 1.0);
            this.fCourbeObs.setCouleur(Styles.COULEURS_COURBE_QOBS);
            this.fCourbeObs.setCursorable(false);
            this.ajouterSerie(0, this.fCourbeObs);
        } else {
            this.fCourbeObs = null;
        }
        if (this.fCourbeYSim != null) {
            this.fCourbeSim = new Courbe(Messages.getString("simule.firstUpper"), 0.0, 1.0);
            this.fCourbeSim.setCouleur(Styles.COULEURS_COURBE_QSIM);
            this.fCourbeSim.setCursorable(false);
            this.ajouterSerie(0, this.fCourbeSim);
        } else {
            this.fCourbeSim = null;
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setControleEnabled(true);
        this.getDessin().setAfficheNomCourbe(true);
        this.getDessin().setMarges(new Marges(10.0, 15.0, 3.0, 3.0));
        this.getDessin().setTitle("<html>r<sub>xy</sub></html>");
        this.getDessin().getTitre().setVisible(true);
        this.getDessin().getTitre().setTransparence(0.0f);
        this.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).setPositionAxes(PositionAxeH.ORIGINE, PositionAxeV.ORIGINE);
        double[] positions = new double[]{-1.0, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        this.getRepere(0).getAxeV().getGraduation().setPositions(positions);
        this.getRepere(0).getQuadrillageV().linkToGraduation();
        this.getRepere(0).getAxeH().getGraduation().setIntervalle(1.0);
        this.getRepere(0).getQuadrillageH().linkToGraduation();
        this.setEtiquette(0, Unit.getInstance().getBase().get(Dimension.TIME), "<html>r<sub>xy</sub></html>");
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> this.setEtiquette(0, pNewValue.get(Dimension.TIME), "<html>r<sub>xy</sub></html>"));
    }

    public void maj() {
        if (this.fCourbeObs != null) {
            this.fCourbeObs.clearDirect();
        }
        if (this.fCourbeSim != null) {
            this.fCourbeSim.clearDirect();
        }
        if (this.fCourbeX.getValues().size() <= 3) {
            return;
        }
        double[] x = this.fCourbeX.getValues().toArray();
        int nb = 0;
        double[] tmpX = new double[x.length];
        for (Plage p : this.fFondPlage.getPlages()) {
            for (int i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                tmpX[nb] = x[i];
                ++nb;
            }
        }
        if (nb < 3) {
            return;
        }
        x = Arrays.copyOf(tmpX, nb);
        boolean missingValues = false;
        if (this.fCourbeYObs != null && this.fCourbeYObs.size() > 0) {
            missingValues = this.majCourbe(x, this.fCourbeYObs, this.fCourbeObs);
        }
        if (this.fCourbeYSim != null && this.fCourbeYSim.size() > 0) {
            missingValues |= this.majCourbe(x, this.fCourbeYSim, this.fCourbeSim);
        }
        if (missingValues) {
            if (this.fLabelWidget == null) {
                this.fLabelWidget = new LabelWidget(this.getDessin(), Messages.getString("missingQobsValues"), 0, 0);
                this.fLabelWidget.setFont(Styles.FONT_GRAPH_LABEL);
                this.fLabelWidget.setCouleurTexte(Color.GRAY);
                this.fLabelWidget.setVisible(true);
                this.fLabelWidget.setVerticalAnchor(1);
                this.fLabelWidget.setHorizontalAnchor(1);
                this.getDessin().addWidget(this.fLabelWidget);
            }
        } else {
            if (this.fLabelWidget != null) {
                this.getDessin().removeWidget(this.fLabelWidget);
            }
            this.fLabelWidget = null;
        }
        this.ajuster();
        double d = 10.0 * Math.log10(nb / 2);
        this.getRepere(0).setBornesX(-d, d);
    }

    private boolean majCourbe(double[] x, Courbe pCourbeY, Courbe pCourbe) {
        int i;
        double[] y = pCourbeY.getValues().toArray();
        int nb = 0;
        double[] tmpY = new double[y.length];
        for (Plage p : this.fFondPlage.getPlages()) {
            for (int i2 = p.getIndiceMin(); i2 <= p.getIndiceMax(); ++i2) {
                tmpY[nb] = y[i2];
                ++nb;
            }
        }
        if (nb < 3) {
            return false;
        }
        y = Arrays.copyOf(tmpY, nb);
        XCorr XCorrXY = new XCorr(x, y);
        XCorr XCorrYX = new XCorr(y, x);
        double[] xCorrPlus = XCorrXY.getValues();
        double[] xCorrMoins = XCorrYX.getValues();
        pCourbe.setXMin(-(xCorrMoins.length - 1));
        double[] xCorr = new double[xCorrMoins.length + xCorrPlus.length - 1];
        int j = 0;
        for (i = xCorrMoins.length - 1; i >= 0; --i) {
            xCorr[j++] = xCorrMoins[i];
        }
        for (i = 1; i < xCorrPlus.length; ++i) {
            xCorr[j++] = xCorrPlus[i];
        }
        pCourbe.setValuesDirect(xCorr);
        return XCorrXY.isValuesMissing() || XCorrYX.isValuesMissing();
    }

    public void clear() {
        if (this.fCourbeObs != null) {
            this.fCourbeObs.clearDirect();
        }
        if (this.fCourbeObs != null) {
            this.fCourbeSim.clearDirect();
        }
    }
}

