/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.CourbeLibre;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.NuageDePoint;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionAxeV;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.Serie;
import fr.dbe.graphique.SerieAdapter;
import fr.geonosis.karstmod.Utils;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.ErrorBar;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterSSI;
import fr.geonosis.karstmod.modele.SensitivityIndexes;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;

public class JGraphiqueSSI
extends JPanneauGraphique {
    private final Map<Parameter, Courbe> fCourbesS;
    private final Map<Parameter, Courbe> fCourbesSt;
    private final Map<Parameter, NuageDePoint> fErrorsS;
    private final Map<Parameter, NuageDePoint> fErrorsSt;
    private final Map<Parameter, CourbeLibre> fCourbesCIsSMin;
    private final Map<Parameter, CourbeLibre> fCourbesCIsStMin;
    private final Map<Parameter, CourbeLibre> fCourbesCIsSMax;
    private final Map<Parameter, CourbeLibre> fCourbesCIsStMax;
    private final CourbeLibre fCourbesSRightMargin;
    private final CourbeLibre fCourbesStRightMargin;

    public JGraphiqueSSI() {
        super("", "", false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setControleEnabled(true);
        this.getDessin().setAfficheNomCourbe(true);
        this.getDessin().setMarges(new Marges(10.0, 3.0, 3.0, 3.0));
        this.getDessin().setTitle("Sobol sensitivity indexes");
        this.getDessin().getTitre().setVisible(false);
        this.getDessin().getTitre().setTransparence(0.0f);
        this.getRepere(0).setPositionAxes(PositionAxeH.BAS, PositionAxeV.GAUCHE);
        this.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setIntervalle(500.0);
        this.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeV().getGraduation().setNombre(5);
        this.getRepere(0).getAxeV().getGraduation().setValeursRondes(true);
        this.getRepere(0).getAxeV().getGraduation().setValeursEntieres(false);
        this.getRepere(0).getQuadrillageH().linkToGraduation();
        this.getRepere(0).getQuadrillageV().linkToGraduation();
        this.setEtiquette(0, "n", "Total effect");
        this.ajouteRepere();
        this.getRepere(1).setPositionAxes(PositionAxeH.HAUT, PositionAxeV.DROITE);
        this.getRepere(1).getAxeV().setSens(Sens.INDIRECT);
        this.getRepere(1).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(1).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(1).getAxeV().getGraduation().setNombre(5);
        this.getRepere(1).getAxeV().getGraduation().setValeursRondes(true);
        this.getRepere(1).getAxeV().getGraduation().setValeursEntieres(false);
        this.getRepere(1).getAxeV().getGraduation().setVisible(true);
        this.getRepere(1).getAxeH().getGraduation().setVisible(false);
        this.getRepere(1).getQuadrillageH().setVisible(false);
        this.getRepere(0).getQuadrillageV().linkToGraduation();
        this.getRepere(1).getQuadrillageV().linkToGraduation();
        this.setBornes(1, 0.0, 1.0, 0.0, 100.0);
        this.setEtiquette(1, "", "First order");
        this.fCourbesS = new HashMap<Parameter, Courbe>();
        this.fCourbesSt = new HashMap<Parameter, Courbe>();
        this.fErrorsS = new HashMap<Parameter, NuageDePoint>();
        this.fErrorsSt = new HashMap<Parameter, NuageDePoint>();
        this.fCourbesCIsSMin = new HashMap<Parameter, CourbeLibre>();
        this.fCourbesCIsStMin = new HashMap<Parameter, CourbeLibre>();
        this.fCourbesCIsSMax = new HashMap<Parameter, CourbeLibre>();
        this.fCourbesCIsStMax = new HashMap<Parameter, CourbeLibre>();
        this.fCourbesSRightMargin = new CourbeLibre("");
        this.fCourbesSRightMargin.setVisibleInMenu(false);
        this.fCourbesSRightMargin.setCursorable(false);
        this.fCourbesSRightMargin.setCouleur(new Color(0, 0, 0, 0));
        this.fCourbesStRightMargin = new CourbeLibre("");
        this.fCourbesStRightMargin.setVisibleInMenu(false);
        this.fCourbesStRightMargin.setCursorable(false);
        this.fCourbesStRightMargin.setCouleur(new Color(0, 0, 0, 0));
    }

    public void maj(Map<Parameter, ParameterSSI> pMap, boolean pAddValues) {
        this.fCourbesSRightMargin.clear();
        this.fCourbesStRightMargin.clear();
        if (!pAddValues) {
            this.fCourbesS.clear();
            this.fCourbesSt.clear();
            this.fErrorsS.clear();
            this.fErrorsSt.clear();
            this.fCourbesCIsSMin.clear();
            this.fCourbesCIsStMin.clear();
            this.fCourbesCIsSMax.clear();
            this.fCourbesCIsStMax.clear();
        }
        this.getRepere(0).supprimerSeries();
        this.getRepere(1).supprimerSeries();
        for (Map.Entry<Parameter, ParameterSSI> entry : pMap.entrySet()) {
            CourbeLibre courbeCIStMax;
            CourbeLibre courbeCISMax;
            CourbeLibre courbeCIStMin;
            CourbeLibre courbeCISMin;
            NuageDePoint errorsSt;
            NuageDePoint errorsS;
            Courbe courbeSt;
            Courbe courbeS;
            int nMin;
            if (pAddValues) {
                nMin = 1;
                courbeS = this.fCourbesS.get(entry.getKey());
                courbeSt = this.fCourbesSt.get(entry.getKey());
                errorsS = this.fErrorsS.get(entry.getKey());
                errorsSt = this.fErrorsSt.get(entry.getKey());
                courbeCISMin = this.fCourbesCIsSMin.get(entry.getKey());
                courbeCIStMin = this.fCourbesCIsStMin.get(entry.getKey());
                courbeCISMax = this.fCourbesCIsSMax.get(entry.getKey());
                courbeCIStMax = this.fCourbesCIsStMax.get(entry.getKey());
            } else {
                nMin = entry.getValue().getIndexes().size() > 1000 ? 500 : 1;
                courbeS = new Courbe(Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (1st order)"), nMin, 1.0);
                courbeS.setCouleur(entry.getKey().getColor());
                courbeS.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{3.0f, 3.0f}, 0.0f));
                this.fCourbesS.put(entry.getKey(), courbeS);
                courbeSt = new Courbe(Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (total effect)"), nMin, 1.0);
                courbeSt.setCouleur(courbeS.getCouleur());
                this.fCourbesSt.put(entry.getKey(), courbeSt);
                errorsS = new NuageDePoint(Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (1st order)"));
                errorsS.setCouleur(entry.getKey().getColor());
                errorsS.setVisibleInMenu(false);
                errorsS.setCursorable(true);
                this.fErrorsS.put(entry.getKey(), errorsS);
                errorsSt = new NuageDePoint(Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (total effect)"));
                errorsSt.setCouleur(courbeSt.getCouleur());
                errorsSt.setVisibleInMenu(false);
                errorsSt.setCursorable(true);
                this.fErrorsSt.put(entry.getKey(), errorsSt);
                courbeCISMin = new CourbeLibre("CI min " + Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (1st order)"));
                courbeCISMin.setCouleur(courbeS.getCouleur());
                courbeCISMin.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 2.0f}, 0.0f));
                courbeCISMin.setVisibleInMenu(false);
                this.fCourbesCIsSMin.put(entry.getKey(), courbeCISMin);
                courbeCIStMin = new CourbeLibre("CI min " + Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (total effect)"));
                courbeCIStMin.setCouleur(courbeSt.getCouleur());
                courbeCIStMin.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 2.0f}, 0.0f));
                courbeCIStMin.setVisibleInMenu(false);
                this.fCourbesCIsStMin.put(entry.getKey(), courbeCIStMin);
                courbeCISMax = new CourbeLibre("CI max " + Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (1st order)"));
                courbeCISMax.setCouleur(courbeS.getCouleur());
                courbeCISMax.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 2.0f}, 0.0f));
                courbeCISMax.setVisibleInMenu(false);
                this.fCourbesCIsSMax.put(entry.getKey(), courbeCISMax);
                courbeCIStMax = new CourbeLibre("CI max " + Utils.addHtmlTag(entry.getKey().getHtmlLabel() + " (total effect)"));
                courbeCIStMax.setCouleur(courbeSt.getCouleur());
                courbeCIStMax.getTypeDessin().setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 2.0f}, 0.0f));
                courbeCIStMax.setVisibleInMenu(false);
                this.fCourbesCIsStMax.put(entry.getKey(), courbeCIStMax);
                courbeS.addSerieListener(new SerieAdapter(){

                    @Override
                    public void serieVisibilityChanged(Serie pSerie) {
                        errorsS.setVisible(pSerie.isVisible());
                        courbeCISMin.setVisible(pSerie.isVisible());
                        courbeCISMax.setVisible(pSerie.isVisible());
                    }
                });
                courbeS.addSerieListener(new SerieAdapter(){

                    @Override
                    public void serieVisibilityChanged(Serie pSerie) {
                        errorsSt.setVisible(pSerie.isVisible());
                        courbeCIStMin.setVisible(pSerie.isVisible());
                        courbeCIStMax.setVisible(pSerie.isVisible());
                    }
                });
            }
            List<SensitivityIndexes> values = entry.getValue().getIndexes();
            int nb = values.size();
            for (int i = nMin - 1; i < nb; ++i) {
                SensitivityIndexes index = values.get(i);
                courbeS.ajoute(index.getS());
                courbeSt.ajoute(index.getSt());
            }
            double x = courbeS.getXMax();
            ErrorBar errorBar = new ErrorBar(entry.getValue().getConfidenceInterval().getS5(), values.get(nb - 1).getS(), entry.getValue().getConfidenceInterval().getS95(), x, 10, 4);
            errorBar.setCouleur(courbeS.getCouleur());
            errorsS.ajouterPoint(errorBar);
            errorBar = new ErrorBar(entry.getValue().getConfidenceInterval().getSt5(), values.get(nb - 1).getSt(), entry.getValue().getConfidenceInterval().getSt95(), x, 10, 4);
            errorBar.setCouleur(courbeSt.getCouleur());
            errorsSt.ajouterPoint(errorBar);
            courbeCISMin.add(new Point2D.Double(x, entry.getValue().getConfidenceInterval().getS5()));
            courbeCISMax.add(new Point2D.Double(x, entry.getValue().getConfidenceInterval().getS95()));
            courbeCIStMin.add(new Point2D.Double(x, entry.getValue().getConfidenceInterval().getSt5()));
            courbeCIStMax.add(new Point2D.Double(x, entry.getValue().getConfidenceInterval().getSt95()));
            this.ajouterSerie(1, courbeS);
            this.ajouterSerie(1, errorsS);
            this.ajouterSerie(1, courbeCISMin);
            this.ajouterSerie(1, courbeCISMax);
            this.ajouterSerie(0, courbeSt);
            this.ajouterSerie(0, errorsSt);
            this.ajouterSerie(0, courbeCIStMin);
            this.ajouterSerie(0, courbeCIStMax);
        }
        this.ajuster();
        if (this.getRepere(1).getSeries().size() > 0) {
            this.ajouterSerie(1, this.fCourbesSRightMargin);
            double x1 = this.getRepere(1).getAxeH().getMax();
            double x2 = x1 + 5.0 / this.getDessin().getRepere(1).getAxeH().getPixelTransformer().getdPix();
            double y = this.getRepere(1).getSeries().get(0).getY((int)this.getRepere(1).getSeries().get(0).getXMax() - (int)this.getRepere(1).getSeries().get(0).getXMin());
            this.fCourbesSRightMargin.add(new Point2D.Double(x1, y));
            this.fCourbesSRightMargin.add(new Point2D.Double(x2, y));
        }
        if (this.getRepere(0).getSeries().size() > 0) {
            this.ajouterSerie(0, this.fCourbesStRightMargin);
            double x1 = (int)this.getRepere(0).getAxeH().getMax();
            double x2 = (int)(x1 + 5.0 / this.getDessin().getRepere(0).getAxeH().getPixelTransformer().getdPix());
            double y = this.getRepere(0).getSeries().get(0).getY((int)this.getRepere(0).getSeries().get(0).getXMax() - (int)this.getRepere(1).getSeries().get(1).getXMin());
            this.fCourbesStRightMargin.add(new Point2D.Double(x1, y));
            this.fCourbesStRightMargin.add(new Point2D.Double(x2, y));
        }
        this.ajuster();
        Repere rep0 = this.getRepere(0);
        Repere rep1 = this.getRepere(1);
        double yMin = Math.min(rep0.getYMin(), rep1.getYMin());
        double yMax = Math.min(rep0.getYMax(), rep1.getYMax());
        rep0.setBornesY(yMin, yMax);
        rep1.setBornesY(yMin, yMax);
        rep0.linkWith(rep1);
        rep1.linkWith(rep0);
    }
}

