/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.Ligne;
import fr.dbe.graphique.LigneHorizontale;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.Utils;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.ihm.graphs.JGraphPeriod;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Color;
import javafx.beans.value.ChangeListener;

public class JGraphiqueQSimMoinsQobs
extends JGraphPeriod {
    private static final String DEBIT_OBS = Messages.getString("QOBSS.htmlName");
    private static final String DEBIT_SIM = Messages.getString("QS.htmlName");
    private static final String TITLE = "<html>" + DEBIT_SIM + " - " + DEBIT_OBS + "<html>";
    private final Courbe fSerieDiffQs;
    private final Courbe fSerieDiffQLoss;
    private final Courbe fCourbeQobs;
    private final Courbe fCourbeQsim;
    private final Courbe fCourbeQlossObs;
    private final Courbe fCourbeQlossSim;

    public JGraphiqueQSimMoinsQobs(Courbe pCourbeQobs, Courbe pCourbeQsim, Courbe pCourbeQLossObs, Courbe pCourbeQLossSim, FondPlage pCalibration, FondPlage pValidation) {
        super(TITLE, Messages.getString("JResults.34"), null, pCalibration, pValidation);
        this.fCourbeQobs = pCourbeQobs;
        this.fCourbeQsim = pCourbeQsim;
        this.fCourbeQlossObs = pCourbeQLossObs;
        this.fCourbeQlossSim = pCourbeQLossSim;
        final Color minusColorQs = new Color(255, 0, 0);
        final Color plusColorQs = new Color(50, 200, 100);
        String QSName = "<html>" + Messages.getString("QS.htmlName") + " - " + Messages.getString("QOBSS.htmlName") + "</html>";
        String QlossName = "<html>" + Messages.getString("Qloss.htmlName") + " <sub>sim</sub> - " + Messages.getString("Qloss.htmlName") + " <sub>obs</sub></html>";
        this.fSerieDiffQs = new Courbe(QSName, 0.0, 1.0){

            @Override
            public void setCouleur(Color c) {
                super.setCouleur(plusColorQs);
            }
        };
        this.fSerieDiffQs.setCouleur(plusColorQs);
        this.fSerieDiffQs.setTypeDessin(new Ligne(){

            @Override
            protected Color getColor(Serie pCourbe, double pY) {
                return pY < 0.0 ? minusColorQs : plusColorQs;
            }
        });
        final Color minusColorQloss = new Color(130, 0, 50);
        final Color plusColorQloss = new Color(30, 100, 100);
        this.fSerieDiffQLoss = new Courbe(QlossName, 0.0, 1.0){

            @Override
            public void setCouleur(Color c) {
                super.setCouleur(plusColorQloss);
            }
        };
        this.fSerieDiffQLoss.setCouleur(plusColorQloss);
        this.fSerieDiffQLoss.setTypeDessin(new Ligne(){

            @Override
            protected Color getColor(Serie pCourbe, double pY) {
                return pY < 0.0 ? minusColorQloss : plusColorQloss;
            }
        });
        LigneHorizontale zero = new LigneHorizontale("Zero", 0.0);
        zero.setColor(Color.BLACK);
        zero.setFillColor(Color.BLACK);
        this.getDessin().getRepere(0).ajouteFond(zero);
        this.getDessin().setTitle(TITLE);
        this.getDessin().getLegende().setVisible(true);
        this.ajouterSerie(0, this.fSerieDiffQs);
        this.ajouterSerie(0, this.fSerieDiffQLoss);
        ChangeListener unitListener = (pObservable, pOldValue, pNewValue) -> {
            this.setUnits(0, pNewValue.get(Dimension.TIME), this.getUnitVGauche());
            this.maj();
            this.repaint();
        };
        Unit.getInstance().baseProperty().addListener(unitListener);
        unitListener.changed(null, null, (Object)Unit.getInstance().getBase());
    }

    @Override
    protected String getEtiquetteVGauche() {
        return null;
    }

    @Override
    protected String getUnitVGauche() {
        return Utils.addHtmlTag(Messages.getString("BaseUnite.9"));
    }

    public void clear() {
        this.fSerieDiffQs.clearDirect();
    }

    public void maj() {
        this.maj(this.fCourbeQobs, this.fCourbeQsim, this.fSerieDiffQs);
        this.maj(this.fCourbeQlossObs, this.fCourbeQlossSim, this.fSerieDiffQLoss);
        this.ajuster();
    }

    private void maj(Courbe pCourbeObs, Courbe pCourbeSim, Courbe pSerie) {
        pSerie.clearDirect();
        pSerie.setActive(pCourbeSim.isActive());
        if (!pSerie.isActive()) {
            return;
        }
        double[] qObs = pCourbeObs.getValues().toArray();
        double[] qSim = pCourbeSim.getValues().toArray();
        int debut = Math.min(this.getFondPlageCalibration().getMin(), this.getFondPlageValidation().getMin());
        int fin = Math.max(this.getFondPlageCalibration().getMax(), this.getFondPlageValidation().getMax());
        double[] diff = new double[fin - debut + 1];
        pSerie.setXMin(debut);
        boolean j = false;
        if (qSim.length > 0 && qObs.length > 0) {
            int i;
            for (Plage p : this.getFondPlageCalibration().getPlages()) {
                for (i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                    if (Double.isNaN(qSim[i])) continue;
                    diff[i - debut] = qSim[i] - qObs[i];
                }
            }
            for (Plage p : this.getFondPlageValidation().getPlages()) {
                for (i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                    if (Double.isNaN(qSim[i])) continue;
                    diff[i - debut] = qSim[i] - qObs[i];
                }
            }
        }
        pSerie.setValuesDirect(diff);
    }
}

