/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.formatter.DecimalFormatter;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.commun.Vecteur;
import fr.dbe.util.ihm.Utils;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.ihm.graphs.JGraphPeriod;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JLabel;

public class JGraphiqueCumulsVolumes
extends JGraphPeriod {
    private static final String VOLUME_ERROR = Messages.getString("JGraphiqueCumulsVolumes.0").toLowerCase();
    private static final String VOLUME_M = Messages.getString("JGraphiqueCumulsVolumes.1");
    private static final String TEMPS = Messages.getString("JGraphiqueCumulsVolumes.2");
    private final JLabel fVolumeErrorLabel;
    private final Courbe fCourbeQSim;
    private final Courbe fCourbeQObs;
    private final Courbe fCourbeQlossSim;
    private final Courbe fCourbeQlossObs;
    private final Courbe fCourbeCumulVolQObs;
    private final Courbe fCourbeCumulVolQSim;
    private final Courbe fCourbeCumulVolQlossObs;
    private final Courbe fCourbeCumulVolQlossSim;
    private final Courbe fCourbeCumulVolQSimAll;
    private final Courbe fCourbeCumulVolQlossSimAll;
    private final FondPlage fFondPlageCalibration;
    private final FondPlage fFondPlageValidation;

    public JGraphiqueCumulsVolumes(Courbe pCourbeQObs, Courbe pCourbeQSim, Courbe pCourbeQlossObs, Courbe pCourbeQlosSim, FondPlage pFondPlageCalibration, FondPlage pFondPlageValidation) {
        super(Messages.getString("JGraphiqueCumulsVolumes.7"), Messages.getString("JResults.34"), null, pFondPlageCalibration, pFondPlageValidation);
        this.fFondPlageCalibration = pFondPlageCalibration;
        this.fFondPlageValidation = pFondPlageValidation;
        this.fCourbeQObs = pCourbeQObs;
        this.fCourbeQSim = pCourbeQSim;
        this.fCourbeCumulVolQObs = new Courbe("<html>" + Messages.getString("QS.htmlName") + " " + Messages.getString("JGraphiqueCumulsVolumes.4") + "</html>", 0.0, 1.0);
        this.fCourbeCumulVolQObs.setCouleur(Styles.COULEURS_COURBE_QOBS);
        this.fCourbeCumulVolQSim = new Courbe("<html>" + Messages.getString("QS.htmlName") + " " + Messages.getString("JGraphiqueCumulsVolumes.5") + "</html>", 0.0, 1.0);
        this.fCourbeCumulVolQSim.setCouleur(Styles.COULEURS_COURBE_QSIM);
        this.fCourbeCumulVolQSimAll = new Courbe("<html>" + Messages.getString("QS.htmlName") + " " + Messages.getString("JGraphiqueCumulsVolumes.51") + "</html>", 0.0, 1.0);
        this.fCourbeCumulVolQSimAll.setCouleur(Styles.COULEURS_COURBE_QSIM_ALL);
        this.fCourbeQlossObs = pCourbeQlossObs;
        this.fCourbeQlossSim = pCourbeQlosSim;
        this.fCourbeCumulVolQlossObs = new Courbe("<html>" + Messages.getString("Qloss.htmlName") + " " + Messages.getString("JGraphiqueCumulsVolumes.4") + "</html>", 0.0, 1.0);
        this.fCourbeCumulVolQlossObs.setCouleur(Styles.COULEURS_COURBE_QLOSS_OBS);
        this.fCourbeCumulVolQlossSim = new Courbe("<html>" + Messages.getString("Qloss.htmlName") + " " + Messages.getString("JGraphiqueCumulsVolumes.5") + "</html>", 0.0, 1.0);
        this.fCourbeCumulVolQlossSim.setCouleur(Styles.COULEURS_COURBE_QLOSS_SIM);
        this.fCourbeCumulVolQlossSimAll = new Courbe("<html>" + Messages.getString("Qloss.htmlName") + " " + Messages.getString("JGraphiqueCumulsVolumes.51") + "</html>", 0.0, 1.0);
        this.fCourbeCumulVolQlossSimAll.setCouleur(Styles.COULEURS_COURBE_QLOSS_ALL);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 3;
        constraints.anchor = 23;
        constraints.weightx = 2.0;
        constraints.fill = 2;
        this.fVolumeErrorLabel = Utils.createLabel("-");
        this.add((Component)this.fVolumeErrorLabel, constraints);
        this.getDessin().setTitle(Messages.getString("JGraphiqueCumulsVolumes.7"));
        this.getRepere(0).getAxeV().getGraduation().setValeursRondes(true);
        this.ajouterSerie(0, this.fCourbeCumulVolQObs);
        this.ajouterSerie(0, this.fCourbeCumulVolQSim);
        this.ajouterSerie(0, this.fCourbeCumulVolQSimAll);
        this.ajouterSerie(0, this.fCourbeCumulVolQlossObs);
        this.ajouterSerie(0, this.fCourbeCumulVolQlossSim);
        this.ajouterSerie(0, this.fCourbeCumulVolQlossSimAll);
        this.setEtiquette(0, this.getXlabel(), this.getEtiquetteVGauche());
        this.setUnits(0, null, this.getUnitVGauche());
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.setEtiquette(0, this.getXlabel(), this.getEtiquetteVGauche());
            this.setUnits(0, null, this.getUnitVGauche());
            this.maj();
            this.repaint();
        });
    }

    @Override
    protected String getEtiquetteVGauche() {
        return VOLUME_M;
    }

    @Override
    protected String getUnitVGauche() {
        return Messages.getString("m3");
    }

    private String getXlabel() {
        return TEMPS.replaceAll("@@unit", Unit.getInstance().getBase().get(Dimension.TIME));
    }

    private String volumeError(double pCalibrationValue, double pValidationValue) {
        DecimalFormatter df = new DecimalFormatter();
        df.setNombreDecimales(2);
        return "<b>" + df.format(pCalibrationValue) + "%</b> (" + Messages.getString("JGraphiqueCumulsVolumes.8") + "), <b>" + df.format(pValidationValue) + "%</b> (" + Messages.getString("JGraphiqueCumulsVolumes.9") + ")";
    }

    public void maj() {
        String qErr = this.maj(this.fCourbeQObs, this.fCourbeQSim, this.fCourbeCumulVolQObs, this.fCourbeCumulVolQSim, this.fCourbeCumulVolQSimAll);
        String qlossErr = this.maj(this.fCourbeQlossObs, this.fCourbeQlossSim, this.fCourbeCumulVolQlossObs, this.fCourbeCumulVolQlossSim, this.fCourbeCumulVolQlossSimAll);
        this.ajuster();
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(Messages.getString("QS.htmlName")).append(" ").append(VOLUME_ERROR).append(": ").append(qErr);
        if (qlossErr != null) {
            sb.append("   /   ").append(Messages.getString("Qloss.htmlName")).append(" ").append(VOLUME_ERROR).append(": ").append(qlossErr);
        }
        sb.append("</html>");
        this.fVolumeErrorLabel.setText(sb.toString());
    }

    private String maj(Courbe pCourbeObs, Courbe pCourbeSim, Courbe pCourbeCumulVolObs, Courbe pCourbeCumulVolSim, Courbe pCourbeCumulVolSimAll) {
        pCourbeCumulVolObs.clearDirect();
        pCourbeCumulVolSim.clearDirect();
        pCourbeCumulVolSimAll.clearDirect();
        this.supprimerSerie(0, pCourbeCumulVolSimAll);
        pCourbeCumulVolObs.setActive(pCourbeSim.isActive());
        pCourbeCumulVolSim.setActive(pCourbeSim.isActive());
        pCourbeCumulVolSimAll.setActive(pCourbeSim.isActive());
        if (!pCourbeSim.isActive()) {
            return null;
        }
        double cc = Unit.getInstance().getBase().getSecondes();
        double calibrationVolumeError = 0.0;
        double validationVolumeError = 0.0;
        int debut = Math.min(this.fFondPlageCalibration.getMin(), this.fFondPlageValidation.getMin());
        pCourbeCumulVolObs.setXMin(debut);
        pCourbeCumulVolSim.setXMin(debut);
        pCourbeCumulVolSimAll.setXMin(debut);
        boolean addSimAll = false;
        int fin = Math.max(this.fFondPlageCalibration.getMax(), this.fFondPlageValidation.getMax());
        double[] cumVolObs = new double[fin - debut + 1];
        double[] cumVolSim = new double[fin - debut + 1];
        double[] cumVolSimAll = new double[fin - debut + 1];
        for (FondPlage fondPlage : new FondPlage[]{this.fFondPlageCalibration, this.fFondPlageValidation}) {
            Vecteur qsim;
            Vecteur qobs = pCourbeObs.getValues();
            double cumulObs = 0.0;
            if (qobs.size() >= fondPlage.getMax() + 1) {
                for (Plage p : fondPlage.getPlages()) {
                    for (int i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                        if (!Double.isNaN(qobs.get(i))) {
                            cumulObs += cc * qobs.get(i);
                        }
                        cumVolObs[i - debut] = cumulObs;
                    }
                }
            }
            if ((qsim = pCourbeSim.getValues()).size() < fondPlage.getMax() + 1) continue;
            double somme = 0.0;
            double cumulSim = 0.0;
            double cumulSimNaN = 0.0;
            for (Plage p : fondPlage.getPlages()) {
                for (int i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                    if (!Double.isNaN(qobs.get(i))) {
                        somme += cc * (qsim.get(i) - qobs.get(i));
                        cumulSim += cc * qsim.get(i);
                    } else {
                        if (!addSimAll) {
                            addSimAll = true;
                        }
                        cumulSimNaN += cc * qsim.get(i);
                    }
                    cumVolSim[i - debut] = cumulSim;
                    cumVolSimAll[i - debut] = cumulSim + cumulSimNaN;
                }
            }
            if (fondPlage == this.fFondPlageCalibration) {
                calibrationVolumeError = somme / cumulObs * 100.0;
                continue;
            }
            if (fondPlage != this.fFondPlageValidation) continue;
            validationVolumeError = somme / cumulObs * 100.0;
        }
        pCourbeCumulVolObs.setValuesDirect(cumVolObs);
        pCourbeCumulVolSim.setValuesDirect(cumVolSim);
        pCourbeCumulVolSimAll.setValuesDirect(cumVolSimAll);
        if (addSimAll) {
            this.ajouterSerie(0, pCourbeCumulVolSimAll);
        }
        return this.volumeError(calibrationVolumeError, validationVolumeError);
    }

    public void clear() {
        this.fCourbeCumulVolQObs.clearDirect();
        this.fCourbeCumulVolQSim.clearDirect();
    }

    @Override
    public void setBusy(String message) {
        this.fVolumeErrorLabel.setVisible(false);
        super.setBusy(message);
    }

    @Override
    public void setReady() {
        this.fVolumeErrorLabel.setVisible(true);
        super.setReady();
    }
}

