/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Fond;
import fr.dbe.graphique.Repere;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class BandeHorizontale
extends Fond {
    private final double fMin;
    private final double fMax;

    public BandeHorizontale(String pNom, double pMin, double pMax, Color pColor, Color pFillColor) {
        super(pNom);
        this.fMin = pMin;
        this.fMax = pMax;
        this.fColor = pColor;
        this.fFillColor = pFillColor;
    }

    @Override
    public void dessine(Graphics pG, Repere pRepere) {
        if (this.fVisible && this.fMin <= this.fMax) {
            Color oldColor = pG.getColor();
            Axe axeH = pRepere.getAxeH();
            Axe axeV = pRepere.getAxeV();
            int y0 = (int)axeV.valToPix(this.fMin);
            int y1 = (int)axeV.valToPix(this.fMax);
            int x0 = (int)axeH.valToPix(axeH.getMin());
            int x1 = (int)axeH.valToPix(axeH.getMax());
            pG.setColor(this.fFillColor);
            pG.fillRect(x0, y1, x1 - x0 + 1, y0 - y1 + 1);
            if (this.fStroke != null) {
                Stroke oldStroke = ((Graphics2D)pG).getStroke();
                pG.setColor(this.fColor);
                ((Graphics2D)pG).setStroke(this.fStroke);
                pG.drawLine(x0, y0, x1, y0);
                pG.drawLine(x0, y1, x1, y1);
                ((Graphics2D)pG).setStroke(oldStroke);
            }
            pG.setColor(oldColor);
        }
    }

    @Override
    public double getYMax() {
        return this.fMax;
    }

    @Override
    public double getYMin() {
        return this.fMin;
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getColor());
        pGraphics2d.fillRect(0, 0, pWidth, pHeight);
    }
}

