/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.compute;

import fr.dbe.graphique.formatter.IFormatter;
import fr.geonosis.karstmod.run.QNorm;

public class SortedDischargeFormatter
implements IFormatter {
    private static final double[] TICKS;

    @Override
    public String[] format(double[] pValues) {
        String[] labels = new String[pValues.length];
        for (int i = 0; i < pValues.length; ++i) {
            labels[i] = this.format(pValues[i]);
        }
        return labels;
    }

    @Override
    public String format(double pValue) {
        int n = TICKS.length - 1;
        int i = 0;
        int j = n;
        int m = i;
        while (j - i > 2) {
            m = (i + j) / 2;
            if (pValue < TICKS[m]) {
                j = m;
                continue;
            }
            i = m;
        }
        if (m < 9100) {
            return String.format("%1.1f", (double)m / (double)n);
        }
        if (m < 9910) {
            return String.format("%1.2f", (double)m / (double)n);
        }
        if (m < 9995) {
            return String.format("%1.3f", (double)m / (double)n);
        }
        return String.format("%1.4f", (double)m / (double)n);
    }

    @Override
    public double valueFor(double pValue) {
        return TICKS[(int)(pValue * (double)(TICKS.length - 1))];
    }

    @Override
    public String formatPrecis(double pValue) {
        int n = TICKS.length - 1;
        int i = 0;
        int j = n;
        int m = i;
        while (j - i > 2) {
            m = (i + j) / 2;
            if (pValue < TICKS[m]) {
                j = m;
                continue;
            }
            i = m;
        }
        return String.format("%1.4f", (double)m / (double)n);
    }

    static {
        double n = 10000.0;
        double[] ticks = new double[(int)n + 1];
        int i = 0;
        while ((double)i < n + 1.0) {
            ticks[i] = ((double)i / n + 1.0) / 2.0;
            ++i;
        }
        TICKS = QNorm.compute(ticks);
    }
}

