/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.compute;

import java.util.Arrays;

public class DiagnosticEfficiency {
    private final double[] fObs;
    private final double[] fSim;
    private double fQuantile;
    private double[] brel;
    private double brelMean;
    private double[] brelres;
    private double bArea;
    private double bTot;
    private double bHf;
    private double bLf;
    private double errHf;
    private double errLf;
    private double bDir;
    private double bSlope;
    private double phi;
    private double eff;
    private double tempCor;

    public DiagnosticEfficiency(double[] pObs, double[] pSim) {
        this.fObs = pObs;
        this.fSim = pSim;
        this.setQuantile(0.5);
    }

    public DiagnosticEfficiency(double[] pObs, double[] pSim, double pQuantile) {
        this.fObs = pObs;
        this.fSim = pSim;
        this.setQuantile(pQuantile);
    }

    public void setQuantile(double pQuantile) {
        if (this.fQuantile != pQuantile) {
            this.fQuantile = pQuantile;
            this.compute();
        }
    }

    private void compute() {
        this.brel = DiagnosticEfficiency.calcBrel(this.fObs, this.fSim, true);
        this.brelMean = DiagnosticEfficiency.calcBrelMean(this.brel);
        this.brelres = DiagnosticEfficiency.calcBrelRes(this.brel, this.brelMean);
        this.bArea = DiagnosticEfficiency.calcBiasArea(this.brelres);
        this.bTot = DiagnosticEfficiency.calcBiasTot(this.brel);
        this.bHf = DiagnosticEfficiency.calcBiasHf(this.brel, this.fQuantile);
        this.bLf = DiagnosticEfficiency.calcBiasLf(this.brel, this.fQuantile);
        this.errHf = DiagnosticEfficiency.calcErrHf(this.bHf, this.bTot);
        this.errLf = DiagnosticEfficiency.calcErrLf(this.bLf, this.bTot);
        this.bDir = DiagnosticEfficiency.calcBiasDir(this.brelres, this.fQuantile);
        this.bSlope = DiagnosticEfficiency.calcBiasSlope(this.bArea, this.bDir);
        this.tempCor = DiagnosticEfficiency.corrPearson(this.fObs, this.fSim);
        this.phi = DiagnosticEfficiency.calcPhi(this.brelMean, this.bSlope);
        this.eff = Math.sqrt(Math.pow(this.brelMean, 2.0) + Math.pow(this.bArea, 2.0) + Math.pow(this.tempCor - 1.0, 2.0));
    }

    public static double corrPearson(double[] x, double[] y) {
        double sig;
        double meanX = Arrays.stream(x).sum() / (double)x.length;
        double meanDev2X = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sig = x[i] - meanX;
            meanDev2X += sig * sig;
        }
        double meanY = Arrays.stream(y).sum() / (double)y.length;
        double meanDev2Y = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sig = y[i] - meanY;
            meanDev2Y += sig * sig;
        }
        double s = Math.sqrt(meanDev2X * meanDev2Y);
        double r = 0.0;
        for (int i = 0; i < x.length; ++i) {
            r += (x[i] - meanX) * (y[i] - meanY) / s;
        }
        return r;
    }

    public static double[] calcBrel(double[] pQobs, double[] pQsim, boolean pSort) {
        double[] qsim;
        double[] qobs;
        if (pQsim.length != pQobs.length) {
            throw new IllegalArgumentException("Arrays are not of equal length!");
        }
        if (pSort) {
            qobs = (double[])pQobs.clone();
            Arrays.sort(qobs);
            DiagnosticEfficiency.revert(qobs);
            qsim = (double[])pQsim.clone();
            Arrays.sort(qsim);
            DiagnosticEfficiency.revert(qsim);
        } else {
            qobs = pQobs;
            qsim = pQsim;
        }
        double[] brel = new double[qobs.length];
        for (int i = 0; i < qsim.length; ++i) {
            double diff = qsim[i] - qobs[i];
            if (qobs[i] == 0.0) {
                if (diff == 0.0) {
                    brel[i] = 0.0;
                    continue;
                }
                brel[i] = Double.NaN;
                continue;
            }
            brel[i] = diff / qobs[i];
        }
        return Arrays.stream(brel).filter(d -> !Double.isNaN(d)).toArray();
    }

    public static double calcBrelMean(double[] pBrel) {
        double brelMean = Arrays.stream(pBrel).average().getAsDouble();
        if (Math.abs(brelMean) < 0.001) {
            brelMean = 0.0;
        }
        return brelMean;
    }

    public static double[] calcBrelRes(double[] pBrel, double pBrelMean) {
        return Arrays.stream(pBrel).map(d -> d - pBrelMean).toArray();
    }

    public static double calcBiasArea(double[] pValues) {
        return DiagnosticEfficiency.simps(Arrays.stream(pValues).map(v -> Math.abs(v)).toArray(), DiagnosticEfficiency.linspace(0.0, 1.0, pValues.length));
    }

    public static double calcBiasTot(double[] pValues) {
        return DiagnosticEfficiency.calcBiasArea(pValues);
    }

    public static double calcBiasHf(double[] pValues, double pQuantile) {
        int n = (int)((double)pValues.length * pQuantile);
        double[] percHf = DiagnosticEfficiency.linspace(0.0, pQuantile, n);
        double res = DiagnosticEfficiency.simps(Arrays.copyOfRange(pValues, 0, n), percHf);
        if (Math.abs(res) < 0.001) {
            res = 0.0;
        }
        return res;
    }

    public static double calcBiasLf(double[] pValues, double pQuantile) {
        int n = pValues.length - (int)((double)pValues.length * pQuantile);
        double[] percHf = DiagnosticEfficiency.linspace(pQuantile, 1.0, pValues.length - n);
        double res = DiagnosticEfficiency.simps(Arrays.copyOfRange(pValues, n, pValues.length), percHf);
        if (Math.abs(res) < 0.001) {
            res = 0.0;
        }
        return res;
    }

    public static double calcErrHf(double pHf, double pTot) {
        double err = pTot > 0.0 ? pHf / pTot : 0.0;
        if (Double.isNaN(err)) {
            err = 0.0;
        }
        return err;
    }

    public static double calcErrLf(double pLf, double pTot) {
        double err = pTot > 0.0 ? pLf / pTot : 0.0;
        if (Double.isNaN(err)) {
            err = 0.0;
        }
        return err;
    }

    public static double calcBiasDir(double[] pValues, double pQuantile) {
        double bRresHf = DiagnosticEfficiency.calcBiasHf(pValues, pQuantile);
        double bResLf = DiagnosticEfficiency.calcBiasLf(pValues, pQuantile);
        if (bRresHf > 0.0 && bResLf < 0.0 || bRresHf == 0.0 && bResLf < 0.0 || bRresHf > 0.0 && bResLf == 0.0) {
            return -1.0;
        }
        if (bRresHf < 0.0 && bResLf > 0.0 || bRresHf == 0.0 && bResLf > 0.0 || bRresHf < 0.0 && bResLf == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double calcBiasSlope(double pArea, double pDir) {
        return pArea * pDir;
    }

    public static double calcPhi(double pMean, double pSlope) {
        double phi = Math.atan2(pMean, pSlope);
        if (Math.abs(phi) < 0.001) {
            return 0.0;
        }
        if (phi > 3.1414) {
            return 3.1414;
        }
        return phi;
    }

    private static double[] linspace(double pStart, double pEnd, int pSize) {
        double[] x = new double[pSize];
        double d = (pEnd - pStart) / (double)(pSize - 1);
        x[0] = pStart;
        for (int i = 1; i < x.length; ++i) {
            x[i] = x[i - 1] + d;
        }
        return x;
    }

    private static double simps(double[] y, double[] x) {
        int N = y.length;
        if (N % 2 == 0) {
            double lastDx = x[x.length - 1] - x[x.length - 2];
            double result = DiagnosticEfficiency.basicSimps(y, 0, N - 3, x);
            double val = 0.5 * lastDx * (y[x.length - 1] + y[x.length - 2]);
            double firstDx = x[1] - x[0];
            return ((result += DiagnosticEfficiency.basicSimps(y, 1, N - 2, x)) + (val += 0.5 * firstDx * (y[1] + y[0]))) / 2.0;
        }
        return DiagnosticEfficiency.basicSimps(y, 0, N - 2, x);
    }

    private static double basicSimps(double[] y, int pStart, int pEnd, double[] x) {
        int step = 2;
        int n = (pEnd - pStart + 1) / step;
        double[][] l = new double[3][n];
        for (int i = 0; i < l.length; ++i) {
            for (int j = 0; j < n; ++j) {
                l[i][j] = y[pStart + j * step + i];
            }
        }
        double[] diffx = new double[x.length - 1];
        for (int i = 0; i < diffx.length; ++i) {
            diffx[i] = x[i + 1] - x[i];
        }
        double[][] h = new double[2][n];
        for (int i = 0; i < h.length; ++i) {
            for (int j = 0; j < h[i].length; ++j) {
                h[i][j] = diffx[j * step + i];
            }
        }
        double[] hsum = new double[h[0].length];
        for (int i = 0; i < hsum.length; ++i) {
            hsum[i] = h[0][i] + h[1][i];
        }
        double[] hprod = new double[h[0].length];
        for (int i = 0; i < hsum.length; ++i) {
            hprod[i] = h[0][i] * h[1][i];
        }
        double[] h0divh1 = new double[h[0].length];
        for (int i = 0; i < hsum.length; ++i) {
            h0divh1[i] = h[0][i] / h[1][i];
        }
        double[] tmp = new double[h[0].length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = hsum[i] / 6.0 * (l[0][i] * (2.0 - 1.0 / h0divh1[i]) + l[1][i] * hsum[i] * hsum[i] / hprod[i] + l[2][i] * (2.0 - h0divh1[i]));
        }
        return Arrays.stream(tmp).sum();
    }

    private static void revert(double[] pArray) {
        for (int i = 0; i < pArray.length / 2; ++i) {
            DiagnosticEfficiency.swap(pArray, i, pArray.length - 1 - i);
        }
    }

    private static void swap(double[] pArray, int pI1, int pI2) {
        double tmp = pArray[pI1];
        pArray[pI1] = pArray[pI2];
        pArray[pI2] = tmp;
    }

    public double[] getBrel() {
        return this.brel;
    }

    public double getBrelMean() {
        return this.brelMean;
    }

    public double[] getBrelRes() {
        return this.brelres;
    }

    public double getbArea() {
        return this.bArea;
    }

    public double getbTot() {
        return this.bTot;
    }

    public double getbHf() {
        return this.bHf;
    }

    public double getbLf() {
        return this.bLf;
    }

    public double getErrHf() {
        return this.errHf;
    }

    public double getErrLf() {
        return this.errLf;
    }

    public double getbDir() {
        return this.bDir;
    }

    public double getbSlope() {
        return this.bSlope;
    }

    public double getPhi() {
        return this.phi;
    }

    public double getEff() {
        return this.eff;
    }

    public double getTempCor() {
        return this.tempCor;
    }

    public double getQuantile() {
        return this.fQuantile;
    }
}

