/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod;

import fr.geonosis.karstmod.Utils;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Messages {
    private static final String BUNDLE_NAME = "fr.geonosis.karstmod.messages";
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("fr.geonosis.karstmod.messages");
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$\\{([^\\}]*)\\}");

    private Messages() {
    }

    public static void setLocale(Locale pLocale) {
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, pLocale);
    }

    public static String getString(String pKey) {
        try {
            String res = RESOURCE_BUNDLE.getString(pKey);
            Matcher matcher = REFERENCE_PATTERN.matcher(res);
            while (matcher.find()) {
                res = res.replaceAll("\\$\\{" + matcher.group(1) + "\\}", Messages.getString(matcher.group(1)));
            }
            return res;
        }
        catch (MissingResourceException e) {
            return "!" + pKey + "!";
        }
    }

    public static void main(String[] args) {
        System.out.println(Messages.getString("toto"));
    }

    public static String getHtmlString(String pKey) {
        return Utils.addHtmlTag(Messages.getString(pKey));
    }
}

