/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod;

import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class KarstModLogger {
    private static final Logger LOGGER = Logger.getLogger("global");

    public static void setup() throws IOException {
        Locale.setDefault(Locale.ENGLISH);
        Logger logger = Logger.getLogger("global");
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        if (handlers[0] instanceof ConsoleHandler) {
            rootLogger.removeHandler(handlers[0]);
        }
        logger.setLevel(Level.INFO);
        FileHandler fileHandler = new FileHandler("karstMod.log", true);
        fileHandler.setFormatter(new KartsModFormatter());
        logger.addHandler(fileHandler);
    }

    public static void severe(String pMessage, Throwable pThrowable, boolean pShowAlert) {
        LOGGER.log(Level.SEVERE, pMessage, pThrowable);
        if (pShowAlert) {
            KarstModLogger.alert(pMessage, Alert.AlertType.ERROR);
        }
    }

    public static void info(String pMessage, Throwable pThrowable, boolean pShowAlert) {
        LOGGER.log(Level.INFO, pMessage, pThrowable);
        if (pShowAlert) {
            KarstModLogger.alert(pMessage, Alert.AlertType.INFORMATION);
        }
    }

    public static void warning(String pMessage, Throwable pThrowable, boolean pShowAlert) {
        LOGGER.log(Level.WARNING, pMessage, pThrowable);
        if (pShowAlert) {
            KarstModLogger.alert(pMessage, Alert.AlertType.WARNING);
        }
    }

    public static void finest(String pMessage, Throwable pThrowable, boolean pShowAlert) {
        LOGGER.log(Level.FINEST, pMessage, pThrowable);
        if (pShowAlert) {
            KarstModLogger.alert(pMessage, Alert.AlertType.INFORMATION);
        }
    }

    public static void alert(String pMessage, Alert.AlertType pType) {
        Platform.runLater(() -> new ModalResizableAlert(pType, pMessage + "\n See log for more information.", ButtonType.OK).showAndWait());
    }

    public static void dialogError(String pMessage) {
        Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, pMessage, ButtonType.OK).showAndWait());
    }

    static class KartsModFormatter
    extends Formatter {
        private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private static final String FORMAT = "%1$s (v%3$s) [%5$s]: %6$s%7$s%n";
        private final Date date = new Date();

        KartsModFormatter() {
        }

        @Override
        public String format(LogRecord pRecord) {
            Object source;
            this.date.setTime(pRecord.getMillis());
            if (pRecord.getSourceClassName() != null) {
                source = pRecord.getSourceClassName();
                if (pRecord.getSourceMethodName() != null) {
                    source = (String)source + " " + pRecord.getSourceMethodName();
                }
            } else {
                source = pRecord.getLoggerName();
            }
            String message = this.formatMessage(pRecord);
            String throwable = "";
            if (pRecord.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                pRecord.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format(FORMAT, DATE_FORMAT.format(this.date), source, "3.1.0", pRecord.getLoggerName(), pRecord.getLevel().getLocalizedName(), message, throwable);
        }
    }
}

