/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.xml;

import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.IExportableElement;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlFormatException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlUtils {
    public static final String DOM_POLICE = "police";
    public static final String DOM_COULEUR = "couleur";
    public static final String DOM_STROKE = "stroke";
    public static final String DOM_STYLE = "style";
    public static final String DOM_SIZE = "size";
    public static final String DOM_RED = "red";
    public static final String DOM_ALPHA = "alpha";
    public static final String DOM_FONT_NAME = "fontName";
    public static final String DOM_GREEN = "green";
    public static final String DOM_BLUE = "blue";
    private static final String DOM_DASH_PHASE = "dashPhase";
    private static final String DOM_END_CAP = "endCap";
    private static final String DOM_LINE_JOIN = "lineJoin";
    private static final String DOM_LINE_WIDTH = "lineWidth";
    private static final String DOM_MITER_LIMIT = "miterLimit";
    private static final String DOM_DASH_ARRAY = "dashArray";

    public static Node getFrereSuivant(Node pNode, String pNameSuivant) {
        Node elt;
        for (elt = pNode.getNextSibling(); elt != null && (elt.getNodeType() != 1 || elt.getNodeType() == 1 && !elt.getNodeName().equals(pNameSuivant)); elt = elt.getNextSibling()) {
        }
        return elt;
    }

    public static Node getFils(Node pNode, String pName) {
        Node elt;
        for (elt = pNode.getFirstChild(); !(elt == null || elt.getNodeType() == 1 && elt.getNodeName().equals(pName)); elt = elt.getNextSibling()) {
        }
        return elt;
    }

    public static String getAttributeStringValue(Node pNode, String pName) throws XmlFormatException {
        NamedNodeMap attributes = pNode.getAttributes();
        if (!XmlUtils.attributeExists(pNode, pName)) {
            throw new XmlFormatException(XmlUtils.getError(pNode, "attribut " + pName + " manquant"));
        }
        return attributes.getNamedItem(pName).getNodeValue();
    }

    public static String getAttributeStringValue(Node pNode, String pName, String pValeurDefaut) {
        try {
            return XmlUtils.getAttributeStringValue(pNode, pName);
        }
        catch (XmlFormatException e) {
            return pValeurDefaut;
        }
    }

    public static Object getAttributeStringValue(Node pNode, String pName, String[] pStrings) throws XmlFormatException {
        String res = XmlUtils.getAttributeStringValue(pNode, pName);
        List<String> l = Arrays.asList(pStrings);
        if (!l.contains(res)) {
            throw new XmlFormatException(XmlUtils.getError(pNode, "Valeur de l'attribut " + pName + " incorrecte (" + res + ") (Valeurs autoris\u00e9es= " + l));
        }
        return res;
    }

    public static int getAttributeIntValue(Node pNode, String pName) throws XmlFormatException {
        NamedNodeMap attributes = pNode.getAttributes();
        if (!XmlUtils.attributeExists(pNode, pName)) {
            throw new XmlFormatException(XmlUtils.getError(pNode, "attribute " + pName + " manquant"));
        }
        String val = attributes.getNamedItem(pName).getNodeValue();
        try {
            return Utilitaire.parseInt(val);
        }
        catch (NumberFormatException ex) {
            throw new XmlFormatException(XmlUtils.getError(pNode, "attribut '" + pName + "' incorrect (" + val + ") : nombre entier attendu"));
        }
    }

    public static int getAttributeIntValue(Node pNode, String pName, int pValeurDefaut) {
        try {
            return XmlUtils.getAttributeIntValue(pNode, pName);
        }
        catch (XmlFormatException e) {
            return pValeurDefaut;
        }
    }

    public static double getAttributeDoubleValue(Node pNode, String pName) throws XmlFormatException {
        NamedNodeMap attributes = pNode.getAttributes();
        if (!XmlUtils.attributeExists(pNode, pName)) {
            throw new XmlFormatException(XmlUtils.getError(pNode, "attribute " + pName + " manquant"));
        }
        String val = attributes.getNamedItem(pName).getNodeValue();
        try {
            return Utilitaire.parseDouble(val);
        }
        catch (NumberFormatException ex) {
            throw new XmlFormatException(XmlUtils.getError(pNode, "attribut '" + pName + "' incorrect (" + val + ") : nombre d\u00e9cimal attendu"));
        }
    }

    public static double getAttributeDoubleValue(Node pNode, String pName, double pValeurDefaut) {
        try {
            return XmlUtils.getAttributeDoubleValue(pNode, pName);
        }
        catch (XmlFormatException e) {
            return pValeurDefaut;
        }
    }

    public static Double getAttributeDoubleValue(Node pNode, String pName, Double pValeurDefaut) {
        try {
            return XmlUtils.getAttributeDoubleValue(pNode, pName);
        }
        catch (XmlFormatException e) {
            return pValeurDefaut;
        }
    }

    public static boolean getAttributeBooleanValue(Node pNode, String pName) throws XmlFormatException {
        NamedNodeMap attributes = pNode.getAttributes();
        if (!XmlUtils.attributeExists(pNode, pName)) {
            throw new XmlFormatException(XmlUtils.getError(pNode, "attribute " + pName + " manquant"));
        }
        String val = attributes.getNamedItem(pName).getNodeValue();
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new XmlFormatException(XmlUtils.getError(pNode, "attribut '" + pName + "' incorrect (" + val + ") : 'true' ou 'false' attendu"));
    }

    public static boolean attributeExists(Node pNode, String pName) {
        NamedNodeMap attributes = pNode.getAttributes();
        return attributes != null && attributes.getNamedItem(pName) != null;
    }

    public static boolean getAttributeBooleanValue(Node pNode, String pName, boolean pValeurDefaut) {
        try {
            return XmlUtils.getAttributeBooleanValue(pNode, pName);
        }
        catch (XmlFormatException e) {
            return pValeurDefaut;
        }
    }

    public static Color getColor(Node pNoeud) {
        return XmlUtils.getColor(pNoeud, DOM_COULEUR);
    }

    public static Color getColor(Node pNoeud, int pDefaultAlpha) {
        return XmlUtils.getColor(pNoeud, DOM_COULEUR, pDefaultAlpha);
    }

    public static Color getColor(Node pNoeud, String pNodeName) {
        return XmlUtils.getColor(pNoeud, pNodeName, 255);
    }

    public static Color getColor(Node pNoeud, String pNodeName, int pDefaultAlpha) {
        Node nCol = XmlUtils.getFils(pNoeud, pNodeName);
        if (nCol == null) {
            return Color.BLACK;
        }
        if (!XmlUtils.attributeExists(nCol, DOM_RED)) {
            return null;
        }
        int red = XmlUtils.getAttributeIntValue(nCol, DOM_RED, 0);
        int green = XmlUtils.getAttributeIntValue(nCol, DOM_GREEN, 0);
        int blue = XmlUtils.getAttributeIntValue(nCol, DOM_BLUE, 0);
        int alpha = XmlUtils.getAttributeIntValue(nCol, DOM_ALPHA, pDefaultAlpha);
        return new Color(red, green, blue, alpha);
    }

    public static Font getPolice(Node pNoeud) {
        Node nFont = XmlUtils.getFils(pNoeud, DOM_POLICE);
        if (nFont == null) {
            Log.getInstance().warn("El\u00e9ment <" + pNoeud.getNodeName() + "><police> absent => police par d\u00e9faut");
            return Utilitaire.FONT_DEFAUT;
        }
        int size = XmlUtils.getAttributeIntValue(nFont, DOM_SIZE, Utilitaire.FONT_DEFAUT.getSize());
        String fontName = XmlUtils.getAttributeStringValue(nFont, DOM_FONT_NAME, Utilitaire.FONT_DEFAUT.getFontName());
        int style = XmlUtils.getAttributeIntValue(nFont, DOM_STYLE, Utilitaire.FONT_DEFAUT.getStyle());
        return new Font(fontName, style, size);
    }

    public static void saveXml(IXmlElement pXmlElement, File pFichier) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(pXmlElement.getDomElement(doc));
        XmlUtils.saveXml(doc, pFichier);
    }

    public static void saveXml(IExportableElement pXmlElement, File pFichier) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(pXmlElement.getExportableElement(doc));
        XmlUtils.saveXml(doc, pFichier);
    }

    public static void saveXml(Document pDocument, File pFichier) throws Exception {
        XmlUtils.saveXml(pDocument, pFichier, false);
    }

    public static void saveXml(Document pDocument, File pFichier, boolean pIndent) throws Exception {
        pDocument.normalize();
        pDocument.setXmlStandalone(true);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", pIndent ? "yes" : "no");
        DOMSource source = new DOMSource(pDocument);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pFichier), StandardCharsets.UTF_8);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        writer.flush();
        writer.close();
    }

    public static Node createPoliceNode(Document pDocument, Font pPolice) {
        Element ePolice = pDocument.createElement(DOM_POLICE);
        ePolice.setAttribute(DOM_SIZE, String.valueOf(pPolice.getSize()));
        ePolice.setAttribute(DOM_FONT_NAME, pPolice.getFontName());
        ePolice.setAttribute(DOM_STYLE, String.valueOf(pPolice.getStyle()));
        return ePolice;
    }

    public static Element createColorNode(Document pDocument, Color pCouleur) {
        return XmlUtils.createColorNode(pDocument, pCouleur, DOM_COULEUR);
    }

    public static Element createColorNode(Document pDocument, Color pCouleur, String pNodeName) {
        Element eCouleur = pDocument.createElement(pNodeName);
        if (pCouleur != null) {
            eCouleur.setAttribute(DOM_RED, String.valueOf(pCouleur.getRed()));
            eCouleur.setAttribute(DOM_GREEN, String.valueOf(pCouleur.getGreen()));
            eCouleur.setAttribute(DOM_BLUE, String.valueOf(pCouleur.getBlue()));
            eCouleur.setAttribute(DOM_ALPHA, String.valueOf(pCouleur.getAlpha()));
        }
        return eCouleur;
    }

    public static Element createStrokeNode(Document pDocument, BasicStroke pStroke) {
        Element eStroke = pDocument.createElement(DOM_STROKE);
        if (pStroke != null) {
            eStroke.setAttribute(DOM_DASH_PHASE, String.valueOf(pStroke.getDashPhase()));
            eStroke.setAttribute(DOM_END_CAP, String.valueOf(pStroke.getEndCap()));
            eStroke.setAttribute(DOM_LINE_JOIN, String.valueOf(pStroke.getLineJoin()));
            eStroke.setAttribute(DOM_LINE_WIDTH, String.valueOf(pStroke.getLineWidth()));
            eStroke.setAttribute(DOM_MITER_LIMIT, String.valueOf(pStroke.getMiterLimit()));
            if (pStroke.getDashArray() != null) {
                eStroke.setAttribute(DOM_DASH_ARRAY, Arrays.toString(pStroke.getDashArray()).replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(", ", ","));
            }
        }
        return eStroke;
    }

    public static Stroke getStroke(Node pNoeud) {
        float[] dashArray;
        Node nStroke = XmlUtils.getFils(pNoeud, DOM_STROKE);
        if (nStroke == null) {
            return new BasicStroke();
        }
        if (!XmlUtils.attributeExists(nStroke, DOM_DASH_PHASE)) {
            return null;
        }
        float dashPhase = (float)XmlUtils.getAttributeDoubleValue(nStroke, DOM_DASH_PHASE, Double.NaN);
        int endCap = XmlUtils.getAttributeIntValue(nStroke, DOM_END_CAP, 0);
        int lineJoin = XmlUtils.getAttributeIntValue(nStroke, DOM_LINE_JOIN, 0);
        float lineWidth = (float)XmlUtils.getAttributeDoubleValue(nStroke, DOM_LINE_WIDTH, 0.0);
        float miterLimit = (float)XmlUtils.getAttributeDoubleValue(nStroke, DOM_MITER_LIMIT, 0.0);
        if (!XmlUtils.attributeExists(nStroke, DOM_DASH_ARRAY)) {
            dashArray = null;
        } else {
            String[] tab = XmlUtils.getAttributeStringValue(nStroke, DOM_DASH_ARRAY, "").split(",");
            dashArray = new float[tab.length];
            int i = 0;
            for (String s : tab) {
                dashArray[i++] = Float.parseFloat(s);
            }
        }
        return new BasicStroke(lineWidth, endCap, lineJoin, miterLimit, dashArray, dashPhase);
    }

    public static String getError(Node pNoeud, String pMessage) {
        NamedNodeMap attributes = pNoeud.getAttributes();
        StringBuilder sb = new StringBuilder(1024);
        sb.append("[WARNING] - ").append("El\u00e9ment ").append(pNoeud.getNodeName());
        if (attributes != null && attributes.getNamedItem("id") != null) {
            sb.append(" d'ID ").append(attributes.getNamedItem("id").getNodeValue());
        }
        sb.append(" : ").append(pMessage);
        return sb.toString();
    }

    public static Element appendChild(Document pDoc, Node pParent, String pNodeName, String pText, String pAttributes) {
        Element elt = pDoc.createElement(pNodeName);
        pParent.appendChild(elt);
        if (pText != null) {
            elt.appendChild(pDoc.createTextNode(pText));
        }
        if (pAttributes != null) {
            for (String s : pAttributes.split(";")) {
                String[] tab = s.split("=");
                elt.setAttribute(tab[0], tab[1]);
            }
        }
        return elt;
    }

    public static Element appendChild(Document pDoc, Node pParent, String pNodeName, String pText) {
        return XmlUtils.appendChild(pDoc, pParent, pNodeName, pText, null);
    }

    public static Element appendChild(Document pDoc, Node pParent, String pNodeName) {
        return XmlUtils.appendChild(pDoc, pParent, pNodeName, null, null);
    }
}

