/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.log;

import fr.dbe.util.log.Level;
import fr.dbe.util.log.LogListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Log {
    public static final String PROPERTY_FILE = "LOG_FILE";
    public static final String PROPERTY_MAX_FILES = "LOG_MAX_FILES";
    public static final String PROPERTY_MAX_LENGTH = "LOG_MAX_LENGTH";
    public static final String CONSOLE = "***console***";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy kk:mm:ss,SSS");
    public static Log instance;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMaxFiles = 0;
    private RandomAccessFile fFile;
    private int fIndiceCourant;
    private List<LogListener> fListeners;

    private Log() {
        String nomFicLog = this.getNomFicLog();
        if (nomFicLog != null && !nomFicLog.equals(CONSOLE)) {
            String sMaxLength;
            String sMaxFiles;
            if (nomFicLog.endsWith(".log")) {
                nomFicLog = nomFicLog.substring(0, nomFicLog.lastIndexOf(".log"));
            }
            if ((sMaxFiles = System.getProperty(PROPERTY_MAX_FILES)) != null) {
                try {
                    this.fMaxFiles = Integer.parseInt(sMaxFiles);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((sMaxLength = System.getProperty(PROPERTY_MAX_LENGTH)) != null) {
                try {
                    this.fMaxLength = Integer.parseInt(sMaxLength);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fIndiceCourant = 0;
            File f = new File(nomFicLog + ".log");
            long d = 0L;
            while (f.exists() && f.lastModified() > d) {
                d = f.lastModified();
                ++this.fIndiceCourant;
                f = new File(nomFicLog + this.fIndiceCourant + ".log");
            }
            this.fIndiceCourant = this.fIndiceCourant == 0 ? 0 : this.fIndiceCourant - 1;
            this.openFile();
        }
    }

    public static synchronized Log getInstance() {
        if (instance == null) {
            instance = new Log();
        }
        return instance;
    }

    private void println(Level pLevel, String pMessage) {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append((Object)pLevel).append("]").append(" - ").append(DATE_FORMAT.format(new Date())).append(" : ").append(pMessage);
        if (this.fFile != null) {
            try {
                if (this.fMaxLength != Integer.MAX_VALUE && this.fFile.getFilePointer() > (long)this.fMaxLength) {
                    this.fFile.close();
                    this.fIndiceCourant = this.fIndiceCourant == this.fMaxFiles ? 0 : this.fIndiceCourant + 1;
                    this.openFile();
                }
                this.fFile.writeBytes(sb + System.getProperty("line.separator"));
            }
            catch (IOException iOException) {}
        } else {
            System.out.println(sb);
        }
        this.fireLog(pLevel, pMessage);
    }

    protected String getNomFicLog() {
        try {
            return System.getProperty(PROPERTY_FILE);
        }
        catch (Exception ex) {
            return CONSOLE;
        }
    }

    private void openFile() {
        this.fFile = null;
        try {
            String nomFicLog = System.getProperty(PROPERTY_FILE);
            File f = new File(nomFicLog + (this.fIndiceCourant == 0 ? "" : String.valueOf(this.fIndiceCourant)) + ".log");
            if (f.length() > (long)this.fMaxLength) {
                FileOutputStream fos = new FileOutputStream(f);
                fos.close();
                this.fFile = new RandomAccessFile(f, "rws");
            } else {
                this.fFile = new RandomAccessFile(f, "rws");
                this.fFile.seek(this.fFile.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void log(Level pLevel, String pMessage) {
        this.println(pLevel, pMessage);
    }

    public void log(Level pLevel, Throwable pThrowable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pThrowable.printStackTrace(pw);
        pw.flush();
        pw.close();
        this.println(pLevel, sw.toString());
    }

    public void log(Level pLevel, String pMessage, Throwable pThrowable) {
        StringWriter sw = new StringWriter();
        sw.write(pMessage);
        sw.write(10);
        PrintWriter pw = new PrintWriter(sw);
        pThrowable.printStackTrace(pw);
        pw.flush();
        pw.close();
        this.println(pLevel, sw.toString());
    }

    private void fireLog(Level pLevel, String pString) {
        if (this.fListeners != null) {
            for (LogListener listener : this.fListeners) {
                listener.log(pLevel, pString);
            }
        }
    }

    public final void addLogListener(LogListener pListener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<LogListener>();
        }
        this.fListeners.add(pListener);
    }

    public final void removeLogListener(LogListener pListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(pListener);
        if (this.fListeners.isEmpty()) {
            this.fListeners = null;
        }
    }

    public final void debug(String pMessage) {
        this.log(Level.DEBUG, pMessage);
    }

    public final void info(String pMessage) {
        this.log(Level.INFO, pMessage);
    }

    public final void warn(String pMessage) {
        this.log(Level.WARN, pMessage);
    }

    public final void error(String pMessage) {
        this.log(Level.ERROR, pMessage);
    }

    public final void fatal(String pMessage) {
        this.log(Level.FATAL, pMessage);
    }

    public final void debug(Throwable pThrowable) {
        this.log(Level.DEBUG, pThrowable);
    }

    public final void info(Throwable pThrowable) {
        this.log(Level.INFO, pThrowable);
    }

    public final void warn(Throwable pThrowable) {
        this.log(Level.WARN, pThrowable);
    }

    public final void error(Throwable pThrowable) {
        this.log(Level.ERROR, pThrowable);
    }

    public final void fatal(Throwable pThrowable) {
        this.log(Level.FATAL, pThrowable);
    }

    public final void debug(String pMessage, Throwable pThrowable) {
        this.log(Level.DEBUG, pMessage, pThrowable);
    }

    public final void info(String pMessage, Throwable pThrowable) {
        this.log(Level.INFO, pMessage, pThrowable);
    }

    public final void warn(String pMessage, Throwable pThrowable) {
        this.log(Level.WARN, pMessage, pThrowable);
    }

    public final void error(String pMessage, Throwable pThrowable) {
        this.log(Level.ERROR, pMessage, pThrowable);
    }

    public final void fatal(String pMessage, Throwable pThrowable) {
        this.log(Level.FATAL, pMessage, pThrowable);
    }
}

