/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class TVRepModel
extends DefaultTreeModel {
    public TVRepModel(String pRep, FileFilter pFiltre) {
        super(null);
        if (pRep == null) {
            this.setRoot(new RepEltNode(null, null, pFiltre));
        } else {
            this.setRoot(new RepEltNode(null, new File(pRep), pFiltre));
        }
    }

    class RepEltNode
    implements TreeNode,
    Comparable<RepEltNode> {
        private final File fRep;
        private final RepEltNode fParent;
        private final FileFilter fFiltre;
        private List<RepEltNode> fils;

        public RepEltNode(RepEltNode parent, File pRep, FileFilter pFiltre) {
            this.fRep = pRep;
            this.fParent = parent;
            this.fFiltre = pFiltre;
        }

        @Override
        public int compareTo(RepEltNode o) {
            return this.fRep.getAbsolutePath().toLowerCase().compareTo(o.fRep.getAbsolutePath().toLowerCase());
        }

        public void ajouteFils(File fic) {
            if (this.fils != null) {
                this.fils.add(new RepEltNode(this, fic, this.fFiltre));
                TVRepModel.this.nodesWereInserted(this, new int[]{this.fils.size() - 1});
            }
        }

        public File getFichier() {
            return this.fRep;
        }

        protected synchronized List<RepEltNode> listeFils() {
            if (this.fils == null) {
                File[] lf;
                if (this.fRep == null) {
                    lf = File.listRoots();
                } else {
                    try {
                        lf = this.fRep.listFiles();
                    }
                    catch (Exception ex) {
                        lf = new File[]{};
                    }
                }
                if (lf == null) {
                    this.fils = new ArrayList<RepEltNode>(0);
                } else {
                    ArrayList<RepEltNode> list = new ArrayList<RepEltNode>(lf.length);
                    for (int i = 0; i < lf.length; ++i) {
                        if (lf[i].getPath().equalsIgnoreCase("A:\\") || lf[i].getPath().equalsIgnoreCase("B:\\") || this.fFiltre != null && !this.fFiltre.accept(lf[i])) continue;
                        list.add(new RepEltNode(this, lf[i], this.fFiltre));
                    }
                    this.fils = list;
                }
                Collections.sort(this.fils);
            }
            return this.fils;
        }

        @Override
        public int getChildCount() {
            return this.listeFils().size();
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            if (this.fRep == null) {
                return false;
            }
            return !this.fRep.isDirectory();
        }

        public Enumeration<RepEltNode> children() {
            return Collections.enumeration(this.listeFils());
        }

        @Override
        public TreeNode getParent() {
            return this.fParent;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.listeFils().get(childIndex);
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.listeFils().indexOf(node);
        }

        public String toString() {
            return this.fRep == null ? "" : (this.fRep.getName().length() == 0 ? this.fRep.getPath() : this.fRep.getName());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            RepEltNode r = (RepEltNode)o;
            return this.fRep == null && r.fRep == null || this.fRep != null && this.fRep.getAbsolutePath().equals(r.fRep.getAbsolutePath());
        }

        public void raz() {
            this.fils = null;
            TVRepModel.this.nodeStructureChanged(this);
        }
    }
}

