/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.ihm.JTextFieldSel;
import fr.dbe.util.ihm.Messages;
import fr.dbe.util.ihm.TVRepModel;
import fr.dbe.util.ihm.Utils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class JSelFic
extends JDialog {
    public static final FileFilter FILTRE_DIRECTORIES = File::isDirectory;
    public static final FileFilter FILTRE_DIRECTORIES_NOT_ROOT = f -> f.isDirectory() && !f.getName().isEmpty();
    public static final FileFilter FILTRE_FICHIERS = File::isFile;
    public static final FileFilter FILTRE_ALL = f -> true;
    public static final FileFilter FILTRE_REPERTOIRE_PROJET = f -> f.isDirectory() && new File(f.getAbsolutePath() + System.getProperty("file.separator") + "modele.xml").exists();
    final JTree tv = new JTree();
    final JTextFieldSel fSle = Utils.createTextFieldSel("");
    private File fRes;

    private JSelFic(Frame pParent, String pDir, FileFilter pFiltreAffichage, FileFilter pFiltreSelect, String pDefault) {
        super(pParent);
        this.init(pDir, pFiltreAffichage, pFiltreSelect, pDefault);
    }

    private JSelFic(Dialog pParent, String pDir, FileFilter pFiltreAffichage, FileFilter pFiltreSelect, String pDefault) {
        super(pParent);
        this.init(pDir, pFiltreAffichage, pFiltreSelect, pDefault);
    }

    public static File showSelectionDialog(Frame pParent, String pRoot, FileFilter pFiltreAffichage, FileFilter pFiltreSelect, String pDefault) {
        JSelFic d = new JSelFic(pParent, pRoot, pFiltreAffichage, pFiltreSelect, pDefault);
        d.setVisible(true);
        File res = d.fRes;
        d.dispose();
        return res;
    }

    public static File showSelectionDialog(Dialog pParent, String pRoot, FileFilter pFiltreAffichage, FileFilter pFiltreSelect, String pDefault) {
        JSelFic d = new JSelFic(pParent, pRoot, pFiltreAffichage, pFiltreSelect, pDefault);
        d.setVisible(true);
        File res = d.fRes;
        d.dispose();
        return res;
    }

    public static File showSelectionDialog(Frame pParent, String pRoot, FileFilter pFiltreAffichage, FileFilter pFiltreSelect, String pDefault, String pTitre) {
        JSelFic d = new JSelFic(pParent, pRoot, pFiltreAffichage, pFiltreSelect, pDefault);
        d.setTitle(pTitre);
        d.setVisible(true);
        File res = d.fRes;
        d.dispose();
        return res;
    }

    public static File showSelectionDialog(Dialog pParent, String pRoot, FileFilter pFiltreAffichage, FileFilter pFiltreSelect, String pDefault, String pTitre) {
        JSelFic d = new JSelFic(pParent, pRoot, pFiltreAffichage, pFiltreSelect, pDefault);
        d.setTitle(pTitre);
        d.setVisible(true);
        File res = d.fRes;
        d.dispose();
        return res;
    }

    private void init(String pDir, FileFilter pFiltreAffichage, FileFilter pFiltreSelect, String pDefault) {
        final JButton btOk = new JButton("OK");
        JButton btAnnuler = new JButton(Messages.getString("JSelFic.4"));
        JButton btNouveauDossier = new JButton(Messages.getString("JSelFic.5"));
        this.setTitle(Messages.getString("JSelFic.6"));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.tv.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && btOk.isEnabled()) {
                    btOk.doClick();
                }
            }
        });
        this.tv.addTreeSelectionListener(pTreeSelectionEvent -> {
            if (this.tv.getSelectionModel().getSelectionCount() == 1) {
                btOk.setEnabled(pFiltreSelect.accept(((TVRepModel.RepEltNode)pTreeSelectionEvent.getPath().getLastPathComponent()).getFichier()));
                File f = ((TVRepModel.RepEltNode)this.tv.getSelectionPath().getLastPathComponent()).getFichier();
                if (f != null && f.isDirectory()) {
                    btNouveauDossier.setEnabled(true);
                    this.fSle.setText(f.getAbsolutePath());
                } else {
                    btNouveauDossier.setEnabled(false);
                    this.fSle.setText("");
                }
            } else {
                this.fSle.setText("");
                btOk.setEnabled(false);
                btNouveauDossier.setEnabled(false);
            }
        });
        btOk.setEnabled(false);
        btNouveauDossier.setEnabled(false);
        this.getContentPane().add((Component)this.fSle, "North");
        this.getContentPane().add((Component)new JScrollPane(this.tv), "Center");
        Box bBt = Box.createHorizontalBox();
        bBt.add(Box.createHorizontalStrut(10));
        bBt.add(btNouveauDossier);
        bBt.add(Box.createHorizontalGlue());
        bBt.add(btOk);
        bBt.add(Box.createHorizontalStrut(20));
        bBt.add(btAnnuler);
        bBt.add(Box.createHorizontalStrut(10));
        this.getContentPane().add((Component)bBt, "South");
        btNouveauDossier.addActionListener(pActionEvent -> {
            String nom = JOptionPane.showInputDialog(this, Messages.getString("JSelFic.9"), Messages.getString("JSelFic.10"), -1);
            if (nom != null) {
                String rep = ((TVRepModel.RepEltNode)this.tv.getSelectionPath().getLastPathComponent()).getFichier().getAbsolutePath() + System.getProperty("file.separator") + nom;
                File f = new File(rep);
                if (f.exists()) {
                    JOptionPane.showMessageDialog(this, Messages.getString("JSelFic.12"), Messages.getString("JSelFic.13"), 0);
                    return;
                }
                if (f.mkdir()) {
                    ((TVRepModel.RepEltNode)this.tv.getSelectionPath().getLastPathComponent()).ajouteFils(f);
                    this.selectionne(f.getAbsolutePath());
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getString("JSelFic.14"), Messages.getString("JSelFic.15"), 0);
                }
            }
        });
        btOk.addActionListener(pActionEvent -> {
            this.fRes = ((TVRepModel.RepEltNode)this.tv.getSelectionPath().getLastPathComponent()).getFichier();
            this.setVisible(false);
        });
        btAnnuler.addActionListener(pActionEvent -> {
            this.fRes = null;
            this.setVisible(false);
        });
        this.tv.setModel(new TVRepModel(pDir, pFiltreAffichage));
        this.tv.setRootVisible(false);
        if (pDefault != null) {
            this.selectionne(pDefault);
        } else {
            this.tv.expandRow(0);
        }
        this.fSle.setEnabled(false);
        this.pack();
        this.setSize(400, 400);
    }

    private void selectionne(String pFic) {
        this.tv.expandRow(0);
        try {
            pFic = new File(pFic).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int lastRowFound = 0;
        for (int row = 1; row < this.tv.getRowCount(); ++row) {
            File fic = ((TVRepModel.RepEltNode)this.tv.getPathForRow(row).getLastPathComponent()).getFichier();
            if (!pFic.startsWith(fic.getAbsolutePath())) continue;
            lastRowFound = row;
            if (pFic.equals(fic.getAbsolutePath())) {
                this.tv.expandRow(row);
                break;
            }
            this.tv.expandRow(row);
        }
        this.tv.setSelectionRow(lastRowFound);
        if (this.tv.getRowHeight() > 1) {
            int ligne = Math.min(this.tv.getRowCount() - 1, lastRowFound + this.tv.getParent().getHeight() / this.tv.getRowHeight() - 1);
            this.tv.scrollRowToVisible(ligne);
        }
        this.repaint();
    }
}

