/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import fr.dbe.util.commun.MathUtils;
import fr.dbe.util.commun.Utilitaire;

public class Vecteur {
    private final int fIncrement;
    protected int fNbElements;
    protected double[] fContenu;
    private double fMoyenne;
    private double fVariance;
    private double fEcartType;
    private double fMax;
    private double fMin;
    private boolean fNeedRecalc;
    private int fShift;

    public Vecteur(int pTaille, int pIncrement) {
        this.fIncrement = Math.max(1, pIncrement);
        this.fContenu = new double[pTaille];
        this.fNbElements = 0;
        this.fNeedRecalc = true;
        this.fShift = 0;
    }

    public Vecteur(double[] pValues) {
        this(pValues != null ? pValues.length : 10, 10);
        if (pValues != null) {
            this.ajouter(pValues);
        }
    }

    public Vecteur(double[] pValues, int pDebut) {
        this(pValues.length, 10);
        this.ajouter(pValues, pDebut);
    }

    public Vecteur() {
        this(1000, 1000);
    }

    public void ajuster(int pNbElement) {
        if (pNbElement > this.fContenu.length) {
            double[] tmp = new double[pNbElement];
            System.arraycopy(this.fContenu, 0, tmp, 0, this.fContenu.length);
            this.fContenu = tmp;
        }
        if (this.fNbElements < pNbElement) {
            this.fNbElements = pNbElement;
            this.fNeedRecalc = true;
        }
    }

    public void ajouter(double d) {
        if (this.fNbElements == this.fContenu.length) {
            double[] tmp = new double[this.fContenu.length + this.fIncrement];
            System.arraycopy(this.fContenu, 0, tmp, 0, this.fContenu.length);
            this.fContenu = tmp;
        }
        this.fContenu[this.fNbElements] = d;
        ++this.fNbElements;
        this.fNeedRecalc = true;
    }

    public void ajouter(double[] d, int pDebut) {
        if (this.fNbElements + d.length - pDebut > this.fContenu.length) {
            double[] tmp = new double[this.fContenu.length + this.fIncrement * ((d.length - pDebut) / this.fIncrement + 1)];
            System.arraycopy(this.fContenu, 0, tmp, 0, this.fContenu.length);
            this.fContenu = tmp;
        }
        System.arraycopy(d, pDebut, this.fContenu, this.fNbElements, d.length - pDebut);
        this.fNbElements += d.length - pDebut;
        this.fNeedRecalc = true;
    }

    public void ajouter(double[] d, int pDebut, int pNbElements) {
        if (this.fNbElements + pNbElements - pDebut > this.fContenu.length) {
            double[] tmp = new double[this.fContenu.length + this.fIncrement * ((pNbElements - pDebut) / this.fIncrement + 1)];
            System.arraycopy(this.fContenu, 0, tmp, 0, this.fContenu.length);
            this.fContenu = tmp;
        }
        System.arraycopy(d, pDebut, this.fContenu, this.fNbElements, pNbElements - pDebut);
        this.fNbElements += pNbElements - pDebut;
        this.fNeedRecalc = true;
    }

    public void ajouter(double[] d) {
        this.ajouter(d, 0);
    }

    public void supprime(int i) {
        if (i < 0 || i >= this.fNbElements) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        System.arraycopy(this.fContenu, i + 1, this.fContenu, i, this.fContenu.length - (i + 1));
        --this.fNbElements;
        this.fNeedRecalc = true;
    }

    public void clear() {
        this.fNbElements = 0;
        this.fNeedRecalc = true;
    }

    public double get(int i) {
        if (i >= this.fNbElements || i < 0) {
            throw new ArrayIndexOutOfBoundsException(i + " / " + this.fNbElements + " : " + this);
        }
        return this.fContenu[i];
    }

    public void set(int i, double d) {
        if (i < 0 || i >= this.fNbElements) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        this.fContenu[i] = d;
        this.fNeedRecalc = true;
    }

    public String toString() {
        return "Vecteur[" + this.fNbElements + "]@" + this.hashCode() + " : " + Utilitaire.toString(this.fContenu, ", ", "[", "]", this.size());
    }

    public int size() {
        return this.fNbElements;
    }

    public void ajouter(Vecteur tab, int debut, int pNbElements) {
        if (this.fNbElements + pNbElements > this.fContenu.length) {
            double[] tmp = new double[this.fContenu.length + this.fIncrement * (pNbElements / this.fIncrement + 1)];
            System.arraycopy(this.fContenu, 0, tmp, 0, this.fContenu.length);
            this.fContenu = tmp;
        }
        System.arraycopy(tab.fContenu, debut, this.fContenu, this.fNbElements, pNbElements);
        this.fNbElements += pNbElements - debut;
        this.fNeedRecalc = true;
    }

    public void ajouter(Vecteur tab, int debut) {
        this.ajouter(tab, debut, tab.size() - debut);
    }

    public void ajouter(Vecteur data) {
        this.ajouter(data, 0);
    }

    public double getMax() {
        if (this.fNeedRecalc) {
            this.majAverages();
        }
        return this.fMax;
    }

    public double getMin() {
        if (this.fNeedRecalc) {
            this.majAverages();
        }
        return this.fMin;
    }

    public void multiplie(double pCoef) {
        int i = 0;
        while (i < this.fNbElements) {
            int n = i++;
            this.fContenu[n] = this.fContenu[n] * pCoef;
        }
        this.fNeedRecalc = true;
    }

    public void translate(double pValeur) {
        int i = 0;
        while (i < this.fNbElements) {
            int n = i++;
            this.fContenu[n] = this.fContenu[n] + pValeur;
        }
        this.fNeedRecalc = true;
    }

    public void cumulGlissant(int pFenetre) {
        int j;
        int i;
        for (i = this.fNbElements - 1; i >= pFenetre - 1; --i) {
            for (j = i - 1; j > i - pFenetre; --j) {
                int n = i;
                this.fContenu[n] = this.fContenu[n] + this.fContenu[j];
            }
        }
        for (i = pFenetre - 2; i > 0; --i) {
            for (j = i - 1; j >= 0; --j) {
                int n = i;
                this.fContenu[n] = this.fContenu[n] + this.fContenu[j];
            }
        }
        this.fNeedRecalc = true;
    }

    public double getMoyenne() {
        if (this.fNeedRecalc) {
            this.majAverages();
        }
        return this.fMoyenne;
    }

    public double getVariance() {
        if (this.fNeedRecalc) {
            this.majAverages();
        }
        return this.fVariance;
    }

    public double getEcartType() {
        if (this.fNeedRecalc) {
            this.majAverages();
        }
        return this.fEcartType;
    }

    private void majAverages() {
        if (this.fNbElements <= 0) {
            this.fMoyenne = Double.NaN;
            this.fMax = Double.NaN;
            this.fMin = Double.NaN;
        } else {
            int i;
            double somme = 0.0;
            double max = Double.MIN_VALUE;
            double min = Double.MAX_VALUE;
            for (i = 0; i < this.fNbElements; ++i) {
                somme += this.fContenu[i];
                min = Math.min(min, this.fContenu[i]);
                max = Math.max(max, this.fContenu[i]);
            }
            this.fMoyenne = somme / (double)this.fNbElements;
            this.fMax = max;
            this.fMin = min;
            somme = 0.0;
            for (i = 0; i < this.fNbElements; ++i) {
                somme += Math.pow(this.fContenu[i] - this.fMoyenne, 2.0);
            }
            this.fVariance = somme / (double)this.fNbElements;
            this.fEcartType = Math.sqrt(this.fVariance);
        }
        this.fNeedRecalc = false;
    }

    protected void needRecalc() {
        this.fNeedRecalc = true;
    }

    public void ajusterCapacite(int pNbElement) {
        if (pNbElement > this.fContenu.length) {
            double[] tmp = new double[pNbElement];
            System.arraycopy(this.fContenu, 0, tmp, 0, this.fContenu.length);
            this.fContenu = tmp;
        }
    }

    public void log10() {
        for (int i = 0; i < this.fNbElements; ++i) {
            this.fContenu[i] = Math.log10(this.fContenu[i]);
        }
        this.fNeedRecalc = true;
    }

    public double[] toArray() {
        double[] array = new double[this.fNbElements];
        System.arraycopy(this.fContenu, 0, array, 0, this.fNbElements);
        return array;
    }

    public double getMediane() {
        return MathUtils.mediane(this.toArray());
    }

    public void truncate(int pIndice) {
        if (pIndice < 0) {
            this.clear();
        }
        if (pIndice >= this.fNbElements) {
            return;
        }
        this.fNbElements = pIndice + 1;
        this.fNeedRecalc = true;
    }

    public double[] toArrayDecale(int pDecalage) {
        double[] array = new double[this.fNbElements + pDecalage];
        System.arraycopy(this.fContenu, 0, array, pDecalage, this.fNbElements);
        return array;
    }

    public int getShift() {
        return this.fShift;
    }

    public void setShift(int pShift) {
        if (pShift < 0) {
            throw new IllegalArgumentException("Shift must be positive");
        }
        int delta = pShift - this.fShift;
        if (delta > 0) {
            this.ajusterCapacite(this.fNbElements + delta);
        }
        System.arraycopy(this.fContenu, this.fShift, this.fContenu, pShift, this.fNbElements - this.fShift);
        if (pShift > 0) {
            System.arraycopy(new double[pShift], 0, this.fContenu, 0, pShift);
        }
        this.fNbElements += delta;
        this.fShift = pShift;
    }
}

